package com.digiwin.monitor.scan.sdk.parse.builder.op;

import com.digiwin.monitor.scan.sdk.util.ClassScanUtil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 自动加载所有转换op的实现类，提供动态的策略，根据不同op调用不同实现
 * @author: liunansheng
 * @date: 2021/11/24 17:46
 */
public class OperatorHandlerHolder {
    private final static Map<String, IOperatorHandler> HANDLER_MAP = new HashMap<>();

    static {
        //加载所有op实现类到Map
        try {
            List<Class> classList = ClassScanUtil.scanClass(OperatorHandlerHolder.class.getPackage().getName() + ".impl");
            for (Class opClass : classList) {
                if (IOperatorHandler.class.isAssignableFrom(opClass)) {
                    IOperatorHandler handler = (IOperatorHandler) opClass.newInstance();
                    HANDLER_MAP.put(handler.getOpType(), handler);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException("初始化op转换类异常:", e);
        }
    }

    /**
     * 拼接condition
     * @param op
     * @param value
     * @param valueType
     * @param tableName
     * @param columnName
     * @return
     */
    public static String handle(String op, String value, String valueType, String tableName, String columnName) {
        IOperatorHandler handler = HANDLER_MAP.get(op);
        if (handler == null) {
            throw new RuntimeException("未支持的op:" + op);
        }
        return handler.handle(value, valueType, tableName, columnName);
    }

}
