package com.digiwin.monitor.scan.sdk.parse.builder.op.impl;


import com.digiwin.monitor.scan.sdk.DataChangeGetExtensionContext;
import com.digiwin.monitor.scan.sdk.enumerate.OpType;
import com.digiwin.monitor.scan.sdk.parse.builder.op.IOperatorHandler;

/**
 * @description:
 * @author: liunansheng
 * @date: 2021/11/24 15:39
 */
public class LeftLikeHandler extends IOperatorHandler {

    @Override
    public String handle(String value, String valueType, String tableName, String columnName) {

        return " " + columnName + " like '" + super.escapeLike(value) + "%' " + DataChangeGetExtensionContext.getDbType().getLikeEscapeSymbol();
    }

    @Override
    public String getOpType() {
        return OpType.LEFT_LIKE.toString();
    }
}
