/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.monitor.scan.sdk;

import com.digiwin.monitor.scan.sdk.enumerate.DbType;
import com.digiwin.monitor.scan.sdk.extension.IApprovedTypeDefaultParamBuilder;
import com.digiwin.monitor.scan.sdk.extension.ICreatedTypeDefaultParamBuilder;
import com.digiwin.monitor.scan.sdk.extension.IModifiedTypeDefaultParamBuilder;
import com.digiwin.monitor.scan.sdk.extension.IOpRightValConvertor;
import com.digiwin.monitor.scan.sdk.extension.IOtherWhereConditionAdder;
import com.digiwin.monitor.scan.sdk.extension.impl.ApprovedTypeDefaultParamBuilderImpl;
import com.digiwin.monitor.scan.sdk.extension.impl.CreatedTypeDefaultParamBuilderImpl;
import com.digiwin.monitor.scan.sdk.extension.impl.ModifiedTypeDefaultParamBuilderImpl;
import com.digiwin.monitor.scan.sdk.extension.impl.OpRightValConvertorImpl;
import com.digiwin.monitor.scan.sdk.util.ClassScanUtil;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import com.digiwin.monitor.scan.sdk.util.StringUtil;
import java.util.List;

public class DataChangeGetExtensionContext {
    private static boolean isInit;
    private static DbType DB_TYPE;
    private static IApprovedTypeDefaultParamBuilder approvedTypeDefaultParamBuilder;
    private static ICreatedTypeDefaultParamBuilder createdTypeDefaultParamBuilder;
    private static IModifiedTypeDefaultParamBuilder modifiedTypeDefaultParamBuilder;
    private static IOpRightValConvertor opRightValConvertor;
    private static IOtherWhereConditionAdder otherWhereConditionAdder;

    static synchronized void initContext(String extensionPackageName, DbType dbType) {
        if (isInit) {
            return;
        }
        if (dbType != null) {
            DB_TYPE = dbType;
        }
        if (StringUtil.isBlank(extensionPackageName)) {
            DataChangeGetExtensionContext.buildDefaultExtension();
            return;
        }
        try {
            List<Class> classList = ClassScanUtil.scanClass(extensionPackageName);
            if (CollectionUtil.isEmpty(classList)) {
                DataChangeGetExtensionContext.buildDefaultExtension();
                return;
            }
            for (Class extensionClass : classList) {
                if (IApprovedTypeDefaultParamBuilder.class.isAssignableFrom(extensionClass)) {
                    approvedTypeDefaultParamBuilder = (IApprovedTypeDefaultParamBuilder)extensionClass.newInstance();
                    continue;
                }
                if (ICreatedTypeDefaultParamBuilder.class.isAssignableFrom(extensionClass)) {
                    createdTypeDefaultParamBuilder = (ICreatedTypeDefaultParamBuilder)extensionClass.newInstance();
                    continue;
                }
                if (IModifiedTypeDefaultParamBuilder.class.isAssignableFrom(extensionClass)) {
                    modifiedTypeDefaultParamBuilder = (IModifiedTypeDefaultParamBuilder)extensionClass.newInstance();
                    continue;
                }
                if (IOpRightValConvertor.class.isAssignableFrom(extensionClass)) {
                    opRightValConvertor = (IOpRightValConvertor)extensionClass.newInstance();
                    continue;
                }
                if (!IOtherWhereConditionAdder.class.isAssignableFrom(extensionClass)) continue;
                otherWhereConditionAdder = (IOtherWhereConditionAdder)extensionClass.newInstance();
            }
            DataChangeGetExtensionContext.buildDefaultExtension();
            isInit = true;
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u8f7d\u5b9a\u5236\u5316\u5b9e\u73b0\u7c7b\u5f02\u5e38:" + extensionPackageName, e);
        }
    }

    private static void buildDefaultExtension() {
        if (null == approvedTypeDefaultParamBuilder) {
            approvedTypeDefaultParamBuilder = new ApprovedTypeDefaultParamBuilderImpl();
        }
        if (null == createdTypeDefaultParamBuilder) {
            createdTypeDefaultParamBuilder = new CreatedTypeDefaultParamBuilderImpl();
        }
        if (null == modifiedTypeDefaultParamBuilder) {
            modifiedTypeDefaultParamBuilder = new ModifiedTypeDefaultParamBuilderImpl();
        }
        if (null == opRightValConvertor) {
            opRightValConvertor = new OpRightValConvertorImpl();
        }
    }

    public static IApprovedTypeDefaultParamBuilder getApprovedTypeDefaultParamBuilder() {
        return approvedTypeDefaultParamBuilder;
    }

    public static ICreatedTypeDefaultParamBuilder getCreatedTypeDefaultParamBuilder() {
        return createdTypeDefaultParamBuilder;
    }

    public static IModifiedTypeDefaultParamBuilder getModifiedTypeDefaultParamBuilder() {
        return modifiedTypeDefaultParamBuilder;
    }

    public static IOtherWhereConditionAdder getOtherWhereConditionAdder() {
        return otherWhereConditionAdder;
    }

    public static IOpRightValConvertor getOpRightValConvertor() {
        if (null == opRightValConvertor) {
            opRightValConvertor = new OpRightValConvertorImpl();
        }
        return opRightValConvertor;
    }

    public static DbType getDbType() {
        return DB_TYPE;
    }

    public static boolean isIsInit() {
        return isInit;
    }

    static {
        DB_TYPE = DbType.MYSQL;
    }
}

