/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.monitor.scan.sdk.parse;

import com.digiwin.monitor.scan.sdk.DataChangeGetExtensionContext;
import com.digiwin.monitor.scan.sdk.enumerate.ConditionType;
import com.digiwin.monitor.scan.sdk.enumerate.MonitorType;
import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;
import com.digiwin.monitor.scan.sdk.parse.builder.GroupCriterion;
import com.digiwin.monitor.scan.sdk.pojo.request.DefaultParam;
import com.digiwin.monitor.scan.sdk.pojo.request.Rule;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DefaultParamConverter {
    public static final String APPROVE_STATUS = "APPROVE_STATUS";
    public static final String APPROVE_DATE = "APPROVE_DATE";
    public static final String CREATE_DATE = "CREATE_DATE";
    public static final String MODI_DATE = "MODI_DATE";

    public static List<Criterion> buildDefaultCondition(Rule rule, String startTime, String endTime) {
        HashMap<String, List<String>> defaultParamMap = new HashMap<String, List<String>>();
        if (CollectionUtil.isNotEmpty(rule.getDefault_params())) {
            for (DefaultParam defaultParam : rule.getDefault_params()) {
                defaultParamMap.put(defaultParam.getName(), defaultParam.getValues());
            }
        }
        if (MonitorType.APPROVED.toString().equals(rule.getMonitor_type())) {
            return DefaultParamConverter.buildApprovedTypeParam(rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
        }
        if (MonitorType.CREATED.toString().equals(rule.getMonitor_type())) {
            return DefaultParamConverter.buildCreateTypeParam(rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
        }
        if (MonitorType.MODIFIED.toString().equals(rule.getMonitor_type())) {
            return DefaultParamConverter.buildModifyTypeParam(rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
        }
        if (MonitorType.CREATED_OR_MODIFIED.toString().equals(rule.getMonitor_type())) {
            Criterion orGroup;
            List<Criterion> modifyCriterionList = DefaultParamConverter.buildModifyTypeParam(rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
            List<Criterion> createCriterionList = DefaultParamConverter.buildCreateTypeParam(rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
            ArrayList<Criterion> orGroupCriterionList = new ArrayList<Criterion>();
            Criterion modifyAndGroup = DefaultParamConverter.convertToGroup(modifyCriterionList, ConditionType.AND_GROUP);
            Criterion createAndGroup = DefaultParamConverter.convertToGroup(createCriterionList, ConditionType.AND_GROUP);
            if (createAndGroup != null) {
                orGroupCriterionList.add(createAndGroup);
            }
            if (modifyAndGroup != null) {
                orGroupCriterionList.add(modifyAndGroup);
            }
            if ((orGroup = DefaultParamConverter.convertToGroup(orGroupCriterionList, ConditionType.OR_GROUP)) == null) {
                return null;
            }
            ArrayList<Criterion> defaultCriterion = new ArrayList<Criterion>();
            defaultCriterion.add(orGroup);
            return defaultCriterion;
        }
        return null;
    }

    private static Criterion convertToGroup(List<Criterion> criterionList, ConditionType conditionType) {
        if (CollectionUtil.isEmpty(criterionList)) {
            return null;
        }
        if (criterionList.size() == 1) {
            return criterionList.get(0);
        }
        GroupCriterion andGroup = new GroupCriterion(conditionType.toString(), criterionList);
        return new Criterion(andGroup);
    }

    public static List<Criterion> buildApprovedTypeParam(String tableName, String alias, Map<String, List<String>> defaultParamMap, String startTime, String endTime) {
        List<String> approveStatusColumnList = defaultParamMap.get(APPROVE_STATUS);
        List<String> approveDateColumnList = defaultParamMap.get(APPROVE_DATE);
        return DataChangeGetExtensionContext.getApprovedTypeDefaultParamBuilder().build(approveDateColumnList, approveStatusColumnList, startTime, endTime, tableName, alias);
    }

    public static List<Criterion> buildCreateTypeParam(String tableName, String alias, Map<String, List<String>> defaultParamMap, String startTime, String endTime) {
        List<String> createDateColumnList = defaultParamMap.get(CREATE_DATE);
        List<String> approveStatusColumnList = defaultParamMap.get(APPROVE_STATUS);
        return DataChangeGetExtensionContext.getCreatedTypeDefaultParamBuilder().build(createDateColumnList, approveStatusColumnList, startTime, endTime, tableName, alias);
    }

    public static List<Criterion> buildModifyTypeParam(String tableName, String alias, Map<String, List<String>> defaultParamMap, String startTime, String endTime) {
        List<String> modifyDateColumnList = defaultParamMap.get(MODI_DATE);
        return DataChangeGetExtensionContext.getModifiedTypeDefaultParamBuilder().build(modifyDateColumnList, startTime, endTime, tableName, alias);
    }
}

