/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.monitor.scan.sdk.parse;

import com.digiwin.monitor.scan.sdk.DataChangeGetExtensionContext;
import com.digiwin.monitor.scan.sdk.enumerate.ConditionType;
import com.digiwin.monitor.scan.sdk.extension.IOtherWhereConditionAdder;
import com.digiwin.monitor.scan.sdk.parse.DefaultParamConverter;
import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;
import com.digiwin.monitor.scan.sdk.parse.builder.GroupCriterion;
import com.digiwin.monitor.scan.sdk.parse.builder.JoinBuilder;
import com.digiwin.monitor.scan.sdk.parse.builder.SelectColumn;
import com.digiwin.monitor.scan.sdk.parse.builder.SqlBuilder;
import com.digiwin.monitor.scan.sdk.pojo.request.Condition;
import com.digiwin.monitor.scan.sdk.pojo.request.DataChangeGetRequest;
import com.digiwin.monitor.scan.sdk.pojo.request.JoinParam;
import com.digiwin.monitor.scan.sdk.pojo.request.ReturnColumn;
import com.digiwin.monitor.scan.sdk.pojo.request.Rule;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SqlParser {
    public static String parse(DataChangeGetRequest requestDto, Rule rule) {
        List<Criterion> otherCondition;
        IOtherWhereConditionAdder otherWhereConditionAdder;
        boolean isDistinct = "DISTINCT".equalsIgnoreCase(rule.getSelect_type());
        List<SelectColumn> returnColumnList = SqlParser.convertSelectColumn(rule.getReturn_columns());
        List<JoinBuilder> joinBuilderList = SqlParser.convertJoin(rule.getJoin_params());
        Criterion dynamicCriterion = SqlParser.conditionCovertToCriterion(rule.getDynamic_condition(), rule.getTable(), rule.getAlias());
        ArrayList<Criterion> whereCriterionList = new ArrayList<Criterion>();
        whereCriterionList.add(dynamicCriterion);
        List<Criterion> defaultCriterionList = DefaultParamConverter.buildDefaultCondition(rule, requestDto.getDatetime_s(), requestDto.getDatetime_e());
        if (CollectionUtil.isNotEmpty(defaultCriterionList)) {
            whereCriterionList.addAll(defaultCriterionList);
        }
        if (null != (otherWhereConditionAdder = DataChangeGetExtensionContext.getOtherWhereConditionAdder()) && CollectionUtil.isNotEmpty(otherCondition = otherWhereConditionAdder.add(requestDto, rule.getTable(), rule.getAlias()))) {
            whereCriterionList.addAll(otherCondition);
        }
        SqlBuilder sqlBuilder = new SqlBuilder(isDistinct, returnColumnList, rule.getTable(), rule.getAlias(), joinBuilderList, whereCriterionList);
        return sqlBuilder.toString();
    }

    private static List<SelectColumn> convertSelectColumn(List<ReturnColumn> returnColumnList) {
        ArrayList<SelectColumn> selectColumnList = new ArrayList<SelectColumn>();
        for (ReturnColumn returnColumn : returnColumnList) {
            selectColumnList.add(new SelectColumn(returnColumn.getName(), returnColumn.getAlias()));
        }
        return selectColumnList;
    }

    private static List<JoinBuilder> convertJoin(List<JoinParam> joinParams) {
        if (CollectionUtil.isEmpty(joinParams)) {
            return null;
        }
        if (joinParams.size() > 1) {
            joinParams.sort(new Comparator<JoinParam>(){

                @Override
                public int compare(JoinParam o1, JoinParam o2) {
                    return o1.getSeq().compareTo(o2.getSeq());
                }
            });
        }
        ArrayList<JoinBuilder> joinBuilderList = new ArrayList<JoinBuilder>();
        for (JoinParam joinParam : joinParams) {
            Criterion criterion = SqlParser.conditionCovertToCriterion(joinParam.getCondition(), joinParam.getTable(), joinParam.getAlias());
            JoinBuilder joinBuilder = new JoinBuilder(joinParam.getTable(), joinParam.getAlias(), joinParam.getType(), criterion);
            joinBuilderList.add(joinBuilder);
        }
        return joinBuilderList;
    }

    private static Criterion conditionCovertToCriterion(Condition condition, String table, String alias) {
        if (ConditionType.SINGLE.toString().equals(condition.getType())) {
            return new Criterion(condition.getLeft(), condition.getOp(), condition.getRight(), condition.getRight_value_type(), table, alias);
        }
        if (ConditionType.AND_GROUP.toString().equals(condition.getType()) || ConditionType.OR_GROUP.toString().equals(condition.getType())) {
            ArrayList<Criterion> criterionList = new ArrayList<Criterion>();
            for (Condition item : condition.getItems()) {
                Criterion one = SqlParser.conditionCovertToCriterion(item, table, alias);
                criterionList.add(one);
            }
            GroupCriterion groupCriterion = new GroupCriterion(condition.getType(), criterionList);
            return new Criterion(groupCriterion);
        }
        throw new RuntimeException("\u672a\u652f\u6301\u7684conditionType\uff1a" + condition.getType());
    }
}

