/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.monitor.scan.sdk.parse.builder;

import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;
import com.digiwin.monitor.scan.sdk.parse.builder.JoinBuilder;
import com.digiwin.monitor.scan.sdk.parse.builder.SelectColumn;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import com.digiwin.monitor.scan.sdk.util.StringUtil;
import java.util.List;

public class SqlBuilder {
    private boolean isDistinct;
    private List<SelectColumn> returnColumnList;
    private String table;
    private String alias;
    private List<JoinBuilder> joinBuilderList;
    private List<Criterion> whereConditionList;

    public SqlBuilder(boolean isDistinct, List<SelectColumn> returnColumnList, String table, String alias, List<JoinBuilder> joinBuilderList, List<Criterion> whereConditionList) {
        this.isDistinct = isDistinct;
        this.returnColumnList = returnColumnList;
        this.table = table;
        this.alias = alias;
        this.joinBuilderList = joinBuilderList;
        this.whereConditionList = whereConditionList;
    }

    public SqlBuilder() {
    }

    public String toString() {
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        if (this.isDistinct) {
            sql.append(" distinct ");
        }
        sql.append(CollectionUtil.join(this.returnColumnList, ",")).append(" from ").append(this.table);
        if (StringUtil.isNotBlank(this.alias)) {
            sql.append(" ").append(this.alias);
        }
        if (CollectionUtil.isNotEmpty(this.joinBuilderList)) {
            sql.append(" ").append(CollectionUtil.join(this.joinBuilderList, " "));
        }
        if (CollectionUtil.isNotEmpty(this.whereConditionList)) {
            sql.append(" where ").append(CollectionUtil.join(this.whereConditionList, " and "));
        }
        return sql.toString();
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean distinct) {
        this.isDistinct = distinct;
    }

    public List<SelectColumn> getReturnColumnList() {
        return this.returnColumnList;
    }

    public void setReturnColumnList(List<SelectColumn> returnColumnList) {
        this.returnColumnList = returnColumnList;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<JoinBuilder> getJoinBuilderList() {
        return this.joinBuilderList;
    }

    public void setJoinBuilderList(List<JoinBuilder> joinBuilderList) {
        this.joinBuilderList = joinBuilderList;
    }

    public List<Criterion> getWhereConditionList() {
        return this.whereConditionList;
    }

    public void setWhereConditionList(List<Criterion> whereConditionList) {
        this.whereConditionList = whereConditionList;
    }
}

