/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.monitor.scan.sdk.parse.builder.op;

import com.digiwin.monitor.scan.sdk.parse.builder.op.IOperatorHandler;
import com.digiwin.monitor.scan.sdk.util.ClassScanUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OperatorHandlerHolder {
    private static final Map<String, IOperatorHandler> HANDLER_MAP = new HashMap<String, IOperatorHandler>();

    public static String handle(String op, String value, String valueType, String tableName, String columnName) {
        IOperatorHandler handler = HANDLER_MAP.get(op);
        if (handler == null) {
            throw new RuntimeException("\u672a\u652f\u6301\u7684op:" + op);
        }
        return handler.handle(value, valueType, tableName, columnName);
    }

    static {
        try {
            List<Class> classList = ClassScanUtil.scanClass(OperatorHandlerHolder.class.getPackage().getName() + ".impl");
            for (Class opClass : classList) {
                if (!IOperatorHandler.class.isAssignableFrom(opClass)) continue;
                IOperatorHandler handler = (IOperatorHandler)opClass.newInstance();
                HANDLER_MAP.put(handler.getOpType(), handler);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316op\u8f6c\u6362\u7c7b\u5f02\u5e38:", e);
        }
    }
}

