/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.monitor.scan.sdk.util;

import com.digiwin.monitor.scan.sdk.parse.builder.op.OperatorHandlerHolder;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import com.digiwin.monitor.scan.sdk.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class ClassScanUtil {
    private static final String SLASH = "/";
    private static final String POINT = ".";
    private static final String CLASS_SUFFIX = ".class";

    public static List<String> scanClassName(String packageName) throws IOException {
        String slashedPackageName = StringUtil.replace(packageName, POINT, SLASH);
        URL url = OperatorHandlerHolder.class.getClassLoader().getResource(slashedPackageName);
        String path = ClassScanUtil.getRootPath(url);
        if (ClassScanUtil.isJarFile(path)) {
            return ClassScanUtil.readJarFileClassName(ClassScanUtil.getRootPath(url), slashedPackageName);
        }
        return ClassScanUtil.readDirectoryClassName(ClassScanUtil.getRootPath(url), slashedPackageName);
    }

    public static List<Class> scanClass(String packageName) throws IOException, ClassNotFoundException {
        List<String> classNameList = ClassScanUtil.scanClassName(packageName);
        if (CollectionUtil.isEmpty(classNameList)) {
            return null;
        }
        ArrayList<Class> classList = new ArrayList<Class>();
        for (String className : classNameList) {
            classList.add(Class.forName(className));
        }
        return classList;
    }

    private static List<String> readJarFileClassName(String path, String slashedPackageName) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(path));
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        ArrayList<String> nameList = new ArrayList<String>();
        while (jarEntry != null) {
            String jarFileName = jarEntry.getName();
            if (jarFileName.startsWith(slashedPackageName) && jarFileName.endsWith(CLASS_SUFFIX)) {
                String className = StringUtil.replace(jarFileName, SLASH, POINT);
                nameList.add(className.substring(0, className.length() - CLASS_SUFFIX.length()));
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return nameList;
    }

    private static List<String> readDirectoryClassName(String path, String slashedPackageName) throws IOException {
        File directory = new File(path);
        File[] childNames = directory.listFiles();
        String packageName = StringUtil.replace(slashedPackageName, SLASH, POINT);
        ArrayList<String> nameList = new ArrayList<String>();
        for (File file : childNames) {
            String className = packageName + POINT + file.getName();
            nameList.add(className.substring(0, className.length() - CLASS_SUFFIX.length()));
        }
        return nameList;
    }

    private static String getRootPath(URL url) {
        String path = url.getPath();
        int pos = path.indexOf("!");
        if (-1 == pos) {
            return path;
        }
        return path.substring(5, pos);
    }

    private static boolean isJarFile(String path) {
        return path.endsWith(".jar");
    }
}

