/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.monitor.sql.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.monitor.sql.sdk.request.ActionParam;
import com.digiwin.monitor.sql.sdk.response.ColMetaInfo;
import com.digiwin.monitor.sql.sdk.response.DWEAIResult;
import com.digiwin.monitor.sql.sdk.util.CollectionUtil;
import com.digiwin.monitor.sql.sdk.util.RespParser;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class DataChangeSqlGetService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataChangeSqlGetService.class);
    private static final String DIGI_OMMAP = "digi-ommap";
    private static final String DB_TAG = "db_tag";
    private static final String DB_NAME = "db_name";
    private static final String ACTION_PARAMS = "action_params";
    private static final String MAX_SIZE = "max_size";
    private static final String SCRIPT = "script";
    private static final String DYNAMIC_CONDITION = "dynamic_condition";
    private static final BigDecimal DATA_MAX_SIZE = new BigDecimal(8192);
    private String jdbcClass;
    private String jdbcUrl;

    public DWEAIResult dataChangeSqlGet(Map<String, Object> header, Map<String, Object> body) {
        List<Map<String, Object>> convertResult;
        LOGGER.info("SDK Sql \u4fa6\u6d4b\u5f00\u59cb===============");
        LOGGER.info(String.format("jdbcClass:%s,jdbcUrl:%S", this.jdbcClass, this.jdbcUrl));
        ArrayList<Map<String, Object>> sqlResult = new ArrayList<Map<String, Object>>();
        ArrayList<ColMetaInfo> colMetaInfos = new ArrayList<ColMetaInfo>();
        Map jsonStringParameter = (Map)((Map)body.get("std_data")).get("parameter");
        List rules = (List)jsonStringParameter.get("rules");
        String callId = Objects.toString(jsonStringParameter.get("call_id"));
        LOGGER.info("\u6267\u884cDEA\u5f00\u59cb*************,callId:{}", (Object)callId);
        try {
            Map rule = (Map)rules.get(0);
            if (CollectionUtil.isEmpty(rule)) {
                return new DWEAIResult("-1", "", "rules\u8282\u70b9\u4e3a\u7a7a\uff01", (Map)((Map)body.get("std_data")).get("parameter"));
            }
            String dbTagVal = MapUtils.getString((Map)rule, (Object)DB_TAG);
            String dbName = null == rule.get(DB_NAME) ? "" : String.valueOf(rule.get(DB_NAME));
            Integer dbTag = StringUtils.isEmpty((CharSequence)dbTagVal) ? null : Integer.valueOf(dbTagVal);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(this.getDataSource(dbTag, dbName));
            String scriptSql = this.getScriptSql(header, rule);
            SqlRowSet rowSet = jdbcTemplate.queryForRowSet(scriptSql);
            String[] cols = rowSet.getMetaData().getColumnNames();
            String actionParams = JSON.toJSONString(rule.get(ACTION_PARAMS));
            List actionParamList = JSON.parseArray((String)actionParams, ActionParam.class);
            boolean hasActionParam = CollectionUtil.isNotEmpty(actionParamList);
            Double maxSizeVal = (Double)rule.get(MAX_SIZE);
            Integer maxSize = null == maxSizeVal ? null : Integer.valueOf(maxSizeVal.intValue());
            int size = 0;
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                String[] stringArray = cols;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String col = stringArray[i];
                    if (hasActionParam) {
                        col = col.toUpperCase();
                    }
                    map.put(col, rowSet.getObject(col));
                }
                sqlResult.add(map);
                if (maxSize == null || ++size != maxSize) continue;
                break;
            }
            convertResult = hasActionParam ? RespParser.convertResp(sqlResult, actionParamList) : sqlResult;
            for (String col : cols) {
                colMetaInfos.add(new ColMetaInfo(col));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new DWEAIResult("-1", "", e.getMessage(), new HashMap<String, Object>());
        }
        HashMap<String, ArrayList<Object>> resultMap = new HashMap<String, ArrayList<Object>>(4);
        HashMap<String, Object> parameter = new HashMap<String, Object>(2);
        JSONArray result = new JSONArray();
        result.add(resultMap);
        parameter.put("response_objects", result);
        resultMap.put("meta_info", colMetaInfos);
        resultMap.put("change_objects", (ArrayList<Object>)convertResult);
        LOGGER.info("\u6267\u884cDEA\u7ed3\u675f*************,callId:{}", (Object)callId);
        if (this.getResultSize(parameter).compareTo(DATA_MAX_SIZE) > 0) {
            LOGGER.error("\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u80fd\u5927\u4e8e8M");
            return new DWEAIResult("-1", "", "\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u80fd\u5927\u4e8e8M", new HashMap<String, Object>());
        }
        LOGGER.info("SDK Sql \u4fa6\u6d4b\u7ed3\u675f===============");
        return new DWEAIResult("0", "", "\u8c03\u7528DEA\u6267\u884c\u6210\u529f\uff01", parameter);
    }

    DataSource getDataSource(Integer dbTag, String dbName) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(this.jdbcClass);
        dataSource.setUrl(this.jdbcUrl);
        return dataSource;
    }

    private String getScriptSql(Map<String, Object> header, Map<String, Object> rule) {
        String scriptSql = (String)rule.get(SCRIPT);
        scriptSql = new String(Base64.getDecoder().decode(scriptSql), StandardCharsets.UTF_8);
        JSONArray dynamicConditionArr = JSONArray.parseArray((String)JSON.toJSONString((Object)rule.get(DYNAMIC_CONDITION)));
        JSONObject eocMap = JSON.parseObject((String)((String)header.get(DIGI_OMMAP)));
        scriptSql = this.replacePlaceholder(scriptSql, dynamicConditionArr, eocMap);
        return scriptSql;
    }

    private String replacePlaceholder(String scriptSql, JSONArray dynamicConditionArr, JSONObject eocMap) {
        HashMap replaceMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)dynamicConditionArr)) {
            for (Object jsonObject : dynamicConditionArr) {
                Map dynamicConditionObj = (Map)jsonObject;
                String type = (String)dynamicConditionObj.get("type");
                String value = (String)dynamicConditionObj.get("value");
                if (!(Objects.equals(type, "BOOLEAN") || Objects.equals(type, "INT") || Objects.equals(type, "DECIMAL"))) {
                    value = "'" + value + "'";
                }
                replaceMap.put(dynamicConditionObj.get("name"), value);
            }
        }
        if (CollectionUtil.isNotEmpty((Map)eocMap)) {
            replaceMap.put("VAR_OM_COMPANY_ID", "'" + eocMap.getString("om_company_id") + "'");
        }
        if (CollectionUtil.isEmpty(replaceMap)) {
            return scriptSql;
        }
        StrSubstitutor sub = new StrSubstitutor(replaceMap);
        scriptSql = sub.replace(scriptSql);
        return scriptSql;
    }

    private BigDecimal getResultSize(Map<String, Object> parameter) {
        Integer length = JSON.toJSONString(parameter).getBytes(Charset.defaultCharset()).length;
        BigDecimal size = new BigDecimal(length);
        BigDecimal u = new BigDecimal(1024);
        return size.divide(u, 2, 1);
    }

    public DataChangeSqlGetService(String jdbcClass, String jdbcUrl) {
        this.jdbcClass = jdbcClass;
        this.jdbcUrl = jdbcUrl;
    }
}

