/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.monitor.sql.sdk.util;

import com.digiwin.monitor.sql.sdk.enums.ActionParamType;
import com.digiwin.monitor.sql.sdk.request.ActionParam;
import com.digiwin.monitor.sql.sdk.util.CollectionUtil;
import com.digiwin.monitor.sql.sdk.util.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RespParser {
    private static Map<String, ActionParamFunc> FUNC_MAP = new HashMap<String, ActionParamFunc>();

    public static List<Map<String, Object>> convertResp(List<Map<String, Object>> records, List<ActionParam> actionParams) {
        if (records == null) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> record : records) {
            HashMap<String, Object> returnRecord = new HashMap<String, Object>();
            for (ActionParam actionParam : actionParams) {
                Object val = RespParser.parseVal(actionParam, record);
                returnRecord.put(actionParam.getName(), val);
            }
            result.add(returnRecord);
        }
        return result;
    }

    private static Object parseVal(ActionParam actionParam, Map<String, Object> record) {
        if (ActionParamType.CONSTANT.toString().equalsIgnoreCase(actionParam.getType())) {
            return actionParam.getValue();
        }
        if (ActionParamType.COLUMN.toString().equalsIgnoreCase(actionParam.getType())) {
            Object val = record.get(actionParam.getValue().toUpperCase());
            if (DateUtil.isDate(val)) {
                return DateUtil.dateFormat(val);
            }
            return val;
        }
        if (ActionParamType.FUNCTION.toString().equalsIgnoreCase(actionParam.getType())) {
            return RespParser.getFunctionVal(actionParam.getFunc_name(), actionParam.getFunction_params(), record);
        }
        throw new RuntimeException("\u672a\u652f\u6301\u7684action_param_type");
    }

    private static Object getFunctionVal(String functionName, List<ActionParam> funcParams, Map<String, Object> record) {
        if (CollectionUtil.isEmpty(funcParams)) {
            return RespParser.doFunction(functionName, null);
        }
        ArrayList<Object> paramValList = new ArrayList<Object>();
        for (ActionParam actionParam : funcParams) {
            paramValList.add(RespParser.parseVal(actionParam, record));
        }
        return RespParser.doFunction(functionName, paramValList);
    }

    private static Object doFunction(String functionName, List<Object> paramList) {
        ActionParamFunc func = FUNC_MAP.get(functionName);
        if (func == null) {
            throw new RuntimeException("\u672a\u652f\u6301\u7684\u51fd\u6570\uff1a" + functionName);
        }
        return func.call(paramList);
    }

    static {
        FUNC_MAP.put("CONCAT", param -> {
            if (CollectionUtil.isEmpty(param)) {
                return null;
            }
            return CollectionUtil.join(param, "");
        });
    }

    private static interface ActionParamFunc {
        public Object call(List<Object> var1);
    }
}

