/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.client;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.client.GPT_CLIENT;
import com.digiwin.chatbi.client.GPT_MODEL;
import com.digiwin.chatbi.common.exception.GptCallAssert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public interface StandardOpenAIClient
extends GPT_CLIENT {
    public String getEndpoint();

    public GPT_MODEL getModel();

    default public String call(String systemPrompt, String userPrompt, String endPoint, Integer maxToken, String temperature, String token, String apiKey, String model, Boolean stream, GPT_CLIENT.StreamCallback streamCallback, JSONObject context) {
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "Bearer " + apiKey);
        return (String)GptCallAssert.GPT_CALL_FAIL_ASSERT.tryCatch(() -> this.callOpenAi(this.createParam(systemPrompt, userPrompt, null, model, stream), endPoint, token, headerParam, apiKey, streamCallback, context), new Object[]{systemPrompt});
    }

    default public String call(List<JSONObject> contents, String endPoint, Integer maxToken, String temperature, String token, String apiKey, String model, Boolean stream, GPT_CLIENT.StreamCallback streamCallback, JSONObject context) {
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "Bearer " + apiKey);
        return (String)GptCallAssert.GPT_CALL_FAIL_ASSERT.tryCatch(() -> this.callOpenAi(this.createParam(contents, null, model, stream), endPoint, token, headerParam, apiKey, streamCallback, context), new Object[]{contents});
    }

    default public String createParam(String systemPrompt, String userPrompt, String sessionId, String model, Boolean stream) {
        ArrayList<JSONObject> messages = new ArrayList<JSONObject>();
        if (StringUtils.isNotBlank((CharSequence)systemPrompt)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("role", (Object)"system");
            jsonObject.put("content", (Object)systemPrompt);
            messages.add(jsonObject);
        }
        JSONObject roleJsonObject = new JSONObject();
        roleJsonObject.put("role", (Object)"user");
        roleJsonObject.put("content", (Object)userPrompt);
        messages.add(roleJsonObject);
        return this.createParam(messages, sessionId, model, stream);
    }

    default public String createParam(List<JSONObject> contents, String sessionId, String model, Boolean stream) {
        JSONObject param = new JSONObject();
        param.put("stream", (Object)stream);
        param.put("model", (Object)(StringUtils.isNotEmpty((CharSequence)model) ? model : this.getModel().getModel()));
        param.put("temperature", (Object)0);
        if (model.contains("qwen") || model.contains("Qwen")) {
            param.put("enable_thinking", (Object)false);
        }
        param.put("max_tokens", (Object)4096);
        param.put("top_p", (Object)1);
        param.put("messages", contents);
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            param.put("session_id", (Object)sessionId);
            param.put("session_limit", (Object)2);
        }
        return param.toJSONString();
    }

    default public String parasContent(String responseBody) {
        return JSONObject.parseObject((String)responseBody).getJSONArray("choices").getJSONObject(0).getJSONObject("message").getString("content");
    }
}

