/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.reasoning.search.config.AiEndpointConfig;
import com.digiwin.chatbi.reasoning.search.config.AppTokenConfig;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AiServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(AiServiceInvoker.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AiEndpointConfig aiEndpointConfig;
    private static String url = "/api/ai/RequestHDL";
    @Autowired
    private AppTokenConfig appTokenConfig;
    private static final Integer timeout = 60;

    public JSONArray synonymSearch(String token, String question, JSONArray applicationCodes, String version, String tenantId, String entityType) throws BussinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", token);
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.appTokenConfig.getAthena());
        JSONObject body = new JSONObject();
        body.put("key", (Object)"0");
        body.put("asynchronous", (Object)false);
        JSONObject data = new JSONObject();
        data.put("method", (Object)"CLU_IE");
        data.put("model", (Object)"es/metadata/syn_search");
        data.put("topic", (Object)"AI");
        data.put("timeout", (Object)timeout);
        JSONObject query = new JSONObject();
        query.put("question", (Object)question);
        JSONArray assistantIdList = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)applicationCodes)) {
            for (Object applicationCode : applicationCodes) {
                JSONObject assistantId = new JSONObject();
                assistantId.put(applicationCode.toString(), (Object)version);
                assistantIdList.add((Object)assistantId);
            }
            query.put("assistant_id_list", (Object)assistantIdList);
        }
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            query.put("tenant_id", (Object)tenantId);
        }
        if (StringUtils.isNotEmpty((CharSequence)entityType)) {
            query.put("entity_type", (Object)entityType);
        }
        data.put("data", (Object)query);
        body.put("data", (Object)data);
        log.info("synonymSearch\u5165\u53c2:{}", (Object)body);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            long start = System.currentTimeMillis();
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.aiEndpointConfig.getAiEndpoint().concat(url), (Object)httpEntity, String.class, new Object[0]);
            long end = System.currentTimeMillis();
            log.info("\u5927ai\u63a5\u53e3\u8017\u65f6\uff1a{}ms", (Object)(end - start));
            log.info("synonymSearch\u51fa\u53c2\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONObject res = JSONObject.parseObject((String)((String)responseEntity.getBody()));
                if (!Objects.isNull(res) && "0".equals(res.getString("code")) && "0".equals(res.getJSONObject("data").getString("code"))) {
                    JSONArray tenantSynonyms = res.getJSONObject("data").getJSONObject("data").getJSONArray("tenant_synonyms");
                    if (CollectionUtils.isNotEmpty((Collection)tenantSynonyms)) {
                        return tenantSynonyms;
                    }
                    JSONArray appSynonyms = res.getJSONObject("data").getJSONObject("data").getJSONArray("app_synonyms");
                    if (CollectionUtils.isNotEmpty((Collection)appSynonyms)) {
                        return appSynonyms;
                    }
                }
                return null;
            }
            log.warn("ai\u641c\u7d22\u540c\u4e49\u8bcd\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse("ai\u641c\u7d22\u540c\u4e49\u8bcd\u5931\u8d25"));
            throw new BussinessException((String)responseEntity.getBody());
        }
        catch (Exception e2) {
            log.error("ai\u641c\u7d22\u540c\u4e49\u8bcd\u5931\u8d25, \u62a5\u9519\u4fe1\u606f\uff1a{} ", (Throwable)e2);
            throw new BussinessException(e2.getMessage());
        }
    }
}

