/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.SysUserInfo;
import com.digiwin.chatbi.beans.vos.iam.Role;
import com.digiwin.chatbi.beans.vos.iam.TenantVo;
import com.digiwin.chatbi.common.UserThreadLocal;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.common.exception.TimeOutException;
import com.digiwin.chatbi.common.util.HttpUtils;
import com.digiwin.chatbi.reasoning.search.config.AniaHostConfig;
import com.digiwin.chatbi.reasoning.search.config.AppTokenConfig;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class IamServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(IamServiceInvoker.class);
    @Value(value="${iam.appToken}")
    private String appToken;
    @Value(value="${iam.url}")
    private String iamApiHost;
    @Value(value="${iam.app-id}")
    private String appId;
    @Value(value="${ania.url}")
    private String aniaApiHost;
    @Value(value="${message-dialogue.minutes}")
    private Long messageDialogueMinutes;
    @Value(value="${message-dialogue.page-num}")
    private Integer messageDialoguePageNum;
    @Autowired
    private AniaHostConfig aniaHostConfig;
    @Autowired
    private AppTokenConfig appTokenConfig;
    private String ERR_MESSAGE = "iam\u7cfb\u7edf\u5f02\u5e38";
    private static String SCRUMBITYPE = "1";
    private static final String USER_PERMISSION_URL = "/api/iam/v2/permission/user/all";
    private static final String TENANTS_URL = "/api/iam/v2/tenant";
    private static final String CHANGE_TENANTS_URL = "/api/iam/v2/identity/token/refresh/tenant";
    private static final String HISTORY_MESSAGE_URL = "/gpt/message/dialogue/latelyMessage";
    private static final String HISTORY_MESSAGE_URL_V2 = "/ania/assistant/message/list";
    private static final String IDENTITY_LOGIN_INTERNAL = "/api/iam/v2/identity/login/internal";
    @Autowired
    private RestTemplate restTemplate;
    private static final String DIGI_MIDDLEWARE_AUTH_APP = "digi-middleware-auth-app";
    private static final String DIGI_MIDDLEWARE_AUTH_USER = "digi-middleware-auth-user";
    private static final String TOKEN = "token";
    private static final String ROUTERKEY = "routerKey";

    public Role iamUserPermissionInfo(String token) throws BussinessException {
        Map header = this.getHeaderMap(token);
        String paramJsonStr = "{\"queryParameter\":{\"effect\":\"allow\"}}";
        String result = HttpUtils.post((String)this.iamApiHost.concat(USER_PERMISSION_URL), (String)paramJsonStr, null, (Map)header);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        String errorCode = resultJson.getString("errorCode");
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            throw new TimeOutException("\u6743\u9650\u8ba4\u8bc1\u5931\u8d25!");
        }
        String userId = resultJson.getJSONObject("query").getString("userId");
        JSONObject result1 = resultJson.getJSONObject("result");
        JSONArray roles = result1.getJSONArray("roles");
        List rolesList = JSONObject.parseArray((String)roles.toJSONString(), Role.class);
        if (CollectionUtils.isEmpty((Collection)rolesList)) {
            throw new TimeOutException("\u6743\u9650\u8ba4\u8bc1\u5931\u8d25!");
        }
        Role role = (Role)rolesList.get(0);
        role.setName(userId);
        role.setId(userId);
        return role;
    }

    public List<TenantVo> tenants(String token) throws BussinessException {
        Map header = this.getHeaderMap(token);
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("appId", this.appId);
        String result = HttpUtils.post((String)this.iamApiHost.concat(TENANTS_URL), (String)JSONObject.toJSONString(request), null, (Map)header);
        if (result.contains("errorCode")) {
            throw new BussinessException("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25!");
        }
        List tenantVos = JSONObject.parseArray((String)result, TenantVo.class);
        if (CollectionUtils.isEmpty((Collection)tenantVos)) {
            throw new BussinessException("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25!");
        }
        return tenantVos;
    }

    public JSONObject changeTenant(String tenantId) throws BussinessException {
        SysUserInfo sysUserInfo = UserThreadLocal.get();
        Map header = this.getHeaderMap(sysUserInfo.getTbbToken());
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("tenantId", tenantId);
        String result = HttpUtils.post((String)this.iamApiHost.concat(CHANGE_TENANTS_URL), (String)JSONObject.toJSONString(request), null, (Map)header);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        String errorCode = resultJson.getString("errorCode");
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            throw new BussinessException(resultJson.getString("errorMessage"));
        }
        return resultJson;
    }

    private Map<String, String> getHeaderMap(String token) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(DIGI_MIDDLEWARE_AUTH_APP, this.appToken);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            header.put(DIGI_MIDDLEWARE_AUTH_USER, token);
        }
        return header;
    }

    public String identityLoginInternal(String tenantId) {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("tenantId", tenantId);
        request.put("userId", "integration");
        request.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        log.info("\u83b7\u53d6\u96c6\u6210token\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString(request));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add(DIGI_MIDDLEWARE_AUTH_APP, this.appTokenConfig.getScrumbi());
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(request), (MultiValueMap)headers);
        JSONArray jsonArray = new JSONArray();
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.aniaHostConfig.getUrl().concat(IDENTITY_LOGIN_INTERNAL), (Object)httpEntity, String.class, new Object[0]);
            log.info("identityLoginInternal\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (StringUtils.isNotEmpty((CharSequence)JSONObject.parseObject((String)((String)responseEntity.getBody())).getString("errorMessage")) && StringUtils.isNotEmpty((CharSequence)JSONObject.parseObject((String)((String)responseEntity.getBody())).getString("errorCode"))) {
                    log.info("\u83b7\u53d6\u96c6\u6210token\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
                    throw new BussinessException(Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
                }
                return JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response").getString(TOKEN);
            }
            log.info("\u83b7\u53d6\u96c6\u6210token\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
            return null;
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u83b7\u53d6\u96c6\u6210token\u5931\u8d25", request, e2});
            return null;
        }
    }

    public List<JSONObject> getUserHistoryMessage(String token, String routerKey, String sessionId, String asaCode) throws BussinessException {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BussinessException("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bddtoken\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("num", this.messageDialoguePageNum);
        request.put("skillType", SCRUMBITYPE);
        if (StringUtils.isNotBlank((CharSequence)sessionId) && !"null".equals(sessionId)) {
            request.put("sessionId", sessionId);
        }
        request.put("asaCode", asaCode);
        log.info("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString(request));
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            try {
                LocalDateTime threshold = LocalDateTime.now().minus(this.messageDialogueMinutes, ChronoUnit.MINUTES);
                LocalDateTime time = new Timestamp(Long.valueOf(sessionId)).toLocalDateTime();
                if (time.isBefore(threshold)) {
                    log.warn("\u65f6\u95f4\u6233\u5df2\u8fc7\u671f,\u5f53\u524d\u65f6\u95f4:{},sessionId:{}", (Object)LocalDateTime.now(), (Object)sessionId);
                }
            }
            catch (NumberFormatException e2) {
                log.warn("\u65f6\u95f4\u6233\u8f6c\u6362\u5f02\u5e38 sessionId:{}", (Object)sessionId);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(request), (MultiValueMap)headers);
        JSONArray jsonArray = new JSONArray();
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.aniaHostConfig.getUrl().concat(HISTORY_MESSAGE_URL), (Object)httpEntity, String.class, new Object[0]);
            log.info("getUserHistoryMessage\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                jsonArray = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("response");
                if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                    jsonArray = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("data");
                }
                LocalDateTime now = LocalDateTime.now();
                LocalDateTime threshold = now.minus(this.messageDialogueMinutes, ChronoUnit.MINUTES);
                List<JSONObject> sortedList = jsonArray.stream().map(obj -> new JSONObject((Map)((JSONObject)obj))).filter(json -> "1".equals(json.getJSONObject("msgExt").getString("skillType"))).filter(json -> {
                    Timestamp timestamp = new Timestamp(Long.valueOf(json.getString("msgTimestamp")));
                    LocalDateTime time = timestamp.toLocalDateTime();
                    return !time.isBefore(threshold);
                }).sorted(Comparator.comparing(jsonObj -> jsonObj.getString("msgTimestamp"))).collect(Collectors.toList());
                return sortedList;
            }
            log.info("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
            throw new BussinessException(Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e3) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u5931\u8d25", request, e3});
            throw new BussinessException("\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\uff1a" + jsonArray.toJSONString());
        }
    }

    public List<JSONObject> getLastedUserHistoryMessage(String token, String routerKey, String sessionId, String asaCode) throws BussinessException {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BussinessException("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bddtoken\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("num", 2);
        request.put("skillType", SCRUMBITYPE);
        if (StringUtils.isNotBlank((CharSequence)sessionId) && !"null".equals(sessionId)) {
            request.put("sessionId", sessionId);
        }
        request.put("asaCode", asaCode);
        log.info("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString(request));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(request), (MultiValueMap)headers);
        JSONArray jsonArray = new JSONArray();
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.aniaHostConfig.getUrl().concat(HISTORY_MESSAGE_URL), (Object)httpEntity, String.class, new Object[0]);
            log.info("getUserHistoryMessage\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                jsonArray = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("response");
                if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                    jsonArray = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("data");
                }
                List<JSONObject> sortedList = jsonArray.stream().map(obj -> new JSONObject((Map)((JSONObject)obj))).filter(json -> "1".equals(json.getJSONObject("msgExt").getString("skillType"))).sorted(Comparator.comparing(jsonObj -> jsonObj.getString("msgTimestamp"))).collect(Collectors.toList());
                return sortedList;
            }
            log.info("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
            throw new BussinessException(Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u5931\u8d25", request, e2});
            throw new BussinessException("\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\uff1a" + jsonArray.toJSONString());
        }
    }

    public JSONObject getLastedUserHistoryMessageV2(String token, String routerKey, String conversationId, String asaCode, String messageId, String sectionId) throws BussinessException {
        List res = this.getLastedUserHistoryMessageV2WithCount(token, routerKey, conversationId, asaCode, messageId, sectionId, 10);
        if (CollectionUtils.isNotEmpty((Collection)res)) {
            return (JSONObject)res.get(0);
        }
        return null;
    }

    public List<JSONObject> getLastedUserHistoryMessageV2WithCount(String token, String routerKey, String conversationId, String asaCode, String messageId, String sectionId, int count) throws BussinessException {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BussinessException("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bddtoken\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("limit", count);
        request.put("conversationId", StringUtils.isEmpty((CharSequence)conversationId) ? "" : conversationId);
        request.put("assistantId", asaCode);
        log.info("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString(request));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(request), (MultiValueMap)headers);
        JSONArray jsonArray = new JSONArray();
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.aniaHostConfig.getUrl().concat(HISTORY_MESSAGE_URL_V2), (Object)httpEntity, String.class, new Object[0]);
            log.info("getUserHistoryMessage\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (StringUtils.isNotEmpty((CharSequence)JSONObject.parseObject((String)((String)responseEntity.getBody())).getString("errorMessage")) && StringUtils.isNotEmpty((CharSequence)JSONObject.parseObject((String)((String)responseEntity.getBody())).getString("errorCode"))) {
                    log.info("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
                    throw new BussinessException(Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
                }
                jsonArray = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response").getJSONArray("messages");
                if (StringUtils.isEmpty((CharSequence)messageId) || StringUtils.isEmpty((CharSequence)sectionId)) {
                    return null;
                }
                List<JSONObject> collect = jsonArray.stream().filter(j -> sectionId.equals(((JSONObject)j).getString("sectionId")) && !messageId.equals(((JSONObject)j).getString("messageId"))).map(o -> (JSONObject)o).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    log.error("\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u622a\u53d6\u5f02\u5e38");
                    return null;
                }
                return collect;
            }
            log.info("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
            throw new BussinessException(Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("\u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u5931\u8d25", request, e2});
            throw new BussinessException("\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\uff1a" + jsonArray.toJSONString());
        }
    }
}

