/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.client.GPT_MODEL;
import com.digiwin.chatbi.common.InternetSearch4Aliyuncs;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.common.exception.GptCallAssert;
import com.digiwin.chatbi.common.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

@Component
public class InternetSearch4Aliyuncs {
    private static final String endPoint = "https://dashscope.aliyuncs.com/api/v1/services/aigc/text-generation/generation";

    public JSONObject call(String systemPrompt, String userPrompt, String apiKey) {
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "Bearer " + apiKey);
        return (JSONObject)GptCallAssert.GPT_CALL_FAIL_ASSERT.tryCatch(() -> this.callAliyun(this.createParam(systemPrompt, userPrompt, GPT_MODEL.QWEN_FLASH.getModel()), headerParam), new Object[]{systemPrompt});
    }

    private JSONObject callAliyun(String body, Map<String, String> headerParams) throws Exception {
        1 retryHandler = new /* Unavailable Anonymous Inner Class!! */;
        try {
            CloseableHttpResponse response;
            Logger.info((String)"endPointLog4Aliyun:https://dashscope.aliyuncs.com/api/v1/services/aigc/text-generation/generation");
            HttpPost httpPost = new HttpPost(endPoint);
            httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            for (Map.Entry<String, String> headerParam : headerParams.entrySet()) {
                httpPost.setHeader(headerParam.getKey(), headerParam.getValue());
            }
            httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(50000).setSocketTimeout(50000).build();
            try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)retryHandler).build();){
                Logger.info((String)("\u8c03\u7528\u963f\u91cc\u4e91\u5343\u95eeflash\u5165\u53c2\uff1a" + body));
                response = httpClient.execute((HttpUriRequest)httpPost);
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            Logger.info((String)("\u8c03\u7528\u963f\u91cc\u4e91\u5343\u95eeflash\u51fa\u53c2\uff1a" + responseBody));
            return this.parasContent(responseBody);
        }
        catch (Exception e) {
            Logger.info((String)("\u8c03\u7528\u963f\u91cc\u4e91\u5343\u95eeflash\u5f02\u5e38\uff1a" + e.toString()));
            throw e;
        }
    }

    private JSONObject parasContent(String responseBody) throws BussinessException {
        JSONObject result = JSONObject.parseObject((String)responseBody);
        JSONObject output = result.getJSONObject("output");
        if (Objects.isNull(output)) {
            String message = result.getString("message");
            throw new BussinessException(message);
        }
        JSONObject parseResult = new JSONObject();
        JSONObject searchInfo = output.getJSONObject("search_info");
        ArrayList<String> searchRes = new ArrayList<String>();
        if (Objects.nonNull(searchInfo)) {
            JSONArray searchResults = searchInfo.getJSONArray("search_results");
            for (int i = 0; i < searchResults.size(); ++i) {
                JSONObject item = (JSONObject)searchResults.get(i);
                String sr = "[" + item.get((Object)"index") + "]: [" + item.getString("title").trim() + "](" + item.getString("url") + ")";
                searchRes.add(sr);
            }
        }
        parseResult.put("searchResults", searchRes);
        String content = output.getJSONArray("choices").getJSONObject(0).getJSONObject("message").getString("content");
        parseResult.put("content", (Object)content);
        return parseResult;
    }

    private String createParam(String systemPrompt, String userPrompt, String model) {
        ArrayList<JSONObject> messages = new ArrayList<JSONObject>();
        if (StringUtils.isNotBlank((CharSequence)systemPrompt)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("role", (Object)"system");
            jsonObject.put("content", (Object)systemPrompt);
            messages.add(jsonObject);
        }
        JSONObject roleJsonObject = new JSONObject();
        roleJsonObject.put("role", (Object)"user");
        roleJsonObject.put("content", (Object)userPrompt);
        messages.add(roleJsonObject);
        JSONObject input = new JSONObject();
        input.put("messages", messages);
        JSONObject param = new JSONObject();
        param.put("model", (Object)model);
        param.put("input", (Object)input);
        JSONObject parameters = new JSONObject();
        parameters.put("result_format", (Object)"message");
        parameters.put("enable_search", (Object)true);
        JSONObject searchOptions = new JSONObject();
        searchOptions.put("forced_search", (Object)true);
        searchOptions.put("enable_source", (Object)true);
        searchOptions.put("enable_citation", (Object)true);
        searchOptions.put("enable_search_extension", (Object)true);
        searchOptions.put("citation_format", (Object)"[ref_<number>]");
        searchOptions.put("search_strategy", (Object)"turbo");
        parameters.put("search_options", (Object)searchOptions);
        param.put("parameters", (Object)parameters);
        return param.toJSONString();
    }
}

