/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common.interceptor;

import com.digiwin.chatbi.common.annotations.LogRecord;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class InterLogHandler {
    private static final Logger log = LoggerFactory.getLogger(InterLogHandler.class);

    @AfterReturning(pointcut="@annotation(logRecord)", returning="result")
    public void doAround(JoinPoint joinPoint, LogRecord logRecord, Object result) throws Throwable {
        try {
            this.saveOpLog(joinPoint, result, logRecord, null, Integer.valueOf(0));
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
    }

    @AfterThrowing(pointcut="@annotation(logRecord)", throwing="exception")
    public void logMethodException(JoinPoint joinPoint, LogRecord logRecord, Throwable exception) throws Throwable {
        try {
            this.saveOpLog(joinPoint, null, logRecord, exception.getMessage(), Integer.valueOf(1));
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
    }

    private void saveOpLog(JoinPoint pjp, Object result, LogRecord logRecord, String ex, Integer status) {
    }
}

