/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.digiwin.chatbi.common.exception.BussinessException;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    public static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static String get(String url, String param, Map<String, Object> formParam, Map<String, String> header) throws BussinessException {
        HttpRequest get = HttpRequest.get((String)url).form(formParam);
        get.addHeaders(header);
        if (StringUtils.isNotBlank((CharSequence)param)) {
            get.body(param);
        }
        get.timeout(20000);
        HttpResponse execute = get.execute();
        String result = "";
        if (execute.getStatus() != 200 && execute.getStatus() != 404) {
            logger.error("http get url:{} response status code is not 200!response:{}", (Object)url, (Object)execute.body());
            throw new BussinessException(execute.body());
        }
        result = execute.body();
        return result;
    }

    public static String post(String url, String param, Map<String, Object> formParam, Map<String, String> header) throws BussinessException {
        HttpRequest post = HttpRequest.post((String)url);
        post.addHeaders(header);
        post.body(param);
        post.form(formParam);
        post.timeout(20000);
        HttpResponse execute = post.execute();
        String result = "";
        if (execute.getStatus() != 200) {
            logger.error("http post url:{} response status code is not 200!response:{}", (Object)url, (Object)execute.body());
            String errorResult = execute.body();
            return errorResult;
        }
        result = execute.body();
        return result;
    }

    public static String put(String url, String param, Map<String, Object> formParam, Map<String, String> header) throws BussinessException {
        HttpRequest put = HttpRequest.put((String)url);
        put.addHeaders(header);
        put.body(param);
        put.form(formParam);
        put.timeout(20000);
        HttpResponse execute = put.execute();
        String result = "";
        if (execute.getStatus() != 200) {
            logger.error("http put url:{} response status code is not 200!response:{}", (Object)url, (Object)execute.body());
            throw new BussinessException(execute.body());
        }
        result = execute.body();
        return result;
    }

    public static String delete(String url, String param, Map<String, Object> formParam, Map<String, String> header) throws Exception {
        HttpRequest delete = HttpRequest.delete((String)url);
        delete.addHeaders(header);
        delete.body(param);
        delete.form(formParam);
        delete.timeout(20000);
        HttpResponse execute = delete.execute();
        String result = "";
        if (execute.getStatus() != 200) {
            logger.error("http delete url:{} response status code is not 200!response:{}", (Object)url, (Object)execute.body());
            throw new BussinessException(execute.body());
        }
        result = execute.body();
        return result;
    }

    public static void concatHeader(Map<String, String> header, HttpRequestBase post) {
        Optional.ofNullable(header).filter(i -> !i.isEmpty()).ifPresent(i -> i.entrySet().forEach(entry -> post.addHeader((String)entry.getKey(), (String)entry.getValue())));
    }
}

