/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JsonRefProcessor {
    InternalData("report", "datasets"),
    ExternalInsights("report", "urls"),
    FusionReport("report", "refs");

    private String reportKey;
    private String urlsKey;
    private static final Pattern REF_PATTERN;
    private static final Pattern URL_INDEX_PATTERN;

    public JSONObject process(JSONObject input) {
        try {
            return this.reindexUrls(this.removeDuplicateUrls(this.removeNoneRef(input)));
        }
        catch (Exception e) {
            return input;
        }
    }

    public JSONObject removeNoneRef(JSONObject input) {
        String report = input.getString(this.reportKey);
        JSONArray urls = input.getJSONArray(this.urlsKey);
        Pattern pattern = Pattern.compile("\\[ref_(\\d+)]");
        Matcher matcher = pattern.matcher(report);
        LinkedHashSet<Integer> usedIndexes = new LinkedHashSet<Integer>();
        while (matcher.find()) {
            usedIndexes.add(Integer.parseInt(matcher.group(1)));
        }
        HashMap<Integer, Integer> oldToNew = new HashMap<Integer, Integer>();
        int newIndex = 1;
        for (Integer oldIndex : usedIndexes) {
            oldToNew.put(oldIndex, newIndex++);
        }
        matcher = pattern.matcher(report);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int oldIndex = Integer.parseInt(matcher.group(1));
            int mappedIndex = (Integer)oldToNew.get(oldIndex);
            matcher.appendReplacement(sb, "[ref_" + mappedIndex + "]");
        }
        matcher.appendTail(sb);
        String newReport = sb.toString();
        JSONArray newUrls = new JSONArray();
        for (int i = 0; i < urls.size(); ++i) {
            String urlEntry = urls.getString(i);
            int urlIndex = i + 1;
            if (!oldToNew.containsKey(urlIndex)) continue;
            int mappedIndex = (Integer)oldToNew.get(urlIndex);
            String updatedUrl = urlEntry.replaceFirst("^\\[" + urlIndex + "]", "[" + mappedIndex + "]");
            newUrls.add((Object)updatedUrl);
        }
        JSONObject output = new JSONObject();
        output.put(this.reportKey, (Object)newReport.replace("[ref_null]", ""));
        output.put(this.urlsKey, (Object)newUrls);
        return this.reindexUrls(output);
    }

    public JSONObject removeDuplicateUrls(JSONObject input) {
        String report = input.getString(this.reportKey);
        JSONArray urls = input.getJSONArray(this.urlsKey);
        Pattern linkPattern = Pattern.compile("^\\[\\d+]: \\[(.*?)]\\(");
        Pattern textPattern = Pattern.compile("^\\[\\d+]:\\s*(.*)$");
        Pattern refPattern = Pattern.compile("\\[ref_(\\d+)]");
        HashMap<String, Integer> titleToKeptIndex = new HashMap<String, Integer>();
        HashMap<Integer, Integer> duplicateRedirect = new HashMap<Integer, Integer>();
        LinkedHashMap<Integer, String> indexToUrl = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < urls.size(); ++i) {
            int idx = i + 1;
            String urlEntry = urls.getString(i);
            String title = "";
            Matcher m1 = linkPattern.matcher(urlEntry);
            Matcher m2 = textPattern.matcher(urlEntry);
            if (m1.find()) {
                title = m1.group(1).trim();
            } else if (m2.find()) {
                title = m2.group(1).trim();
            }
            if (titleToKeptIndex.containsKey(title)) {
                duplicateRedirect.put(idx, (Integer)titleToKeptIndex.get(title));
                continue;
            }
            titleToKeptIndex.put(title, idx);
            indexToUrl.put(idx, urlEntry);
        }
        Matcher matcher = refPattern.matcher(report);
        StringBuffer sbReport = new StringBuffer();
        while (matcher.find()) {
            int oldIndex = Integer.parseInt(matcher.group(1));
            int targetIndex = duplicateRedirect.getOrDefault(oldIndex, oldIndex);
            matcher.appendReplacement(sbReport, "[ref_" + targetIndex + "]");
        }
        matcher.appendTail(sbReport);
        report = sbReport.toString();
        HashMap<Integer, Integer> oldToNew = new HashMap<Integer, Integer>();
        int newIdx = 1;
        for (Integer oldIndex : indexToUrl.keySet()) {
            oldToNew.put(oldIndex, newIdx++);
        }
        matcher = refPattern.matcher(report);
        StringBuffer finalReport = new StringBuffer();
        while (matcher.find()) {
            int oldIndex = Integer.parseInt(matcher.group(1));
            matcher.appendReplacement(finalReport, "[ref_" + oldToNew.get(oldIndex) + "]");
        }
        matcher.appendTail(finalReport);
        JSONArray newUrls = new JSONArray();
        for (Map.Entry entry : indexToUrl.entrySet()) {
            int oldIndex = (Integer)entry.getKey();
            int mappedIndex = (Integer)oldToNew.get(oldIndex);
            String updatedUrl = ((String)entry.getValue()).replaceFirst("^\\[" + oldIndex + "]", "[" + mappedIndex + "]");
            newUrls.add((Object)updatedUrl);
        }
        String cleanedReport = finalReport.toString().replaceAll("(\\[ref_\\d+])\\1+", "$1");
        JSONObject output = new JSONObject();
        output.put(this.reportKey, (Object)cleanedReport.replace("[ref_null]", ""));
        output.put(this.urlsKey, (Object)newUrls);
        return this.reindexUrls(output);
    }

    public JSONObject reindexUrls(JSONObject input) {
        String report = input.getString(this.reportKey);
        JSONArray urls = input.getJSONArray(this.urlsKey);
        Pattern refPattern = Pattern.compile("\\[ref_(\\d+)]");
        HashMap<Integer, Integer> oldToNew = new HashMap<Integer, Integer>();
        for (int i = 0; i < urls.size(); ++i) {
            int oldIndex = Integer.parseInt(urls.getString(i).substring(1, urls.getString(i).indexOf("]")));
            oldToNew.put(oldIndex, i + 1);
        }
        Matcher matcher = refPattern.matcher(report);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int oldIndex = Integer.parseInt(matcher.group(1));
            matcher.appendReplacement(sb, "[ref_" + oldToNew.get(oldIndex) + "]");
        }
        matcher.appendTail(sb);
        String newReport = sb.toString();
        JSONArray newUrls = new JSONArray();
        for (int i = 0; i < urls.size(); ++i) {
            int newIndex = i + 1;
            String updatedUrl = urls.getString(i).replaceFirst("^\\[\\d+]", "[" + newIndex + "]");
            newUrls.add((Object)updatedUrl);
        }
        JSONObject output = new JSONObject();
        output.put(this.reportKey, (Object)newReport.replace("[ref_null]", ""));
        output.put(this.urlsKey, (Object)newUrls);
        return output;
    }

    public JSONObject shiftRefs(JSONObject input, int offset) {
        String report = input.getString(this.reportKey);
        JSONArray urls = input.getJSONArray(this.urlsKey);
        Matcher matcher = REF_PATTERN.matcher(report);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int oldIndex = Integer.parseInt(matcher.group(1));
            int newIndex = oldIndex + offset;
            matcher.appendReplacement(sb, "[ref_" + newIndex + "]");
        }
        matcher.appendTail(sb);
        String newReport = sb.toString();
        JSONArray newUrls = new JSONArray();
        for (int i = 0; i < urls.size(); ++i) {
            String urlEntry = urls.getString(i);
            Matcher um = URL_INDEX_PATTERN.matcher(urlEntry);
            if (um.find()) {
                int oldIndex = Integer.parseInt(um.group(1));
                int newIndex = oldIndex + offset;
                String updatedUrl = um.replaceFirst("[" + newIndex + "]");
                newUrls.add((Object)updatedUrl);
                continue;
            }
            newUrls.add((Object)urlEntry);
        }
        input.put(this.reportKey, (Object)newReport);
        input.put(this.urlsKey, (Object)newUrls);
        return input;
    }

    public JSONObject mergeJsonList(List<JSONObject> inputs) {
        return this.mergeJsonList(inputs, 0);
    }

    public JSONObject mergeJsonList(List<JSONObject> inputs, int initOffset) {
        ArrayList<JSONObject> mergedReport = new ArrayList<JSONObject>();
        JSONArray mergedUrls = new JSONArray();
        int offset = initOffset;
        for (int i = 0; i < inputs.size(); ++i) {
            JSONObject current = inputs.get(i);
            if (offset > 0) {
                current = this.shiftRefs(current, offset);
            }
            mergedReport.add(current);
            mergedUrls.addAll((Collection)current.getJSONArray(this.urlsKey));
            offset = mergedUrls.size() + initOffset;
        }
        JSONObject result = new JSONObject();
        result.put(this.reportKey, mergedReport);
        result.put(this.urlsKey, (Object)mergedUrls);
        return result;
    }

    public static void main(String[] args) {
        String jsonStr = "{\"report\": \"\u6839\u636e2025\u5e74\u5404\u5b63\u5ea6\u7684\u5229\u6da6\u6570\u636e\u5206\u6790\uff0c\u4ee5\u4e0b\u662f\u5173\u952e\u53d1\u73b0\uff1a\n1. 2025\u5e74\u7b2c\u4e00\u5b63\u5ea6\u7684\u5229\u6da6\u603b\u989d\u4e3a34468.48\u4e07\u5143 [ref_1][ref_2]\u3002\n2. \u4e0e2024\u5e74\u540c\u671f\u76f8\u6bd4\uff0c2025\u5e74\u7b2c\u4e00\u5b63\u5ea6\u7684\u5229\u6da6\u603b\u989d\u540c\u6bd4\u589e\u957f\u4e86100%\uff0c\u4e3b\u8981\u539f\u56e0\u662f2024\u5e74\u540c\u671f\u5229\u6da6\u4e3a\u96f6 [ref_1]\u3002\n3. \u6570\u636e\u4e2d\u7f3a\u5c112025\u5e74\u7b2c\u4e8c\u5b63\u5ea6\u53ca\u4e4b\u540e\u7684\u5229\u6da6\u6570\u636e\uff0c\u56e0\u6b64\u65e0\u6cd5\u5168\u9762\u5206\u6790\u5b63\u5ea6\u95f4\u7684\u6ce2\u52a8\u60c5\u51b5\u6216\u5b63\u8282\u6027\u8d8b\u52bf\u3002\",\"datasets\": [\"[1]: \u6570\u636e\u96c6[\u5229\u6da6]\"]}";
        JSONObject input = JSON.parseObject((String)jsonStr);
        JSONObject output = InternalData.process(input);
        System.out.println(JSON.toJSONString((Object)output, (boolean)true));
    }

    private JsonRefProcessor(String reportKey, String urlsKey) {
        this.reportKey = reportKey;
        this.urlsKey = urlsKey;
    }

    public String getReportKey() {
        return this.reportKey;
    }

    public String getUrlsKey() {
        return this.urlsKey;
    }

    static {
        REF_PATTERN = Pattern.compile("\\[ref_(\\d+)]");
        URL_INDEX_PATTERN = Pattern.compile("^\\[(\\d+)]");
    }
}

