/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.beans.dtos.chart.BusinessCreateReqDto;
import com.digiwin.chatbi.beans.dtos.chart.BusinessCreateResDto;
import com.digiwin.chatbi.beans.dtos.chart.ExtInfoCreateReqDto;
import com.digiwin.chatbi.beans.dtos.chart.ExtInfoResDto;
import com.digiwin.chatbi.beans.dtos.chart.QuestionRecommendTReqDto;
import com.digiwin.chatbi.beans.dtos.chart.TopicDto;
import com.digiwin.chatbi.beans.pojos.DataAnalysisReq;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.QuestionDemo;
import com.digiwin.chatbi.beans.pojos.QuestionLite;
import com.digiwin.chatbi.beans.pojos.autoData.IntentionConfirmReq;
import com.digiwin.chatbi.beans.pojos.autoData.ReportCreateReq;
import com.digiwin.chatbi.beans.pojos.convoBoard.ChartPlanReq;
import com.digiwin.chatbi.beans.pojos.convoBoard.LayoutDesignReq;
import com.digiwin.chatbi.beans.pojos.dataAttribution.DataAttributionReportRequest;
import com.digiwin.chatbi.beans.pojos.dataAttribution.DataAttributionRequest;
import com.digiwin.chatbi.beans.pojos.dataAttribution.FluctuateRequest;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.PPTGenerateReq;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.PPTRefineReq;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.QuestionPlanningReq;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.QuestionReGenerateReq;
import com.digiwin.chatbi.beans.vos.ResultBeanExtra;
import com.digiwin.chatbi.common.enums.Locale;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.ParseFactor;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.loader.RuleFactory;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.rule.RuleType;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.model.Token;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.model.Tokenizer;
import com.digiwin.chatbi.reasoning.constant.Strategy;
import com.digiwin.chatbi.reasoning.context.SseContext;
import com.digiwin.chatbi.reasoning.executor.extract.EasyConvertorWrapperExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.GeneralConvertorWrapperExecutor;
import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import com.digiwin.chatbi.reasoning.process.AutoDataProcess;
import com.digiwin.chatbi.reasoning.process.ChatProcess;
import com.digiwin.chatbi.reasoning.process.ConvoBoardProcess;
import com.digiwin.chatbi.reasoning.process.DataAttributionProcess;
import com.digiwin.chatbi.reasoning.process.PPTGenerationProcess;
import com.digiwin.chatbi.reasoning.prompt.TemplateFormatter;
import com.digiwin.chatbi.reasoning.prompt.TemplateLocalFileBroker;
import com.digiwin.chatbi.service.OperateESService;
import com.digiwin.chatbi.service.SseEmitterCallbackComponent;
import com.digiwin.chatbi.service.TopicService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"scrumbi"})
@Api(value="ScrumBIController", tags={"ScrumBIController"})
public class ScrumBIController {
    private static final Logger log = LoggerFactory.getLogger(ScrumBIController.class);
    @Resource
    private ChatProcess chatProcess;
    @Resource
    private SseEmitterCallbackComponent sseEmitterCallbackComponent;
    @Resource
    private Executor taskExecutorScrumbi;
    @Resource
    private TopicService topicService;
    @Resource
    private OperateESService operateESService;
    @Resource
    private DataAttributionProcess dataAttributionProcess;
    @Resource
    private PPTGenerationProcess pPTGenerationProcess;
    @Resource
    private AutoDataProcess autoDataProcess;
    @Resource
    private ConvoBoardProcess convoBoardProcess;

    @PostMapping(value={"/stream/chat"})
    @ApiOperation(value="\u5bf9\u8bdd")
    public Object doChat4StreamV2(@RequestBody Question question, @RequestHeader(value="locale", required=false) String locale) {
        String traceId;
        log.info("doChat4StreamV2#request: {}", (Object)JSONObject.toJSONString((Object)question));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        question.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        question.setToken(Pipeline.getUserToken());
        question.setRouterKey(Pipeline.getRouterKey());
        question.setMessageId(Pipeline.getMessageId());
        question.setPtxId(Pipeline.getPtxId());
        question.setSid(Pipeline.getsId());
        if (StrUtil.isBlank((CharSequence)question.getPtxId())) {
            question.setPtxId(MdcUtil.getTraceId());
        }
        if (StringUtils.isNotEmpty((CharSequence)question.getCombinationMsg())) {
            question.setMultiDialogue(false);
            question.setMessage(question.getCombinationMsg());
        }
        if (StrUtil.isBlank((CharSequence)(traceId = MdcUtil.get((String)"PtxId")))) {
            traceId = MdcUtil.getTraceId();
        }
        if (question.isCloseStream()) {
            JSONObject chatResult = this.chatProcess.doProcessV2(question);
            List timeTrace = (List)chatResult.get((Object)"timeTrace");
            List outputTrace = (List)chatResult.get((Object)"outputTrace");
            chatResult.remove((Object)"timeTrace");
            chatResult.remove((Object)"outputTrace");
            ResultBeanExtra res = ResultBeanExtra.ok((Object)chatResult).withTimeTrace(question.isTimeTrace(), timeTrace).withExplain(question.isExplain(), outputTrace);
            stopWatch.stop();
            log.info("ScrumBIController#doChat4StreamV2 elapsed time: {}ms", (Object)stopWatch.getTime());
            return res;
        }
        question.setIfStream(true);
        SseEmitter sseEmitter = this.sseEmitterCallbackComponent.generateSseEmitter(question);
        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        String finalTraceId = StringUtils.isNotEmpty((CharSequence)traceId) ? traceId : question.getPtxId();
        log.info("ptxdid:{}", (Object)question.getPtxId());
        log.info("finalTraceId:{}", (Object)finalTraceId);
        CompletableFuture.runAsync(() -> {
            try {
                MdcUtil.setTraceId((String)finalTraceId);
                LocaleContextHolder.setLocale((java.util.Locale)java.util.Locale.forLanguageTag(langName));
                this.chatProcess.doProcess4StreamV2(question);
                stopWatch.stop();
                log.info("ScrumBIController#doChat4StreamV2 elapsed time: {}ms", (Object)stopWatch.getTime());
            }
            finally {
                MdcUtil.clear();
            }
        }, this.taskExecutorScrumbi);
        return sseEmitter;
    }

    @PostMapping(value={"/testToken"})
    @ApiOperation(value="testToken")
    public ResultBean<List<Token>> testToken(@RequestBody Question question) {
        List tokens = ParseFactor.parse((String)question.getMessage(), (List[])new List[]{RuleFactory.loadRulesFromEs((RuleType)RuleType.DATE)});
        return ResultBeanExtra.ok((Object)Tokenizer.process((String)question.getMessage(), (List)tokens));
    }

    @PostMapping(value={"/testGpt"})
    @ApiOperation(value="testGpt")
    public JSONObject testGpt(@RequestBody Question question) {
        question.setStrategy(Strategy.SUPER_ACCURATE);
        return this.chatProcess.tesGpt(question);
    }

    @GetMapping(value={"/generatingFunctionByGpt"})
    @ApiOperation(value="\u901a\u8fc7\u63d0\u793a\u8bcd\u751f\u6210\u51fd\u6570")
    public ResultBean generatingFunctionByGpt(@RequestParam String prompt) {
        log.info("ScrumBIController#generatingFunByGPT prompt: {}", (Object)prompt);
        if (StringUtils.isBlank((CharSequence)prompt)) {
            return null;
        }
        return this.chatProcess.generatingFunctionByGpt(prompt);
    }

    @PostMapping(value={"/chat/demo"})
    @ApiOperation(value="\u5bf9\u8bdd")
    public ResultBean<List<JSONObject>> doChatDemo(@RequestBody QuestionDemo question, @RequestHeader(value="locale", required=false) String locale) {
        log.info("ScrumBIController#request: {}", (Object)question);
        StopWatch stopWatch = StopWatch.createStarted();
        question.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        question.setToken(Pipeline.getUserToken());
        question.setRouterKey(Pipeline.getRouterKey());
        List chatResult = this.chatProcess.doProcessDemo(question);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        stopWatch.stop();
        log.info("ScrumBIController#doChatDemo elapsed time: {}ms", (Object)stopWatch.getTime());
        if (CollectionUtils.isNotEmpty((Collection)chatResult) && !Objects.isNull(chatResult.get(0))) {
            ((JSONObject)chatResult.get(0)).put("totalTime", (Object)stopWatch.getTime());
        }
        return ResultBeanExtra.ok((Object)chatResult).withTimeTrace(question.isTimeTrace(), timeTrace).withExplain(question.isExplain(), outputTrace);
    }

    @PostMapping(value={"/chat/v1/lite"})
    @ApiOperation(value="\u5bf9\u8bdd")
    public ResultBean<List<JSONObject>> doChatLite(@RequestBody QuestionLite question, @RequestHeader(value="locale", required=false) String locale) {
        log.info("ScrumBIController#doChatLite#request: {}", (Object)question);
        StopWatch stopWatch = StopWatch.createStarted();
        question.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        question.setToken(Pipeline.getUserToken());
        question.setRouterKey(Pipeline.getRouterKey());
        question.setStrategy(Strategy.LITE);
        List chatResult = this.chatProcess.doProcessLite(question);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        stopWatch.stop();
        log.info("ScrumBIController#doChatLite elapsed time: {}ms", (Object)stopWatch.getTime());
        if (CollectionUtils.isNotEmpty((Collection)chatResult) && !Objects.isNull(chatResult.get(0))) {
            ((JSONObject)chatResult.get(0)).put("totalTime", (Object)stopWatch.getTime());
        }
        return ResultBeanExtra.ok((Object)chatResult).withTimeTrace(question.isTimeTrace(), timeTrace).withExplain(question.isExplain(), outputTrace);
    }

    @PostMapping(value={"/chat/lite"})
    @ApiOperation(value="\u5bf9\u8bdd")
    public ResultBean<List<JSONObject>> doChatLiteV2(@RequestBody QuestionLite question, @RequestHeader(value="locale", required=false) String locale) {
        log.info("ScrumBIController#doChatLite#request: {}", (Object)question);
        StopWatch stopWatch = StopWatch.createStarted();
        question.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        question.setToken(Pipeline.getUserToken());
        question.setRouterKey(Pipeline.getRouterKey());
        question.setStrategy(Strategy.LITE_V2);
        List chatResult = this.chatProcess.doProcessLiteV2(question);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        stopWatch.stop();
        log.info("ScrumBIController#doChatLiteV2 elapsed time: {}ms", (Object)stopWatch.getTime());
        if (CollectionUtils.isNotEmpty((Collection)chatResult) && !Objects.isNull(chatResult.get(0))) {
            ((JSONObject)chatResult.get(0)).put("totalTime", (Object)stopWatch.getTime());
        }
        return ResultBeanExtra.ok((Object)chatResult).withTimeTrace(question.isTimeTrace(), timeTrace).withExplain(question.isExplain(), outputTrace);
    }

    @PostMapping(value={"/dataAnalysisDemo"})
    @ApiOperation(value="\u8bed\u4e49\u6839\u636e\u95ee\u6570\u7ed3\u679c\u6570\u636e\u5206\u6790demo")
    public ResultBean dataAnalysisDemo(@RequestBody DataAnalysisReq req, @RequestHeader(value="token", required=false) String token, @RequestHeader(value="routeKey", required=false) String routeKey, @RequestHeader(value="locale", required=false) String locale) {
        List userPromptList = req.getUserPromptList();
        String snapshotId = req.getSnapshotId();
        log.info("ScrumBIController#dataAnalysisDemo snapshotId: {},token:{},routeKey:{},locale:{},userPromptList:{}", new Object[]{snapshotId, token, routeKey, locale, userPromptList});
        if (StringUtils.isEmpty((CharSequence)token)) {
            log.error("\u67e5\u8be2\u5feb\u7167\u4fe1\u606ftoken\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultBean.fail((String)"\u67e5\u8be2\u5feb\u7167\u4fe1\u606ftoken\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)snapshotId)) {
            return ResultBean.fail((String)"\u67e5\u8be2\u5feb\u7167\u4fe1\u606f\u5feb\u7167ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.chatProcess.dataAnalysisDemo(snapshotId, token, routeKey, locale, userPromptList);
    }

    @PostMapping(value={"/dataAnalysisDemo/V2/save"})
    @ApiOperation(value="\u6570\u636e\u5206\u6790V2\u4fdd\u5b58")
    public ResultBean save(@RequestBody TopicDto topicDto) throws BussinessException {
        log.info("ScrumBIController#dataAnalysisDemoV2Save topicDto: {}", (Object)topicDto);
        if (Objects.isNull(topicDto)) {
            return ResultBean.fail((String)"\u4fdd\u5b58\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long id = this.topicService.dataAnalysisDemoSave(topicDto);
        if (Objects.isNull(id)) {
            return ResultBean.fail((String)"\u4fdd\u5b58\u6570\u636e\u5f02\u5e38");
        }
        return ResultBean.ok((Object)id);
    }

    @PostMapping(value={"/dataAnalysisDemo/V2/run"})
    @ApiOperation(value="\u6570\u636e\u5206\u6790V2\u8fd0\u884c")
    public ResultBean run(@RequestBody TopicDto topicDto, @RequestHeader(value="token", required=false) String token, @RequestHeader(value="routeKey", required=false) String routerKey, @RequestHeader(value="locale", required=false) String locale) throws BussinessException {
        log.info("ScrumBIController#dataAnalysisDemo topicDto: {},token:{},routerKey:{},locale:{}", new Object[]{topicDto, token, routerKey, locale});
        if (Objects.isNull(topicDto) || CollectionUtils.isEmpty((Collection)topicDto.getTopicDetailDtos())) {
            return ResultBean.fail((String)"\u8fd0\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List collect = topicDto.getTopicDetailDtos().stream().flatMap(d -> d.getTopicPromptDtos().stream()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return ResultBean.fail((String)"\u63d0\u793a\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List prompts = collect.stream().map(c -> c.getPrompt()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(prompts)) {
            return ResultBean.fail((String)"\u63d0\u793a\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long topicId = this.topicService.dataAnalysisDemoSave(topicDto);
        this.topicService.updateStatus(topicId, Integer.valueOf(2));
        this.topicService.dataAnalysisDemoRun(topicId, token, routerKey);
        return ResultBean.ok();
    }

    @GetMapping(value={"/dataAnalysisDemo/V2/detail"})
    @ApiOperation(value="\u6570\u636e\u5206\u6790V2\u8be6\u60c5")
    public ResultBean<List<TopicDto>> detail(Long id) {
        log.info("ScrumBIController#dataAnalysisDemoV2Detail id: {}", (Object)id);
        return ResultBean.ok((Object)this.topicService.dataAnalysisDemoDetail(id));
    }

    @PostMapping(value={"/questions/recommended"})
    @ApiOperation(value="\u63a8\u8350\u95ee\u53e5")
    public ResultBean<List<String>> questionsRecommended(@RequestBody QuestionRecommendTReqDto req, @RequestHeader(value="token", required=false) String token, @RequestHeader(value="locale", required=false) String locale) {
        log.info("ScrumBIController#questionsRecommended req: {},token:{},locale:{}", new Object[]{req, token, locale});
        if (StringUtils.isEmpty((CharSequence)token)) {
            log.error("\u67e5\u8be2\u5feb\u7167\u4fe1\u606ftoken\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultBean.fail((String)"\u63a8\u8350\u95ee\u53e5token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(req)) {
            return ResultBean.fail((String)"\u63a8\u8350\u95ee\u53e5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return ResultBean.ok((Object)this.chatProcess.questionsRecommended(req, token, locale));
        }
        catch (Exception e) {
            log.error("\u63a8\u8350\u95ee\u53e5\u5f02\u5e38\uff1a{}", (Throwable)e);
            return ResultBean.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/resultAnalysis"})
    @ApiOperation(value="\u7ed3\u679c\u603b\u7ed3")
    public ResultBean<String> resultAnalysis(@RequestBody DataAnalysisReq req, @RequestHeader(value="token", required=false) String token, @RequestHeader(value="routerKey", required=false) String routeKey, @RequestHeader(value="locale", required=false) String locale) {
        String snapshotId = req.getSnapshotId();
        log.info("ScrumBIController#resultAnalysis snapshotId: {},token:{},routeKey:{},locale:{}", new Object[]{snapshotId, token, routeKey, locale});
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (StringUtils.isEmpty((CharSequence)token)) {
            log.error("\u67e5\u8be2\u5feb\u7167\u4fe1\u606ftoken\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultBean.fail((String)"\u67e5\u8be2\u5feb\u7167\u4fe1\u606ftoken\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String res = this.chatProcess.resultAnalysis(req, locale);
            stopWatch.stop();
            log.info("ScrumBIController#resultAnalysis elapsed time: {}ms", (Object)stopWatch.getTime());
            return ResultBean.ok((Object)res);
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u603b\u7ed3\u5f02\u5e38\uff1a{}", (Throwable)e);
            return ResultBean.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="fewShot\u6570\u636e\u6574\u5408")
    @PostMapping(value={"/fewShot/formatSearch"})
    public List<JSONObject> fewShotFormatSearch(@RequestBody JSONObject param) {
        List res = this.operateESService.fewShotFormatSearch(param);
        return res;
    }

    @PostMapping(value={"/business/create"})
    @ApiOperation(value="\u4e1a\u52a1\u7c7b\u578b\u751f\u6210")
    public ResultBean<List<BusinessCreateResDto>> createBusiness(@RequestBody List<BusinessCreateReqDto> req, @RequestHeader(value="token", required=false) String token, @RequestHeader(value="routeKey", required=false) String routeKey, @RequestHeader(value="locale", required=false) String locale) {
        log.info("ScrumBIController#createBusiness token:{},routeKey:{},locale:{}", new Object[]{token, routeKey, locale});
        if (CollectionUtils.isEmpty(req)) {
            log.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultBean.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List business = this.chatProcess.createBusiness(req);
            if (Objects.isNull(business)) {
                return ResultBean.fail((String)"\u4e1a\u52a1\u7c7b\u578b\u751f\u6210\u5f02\u5e38");
            }
            return ResultBean.ok((Object)business);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u7c7b\u578b\u751f\u6210\u5f02\u5e38\uff1a{}", (Throwable)e);
            return ResultBean.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/extInfo/create"})
    @ApiOperation(value="\u6570\u636e\u96c6\u6269\u5c55\u4fe1\u606f\u751f\u6210")
    public ResultBean<ExtInfoResDto> createExtInfo(@RequestBody ExtInfoCreateReqDto req, @RequestHeader(value="token", required=false) String token, @RequestHeader(value="routeKey", required=false) String routeKey, @RequestHeader(value="locale", required=false) String locale) {
        log.info("ScrumBIController#createExtInfo token:{},routeKey:{},locale:{}", new Object[]{token, routeKey, locale});
        if (Objects.isNull(req) || CollectionUtils.isEmpty((Collection)req.getFieldSchemas()) || StringUtils.isEmpty((CharSequence)req.getDatasetId())) {
            log.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultBean.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return ResultBean.ok((Object)this.chatProcess.createExtInfo(req));
        }
        catch (Exception e) {
            log.error("\u6269\u5c55\u4fe1\u606f\u751f\u6210\u5f02\u5e38\uff1a{}", (Throwable)e);
            return ResultBean.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/dataAttribution/fluctuate"})
    @ApiOperation(value="\u6570\u636e\u5f52\u56e0\u6ce2\u52a8api")
    public Object fluctuate(@RequestBody FluctuateRequest fluctuateRequest, @RequestHeader(value="locale", required=false) String locale) {
        log.info("fluctuate#request: {}", (Object)JSONObject.toJSONString((Object)fluctuateRequest));
        fluctuateRequest.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        fluctuateRequest.setToken(Pipeline.getUserToken());
        fluctuateRequest.setRouterKey(Pipeline.getRouterKey());
        fluctuateRequest.setMessageId(Pipeline.getMessageId());
        fluctuateRequest.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)fluctuateRequest.getPtxId())) {
            fluctuateRequest.setPtxId(MdcUtil.getTraceId());
        }
        JSONObject fluctuateResult = this.dataAttributionProcess.fluctuate(fluctuateRequest);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        log.info("fluctuate#res: {}", (Object)JSONObject.toJSONString((Object)fluctuateResult));
        ResultBeanExtra res = ResultBeanExtra.ok((Object)fluctuateResult).withTimeTrace(fluctuateRequest.isTimeTrace(), timeTrace).withExplain(fluctuateRequest.isExplain(), outputTrace);
        return res;
    }

    @PostMapping(value={"/dataAttribution"})
    @ApiOperation(value="\u6570\u636e\u5f52\u56e0api")
    public Object dataAttribution(@RequestBody DataAttributionRequest dataAttributionRequest, @RequestHeader(value="locale", required=false) String locale) {
        log.info("dataAttribution#request: {}", (Object)JSONObject.toJSONString((Object)dataAttributionRequest));
        dataAttributionRequest.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        dataAttributionRequest.setToken(Pipeline.getUserToken());
        dataAttributionRequest.setRouterKey(Pipeline.getRouterKey());
        dataAttributionRequest.setMessageId(Pipeline.getMessageId());
        dataAttributionRequest.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)dataAttributionRequest.getPtxId())) {
            dataAttributionRequest.setPtxId(MdcUtil.getTraceId());
        }
        JSONObject fluctuateResult = this.dataAttributionProcess.dataAttribution(dataAttributionRequest);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        log.info("dataAttribution#res: {}", (Object)JSONObject.toJSONString((Object)fluctuateResult));
        ResultBeanExtra res = ResultBeanExtra.ok((Object)fluctuateResult).withTimeTrace(dataAttributionRequest.isTimeTrace(), timeTrace).withExplain(dataAttributionRequest.isExplain(), outputTrace);
        return res;
    }

    @PostMapping(value={"/dataAttribution/report"})
    @ApiOperation(value="\u5f52\u56e0\u62a5\u544a")
    public Object dataAttributionReport(@RequestBody DataAttributionReportRequest req, @RequestHeader(value="locale", required=false) String locale) {
        String traceId;
        log.info("dataAttributionReport#request: {}", (Object)JSONObject.toJSONString((Object)req));
        req.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        req.setToken(Pipeline.getUserToken());
        req.setRouterKey(Pipeline.getRouterKey());
        req.setMessageId(Pipeline.getMessageId());
        req.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)req.getPtxId())) {
            req.setPtxId(MdcUtil.getTraceId());
        }
        if (StrUtil.isBlank((CharSequence)(traceId = MdcUtil.get((String)"PtxId")))) {
            traceId = MdcUtil.getTraceId();
        }
        String id = UUID.randomUUID().toString().replace("-", "");
        req.setId(id);
        SseEmitter sseEmitter = this.sseEmitterCallbackComponent.generateSseEmitter((Object)req, id);
        String finalTraceId = traceId;
        log.info("ptxdid:{}", (Object)req.getPtxId());
        log.info("finalTraceId:{}", (Object)finalTraceId);
        CompletableFuture.runAsync(() -> {
            try {
                MdcUtil.setTraceId((String)finalTraceId);
                this.dataAttributionProcess.doDataAttributionReport4Stream(req);
            }
            finally {
                MdcUtil.clear();
                if (Objects.nonNull(SseContext.getSseEmitter((String)req.getId()))) {
                    SseContext.getSseEmitter((String)req.getId()).complete();
                }
                SseContext.cleanUpDataAttribution((String)req.getId());
            }
        }, this.taskExecutorScrumbi);
        return sseEmitter;
    }

    @PostMapping(value={"/testSql2Json"})
    @ApiOperation(value="testSql2Json")
    public ResultBean<Void> testSql2Json() {
        GeneralConvertorWrapperExecutor generalConvertorWrapperExecutor = new GeneralConvertorWrapperExecutor();
        generalConvertorWrapperExecutor.testSql2Json();
        return ResultBeanExtra.ok();
    }

    @PostMapping(value={"/testEasySql"})
    @ApiOperation(value="testEasySql")
    public ResultBean<Void> testEasySql() {
        EasyConvertorWrapperExecutor generalConvertorWrapperExecutor = new EasyConvertorWrapperExecutor();
        generalConvertorWrapperExecutor.testEasySql();
        return ResultBeanExtra.ok();
    }

    @PostMapping(value={"/question/planning"})
    @ApiOperation(value="\u95ee\u53e5\u89c4\u5212")
    public Object questionPlanning(@RequestBody QuestionPlanningReq questionPlanningReq, @RequestHeader(value="locale", required=false) String locale) {
        String traceId;
        log.info("questionPlanning#request: {}", (Object)JSONObject.toJSONString((Object)questionPlanningReq));
        questionPlanningReq.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        questionPlanningReq.setToken(Pipeline.getUserToken());
        questionPlanningReq.setRouterKey(Pipeline.getRouterKey());
        questionPlanningReq.setMessageId(Pipeline.getMessageId());
        questionPlanningReq.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)questionPlanningReq.getPtxId())) {
            questionPlanningReq.setPtxId(MdcUtil.getTraceId());
        }
        if (StrUtil.isBlank((CharSequence)(traceId = MdcUtil.get((String)"PtxId")))) {
            traceId = MdcUtil.getTraceId();
        }
        if (questionPlanningReq.isCloseStream()) {
            JSONObject questionPlanningResult = this.pPTGenerationProcess.doQuestionPlanning(questionPlanningReq);
            List timeTrace = (List)questionPlanningResult.get((Object)"timeTrace");
            List outputTrace = (List)questionPlanningResult.get((Object)"outputTrace");
            questionPlanningResult.remove((Object)"timeTrace");
            questionPlanningResult.remove((Object)"outputTrace");
            ResultBeanExtra res = ResultBeanExtra.ok((Object)questionPlanningResult).withTimeTrace(questionPlanningReq.isTimeTrace(), timeTrace).withExplain(questionPlanningReq.isExplain(), outputTrace);
            return res;
        }
        questionPlanningReq.setIfStream(true);
        SseEmitter sseEmitter = this.sseEmitterCallbackComponent.generateSseEmitter(questionPlanningReq);
        String finalTraceId = traceId;
        log.info("ptxdid:{}", (Object)questionPlanningReq.getPtxId());
        log.info("finalTraceId:{}", (Object)finalTraceId);
        CompletableFuture.runAsync(() -> {
            try {
                MdcUtil.setTraceId((String)finalTraceId);
                this.pPTGenerationProcess.doQuestionPlanning4Stream(questionPlanningReq);
            }
            finally {
                MdcUtil.clear();
            }
        }, this.taskExecutorScrumbi);
        return sseEmitter;
    }

    @PostMapping(value={"/question/reGenarate"})
    @ApiOperation(value="\u91cd\u65b0\u751f\u6210\u95ee\u53e5")
    public ResultBeanExtra<JSONObject> questionReGenarate(@RequestBody QuestionReGenerateReq questionReGenarateReq, @RequestHeader(value="locale", required=false) String locale) {
        log.info("questionReGenarate#request: {}", (Object)JSONObject.toJSONString((Object)questionReGenarateReq));
        questionReGenarateReq.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        questionReGenarateReq.setToken(Pipeline.getUserToken());
        questionReGenarateReq.setRouterKey(Pipeline.getRouterKey());
        questionReGenarateReq.setMessageId(Pipeline.getMessageId());
        questionReGenarateReq.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)questionReGenarateReq.getPtxId())) {
            questionReGenarateReq.setPtxId(MdcUtil.getTraceId());
        }
        JSONObject questionReGenarateRes = this.pPTGenerationProcess.doQuestionReGenarate(questionReGenarateReq);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        log.info("questionReGenarate#res: {}", (Object)JSONObject.toJSONString((Object)questionReGenarateRes));
        ResultBeanExtra res = ResultBeanExtra.ok((Object)questionReGenarateRes).withTimeTrace(questionReGenarateReq.isTimeTrace(), timeTrace).withExplain(questionReGenarateReq.isExplain(), outputTrace);
        return res;
    }

    @PostMapping(value={"/ppt/genarate"})
    @ApiOperation(value="\u751f\u6210ppt")
    public ResultBeanExtra<JSONObject> pPTGenarate(@RequestBody PPTGenerateReq pPTGenerateReq, @RequestHeader(value="locale", required=false) String locale) {
        log.info("pPTGenarate#request: {}", (Object)JSONObject.toJSONString((Object)pPTGenerateReq));
        pPTGenerateReq.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        pPTGenerateReq.setToken(Pipeline.getUserToken());
        pPTGenerateReq.setRouterKey(Pipeline.getRouterKey());
        pPTGenerateReq.setMessageId(Pipeline.getMessageId());
        pPTGenerateReq.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)pPTGenerateReq.getPtxId())) {
            pPTGenerateReq.setPtxId(MdcUtil.getTraceId());
        }
        JSONObject pptGenarateRes = this.pPTGenerationProcess.doPPTGenarate(pPTGenerateReq);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        log.info("pPTGenarate#res: {}", (Object)JSONObject.toJSONString((Object)pptGenarateRes));
        ResultBeanExtra res = ResultBeanExtra.ok((Object)pptGenarateRes).withTimeTrace(pPTGenerateReq.isTimeTrace(), timeTrace).withExplain(pPTGenerateReq.isExplain(), outputTrace);
        return res;
    }

    @PostMapping(value={"/ppt/refine"})
    @ApiOperation(value="ppt\u63d0\u70bc")
    public ResultBeanExtra<String> pPTRefine(@RequestBody PPTRefineReq pptRefineReq, @RequestHeader(value="locale", required=false) String locale) {
        log.info("pPTRefine#req: {}", (Object)pptRefineReq.getData());
        pptRefineReq.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        pptRefineReq.setToken(Pipeline.getUserToken());
        pptRefineReq.setRouterKey(Pipeline.getRouterKey());
        pptRefineReq.setMessageId(Pipeline.getMessageId());
        pptRefineReq.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)pptRefineReq.getPtxId())) {
            pptRefineReq.setPtxId(MdcUtil.getTraceId());
        }
        String data = this.pPTGenerationProcess.pPTRefine(pptRefineReq);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        log.info("pPTRefine#res: {}", (Object)data);
        ResultBeanExtra res = ResultBeanExtra.ok((Object)data).withTimeTrace(pptRefineReq.isTimeTrace(), timeTrace).withExplain(pptRefineReq.isExplain(), outputTrace);
        return res;
    }

    @PostMapping(value={"/intention/confirm"})
    @ApiOperation(value="\u610f\u56fe\u786e\u8ba4")
    public ResultBeanExtra<JSONObject> intentionConfirm(@RequestBody IntentionConfirmReq intentionConfirmReq, @RequestHeader(value="locale", required=false) String locale) {
        log.info("intentionConfirm#request: {}", (Object)JSONObject.toJSONString((Object)intentionConfirmReq));
        intentionConfirmReq.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        intentionConfirmReq.setToken(Pipeline.getUserToken());
        intentionConfirmReq.setRouterKey(Pipeline.getRouterKey());
        intentionConfirmReq.setMessageId(Pipeline.getMessageId());
        intentionConfirmReq.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)intentionConfirmReq.getPtxId())) {
            intentionConfirmReq.setPtxId(MdcUtil.getTraceId());
        }
        JSONObject pptGenarateRes = this.autoDataProcess.intentionConfirm(intentionConfirmReq);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        log.info("intentionConfirm#res: {}", (Object)JSONObject.toJSONString((Object)pptGenarateRes));
        ResultBeanExtra res = ResultBeanExtra.ok((Object)pptGenarateRes).withTimeTrace(intentionConfirmReq.isTimeTrace(), timeTrace).withExplain(intentionConfirmReq.isExplain(), outputTrace);
        return res;
    }

    @PostMapping(value={"/report/create"})
    @ApiOperation(value="\u62a5\u544a\u751f\u6210")
    public Object reportCreate(@RequestBody ReportCreateReq reportCreateReq, @RequestHeader(value="locale", required=false) String locale) {
        String traceId;
        log.info("reportCreate#request: {}", (Object)JSONObject.toJSONString((Object)reportCreateReq));
        reportCreateReq.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        reportCreateReq.setToken(Pipeline.getUserToken());
        reportCreateReq.setRouterKey(Pipeline.getRouterKey());
        reportCreateReq.setMessageId(Pipeline.getMessageId());
        reportCreateReq.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)reportCreateReq.getPtxId())) {
            reportCreateReq.setPtxId(MdcUtil.getTraceId());
        }
        if (StrUtil.isBlank((CharSequence)(traceId = MdcUtil.get((String)"PtxId")))) {
            traceId = MdcUtil.getTraceId();
        }
        if (reportCreateReq.isCloseStream()) {
            JSONObject result = this.autoDataProcess.doReportCreate(reportCreateReq);
            List timeTrace = (List)result.get((Object)"timeTrace");
            List outputTrace = (List)result.get((Object)"outputTrace");
            result.remove((Object)"timeTrace");
            result.remove((Object)"outputTrace");
            ResultBeanExtra res = ResultBeanExtra.ok((Object)result).withTimeTrace(reportCreateReq.isTimeTrace(), timeTrace).withExplain(reportCreateReq.isExplain(), outputTrace);
            return res;
        }
        reportCreateReq.setIfStream(true);
        String id = UUID.randomUUID().toString().replace("-", "");
        reportCreateReq.setId(id);
        SseEmitter sseEmitter = this.sseEmitterCallbackComponent.generateSseEmitter((Object)reportCreateReq, id);
        String finalTraceId = traceId;
        log.info("ptxdid:{}", (Object)reportCreateReq.getPtxId());
        log.info("finalTraceId:{}", (Object)finalTraceId);
        CompletableFuture.runAsync(() -> {
            try {
                MdcUtil.setTraceId((String)finalTraceId);
                this.autoDataProcess.doReportCreate4Stream(reportCreateReq);
            }
            finally {
                MdcUtil.clear();
            }
        }, this.taskExecutorScrumbi);
        return sseEmitter;
    }

    @PostMapping(value={"/chart/plan"})
    @ApiOperation(value="\u56fe\u8868\u89c4\u5212")
    public Object chartPlan(@RequestBody ChartPlanReq chartPlanReq, @RequestHeader(value="locale", required=false) String locale) {
        String traceId;
        log.info("chartPlan#request: {}", (Object)JSONObject.toJSONString((Object)chartPlanReq));
        chartPlanReq.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        chartPlanReq.setToken(Pipeline.getUserToken());
        chartPlanReq.setRouterKey(Pipeline.getRouterKey());
        chartPlanReq.setMessageId(Pipeline.getMessageId());
        chartPlanReq.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)chartPlanReq.getPtxId())) {
            chartPlanReq.setPtxId(MdcUtil.getTraceId());
        }
        if (StrUtil.isBlank((CharSequence)(traceId = MdcUtil.get((String)"PtxId")))) {
            traceId = MdcUtil.getTraceId();
        }
        if (chartPlanReq.isCloseStream()) {
            JSONObject result = this.convoBoardProcess.doChartPlan(chartPlanReq);
            List timeTrace = (List)result.get((Object)"timeTrace");
            List outputTrace = (List)result.get((Object)"outputTrace");
            result.remove((Object)"timeTrace");
            result.remove((Object)"outputTrace");
            ResultBeanExtra res = ResultBeanExtra.ok((Object)result).withTimeTrace(chartPlanReq.isTimeTrace(), timeTrace).withExplain(chartPlanReq.isExplain(), outputTrace);
            return res;
        }
        chartPlanReq.setIfStream(true);
        String id = UUID.randomUUID().toString().replace("-", "");
        chartPlanReq.setId(id);
        SseEmitter sseEmitter = this.sseEmitterCallbackComponent.generateSseEmitter((Object)chartPlanReq, id);
        String finalTraceId = traceId;
        CompletableFuture.runAsync(() -> {
            try {
                MdcUtil.setTraceId((String)finalTraceId);
                this.convoBoardProcess.doChartPlan4Stream(chartPlanReq);
            }
            finally {
                MdcUtil.clear();
            }
        }, this.taskExecutorScrumbi);
        return sseEmitter;
    }

    @PostMapping(value={"/layout/design"})
    @ApiOperation(value="\u770b\u677f\u5e03\u5c40\u89c4\u5212")
    public ResultBeanExtra<JSONObject> layoutDesign(@RequestBody LayoutDesignReq layoutDesignReq, @RequestHeader(value="locale", required=false) String locale) {
        log.info("layoutDesign#request: {}", (Object)JSONObject.toJSONString((Object)layoutDesignReq));
        layoutDesignReq.setLocale(Objects.isNull(locale) ? "zh_CN" : Locale.codeOf((String)locale).getLocale());
        layoutDesignReq.setToken(Pipeline.getUserToken());
        layoutDesignReq.setRouterKey(Pipeline.getRouterKey());
        layoutDesignReq.setMessageId(Pipeline.getMessageId());
        layoutDesignReq.setPtxId(Pipeline.getPtxId());
        if (StrUtil.isBlank((CharSequence)layoutDesignReq.getPtxId())) {
            layoutDesignReq.setPtxId(MdcUtil.getTraceId());
        }
        JSONObject pptGenarateRes = this.convoBoardProcess.doLayoutDesign(layoutDesignReq);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        log.info("layoutDesign#res: {}", (Object)JSONObject.toJSONString((Object)pptGenarateRes));
        ResultBeanExtra res = ResultBeanExtra.ok((Object)pptGenarateRes).withTimeTrace(layoutDesignReq.isTimeTrace(), timeTrace).withExplain(layoutDesignReq.isExplain(), outputTrace);
        return res;
    }

    @GetMapping(value={"/prompts/content"})
    @ApiOperation(value="\u83b7\u53d6\u63d0\u793a\u5185\u5bb9")
    public JSONObject getPromptsContent(@RequestParam String name, @RequestParam String type) {
        TemplateFormatter a = ((TemplateLocalFileBroker)SpringContextUtil.getBean(TemplateLocalFileBroker.class)).get(type, name);
        JSONObject res = new JSONObject();
        String temptate = a.getTemplate();
        res.put("content", (Object)temptate);
        return res;
    }
}

