/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.boostEngine.chunk.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static int convertCnNumToInt(String cnNumStr) {
        switch (cnNumStr) {
            case "\u4e00": {
                return 1;
            }
            case "\u4e8c": {
                return 2;
            }
            case "\u4e09": {
                return 3;
            }
            case "\u56db": {
                return 4;
            }
            case "\u4e94": {
                return 5;
            }
            case "\u516d": {
                return 6;
            }
            case "\u4e03": {
                return 7;
            }
            case "\u516b": {
                return 8;
            }
            case "\u4e5d": {
                return 9;
            }
            case "\u5341": {
                return 10;
            }
            case "\u5341\u4e00": {
                return 11;
            }
            case "\u5341\u4e8c": {
                return 12;
            }
        }
        throw new IllegalArgumentException("Unexpected Chinese number: " + cnNumStr);
    }

    public static String[][] getOneYearAgo() {
        LocalDate today = LocalDate.now();
        LocalDate oneYearAgo = today.minus(1L, ChronoUnit.YEARS);
        return new String[][]{{oneYearAgo.format(formatter)}};
    }

    public static String[][] getOneYearAgo(String dateStr) {
        LocalDate date = LocalDate.parse(dateStr, formatter);
        LocalDate oneYearAgo = date.minus(1L, ChronoUnit.YEARS);
        return new String[][]{{oneYearAgo.format(formatter)}};
    }

    public static String[][] getOneMonthAgo(String dateStr) {
        LocalDate date = LocalDate.parse(dateStr, formatter);
        LocalDate oneMonthAgo = date.minus(1L, ChronoUnit.MONTHS);
        return new String[][]{{oneMonthAgo.format(formatter)}};
    }

    public static String[][] parseRelativeDay(int offset) {
        LocalDate today = LocalDate.now();
        LocalDate targetDate = today.plusDays(offset);
        return new String[][]{{targetDate.format(formatter)}};
    }

    public static String[][] parseRelativeMonth(int offset) {
        LocalDate today = LocalDate.now();
        LocalDate firstDayOfTargetMonth = today.withDayOfMonth(1).plusMonths(offset);
        LocalDate lastDayOfTargetMonth = firstDayOfTargetMonth.with(TemporalAdjusters.lastDayOfMonth());
        return new String[][]{{firstDayOfTargetMonth.format(formatter), lastDayOfTargetMonth.format(formatter)}};
    }

    public static String[][] parseYearMonth(String[] groups, Map<String, Integer> yearMap) {
        int currentYear = LocalDate.now().getYear();
        String yearStr = groups[0];
        String monthStr = groups[1];
        int yearOffset = yearMap.getOrDefault(yearStr, 0);
        int year = currentYear + yearOffset;
        int month = monthStr.matches("\\d+") ? Integer.parseInt(monthStr) : DateUtils.convertCnNumToInt((String)monthStr);
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
        return new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
    }

    public static String[][] parseMonthOfYear(String[] groups) {
        int month = groups[0].matches("\\d+") ? Integer.parseInt(groups[0]) : DateUtils.convertCnNumToInt((String)groups[0]);
        LocalDate today = LocalDate.now();
        LocalDate startDate = LocalDate.of(today.getYear(), month, 1);
        LocalDate endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
        return new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
    }

    public static String[][] parseRelativeDuration(String[] groups) {
        String[][] result;
        int num = groups[0].matches("\\d+") ? Integer.parseInt(groups[0]) : DateUtils.convertCnNumToInt((String)groups[0]);
        LocalDate today = LocalDate.now();
        String unit = groups[1];
        if (unit.contains("\u5929")) {
            LocalDate startDate = today.minusDays(num);
            LocalDate endDate = today.minusDays(1L);
            result = new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
        } else if (unit.contains("\u6708")) {
            LocalDate startDate = today.minusMonths(num);
            LocalDate endDate = today.minusDays(1L);
            result = new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
        } else if (unit.contains("\u5e74")) {
            LocalDate startDate = today.minusYears((long)num - 1L).withDayOfYear(1);
            LocalDate endDate = today.with(TemporalAdjusters.lastDayOfYear());
            result = new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
        } else {
            throw new IllegalArgumentException("Unsupported unit: " + unit);
        }
        return result;
    }

    public static String[][] parseHalfYear(String[] groups, Map<String, Integer> yearMap, Map<String, String> halfMap) {
        String yearStr = groups[0];
        String halfStr = groups[1];
        String half = halfMap.get(halfStr);
        int year = LocalDate.now().getYear() + yearMap.getOrDefault(yearStr, 0);
        if ("first".equals(half)) {
            return new String[][]{{year + "-01-01", year + "-06-30"}};
        }
        return new String[][]{{year + "-07-01", year + "-12-31"}};
    }

    public static String[][] parseYear(String[] groups, Map<String, Integer> yearMap) {
        String yearStr = groups[0];
        int currentYear = LocalDate.now().getYear() + yearMap.getOrDefault(yearStr, 0);
        return new String[][]{{currentYear + "-01-01", currentYear + "-12-31"}};
    }

    public static String[][] parseRelativeYear(int offset) {
        int targetYear = LocalDate.now().getYear() + offset;
        return new String[][]{{targetYear + "-01-01", targetYear + "-12-31"}};
    }

    public static String[][] parseRelativeWeek(int offset) {
        LocalDate today = LocalDate.now();
        WeekFields weekFields = WeekFields.of(DayOfWeek.MONDAY, 1);
        LocalDate startDate = today.with(weekFields.dayOfWeek(), 1L).plusWeeks(offset);
        LocalDate endDate = startDate.plusDays(6L);
        return new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
    }

    public static String[][] parseMultiYear() {
        int currentYear = LocalDate.now().getYear();
        int lastYear = currentYear - 1;
        return new String[][]{{lastYear + "-01-01", lastYear + "-12-31"}, {currentYear + "-01-01", currentYear + "-12-31"}};
    }

    public static String[][] parseMultiYearMonth(String[] groups, Map<String, Integer> yearMap) {
        String[][] result1 = DateUtils.parseYearMonth((String[])new String[]{groups[0], groups[1]}, yearMap);
        String[][] result2 = DateUtils.parseYearMonth((String[])new String[]{groups[2], groups[3]}, yearMap);
        return new String[][]{{result1[0][0], result1[0][1]}, {result2[0][0], result2[0][1]}};
    }

    public static String[][] parseYearMonthSpecific(String[] groups) {
        int year = Integer.parseInt(groups[0]);
        int month = groups[1].matches("\\d+") ? Integer.parseInt(groups[1]) : DateUtils.convertCnNumToInt((String)groups[1]);
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
        return new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
    }

    public static String[][] parseSpecificDate(String[] groups) {
        int year = Integer.parseInt(groups[0]);
        int month = Integer.parseInt(groups[1]);
        int day = Integer.parseInt(groups[2]);
        LocalDate specificDate = LocalDate.of(year, month, day);
        return new String[][]{{specificDate.format(formatter)}};
    }

    public static String[][] parseSpecificYear(String[] groups) {
        int year = Integer.parseInt(groups[0]);
        return new String[][]{{year + "-01-01", year + "-12-31"}};
    }

    public static String[][] parseCurrentMonthDay(String[] groups) {
        int day = Integer.parseInt(groups[0]);
        LocalDate today = LocalDate.now();
        LocalDate specificDate = today.withDayOfMonth(day);
        return new String[][]{{specificDate.format(formatter)}};
    }

    public static String[][] parseMonthDay(String[] groups) {
        int month = Integer.parseInt(groups[0]);
        int day = Integer.parseInt(groups[1]);
        LocalDate today = LocalDate.now();
        LocalDate specificDate = LocalDate.of(today.getYear(), month, day);
        return new String[][]{{specificDate.format(formatter)}};
    }

    public static String[][] parseRelativeQuarter(String[] groups, int yearOffset) {
        int currentYear = LocalDate.now().getYear() + yearOffset;
        int quarter = groups[0].matches("\\d+") ? Integer.parseInt(groups[0]) : DateUtils.convertCnNumToInt((String)groups[0]);
        int startMonth = (quarter - 1) * 3 + 1;
        LocalDate startDate = LocalDate.of(currentYear, startMonth, 1);
        LocalDate endDate = startDate.plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
        return new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
    }

    public static String[][] parseCurrentYearQuarter(String[] groups) {
        return DateUtils.parseRelativeQuarter((String[])groups, (int)0);
    }

    public static String[][] parseRelativeQuarterOffset(int offset) {
        int currentQuarter = (LocalDate.now().getMonthValue() - 1) / 3 + 1;
        int targetQuarter = currentQuarter + offset;
        int yearOffset = 0;
        if (targetQuarter < 1) {
            targetQuarter += 4;
            --yearOffset;
        } else if (targetQuarter > 4) {
            targetQuarter -= 4;
            ++yearOffset;
        }
        return DateUtils.parseRelativeQuarter((String[])new String[]{String.valueOf(targetQuarter)}, (int)yearOffset);
    }

    public static String[][] parseNDaysBefore(String[] groups) {
        String numberStr = groups[1];
        int days = numberStr.matches("\\d+") ? Integer.parseInt(numberStr) : DateUtils.convertCnNumToInt((String)numberStr);
        LocalDate today = LocalDate.now();
        LocalDate startDate = today.minusDays(days);
        LocalDate endDate = today.minusDays(1L);
        return new String[][]{{startDate.format(formatter), endDate.format(formatter)}};
    }

    public static String[][] parseNDaysAfter(String[] groups) {
        String numberStr = groups[1];
        int days = numberStr.matches("\\d+") ? Integer.parseInt(numberStr) : DateUtils.convertCnNumToInt((String)numberStr);
        LocalDate today = LocalDate.now();
        LocalDate endDate = today.plusDays((long)days - 1L);
        return new String[][]{{today.format(formatter), endDate.format(formatter)}};
    }

    public static String[][] parseNDaysUnspecified(String[] groups) {
        String numberStr = groups[0];
        int days = numberStr.matches("\\d+") ? Integer.parseInt(numberStr) : DateUtils.convertCnNumToInt((String)numberStr);
        LocalDate today = LocalDate.now();
        String[][] futureRange = new String[][]{{today.format(formatter), today.plusDays((long)days - 1L).format(formatter)}};
        String[][] pastRange = new String[][]{{today.minusDays(days).format(formatter), today.minusDays(1L).format(formatter)}};
        return new String[][]{{pastRange[0][0], pastRange[0][1]}, {futureRange[0][0], futureRange[0][1]}};
    }
}

