/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.datasource;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.TableSchema;
import com.digiwin.chatbi.beans.dtos.chart.DdlCreateReqDto;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.process.ChatProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScrumDatasourceService {
    private static final Logger log = LoggerFactory.getLogger(ScrumDatasourceService.class);
    @Resource
    private Executor ddlCreateThreadPool;

    public JSONArray createDdl(List<DdlCreateReqDto> reqs, String token, String locale) {
        ArrayList<CompletableFuture<JSONObject>> futures = new ArrayList<CompletableFuture<JSONObject>>();
        int i = 0;
        while (i < reqs.size()) {
            DdlCreateReqDto req = reqs.get(i);
            int n = i++;
            CompletableFuture<JSONObject> future = CompletableFuture.supplyAsync(() -> {
                try {
                    JSONArray demoDatasArray = new JSONArray();
                    demoDatasArray.add((Object)req.getColumns());
                    demoDatasArray.addAll((Collection)req.getDatas());
                    JSONObject param = new JSONObject();
                    param.put("demoDatas", (Object)demoDatasArray);
                    param.put("sheetName", (Object)req.getSheetName());
                    String gptResult = ExecutorFactory.CALL_GPT_WITH_CREATE_TABLE.callGpt(new ChatProcess().systemMessage(param, "CreateDDL", "datasource"), "", null, Integer.valueOf(4096), null, token);
                    TableSchema ddl = TableSchema.createDDL((String)gptResult);
                    ddl.setTableName(ddl.getTableName() + "_" + index);
                    JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)ddl));
                    jsonObject.put("sheetName", (Object)req.getSheetName());
                    return jsonObject;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.error("\u521b\u5efaddl\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                    return null;
                }
            }, this.ddlCreateThreadPool);
            futures.add(future);
        }
        JSONArray res = new JSONArray();
        for (CompletableFuture completableFuture : futures) {
            try {
                JSONObject jsonObject = (JSONObject)completableFuture.get();
                if (!MapUtils.isNotEmpty((Map)jsonObject)) continue;
                res.add((Object)jsonObject);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error("\u521b\u5efaddl\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
        return res;
    }
}

