/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.enums.DebugMode;
import com.digiwin.chatbi.common.enums.SpecialModeEnum;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.KnowledgemapsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSceneExistExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(CheckSceneExistExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Output doProcess(JSONObject context) {
        List<LogCheckDto> logCheckDtos;
        List list = logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        if (Objects.nonNull(context.getString("datasourceId"))) {
            context.put("sentences", ((Map)context.getOrDefault((Object)"locale_sentences", new HashMap())).get(context.getString("datasourceId")));
        }
        if (context.containsKey((Object)"no_template")) {
            return Output.through().keep("have_scene_flag", (Object)false);
        }
        List schemas = ((List)((JSONObject)context.getOrDefault((Object)"schemas", (Object)new JSONObject())).getOrDefault((Object)"Schemas", new ArrayList())).stream().map(inner_hit -> inner_hit.getString("name")).collect(Collectors.toList());
        JSONArray jsonArray = Optional.ofNullable(context.getJSONObject("Dimension")).map(e -> e.getJSONArray("group_by")).orElse(new JSONArray());
        JSONArray dimensions = context.getJSONArray("allDimensions");
        JSONArray promptsDimension = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            jsonArray.forEach(json -> dimensions.forEach(dimension -> {
                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dimension));
                if (jsonObject.getString("name").equals(json) && schemas.contains(json)) {
                    promptsDimension.add(json);
                }
            }));
        }
        String dataSourceId = context.getString("datasourceId");
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        context.put("final_dimension", (Object)(CollectionUtils.isEmpty((Collection)promptsDimension) ? new JSONArray() : new JSONArray(promptsDimension.stream().distinct().collect(Collectors.toList()))));
        context.put("templateCode", (Object)context.getString(PipelineFactory.PipelineKey.INTENT_CODE.getKey()));
        JSONArray final_dimension = context.getJSONArray("final_dimension");
        if ("sales".equals(dataSourceId) && "ranking".equals(context.getString(PipelineFactory.PipelineKey.INTENT_CODE.getKey())) && (question.contains("\u53d8\u5316") || question.contains("\u8b8a\u5316"))) {
            context.put("templateCode", (Object)"ranking_diff");
        }
        String templateCode = context.getString("templateCode");
        boolean checkSceneExistResult = this.checkSceneExist(context);
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        if (Objects.isNull(checkSceneExistResult)) return Output.through().keep("checkSceneExist", (Object)checkSceneExistResult).keep("reply", (Object)"message.scrumbi.check.scenes").keep("have_scene_flag", (Object)false);
        if (!checkSceneExistResult) {
            return Output.through().keep("checkSceneExist", (Object)checkSceneExistResult).keep("reply", (Object)"message.scrumbi.check.scenes").keep("have_scene_flag", (Object)false);
        }
        boolean checkResult = this.checkPrModeScene(context, templateCode, dataSourceId, final_dimension);
        if (Objects.isNull(checkResult)) return Output.through().keep("checkPrModeScene", (Object)checkResult).keep("reply", (Object)"message.scrumbi.not.match.scenes").keep("have_scene_flag", (Object)false);
        if (!checkResult) {
            return Output.through().keep("checkPrModeScene", (Object)checkResult).keep("reply", (Object)"message.scrumbi.not.match.scenes").keep("have_scene_flag", (Object)false);
        }
        String sceneCode = ((Question)context.getObject("question", Question.class)).getSceneCode();
        String debugMode = ((Question)context.getObject("question", Question.class)).getDebugMode();
        try {
            JSONObject params;
            KnowledgemapsService bean;
            String sceneCodeRes = DebugMode.DEBUG.getCode().equals(debugMode) || DebugMode.PR_PARAM.getCode().equals(debugMode) ? sceneCode : null;
            List jsonObjects = new ArrayList<JSONObject>();
            JSONObject jsonObjectII = new JSONObject();
            jsonObjectII.put("sceneCode", (Object)sceneCodeRes);
            if (StringUtils.isNotEmpty((String)sceneCodeRes)) {
                bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
                params = new JSONObject();
                String sceneCodeII = ((Question)context.getObject("question", Question.class)).getSceneCode();
                params.put("sceneCode", (Object)sceneCodeII);
                try {
                    ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
                    params.put("applicationCodes", applicationCodes);
                    params.put("version", (Object)context.getString("version"));
                    JSONObject jsonObject2 = bean.querySceneMaps(params, context);
                    if (!Objects.isNull(jsonObject2)) {
                        jsonObjectII.put("billingGoodsId", (Object)jsonObject2.getString("billingGoodsId"));
                        jsonObjectII.put("appCode", (Object)jsonObject2.getString("applicationCode"));
                        jsonObjectII.put("appName", (Object)jsonObject2.getString("applicationName"));
                        List productLines = (List)jsonObject2.getOrDefault((Object)"productLine", new ArrayList());
                        jsonObjectII.put("productLine", (Object)productLines);
                    }
                }
                catch (Exception e2) {
                    log.error("\u6839\u636e\u573a\u666f\u7f16\u7801\u67e5\u8be2\u573a\u666f\u5f02\u5e38\uff1a", (Throwable)e2);
                    return Output.through().keep("reply", (Object)"message.scrumbi.query.billgoods.error").keep("have_scene_flag", (Object)false);
                }
            }
            jsonObjects.add(jsonObjectII);
            bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
            params = new JSONObject();
            params.put("templateCode", (Object)context.getString("templateCode"));
            params.put("targetId", (Object)dataSourceId);
            params.put("dimension", (Object)final_dimension);
            ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
            params.put("applicationCodes", applicationCodes);
            params.put("version", (Object)context.getString("version"));
            String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
            String token = ((Question)context.getObject("question", Question.class)).getToken();
            List<Object> list2 = jsonObjects = StringUtils.isNotEmpty((String)sceneCodeRes) ? jsonObjects : bean.getKmScenes(params, locale, context);
            if (CollectionUtils.isNotEmpty(jsonObjects)) {
                List permissionList = this.queryPermissionSceneOrMetric(token, routerKey, context, jsonObjects);
                if (!CollectionUtils.isNotEmpty((Collection)permissionList)) {
                    context.put("scenePermission", (Object)true);
                    log.warn("user not exist scene permission");
                    return Output.through().keep("reply", (Object)"message.scrumbi.no.scene.permission").keep("have_scene_flag", (Object)false);
                }
                jsonObjects = permissionList;
                if (jsonObjects.size() > 1 && !DebugMode.TEST.getCode().equals(debugMode)) {
                    context.put("special_mode", (Object)SpecialModeEnum.MORE_SCENE.getValue());
                }
                if (jsonObjects.size() == 1) {
                    context.put("finalProductLineInfo", (Object)this.buildProductLineInfo((JSONObject)jsonObjects.get(0)));
                }
                jsonObjects.forEach(jsonObject -> jsonObject.remove((Object)"productLine"));
                context.put("scenes", jsonObjects);
            } else {
                log.warn("\u83b7\u53d6\u573a\u666f\u5931\u8d25");
                if (context.containsKey((Object)"scelect_scene_metric_mix")) {
                    String targetName = this.getTargetName(context);
                    String templateName = this.getTemplateName(context);
                    List dimensionNames = this.getDimensionNames(context);
                    JSONObject input = new JSONObject();
                    input.put("targetName", (Object)targetName);
                    input.put("templateName", (Object)templateName);
                    input.put("dimensionNames", (Object)dimensionNames);
                    LogCheckDto logCheckDto = new LogCheckDto();
                    logCheckDto.buildParams("ChatResultVo", LogUtils.WARING, input.toJSONString(), "\u672a\u5339\u914d\u5230\u5408\u9002\u573a\u666f,\u53ef\u80fd\u56e0\u4e3a\u6ca1\u6709\u914d\u7f6e\u8be5\u573a\u666f\uff0c\u6216\u6ca1\u6709\u53d1\u7248\u5bfc\u81f4\u5df2\u914d\u7f6e\u7684\u573a\u666f\u6ca1\u6709\u751f\u6548", "1.\u4f9d\u6b21\u68c0\u67e5\u573a\u666f\u4e2d\u76ee\u6807=target\uff0c\u89d2\u5ea6=template\uff0c\u7ef4\u5ea6=dimensions\u7684\u914d\u7f6e\u3002\n2.\u5bf9\u4e8e\u672a\u914d\u7f6e\u7684\u90e8\u5206\uff0c\u6dfb\u52a0\u76f8\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\uff0c\u5df2\u914d\u7f6e\u7684\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002\n3.\u4fdd\u5b58\u914d\u7f6e\uff0c\u8fdb\u884c\u53d1\u7248\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u4ecd\u6709\u95ee\u9898\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002".replace("template", templateName).replace("target", targetName).replace("dimensions", dimensionNames.toString()));
                    logCheckDtos.add(logCheckDto);
                    context.put("logCheckDtos", logCheckDtos);
                }
                if (StringUtils.isEmpty((String)debugMode)) return Output.through().keep("reply", (Object)"message.scrumbi.no.scenes").keep("have_scene_flag", (Object)false);
                if (DebugMode.DEBUG.getCode().equals(debugMode)) {
                    return Output.through().keep("reply", (Object)"message.scrumbi.no.scenes").keep("have_scene_flag", (Object)false);
                }
            }
        }
        catch (Exception e3) {
            log.error("\u83b7\u53d6\u573a\u666f\u5931\u8d25", (Throwable)e3);
            return Output.through().keep("reply", (Object)"message.scrumbi.no.scenes").keep("have_scene_flag", (Object)false);
        }
        List scenes = (List)context.getOrDefault((Object)"scenes", new ArrayList());
        if (!StringUtils.isNotEmpty((String)sceneCode)) return Output.finish().keep("have_scene_flag", (Object)true);
        if (!DebugMode.TEST.getCode().equals(debugMode)) return Output.finish().keep("have_scene_flag", (Object)true);
        if (!CollectionUtils.isNotEmpty((Collection)scenes)) return Output.finish().keep("have_scene_flag", (Object)true);
        List sceneCodes = scenes.stream().map(scene -> scene.getString("sceneCode")).collect(Collectors.toList());
        if (!sceneCodes.contains(sceneCode)) return Output.through().keep("reply", (Object)"message.scrumbi.test.mode.not.match.scene").keep("have_scene_flag", (Object)false);
        context.put("autoChoiceScene", (Object)1);
        return Output.finish().keep("have_scene_flag", (Object)true);
    }

    public boolean checkSceneExist(JSONObject context) {
        String sceneExist = context.getString("sceneNotExist");
        return !"1".equals(sceneExist);
    }

    public boolean checkPrModeScene(JSONObject context, String templateCode, String datasourceId, JSONArray dimension) {
        String debugMode = ((Question)context.getObject("question", Question.class)).getDebugMode();
        String sceneCode = ((Question)context.getObject("question", Question.class)).getSceneCode();
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        String token = ((Question)context.getObject("question", Question.class)).getToken();
        JSONObject params = new JSONObject();
        params.put("templateCode", (Object)templateCode);
        params.put("targetId", (Object)datasourceId);
        params.put("dimension", (Object)dimension);
        ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
        params.put("applicationCodes", applicationCodes);
        params.put("version", (Object)context.getString("version"));
        KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
        try {
            List kmScenes;
            if (DebugMode.PR_PARAM.getCode().equals(debugMode) && StringUtils.isNotEmpty((String)sceneCode) && (CollectionUtils.isEmpty((Collection)(kmScenes = bean.getKmScenes(params, locale, context))) || !kmScenes.stream().map(kmScene -> kmScene.getString("sceneCode")).collect(Collectors.toList()).contains(sceneCode))) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5pr\u6a21\u5f0f\u573a\u666f\u5339\u914d\u5f02\u5e38");
            return false;
        }
        return true;
    }

    public List<JSONObject> queryPermissionSceneOrMetric(String token, String routerKey, JSONObject context, List<JSONObject> jsonObjects) {
        if (!ConvertorJsonCommonMethod.queryMetricSwitch((JSONObject)context).booleanValue()) {
            return jsonObjects;
        }
        String userId = ((Question)context.getObject("question", Question.class)).getUserId();
        List applicationCodes = jsonObjects.stream().map(t -> t.getString("appCode")).distinct().collect(Collectors.toList());
        List metricOrSceneCodes = jsonObjects.stream().map(t -> t.getString("sceneCode")).distinct().collect(Collectors.toList());
        KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
        try {
            JSONObject res = bean.queryPermissionSceneOrMetric(token, routerKey, userId, applicationCodes, metricOrSceneCodes);
            if (res != null) {
                ArrayList permissionList;
                List list = permissionList = Objects.isNull(res.getObject("response", List.class)) ? new ArrayList() : (List)res.getObject("response", List.class);
                if (CollectionUtils.isNotEmpty(permissionList)) {
                    ArrayList<JSONObject> newResult = new ArrayList<JSONObject>();
                    jsonObjects.forEach(jsonObject -> {
                        if (permissionList.contains(jsonObject.getString("sceneCode"))) {
                            newResult.add((JSONObject)jsonObject);
                        }
                    });
                    return newResult;
                }
                return null;
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u573a\u666f\u6307\u6807\u6743\u9650\u83b7\u53d6\u5931\u8d25:{}", (Throwable)e);
        }
        return jsonObjects;
    }

    public List<JSONObject> buildProductLineInfo(JSONObject sceneObject) {
        ArrayList<JSONObject> productLineInfo = new ArrayList<JSONObject>();
        try {
            List productLines = (List)sceneObject.getOrDefault((Object)"productLine", new ArrayList());
            for (String productLine : productLines) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("productLine", (Object)productLine);
                productLineInfo.add(jsonObject);
            }
            return productLineInfo;
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u591a\u4ea7\u54c1\u7ebf\u53c2\u6570\u5f02\u5e38\uff1a", (Throwable)e);
            return productLineInfo;
        }
    }

    public String getTargetName(JSONObject context) {
        String targetName = Optional.ofNullable((List)context.getObject("targets", List.class)).map(targets -> {
            for (Object t : targets) {
                JSONObject jsonObject = (JSONObject)t;
                if (!StringUtils.isNotEmpty((String)context.getString("datasourceId")) || !context.getString("datasourceId").equals(jsonObject.getString("datasourceId"))) continue;
                return jsonObject.getString("datasourceName");
            }
            return context.getString("datasourceId");
        }).orElse("");
        return targetName;
    }

    public String getTemplateName(JSONObject context) {
        String templateName = Optional.ofNullable((List)context.getObject("templates", List.class)).map(templates -> {
            for (Object t : templates) {
                JSONObject jsonObject = (JSONObject)t;
                if (!StringUtils.isNotEmpty((String)context.getString("templateCode")) || !context.getString("templateCode").equals(jsonObject.getString("templateCode"))) continue;
                return jsonObject.getString("templateName");
            }
            return context.getString("templateCode");
        }).orElse("");
        return templateName;
    }

    public List<String> getDimensionNames(JSONObject context) {
        JSONArray dimensionArray = context.getJSONArray("final_dimension");
        ArrayList<String> dimensionNames = new ArrayList<String>();
        List schemaList = (List)((JSONObject)context.getOrDefault((Object)"schemas", (Object)new JSONObject())).getOrDefault((Object)"Schemas", new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)schemaList)) {
            for (JSONObject t : schemaList) {
                if (!CollectionUtils.isNotEmpty((Collection)dimensionArray)) continue;
                dimensionArray.forEach(d -> {
                    if (d.toString().equals(t.getString("name"))) {
                        dimensionNames.add(t.getString("title"));
                    }
                });
            }
        }
        return dimensionNames;
    }
}

