/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.AppSystemEnum;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDataSetCrossCheckExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(MetricDataSetCrossCheckExecutor.class);

    public Output doProcess(JSONObject context) {
        List applicationCodes = (List)context.getObject("applicationCodes", List.class);
        String sceneCode = ((Question)context.getObject("question", Question.class)).getSceneCode();
        List metricIdList = ((Question)context.getObject("question", Question.class)).getMetricIdList();
        if (StringUtils.isNotEmpty((CharSequence)sceneCode) || CollectionUtils.isNotEmpty((Collection)metricIdList)) {
            return Output.through((String)"appSystem", (Object)AppSystemEnum.METRIC.getValue());
        }
        List datasetIdList = ((Question)context.getObject("question", Question.class)).getDatasetIdList();
        if (CollectionUtils.isNotEmpty((Collection)datasetIdList)) {
            return Output.through((String)"appSystem", (Object)AppSystemEnum.DATASET.getValue());
        }
        List appSystems = (List)context.getObject("appSystems", List.class);
        HashMap appMap = (HashMap)context.getObject("appMap", HashMap.class);
        if (appSystems.contains(AppSystemEnum.DATASET.getValue()) && (appSystems.contains(null) || appSystems.contains(AppSystemEnum.METRIC.getValue()))) {
            ArrayList<JSONObject> applications = new ArrayList<JSONObject>();
            for (Map.Entry app : appMap.entrySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCode", app.getKey());
                jsonObject.put("applicationName", app.getValue());
                applications.add(jsonObject);
            }
            return Output.finish((String)"reply", (Object)"message.scrumbi.more.app").keep("scelect_metric", (Object)true).keep(MetricSearchResultEnum.MORE_APP_MORE_METRIC.getKey(), (Object)MetricSearchResultEnum.MORE_APP_MORE_METRIC.getValue()).keep("more_app_list", applications);
        }
        log.info("\u8de8\u4f53\u7cfb\u6821\u9a8c\u901a\u8fc7");
        return Output.through((String)"appSystem", (Object)(appSystems.contains(AppSystemEnum.DATASET.getValue()) ? AppSystemEnum.DATASET.getValue() : AppSystemEnum.METRIC.getValue()));
    }
}

