/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.sse.SseSendService;
import com.digiwin.chatbi.service.TranslateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemSolvingDataProcessExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(ProblemSolvingDataProcessExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        String cotSql;
        List sqlExplain;
        Output output = Output.through();
        String problemSolvingGptName = "nl2sql_cot";
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            problemSolvingGptName = problemSolvingGptName + "_V1";
        } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            problemSolvingGptName = problemSolvingGptName + "_V2";
        }
        JSONObject problemSolvingGptResult = context.getJSONObject(problemSolvingGptName);
        if (Objects.isNull(problemSolvingGptResult) || Objects.isNull(problemSolvingGptResult.getBoolean("isDataSourceComplete"))) {
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.nl2sql.cot.error");
        }
        if (!problemSolvingGptResult.getBoolean("isDataSourceComplete").booleanValue()) {
            String dataSourceValidation = problemSolvingGptResult.getString("dataSourceValidation");
            if (StringUtils.isEmpty((String)dataSourceValidation)) {
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.nl2sql.cot.error");
            }
            int colonIndex = dataSourceValidation.indexOf("\uff1a");
            if (colonIndex == -1) {
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.nl2sql.cot.error");
            }
            dataSourceValidation = dataSourceValidation.substring(colonIndex + 1);
            if (StringUtils.isEmpty((String)dataSourceValidation)) {
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.nl2sql.cot.error");
            }
            String[] split = dataSourceValidation.split("[,\uff0c]");
            ArrayList<String> missingFields = new ArrayList<String>();
            for (String s : split) {
                if (!s.contains("(\u7f3a\u5931)")) continue;
                missingFields.add(s.replace("(\u7f3a\u5931)", ""));
            }
            if (CollectionUtils.isNotEmpty(missingFields)) {
                List datasetList = (List)context.getOrDefault((Object)"final_dataSet", new ArrayList());
                if (CollectionUtils.isEmpty((Collection)datasetList)) {
                    datasetList = (List)context.getOrDefault((Object)"final_metric", new ArrayList());
                }
                List names = datasetList.stream().map(dataset -> {
                    if (StringUtils.isNotEmpty((String)dataset.getString("datasetName"))) {
                        return dataset.getString("datasetName");
                    }
                    return dataset.getString("metricName");
                }).collect(Collectors.toList());
                String reply = "\u6570\u636e\u6e90\u3010" + String.join((CharSequence)"\u3001", names) + "\u3011\u4e2d\u672a\u627e\u5230\u3010" + String.join((CharSequence)"\u3001", missingFields) + "\u3011\u5b57\u6bb5\uff0c\u8bf7\u53c2\u8003\u6307\u4ee4\u96c6\u5185\u95ee\u53e5\u63d0\u95ee\uff5e";
                TranslateService translateService = (TranslateService)SpringContextUtil.getBean(TranslateService.class);
                String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                if ("zh_TW".equals(locale)) {
                    reply = translateService.zh2Hant(reply);
                }
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
            }
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.nl2sql.cot.error");
        }
        Question question = (Question)context.getObject("question", Question.class);
        if (context.containsKey((Object)"scelect_metric")) {
            sqlExplain = (List)problemSolvingGptResult.getObject("sqlExplain", List.class);
            cotSql = sqlExplain.toString();
        } else {
            sqlExplain = ((JSONArray)problemSolvingGptResult.getObject("sqlExplain", JSONArray.class)).stream().map(cot -> ((JSONObject)cot).getString("explanation")).collect(Collectors.toList());
            JSONObject tempCotResult = JSONObject.parseObject((String)JSONObject.toJSONString((Object)problemSolvingGptResult));
            tempCotResult.remove((Object)"dataSourceValidation");
            tempCotResult.remove((Object)"isDataSourceComplete");
            for (Object o : (JSONArray)tempCotResult.getObject("sqlExplain", JSONArray.class)) {
                ((JSONObject)o).remove((Object)"sourceFields");
            }
            cotSql = JSONObject.toJSONString((Object)tempCotResult);
        }
        SseSendService sseSendService = (SseSendService)SpringContextUtil.getBean(SseSendService.class);
        sseSendService.asyncSendProblemSolvingDetail(question, String.join((CharSequence)"\n", sqlExplain), Boolean.valueOf(question.isIfStream()), context);
        return output.keep("languageType", (Object)problemSolvingGptResult.getString("languageType")).keep("sqlExplain", context.containsKey((Object)"sqlExplain") ? context.get((Object)"sqlExplain") : sqlExplain).keep("cot_sql", (Object)cotSql);
    }
}

