/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.DataTypeCode;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.DataProcessAfterSearchExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SearchMatchestDimensionExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchMatchestDimensionExecutor.class);
    public static final String SPLITE = "&&&&";

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        HashSet<JSONObject> filterDimensionStandardWords;
        String questionMsg;
        List dimensionStandardWords;
        Environment environment = (Environment)SpringContextUtil.getBean(Environment.class);
        boolean synonymOldSwitch = (Boolean)environment.getProperty("synonym.old.switch", Boolean.class);
        log.info("\u641c\u7d22\u7ef4\u5ea6\u662f\u5426\u8d70\u8001es\u5f00\u5173:{}", (Object)synonymOldSwitch);
        if (!Objects.isNull(synonymOldSwitch) && synonymOldSwitch) {
            return Output.through();
        }
        List dimensionStandardSynonymsWords = (List)context.getOrDefault((Object)"dimension_standard_synonyms_words", new ArrayList());
        List metrics = (List)context.getOrDefault((Object)"final_metric", new ArrayList());
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        LogCheckDto logCheckDto = new LogCheckDto();
        logCheckDto.buildParams("SearchMatchestDimension", LogUtils.SUCCESS, dimensionStandardSynonymsWords.toString(), "", "");
        if (CollectionUtils.isEmpty((Collection)metrics)) {
            log.error("\u68c0\u7d22\u7ef4\u5ea6\u65f6\u53d1\u73b0\u6307\u6807\u4e3a\u7a7a");
            return Output.through();
        }
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        ArrayList<JSONObject> accurateStandardWords = new ArrayList<JSONObject>();
        for (Object metric : metrics) {
            if (CollectionUtils.isEmpty((Collection)metric.getJSONArray("fieldSchema"))) continue;
            for (Object o : metric.getJSONArray("fieldSchema")) {
                JSONObject fieldSchema = (JSONObject)o;
                if (StringUtils.isEmpty((CharSequence)fieldSchema.getString("dataType")) || DataTypeCode.NUMERIC.getCode().equalsIgnoreCase(fieldSchema.getString("dataType")) || StringUtils.isEmpty((CharSequence)fieldSchema.getString("title"))) continue;
                JSONObject jsonObject = new JSONObject();
                String standard_name = fieldSchema.getString("title");
                if (locale.equalsIgnoreCase("zh_TW") && Objects.nonNull(fieldSchema.getJSONObject("lang")) && Objects.nonNull(fieldSchema.getJSONObject("lang").getJSONObject("title")) && StringUtils.isNotEmpty((CharSequence)fieldSchema.getJSONObject("lang").getJSONObject("title").getString("zh_TW"))) {
                    standard_name = fieldSchema.getJSONObject("lang").getJSONObject("title").getString("zh_TW");
                } else if (locale.equalsIgnoreCase("zh_CN") && Objects.nonNull(fieldSchema.getJSONObject("lang")) && Objects.nonNull(fieldSchema.getJSONObject("lang").getJSONObject("title")) && StringUtils.isNotEmpty((CharSequence)fieldSchema.getJSONObject("lang").getJSONObject("title").getString("zh_CN"))) {
                    standard_name = fieldSchema.getJSONObject("lang").getJSONObject("title").getString("zh_CN");
                }
                jsonObject.put("applicationCodes", Arrays.asList(metric.get((Object)"applicationCode")));
                jsonObject.put("version", (Object)metric.getString("version"));
                jsonObject.put("standard_name", (Object)standard_name);
                jsonObject.put("match_words", Arrays.asList(standard_name));
                jsonObject.put("entity_type", (Object)"\u7ef4\u5ea6");
                accurateStandardWords.add(jsonObject);
            }
        }
        if (CollectionUtils.isEmpty((Collection)dimensionStandardSynonymsWords) || CollectionUtils.isEmpty((Collection)metrics)) {
            log.info("\u6307\u6807\u6216\u7ef4\u5ea6\u4e3a\u7a7a");
            logCheckDto.setResult("\u672a\u68c0\u7d22\u5230\u7ef4\u5ea6\u540c\u4e49\u8bcd");
            logCheckDtos.add(logCheckDto);
            return Output.through().keep("logCheckDtos", logCheckDtos);
        }
        String applicationCode = ((JSONObject)metrics.get(0)).getString("applicationCode");
        if (CollectionUtils.isEmpty(dimensionStandardSynonymsWords = dimensionStandardSynonymsWords.stream().filter(dimension -> applicationCode.equals(dimension.getString("assistant_id")) || StringUtils.isNotEmpty((CharSequence)dimension.getString("tenant_id"))).collect(Collectors.toList())) && CollectionUtils.isEmpty(accurateStandardWords)) {
            log.info("\u7ef4\u5ea6\u6309\u6307\u6807\u5e94\u7528\u8fc7\u6ee4\u540e\u4e3a\u7a7a");
            logCheckDto.setResult("\u6307\u6807\u6240\u5c5e\u7684\u5e94\u7528\u4e0b\u672a\u627e\u5230\u7ef4\u5ea6\u7684\u540c\u4e49\u8bcd");
            logCheckDto.setCode(LogUtils.WARING);
            logCheckDto.setSuggestion("1.\u6253\u5f00\u540c\u4e49\u8bcd\u914d\u7f6e\u9875\u9762\u3002\n2.\u4e3a\u7ef4\u5ea6\u6dfb\u52a0\u6216\u4fee\u6539\u540c\u4e49\u8bcd\uff0c\u786e\u4fdd\u5176\u51c6\u786e\u53cd\u6620\u7ef4\u5ea6\u542b\u4e49\u3002\n3.\u4fdd\u5b58\u914d\u7f6e\uff0c\u68c0\u67e5\u7cfb\u7edf\u662f\u5426\u6b63\u5e38\u8fd0\u884c\uff0c\u5426\u5219\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.through().keep("logCheckDtos", logCheckDtos);
        }
        if (CollectionUtils.isNotEmpty(dimensionStandardSynonymsWords)) {
            for (JSONObject standardSynonymsWord : dimensionStandardSynonymsWords) {
                JSONObject jsonObject = new JSONObject();
                if (StringUtils.isEmpty((CharSequence)standardSynonymsWord.getString("tenant_id"))) {
                    jsonObject.put("applicationCodes", Arrays.asList(standardSynonymsWord.getString("assistant_id")));
                } else {
                    jsonObject.put("applicationCodes", context.get((Object)"applicationCodes"));
                }
                jsonObject.put("version", (Object)context.getString("version"));
                jsonObject.put("standard_name", standardSynonymsWord.get((Object)"standard_name"));
                jsonObject.put("match_words", standardSynonymsWord.get((Object)"match_words"));
                jsonObject.put("entity_type", standardSynonymsWord.get((Object)"entity_type"));
                jsonObject.put("synonyms", standardSynonymsWord.get((Object)"synonyms"));
                accurateStandardWords.add(jsonObject);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(dimensionStandardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV3(accurateStandardWords, (String)(questionMsg = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "")))))) {
            log.info("\u7ef4\u5ea6\u6309\u6700\u957f\u8bcd\u5339\u914d\u540e\u4e3a\u7a7a");
            logCheckDto.setResult("\u7ef4\u5ea6\u6309\u6700\u957f\u8bcd\u5339\u914d\u540e\u4e3a\u7a7a");
            logCheckDto.setCode(LogUtils.WARING);
            logCheckDto.setSuggestion("\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
            logCheckDtos.add(logCheckDto);
            return Output.through().keep("logCheckDtos", logCheckDtos);
        }
        if (context.containsKey((Object)"scelect_dataSet")) {
            filterDimensionStandardWords = new HashSet(dimensionStandardWords);
        } else {
            filterDimensionStandardWords = new HashSet<JSONObject>();
            for (JSONObject dimensionStandardWord : dimensionStandardWords) {
                String standardName = dimensionStandardWord.getString("standard_name");
                for (JSONObject metric : metrics) {
                    JSONArray fieldSchemas = (JSONArray)metric.getOrDefault((Object)"fieldSchema", (Object)new JSONArray());
                    for (Object obj : fieldSchemas) {
                        JSONObject fieldSchema = (JSONObject)obj;
                        String title = fieldSchema.getString("title");
                        JSONObject lang = (JSONObject)fieldSchema.getOrDefault((Object)"lang", (Object)new JSONObject());
                        JSONObject langTitle = (JSONObject)lang.getOrDefault((Object)"title", (Object)new JSONObject());
                        String langTitleZH_TW = langTitle.getString("zh_TW");
                        String langTitleZH_CN = langTitle.getString("zh_CN");
                        if (!standardName.equals(title) && !standardName.equals(langTitleZH_TW) && !standardName.equals(langTitleZH_CN)) continue;
                        dimensionStandardWord.put("title", (Object)title);
                        filterDimensionStandardWords.add(dimensionStandardWord);
                    }
                }
            }
        }
        ArrayList jsonObjects = new ArrayList(filterDimensionStandardWords);
        HashSet seen = new HashSet();
        List distinctDimensionStandardWords = jsonObjects.stream().filter(json -> {
            String title = json.getString("title");
            String compareField = json.getString("compare_field");
            return seen.add(title + compareField);
        }).collect(Collectors.toList());
        logCheckDto.setResult(JSONObject.toJSONString(distinctDimensionStandardWords));
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"distinctDimensionStandardWords", distinctDimensionStandardWords).keep("logCheckDtos", logCheckDtos);
    }
}

