/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.DataProcessAfterSearchExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.SearchMetricRollBackExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.reasoning.sse.SseSendService;
import com.digiwin.chatbi.service.TranslateService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SearchMetricExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchMetricExecutor.class);
    public static final String SPLITE = "&&&&";

    public Output doProcess(JSONObject context) {
        HashMap groupedMetrics;
        Environment environment = (Environment)SpringContextUtil.getBean(Environment.class);
        boolean synonymOldSwitch = (Boolean)environment.getProperty("synonym.old.switch", Boolean.class);
        log.info("\u641c\u7d22\u6307\u6807\u662f\u5426\u8d70\u8001es\u5f00\u5173:{}", (Object)synonymOldSwitch);
        if (!Objects.isNull(synonymOldSwitch) && synonymOldSwitch) {
            SearchMetricRollBackExecutor searchMetricRollBackExecutor = (SearchMetricRollBackExecutor)SpringContextUtil.getBean(SearchMetricRollBackExecutor.class);
            return searchMetricRollBackExecutor.doProcess(context);
        }
        List metrics = null;
        List metric_standard_synonyms_before_filter = new ArrayList();
        List metric_standard_synonyms_after_filter = new ArrayList();
        List distinctMetricStandardWords4Gpt = new ArrayList();
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        try {
            metrics = this.matchestMetricsSearch(context);
            metric_standard_synonyms_before_filter = (List)context.getOrDefault((Object)"metric_standard_synonyms_before_filter", new ArrayList());
            metric_standard_synonyms_after_filter = (List)context.getOrDefault((Object)"metric_standard_synonyms_after_filter", new ArrayList());
            distinctMetricStandardWords4Gpt = (List)context.getOrDefault((Object)"distinctMetricStandardWords4Gpt", new ArrayList());
        }
        catch (Exception e) {
            log.error("\u6307\u6807\u641c\u7d22\u5931\u8d25\uff1a{}", (Throwable)e);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.rh.or.es.sys.error").keep("metric_standard_synonyms_before_filter", metric_standard_synonyms_before_filter).keep("metric_standard_synonyms_after_filter", metric_standard_synonyms_after_filter).keep("distinctMetricStandardWords4Gpt", distinctMetricStandardWords4Gpt);
        }
        JSONObject input = new JSONObject();
        input.put("metric_standard_synonyms_before_filter", metric_standard_synonyms_before_filter);
        JSONObject result = new JSONObject();
        result.put("metric_standard_synonyms_after_filter", metric_standard_synonyms_after_filter);
        result.put("metrics", (Object)metrics);
        if (CollectionUtils.isEmpty((Collection)metrics)) {
            log.info("\u641c\u6307\u6807\u6ca1\u641c\u5230");
            context.remove((Object)"not_query_all");
            metrics = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            if (CollectionUtils.isEmpty((Collection)metrics)) {
                LogCheckDto logCheckDto = new LogCheckDto();
                logCheckDto.buildParams("SearchMetric", "U.SCRUMBI.901.0110", input.toJSONString(), "\u7528\u6237\u5df2\u8ba2\u8d2d\u5e94\u7528\u4e0b\u65e0\u4efb\u4f55\u6307\u6807\uff0c\u53ef\u80fd\u662f\u79df\u6237\u3010" + context.getString("tenantId") + "\u3011" + "\u548c\u5e94\u7528\u7248\u672c\u4e0d\u76f8\u540c\u6216\u672a\u914d\u7f6e\u5e94\u7528\u6743\u9650", "1.\u786e\u8ba4\u7528\u6237\u6743\u9650\u5728\u6743\u9650\u7ba1\u7406\u754c\u9762\u662f\u5426\u6b63\u786e\u3002\n2.\u95ee\u9898\u662f\u5728\u6d4b\u8bd5\u533a\uff0c\u79df\u6237\u7248\u672c1.0\u9700\u53d1\u7248\u6307\u6807\u6240\u5728\u7684\u5e94\u7528\uff0c2.0\u9700\u5207\u7248\u6307\u6807\u6240\u5728\u7684\u5e94\u7528\u3002\n3.\u8fdb\u5165\u7cfb\u7edf\u7684\u53d1\u7248\u6216\u5207\u7248\u64cd\u4f5c\u754c\u9762\uff0c\u6267\u884c\u64cd\u4f5c\u3002\n4.\u5907\u4efd\u6570\u636e\u540e\u53d1\u7248\u6216\u5207\u7248\uff0c\u5b8c\u6210\u540e\u68c0\u67e5\u7cfb\u7edf\u662f\u5426\u6b63\u5e38\uff0c\u5426\u5219\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                logCheckDtos.add(logCheckDto);
                return Output.finish((String)"success", (Object)false).keep("metric_standard_synonyms_before_filter", metric_standard_synonyms_before_filter).keep("metric_standard_synonyms_after_filter", metric_standard_synonyms_after_filter).keep("distinctMetricStandardWords4Gpt", distinctMetricStandardWords4Gpt).keep("reply", (Object)"message.scrumbi.no.metric.error").keep("logCheckDtos", logCheckDtos);
            }
            Map<String, List<JSONObject>> groupedMetrics2 = metrics.stream().collect(Collectors.groupingBy(metric -> metric.getString("applicationCode")));
            ArrayList gptParam = new ArrayList();
            ArrayList apps = new ArrayList();
            groupedMetrics2.entrySet().forEach(g -> {
                ArrayList metricNames = new ArrayList();
                List value = (List)g.getValue();
                value.forEach(v -> metricNames.add(v.getString("metricName")));
                gptParam.add(metricNames);
                apps.add((String)g.getKey());
            });
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchMetric", LogUtils.WARING, input.toJSONString(), "\u672a\u5339\u914d\u5230\u76f8\u5173\u6307\u6807\uff0c\u63a5\u4e0b\u6765\u5c06\u4f7f\u7528LLM\u515c\u5e95\u68c0\u7d22\u6307\u6807\uff0c\u53ef\u80fd\u539f\u56e0\u662f\u672a\u914d\u7f6e\u6307\u6807\u6216\u672a\u914d\u7f6e\u6307\u6807\u540c\u4e49\u8bcd", "1.\u6253\u5f00\u6307\u6807\u548c\u540c\u4e49\u8bcd\u7684\u914d\u7f6e\u9875\u9762\u3002\n2.\u786e\u8ba4\u6240\u95ee\u6307\u6807\u662f\u5426\u5df2\u914d\u7f6e\uff0c\u6307\u6807\u4fe1\u606f\u662f\u5426\u5b8c\u6574\u3002\n3.\u68c0\u67e5\u6307\u6807\u7684\u540c\u4e49\u8bcd\u662f\u5426\u5df2\u8bbe\u7f6e\uff0c\u786e\u4fdd\u5176\u51c6\u786e\u6027\u3002\n4.\u4fdd\u5b58\u5e76\u91cd\u65b0\u53d1\u7248\u64cd\u4f5c\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            context.put("all_metric_list", groupedMetrics2);
            return Output.through((String)MetricSearchResultEnum.NO_METRIC.getKey(), (Object)MetricSearchResultEnum.NO_METRIC.getValue()).keep("no_metric_gpt_param", (Object)this.buildMetricParams(groupedMetrics2)).keep("no_metric_apps", apps).keep("metric_standard_synonyms_before_filter", metric_standard_synonyms_before_filter).keep("metric_standard_synonyms_after_filter", metric_standard_synonyms_after_filter).keep("distinctMetricStandardWords4Gpt", distinctMetricStandardWords4Gpt).keep("logCheckDtos", logCheckDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)metrics) && ConvertorJsonCommonMethod.queryMetricSwitch((JSONObject)context).booleanValue() && CollectionUtils.isEmpty((Collection)(metrics = ConvertorJsonCommonMethod.filterMetricPermission((JSONObject)context, (List)metrics)))) {
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchMetric", "U.SCRUMBI.901.0109", input.toJSONString(), "\u8bc6\u522b\u5230\u7528\u6237\u65e0\u6b64\u6307\u6807" + context.getOrDefault((Object)"noPermissionMetrics", new HashSet()).toString() + "\u6743\u9650", "1.\u767b\u5f55\u9f0e\u6377\u4e91\u7684\u6743\u9650\u7ba1\u7406\u90e8\u5206\uff0c\u9009\u62e9\u76f8\u5e94\u7528\u6237\u548c\u5e94\u7528\u3002\n2.\u67e5\u627e\u76f8\u5173\u6307\u6807\uff0c\u67e5\u770b\u5176\u6743\u9650\u8bbe\u7f6e\u3002\n3.\u786e\u4fdd\u7528\u6237\u6216\u7528\u6237\u7ec4\u6709\u76f8\u5e94\u7684\u6307\u6807\u8bbf\u95ee\u6743\u9650\u3002\n4.\u82e5\u6743\u9650\u7f3a\u5931\uff0c\u6dfb\u52a0\u6743\u9650\uff0c\u91cd\u65b0\u6d4b\u8bd5\u6307\u6807\u8bbf\u95ee\uff0c\u82e5\u95ee\u9898\u5b58\u5728\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.permission").keep("metric_standard_synonyms_before_filter", metric_standard_synonyms_before_filter).keep("metric_standard_synonyms_after_filter", metric_standard_synonyms_after_filter).keep("distinctMetricStandardWords4Gpt", distinctMetricStandardWords4Gpt).keep("no_metric_permission_flag", (Object)1).keep("logCheckDtos", logCheckDtos);
        }
        Map<Object, Object> map = groupedMetrics = CollectionUtils.isEmpty((Collection)metrics) ? Maps.newHashMap() : metrics.stream().collect(Collectors.groupingBy(metric -> metric.getString("applicationCode")));
        if (groupedMetrics.size() > 1) {
            ArrayList metricsAppInfos = new ArrayList();
            groupedMetrics.entrySet().forEach(g -> {
                JSONObject groupedMetric = (JSONObject)((List)g.getValue()).get(0);
                JSONObject metricsAppInfo = new JSONObject();
                metricsAppInfo.put("applicationCode", (Object)groupedMetric.getString("applicationCode"));
                metricsAppInfo.put("applicationName", (Object)groupedMetric.getString("applicationName"));
                metricsAppInfos.add(metricsAppInfo);
            });
            log.info("\u641c\u6307\u6807\u771f\u8d70\u5230\u591a\u5e94\u7528\u4e86\uff1a{}", (Object)JSONObject.toJSONString((Object)metrics));
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchMetric", LogUtils.SUCCESS, input.toJSONString(), JSONObject.toJSONString((Object)metrics), "");
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"reply", (Object)"message.scrumbi.more.app").keep(MetricSearchResultEnum.MORE_APP_MORE_METRIC.getKey(), (Object)MetricSearchResultEnum.MORE_APP_MORE_METRIC.getValue()).keep("more_app_list", metricsAppInfos).keep("metric_size", (Object)(Objects.nonNull(metrics) ? metrics.size() : 0)).keep("metric_standard_synonyms_before_filter", metric_standard_synonyms_before_filter).keep("metric_standard_synonyms_after_filter", metric_standard_synonyms_after_filter).keep("distinctMetricStandardWords4Gpt", distinctMetricStandardWords4Gpt).keep("logCheckDtos", logCheckDtos);
        }
        LogCheckDto logCheckDto = new LogCheckDto();
        logCheckDto.buildParams("SearchMetric", LogUtils.SUCCESS, input.toJSONString(), JSONObject.toJSONString((Object)metrics), "");
        logCheckDtos.add(logCheckDto);
        Question question = (Question)context.getObject("question", Question.class);
        String metricNames = "";
        if (CollectionUtils.isNotEmpty((Collection)metrics)) {
            metricNames = metrics.stream().map(metric -> metric.getString("metricName")).collect(Collectors.toList()).toString();
        }
        SseSendService sseSendService = (SseSendService)SpringContextUtil.getBean(SseSendService.class);
        sseSendService.asyncSendAQDetailAndSCTitle(question, metricNames, question.isIfStream(), context);
        return Output.through((String)"final_metric", (Object)metrics).keep(MetricSearchResultEnum.ONE_METRIC.getKey(), (Object)MetricSearchResultEnum.ONE_METRIC.getValue()).keep("metric_size", (Object)(Objects.nonNull(metrics) ? metrics.size() : 0)).keep("billingGoodsId", (Object)(Objects.nonNull(metrics) ? ((JSONObject)metrics.get(0)).getString("billingGoodsId") : "")).keep("metric_standard_synonyms_before_filter", metric_standard_synonyms_before_filter).keep("metric_standard_synonyms_after_filter", metric_standard_synonyms_after_filter).keep("distinctMetricStandardWords4Gpt", distinctMetricStandardWords4Gpt).keep("logCheckDtos", logCheckDtos);
    }

    private List<JSONObject> productPriority(List<JSONObject> metrics) {
        Map<String, List<JSONObject>> tempGroupedMetrics = metrics.stream().collect(Collectors.groupingBy(metric -> metric.getString("applicationCode")));
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        tempGroupedMetrics.values().forEach(tempGroupedMetric -> {
            Map<String, List<JSONObject>> groupedByMetricName = tempGroupedMetric.stream().collect(Collectors.groupingBy(metric -> metric.getString("metricName")));
            List result = groupedByMetricName.values().stream().map(group -> {
                JSONObject nonCommon = group.stream().filter(metric -> !"common".equals(metric.getString("prod"))).findAny().orElse(null);
                return nonCommon != null ? nonCommon : (JSONObject)group.get(0);
            }).collect(Collectors.toList());
            res.addAll(result);
        });
        return res;
    }

    private List<JSONObject> matchestMetricsSearch(JSONObject context) {
        String applicationCode = ((Question)context.getObject("question", Question.class)).getAppCode();
        List metricIds = ((Question)context.getObject("question", Question.class)).getMetricIdList();
        List metrics = null;
        if (StringUtils.isNotEmpty((CharSequence)applicationCode)) {
            context.put("appCodesCondition", Arrays.asList(applicationCode));
        } else {
            ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
            context.put("appCodesCondition", applicationCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)metricIds)) {
            context.put("metricIds", (Object)metricIds);
            metrics = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            return metrics;
        }
        context.put("not_query_all", (Object)"1");
        String questionMsg = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        String originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getOriginFinallyQuestion();
        if (StringUtils.isEmpty((CharSequence)originFinallyQuestion)) {
            originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getMessage();
        }
        JSONObject cnAndTw = this.translate(questionMsg);
        String simplified_use_question = cnAndTw.getString("zh_CN");
        String traditional_use_question = cnAndTw.getString("zh_TW");
        List metricsSearchedKey = null;
        ArrayList<JSONObject> accurateStandardWords = new ArrayList<JSONObject>();
        context.put("simplified_use_question", (Object)simplified_use_question);
        context.put("traditional_use_question", (Object)traditional_use_question);
        context.put("origin_finally_question", (Object)originFinallyQuestion);
        metricsSearchedKey = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        log.info("metricsSearchedKey:{}", (Object)metricsSearchedKey);
        if (CollectionUtils.isNotEmpty((Collection)metricsSearchedKey)) {
            metricsSearchedKey.forEach(t -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCodes", Arrays.asList(t.getString("applicationCode")));
                jsonObject.put("version", (Object)t.getString("version"));
                jsonObject.put("standard_name", (Object)t.getString("metricName"));
                jsonObject.put("match_words", Arrays.asList(t.getString("metricName")));
                jsonObject.put("entity_type", (Object)t.getString("entity_type"));
                accurateStandardWords.add(jsonObject);
            });
        }
        log.info("accurateStandardWords:{}", accurateStandardWords);
        List standardSynonymsWords = (List)context.getObject("standardSynonymsWords", List.class);
        if (CollectionUtils.isNotEmpty((Collection)standardSynonymsWords)) {
            for (JSONObject standardSynonymsWord : standardSynonymsWords) {
                JSONObject jsonObject = new JSONObject();
                if (StringUtils.isEmpty((CharSequence)standardSynonymsWord.getString("tenant_id"))) {
                    jsonObject.put("applicationCodes", Arrays.asList(standardSynonymsWord.getString("assistant_id")));
                } else {
                    jsonObject.put("applicationCodes", context.get((Object)"applicationCodes"));
                }
                jsonObject.put("version", (Object)context.getString("version"));
                jsonObject.put("entity_type", (Object)standardSynonymsWord.getString("entity_type"));
                jsonObject.put("standard_name", (Object)standardSynonymsWord.getString("standard_name"));
                jsonObject.put("match_words", standardSynonymsWord.get((Object)"match_words"));
                accurateStandardWords.add(jsonObject);
            }
        }
        context.put("metric_standard_synonyms_before_filter", accurateStandardWords);
        List standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV2(accurateStandardWords, (String)originFinallyQuestion);
        if (CollectionUtils.isEmpty((Collection)standardWords)) {
            standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV2(accurateStandardWords, (String)simplified_use_question);
        }
        if (CollectionUtils.isEmpty((Collection)standardWords)) {
            standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV2(accurateStandardWords, (String)traditional_use_question);
        }
        if (CollectionUtils.isEmpty((Collection)standardWords) && CollectionUtils.isNotEmpty(accurateStandardWords)) {
            log.info("\u6700\u957f\u8bcd\u6ed1\u52a8\u6ca1\u627e\u5230\u4efb\u4f55\u8bcd");
        }
        if (CollectionUtils.isNotEmpty((Collection)standardWords)) {
            context.put("metric_standard_synonyms_after_filter", (Object)standardWords);
            HashSet seen = new HashSet();
            List distinctMetricStandardWords = standardWords.stream().filter(json -> {
                String standardName = json.getString("standard_name");
                String compareField = json.getString("compare_field");
                return seen.add(standardName + compareField);
            }).collect(Collectors.toList());
            context.put("distinctMetricStandardWords", distinctMetricStandardWords);
            metrics = Optional.ofNullable(Retrieve.METRIC_V2.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            ArrayList<JSONObject> distinctMetricStandardWords4Gpt = new ArrayList<JSONObject>();
            if (CollectionUtils.isNotEmpty((Collection)metrics) && CollectionUtils.isNotEmpty(distinctMetricStandardWords)) {
                for (JSONObject metric : metrics) {
                    for (JSONObject distinctMetricStandardWord : distinctMetricStandardWords) {
                        if (!metric.getString("metricName").equals(distinctMetricStandardWord.getString("standard_name")) || !((List)distinctMetricStandardWord.get((Object)"applicationCodes")).contains(metric.getString("applicationCode"))) continue;
                        distinctMetricStandardWords4Gpt.add(distinctMetricStandardWord);
                    }
                }
            }
            context.put("distinctMetricStandardWords4Gpt", distinctMetricStandardWords4Gpt.stream().distinct().collect(Collectors.toList()));
        }
        return metrics;
    }

    private JSONObject translate(String key) {
        TranslateService bean = (TranslateService)SpringContextUtil.getBean(TranslateService.class);
        JSONObject cnAndTw = bean.cnAndTw(key);
        return cnAndTw;
    }

    public String buildMetricParams(Map<String, List<JSONObject>> groupedMetrics) {
        StringBuilder result = new StringBuilder();
        int count = 1;
        for (Map.Entry<String, List<JSONObject>> entry : groupedMetrics.entrySet()) {
            String appName = "\u5e94\u7528" + count;
            List<JSONObject> metrics = entry.getValue();
            String s = this.appendMetricNames(appName, metrics);
            result.append(s);
            ++count;
        }
        return result.toString();
    }

    private List<JSONObject> buildMetricParams4OneApp(List<JSONObject> metrics) {
        ArrayList<JSONObject> params = new ArrayList<JSONObject>();
        for (JSONObject metric : metrics) {
            String description = metric.getString("description");
            JSONObject param = new JSONObject();
            param.put("metric", (Object)metric.getString("metricName"));
            if (StringUtils.isNotEmpty((CharSequence)description)) {
                param.put("description", (Object)description);
            }
            params.add(param);
        }
        return params;
    }

    private String appendMetricNames(String appName, List<JSONObject> metrics) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            result.append(appName).append(":\n");
        }
        for (JSONObject metric : metrics) {
            String metricName = metric.getString("metricName");
            String description = metric.getString("description");
            result.append("  - ").append(metricName);
            if (StringUtils.isNotEmpty((CharSequence)description) && !"null".equals(description)) {
                result.append(": ").append(description);
            }
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }
}

