/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.executor.prompt.PromptExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.KnowledgemapsService;
import com.google.common.collect.Lists;
import groovy.lang.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CotFieldCheckExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(CotFieldCheckExecutor.class);
    public static final Integer maxDatasetCount = 15;

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        Output output;
        Retrieve datasetRetrieve;
        Executor CALL_GPT_WITH_COT_REPEATABLE_PROMPT;
        String problemSolvingGptName;
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        if (ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            problemSolvingGptName = "nl2sql_cot_V1";
            CALL_GPT_WITH_COT_REPEATABLE_PROMPT = ExecutorFactory.CALL_GPT_WITH_COT_REPEATABLE_PROMPT_V1;
            datasetRetrieve = Retrieve.DATASET_V1;
        } else {
            problemSolvingGptName = "nl2sql_cot_V2";
            CALL_GPT_WITH_COT_REPEATABLE_PROMPT = ExecutorFactory.CALL_GPT_WITH_COT_REPEATABLE_PROMPT_V2;
            datasetRetrieve = Retrieve.DATASET_V2;
        }
        JSONObject problemSolvingGptResult = context.getJSONObject(problemSolvingGptName);
        if (Objects.isNull(problemSolvingGptResult) || CollectionUtils.isEmpty((Collection)problemSolvingGptResult.getJSONArray("sqlExplain"))) {
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.nl2sql.cot.error");
        }
        List datasetsMatchedTable = (List)context.getOrDefault((Object)"final_dataSet", new ArrayList());
        List errorDetails = this.getErrorMsg(problemSolvingGptResult, datasetsMatchedTable);
        String errorDetailsStr = "";
        if (CollectionUtils.isNotEmpty((Collection)errorDetails)) {
            errorDetailsStr = JSONObject.toJSONString((Object)errorDetails);
        }
        if (!problemSolvingGptResult.getBooleanValue("isDataSourceComplete")) {
            errorDetailsStr = errorDetailsStr + "\n" + problemSolvingGptResult.getString("dataSourceValidation");
        }
        if (StringUtils.isEmpty((CharSequence)errorDetailsStr)) {
            return Output.through();
        }
        JSONObject errorMsg = new JSONObject();
        errorMsg.put("feedbackType", (Object)"\u6570\u636e\u6e90\u6821\u9a8c\u5931\u8d25");
        errorMsg.put("errorDetails", (Object)errorDetailsStr);
        context.put("errorMsg", (Object)errorMsg);
        Question question = (Question)context.getObject("question", Question.class);
        List<Object> relationIds4Cot = new ArrayList();
        List datasets4Cot = datasetsMatchedTable;
        if (CollectionUtils.isNotEmpty((Collection)question.getDatasetIdList())) {
            for (JSONObject dataset4Cot : datasets4Cot) {
                dataset4Cot.put("metricId", (Object)dataset4Cot.getString("datasetId"));
                dataset4Cot.put("metricName", (Object)dataset4Cot.getString("datasetName"));
            }
            context.put("final_dataSet", (Object)datasets4Cot);
            context.put("metricData", (Object)PromptExecutor.getMetricData((JSONObject)context));
            context.put("metricDataMd", (Object)PromptExecutor.getMetricDataMd((JSONObject)context));
            output = CALL_GPT_WITH_COT_REPEATABLE_PROMPT.doProcess(context);
            problemSolvingGptResult = output.getOutputContext().getJSONObject(problemSolvingGptName);
            context.put(problemSolvingGptName, (Object)problemSolvingGptResult);
            errorDetails = this.getErrorMsg(problemSolvingGptResult, datasetsMatchedTable);
        } else {
            List datasetIds = datasetsMatchedTable.stream().map(dataset -> dataset.getString("datasetId")).collect(Collectors.toList());
            context.put("datasetIds", datasetIds);
            List tableRelations = Optional.ofNullable(Retrieve.MATCH_TABLE_RELATIONS.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)tableRelations) && 1 != datasetIds.size()) {
                for (JSONObject tableRelation2 : tableRelations) {
                    List relations = tableRelation2.getJSONArray("relations").stream().map(JSONObject.class::cast).filter(relation -> datasetIds.contains(relation.getString("target_table"))).collect(Collectors.toList());
                    tableRelation2.put("relations", (Object)JSONArray.parseArray((String)JSONArray.toJSONString(relations)));
                }
            }
            List relationIds = tableRelations.stream().flatMap(tableRelation -> tableRelation.getJSONArray("relations").stream()).map(relation -> (JSONObject)relation).map(json -> json.getJSONArray("relation_ids")).flatMap(relation_ids -> relation_ids.stream()).map(Object::toString).distinct().collect(Collectors.toList());
            context.put("relationIds", relationIds);
            List relationships = Optional.ofNullable(Retrieve.MATCH_TABLE_RELATIONSHIPS.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
            List dataSetIdsMatchedTableRelation = relationships.stream().flatMap(relationship -> {
                JSONArray tables = relationship.getJSONArray("tables");
                return tables.stream().map(Object::toString);
            }).distinct().collect(Collectors.toList());
            List dataSetIdsMatchedTableRelationWithPermission = this.queryPermission4DataSet(context, dataSetIdsMatchedTableRelation);
            List relationIdsWithPermission = relationships.stream().filter(relationship -> dataSetIdsMatchedTableRelationWithPermission.containsAll((Collection<?>)relationship.getJSONArray("tables"))).map(relationship -> relationship.getString("id")).collect(Collectors.toList());
            List tableRelationsWithPermission = tableRelations.stream().map(tableRelation -> {
                List relations = tableRelation.getJSONArray("relations").stream().map(JSONObject.class::cast).filter(relation -> relationIdsWithPermission.containsAll((Collection<?>)relation.getJSONArray("relation_ids"))).collect(Collectors.toList());
                tableRelation.put("relations", (Object)JSONArray.parseArray((String)JSONArray.toJSONString(relations)));
                return tableRelation;
            }).filter(tableRelation -> CollectionUtils.isNotEmpty((Collection)tableRelation.getJSONArray("relations"))).collect(Collectors.toList());
            Boolean ifAllFindedRelations = true;
            JSONArray relationIdsByFindedDatasets = new JSONArray();
            if (datasetIds.size() > 1 && CollectionUtils.isNotEmpty(tableRelationsWithPermission)) {
                List result = IntStream.range(0, datasetIds.size()).boxed().flatMap(i -> IntStream.range(i + 1, datasetIds.size()).mapToObj(j -> new Tuple2(datasetIds.get((int)i), datasetIds.get(j)))).collect(Collectors.toList());
                for (Tuple2 tuple2 : result) {
                    for (JSONObject tableRelation3 : tableRelationsWithPermission) {
                        HashMap map = new HashMap();
                        tableRelation3.getJSONArray("relations").forEach(relation -> map.put(((JSONObject)relation).getString("target_table"), ((JSONObject)relation).getJSONArray("relation_ids")));
                        if (tableRelation3.getString("source_table").equals(tuple2.getV1()) && CollectionUtils.isNotEmpty((Collection)((Collection)map.get(tuple2.getV2())))) {
                            relationIdsByFindedDatasets.addAll((Collection)map.get(tuple2.getV2()));
                            continue;
                        }
                        if (tableRelation3.getString("source_table").equals(tuple2.getV2()) && CollectionUtils.isNotEmpty((Collection)((Collection)map.get(tuple2.getV1())))) {
                            relationIdsByFindedDatasets.addAll((Collection)map.get(tuple2.getV1()));
                            continue;
                        }
                        ifAllFindedRelations = false;
                    }
                }
                relationIds4Cot = relationIdsByFindedDatasets.stream().map(relationId -> relationId.toString()).distinct().collect(Collectors.toList());
            } else {
                ifAllFindedRelations = false;
                relationIds4Cot = relationIdsWithPermission;
            }
            JSONObject tempContext = JSONObject.parseObject((String)JSONObject.toJSONString((Object)context));
            tempContext.put("not_query_all", (Object)false);
            if (CollectionUtils.isEmpty((Collection)question.getDatasetIdList())) {
                tempContext.remove((Object)"datasetIds");
            }
            List allDatasets = Optional.ofNullable(datasetRetrieve.retrieve(tempContext)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
            if (ifAllFindedRelations.booleanValue()) {
                datasets4Cot = allDatasets.stream().filter(dataset -> dataSetIdsMatchedTableRelationWithPermission.contains(dataset.getString("datasetId"))).collect(Collectors.toList());
            } else if (allDatasets.size() <= maxDatasetCount) {
                List dataSetIdsWithPermission = this.queryPermission4DataSet(context, allDatasets.stream().map(dataset -> dataset.getString("datasetId")).collect(Collectors.toList()));
                context.put("datasetIds", (Object)dataSetIdsWithPermission);
                List straightRelationships = Optional.ofNullable(Retrieve.MATCH_STRAIGHT_TABLE_RELATIONSHIPS.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
                List straightRelationshipIds = straightRelationships.stream().map(relationship -> relationship.getString("id")).collect(Collectors.toList());
                relationIds4Cot.addAll(straightRelationshipIds);
                relationIds4Cot = relationIds4Cot.stream().distinct().collect(Collectors.toList());
                datasets4Cot = allDatasets.stream().filter(dataset -> dataSetIdsWithPermission.contains(dataset.getString("datasetId"))).collect(Collectors.toList());
            } else {
                List moduleNames = datasetsMatchedTable.stream().flatMap(dataset -> dataset.getJSONArray("modules").stream().map(module -> ((JSONObject)module).getString("name"))).collect(Collectors.toList());
                tempContext.put("moduleNames", (Object)moduleNames);
                List datasetsWithModules = Optional.ofNullable(datasetRetrieve.retrieve(tempContext)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
                List dataSetIdsWithModulesAndPermission = this.queryPermission4DataSet(context, datasetsWithModules.stream().map(dataset -> dataset.getString("datasetId")).collect(Collectors.toList()));
                context.put("datasetIds", (Object)dataSetIdsWithModulesAndPermission);
                List straightRelationships = Optional.ofNullable(Retrieve.MATCH_STRAIGHT_TABLE_RELATIONSHIPS.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
                List straightRelationshipIds = straightRelationships.stream().map(relationship -> relationship.getString("id")).collect(Collectors.toList());
                relationIds4Cot.addAll(straightRelationshipIds);
                relationIds4Cot = relationIds4Cot.stream().distinct().collect(Collectors.toList());
                dataSetIdsMatchedTableRelationWithPermission.addAll(dataSetIdsWithModulesAndPermission);
                List dataSetIds = dataSetIdsMatchedTableRelationWithPermission.stream().distinct().collect(Collectors.toList());
                datasets4Cot = allDatasets.stream().filter(dataset -> dataSetIds.contains(dataset.getString("datasetId"))).collect(Collectors.toList());
            }
            for (JSONObject dataset4Cot : datasets4Cot) {
                dataset4Cot.put("metricId", (Object)dataset4Cot.getString("datasetId"));
                dataset4Cot.put("metricName", (Object)dataset4Cot.getString("datasetName"));
            }
            context.put("final_dataSet", datasets4Cot);
            context.put("metricData", (Object)PromptExecutor.getMetricData((JSONObject)context));
            context.put("metricDataMd", (Object)PromptExecutor.getMetricDataMd((JSONObject)context));
            context.put("relationIds", relationIds4Cot);
            List tableRelationships = Optional.ofNullable(Retrieve.MATCH_TABLE_RELATIONSHIPS.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            context.put("relationships4Cot", (Object)tableRelationships);
            output = CALL_GPT_WITH_COT_REPEATABLE_PROMPT.doProcess(context);
            problemSolvingGptResult = output.getOutputContext().getJSONObject(problemSolvingGptName);
            context.put(problemSolvingGptName, (Object)problemSolvingGptResult);
            errorDetails = this.getErrorMsg(problemSolvingGptResult, datasets4Cot);
        }
        if (CollectionUtils.isNotEmpty((Collection)errorDetails)) {
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.nl2sql.cot.error");
        }
        List sqlExplain = ((JSONArray)problemSolvingGptResult.getObject("sqlExplain", JSONArray.class)).stream().map(cot -> ((JSONObject)cot).getString("explanation") + "\uff0c\u5173\u7cfb\uff1a" + ((JSONObject)cot).get((Object)"sourceFields")).collect(Collectors.toList());
        JSONObject tempCotResult = JSONObject.parseObject((String)JSONObject.toJSONString((Object)problemSolvingGptResult));
        tempCotResult.remove((Object)"dataSourceValidation");
        tempCotResult.remove((Object)"isDataSourceComplete");
        for (Object o : (JSONArray)tempCotResult.getObject("sqlExplain", JSONArray.class)) {
            ((JSONObject)o).remove((Object)"sourceFields");
        }
        String cotSql = JSONObject.toJSONString((Object)tempCotResult);
        return output.keep("languageType", (Object)problemSolvingGptResult.getString("languageType")).keep("sqlExplain", sqlExplain).keep("cot_sql", (Object)cotSql);
    }

    private List<JSONObject> getErrorMsg(JSONObject problemSolvingGptResult, List<JSONObject> datasetList) {
        return problemSolvingGptResult.getJSONArray("sqlExplain").stream().flatMap(cot -> ((JSONObject)cot).getJSONObject("sourceFields").entrySet().stream()).filter(entry -> !"dual".equalsIgnoreCase((String)entry.getKey())).flatMap(entry -> {
            ArrayList<JSONObject> errorDetails = new ArrayList<JSONObject>();
            String datasetId = (String)entry.getKey();
            Optional<JSONObject> datasetOpt = datasetList.stream().filter(dataset -> datasetId.equals(dataset.getString("datasetId"))).findFirst();
            if (!datasetOpt.isPresent()) {
                JSONObject errorDetail = new JSONObject();
                errorDetail.put("errorType", (Object)"\u8868\u4e0d\u5b58\u5728");
                errorDetail.put("errorTable", (Object)datasetId);
                errorDetails.add(errorDetail);
                return errorDetails.stream();
            }
            JSONObject dataset2 = datasetOpt.get();
            Set titleSet = dataset2.getJSONArray("fieldSchema").stream().map(JSONObject.class::cast).map(field -> field.getString("name")).collect(Collectors.toSet());
            List fields = ((JSONArray)entry.getValue()).toJavaList(String.class);
            List notExistFields = fields.stream().filter(field -> !titleSet.contains(field)).collect(Collectors.toList());
            if (!notExistFields.isEmpty()) {
                JSONObject errorDetail = new JSONObject();
                errorDetail.put("errorType", (Object)"\u5b57\u6bb5\u4e0d\u5b58\u5728");
                errorDetail.put("errorTable", (Object)datasetId);
                errorDetail.put("errorField", notExistFields);
                errorDetails.add(errorDetail);
            }
            return errorDetails.stream();
        }).collect(Collectors.toList());
    }

    private List<String> queryPermission4DataSet(JSONObject context, List<String> dataSetIds) {
        String userId = ((Question)context.getObject("question", Question.class)).getUserId();
        String token = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
        List datasetIds = dataSetIds.stream().map(t -> t.toString()).distinct().collect(Collectors.toList());
        KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
        try {
            JSONObject res = bean.queryPermissionSceneOrMetric(token, routerKey, userId, applicationCodes, datasetIds);
            if (res != null) {
                ArrayList<String> permissionList;
                List<String> list = permissionList = Objects.isNull(res.getObject("response", List.class)) ? new ArrayList<String>() : (List)res.getObject("response", List.class);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(permissionList)) {
                    return permissionList;
                }
                return new ArrayList<String>();
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u6570\u636e\u96c6\u6743\u9650\u83b7\u53d6\u5931\u8d25:{}", (Throwable)e);
        }
        return new ArrayList<String>();
    }
}

