/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.chart.DimensionInfoDto;
import com.digiwin.chatbi.beans.dtos.chart.ExtractDimensionReq;
import com.digiwin.chatbi.beans.dtos.chart.ExtractDimensionRes;
import com.digiwin.chatbi.beans.dtos.chart.FieldInfo;
import com.digiwin.chatbi.beans.dtos.chart.ModelInfo;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.DmpServiceInvoker;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchDimensionEntitiesExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchDimensionEntitiesExecutor.class);
    public static Integer MAX_COUNT = 5;

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        JSONObject tables;
        List dataSets;
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        if (ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            log.info("1.0\u627e\u8868\u65e0\u9700\u67e5\u8be2\u7ef4\u5ea6\u5b9e\u4f53\u6570\u636e");
            JSONObject tables2 = context.getJSONObject("matched_tables");
            return Output.through((String)"matched_tables_md", (Object)SearchDimensionEntitiesExecutor.generateMarkdownFromEsHits((JSONObject)tables2, null));
        }
        if (context.containsKey((Object)"final_search_dimension_entities")) {
            dataSets = (List)context.getOrDefault((Object)"final_dataSet", new ArrayList());
        } else {
            dataSets = (List)context.getOrDefault((Object)"dataSets_with_permission", new ArrayList());
            List allDatasetIds = (List)context.getOrDefault((Object)"matched_table_ids_es", new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)allDatasetIds)) {
                dataSets = dataSets.stream().filter(dataSet -> allDatasetIds.contains(dataSet.getString("datasetId"))).collect(Collectors.toList());
            }
        }
        Map modelFieldCodesMap = SearchDimensionEntitiesExecutor.getModelFieldCodesMap((List)dataSets);
        if (modelFieldCodesMap.size() <= 0) {
            log.info("\u65e0\u9700\u67e5\u8be2\u7ef4\u5ea6\u5b9e\u4f53\u6570\u636e");
            JSONObject tables3 = context.getJSONObject("matched_tables");
            return Output.through((String)"matched_tables_md", (Object)SearchDimensionEntitiesExecutor.generateMarkdownFromEsHits((JSONObject)tables3, null));
        }
        ExtractDimensionReq req = new ExtractDimensionReq();
        ArrayList<DimensionInfoDto> dimensionInfoDtos = new ArrayList<DimensionInfoDto>();
        for (Map.Entry modelFieldCodesEntry : modelFieldCodesMap.entrySet()) {
            DimensionInfoDto dimensionInfoDto1 = new DimensionInfoDto();
            dimensionInfoDto1.setModelCode((String)modelFieldCodesEntry.getKey());
            dimensionInfoDto1.setFields(new ArrayList((Collection)modelFieldCodesEntry.getValue()));
            dimensionInfoDtos.add(dimensionInfoDto1);
        }
        req.setLimit(MAX_COUNT);
        req.setInfoDtos(dimensionInfoDtos);
        ExtractDimensionRes extractDimensionRes = new ExtractDimensionRes();
        try {
            JSONObject param = JSONObject.parseObject((String)JSONObject.toJSONString((Object)req));
            Question question = (Question)context.getObject("question", Question.class);
            CompletableFuture jsonArrayFuture = ((DmpServiceInvoker)SpringContextUtil.getBean(DmpServiceInvoker.class)).queryDistinctDimensionData(param, question.getToken(), question.getSid(), question.getRouterKey(), question.getPtxId());
            JSONArray jsonArray = (JSONArray)jsonArrayFuture.get();
            ArrayList<ModelInfo> models = new ArrayList<ModelInfo>();
            for (Object o : jsonArray) {
                String modelCode = ((JSONObject)o).getString("modelCode");
                JSONArray dimensionDataVOs = ((JSONObject)o).getJSONArray("dimensionDataVOs");
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.setModelCode(modelCode);
                ArrayList<FieldInfo> fieldInfo = new ArrayList<FieldInfo>();
                for (Object dimensionDataVO : dimensionDataVOs) {
                    FieldInfo fieldInfo1 = new FieldInfo();
                    List contents = (List)((JSONObject)dimensionDataVO).getOrDefault((Object)"values", new ArrayList());
                    fieldInfo1.setContents(contents);
                    fieldInfo1.setFieldCode(((JSONObject)dimensionDataVO).getString("field"));
                    fieldInfo.add(fieldInfo1);
                }
                modelInfo.setFieldInfo(fieldInfo);
                models.add(modelInfo);
            }
            extractDimensionRes.setModels(models);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7ef4\u5ea6\u5b9e\u4f53\u8bcd\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)extractDimensionRes.getModels())) {
            log.info("\u67e5\u8be2\u7ef4\u5ea6\u5b9e\u4f53\u6570\u636e\u4e3a\u7a7a");
            tables = context.getJSONObject("matched_tables");
            if (Objects.nonNull(tables)) {
                return Output.through((String)"matched_tables_md", (Object)SearchDimensionEntitiesExecutor.generateMarkdownFromEsHits((JSONObject)tables, null));
            }
            return Output.through();
        }
        tables = context.getJSONObject("matched_tables");
        if (Objects.nonNull(tables)) {
            return Output.through((String)"extractDimensionRes", (Object)extractDimensionRes).keep("matched_tables_md", (Object)SearchDimensionEntitiesExecutor.generateMarkdownFromEsHits((JSONObject)tables, (ExtractDimensionRes)extractDimensionRes));
        }
        return Output.through((String)"extractDimensionRes", (Object)extractDimensionRes);
    }

    public static Map<String, Set<String>> getModelFieldCodesMap(List<JSONObject> dataSets) {
        Map<String, List<JSONObject>> modelDatasetGroup = dataSets.stream().collect(Collectors.groupingBy(dataset -> dataset.getString("modelCode")));
        HashMap<String, Set<String>> modelFieldCodes = new HashMap<String, Set<String>>();
        for (Map.Entry<String, List<JSONObject>> modelDataset : modelDatasetGroup.entrySet()) {
            String modeCode = modelDataset.getKey();
            HashSet<String> fieldCodes = new HashSet<String>();
            List<JSONObject> dataSetDtos = modelDataset.getValue();
            for (JSONObject dataSetDto : dataSetDtos) {
                for (Object o : dataSetDto.getJSONArray("fieldSchema")) {
                    if (!((JSONObject)o).getBooleanValue("needPullData")) continue;
                    fieldCodes.add(((JSONObject)o).getString("name"));
                }
            }
            if (!CollectionUtils.isNotEmpty(fieldCodes)) continue;
            modelFieldCodes.put(modeCode, fieldCodes);
        }
        return modelFieldCodes;
    }

    public static String generateMarkdownFromEsHits(JSONObject esResult, ExtractDimensionRes extractDimensionRes) {
        if (Objects.isNull(esResult)) {
            return null;
        }
        StringBuilder markdown = new StringBuilder();
        JSONArray hits = esResult.getJSONObject("hits").getJSONArray("hits");
        for (int i = 0; i < hits.size(); ++i) {
            JSONObject hit = hits.getJSONObject(i);
            JSONObject source = hit.getJSONObject("_source");
            String datasetId = source.getString("datasetId");
            String datasetName = source.getString("datasetName");
            String modeCode = source.getString("modelCode");
            JSONArray fieldSchema = source.getJSONArray("fieldSchema");
            markdown.append("### Dataset: ").append(datasetName).append(" (`datasetId`: ").append(datasetId).append(")\n\n");
            markdown.append("| \u5b57\u6bb5\u6807\u9898 (fieldTitle) | \u5b57\u6bb5\u540d (fieldName) |    \u793a\u4f8b    |\n");
            markdown.append("|-----------------------|--------------------|--------------------|\n");
            if (fieldSchema != null) {
                for (int j = 0; j < fieldSchema.size(); ++j) {
                    FieldInfo fieldInfo;
                    ModelInfo modelInfo;
                    JSONObject field = fieldSchema.getJSONObject(j);
                    String fieldTitle = field.getString("title");
                    String fieldName = field.getString("name");
                    String contents = "";
                    if (Objects.nonNull(extractDimensionRes) && Objects.nonNull(modelInfo = (ModelInfo)extractDimensionRes.getModels().stream().filter(e -> e.getModelCode().equals(modeCode)).findFirst().orElse(null)) && Objects.nonNull(fieldInfo = (FieldInfo)modelInfo.getFieldInfo().stream().filter(f -> f.getFieldCode().equals(fieldName)).findFirst().orElse(null))) {
                        contents = fieldInfo.getContents().toString();
                        contents = contents.substring(1, contents.length() - 1);
                    }
                    markdown.append("| ").append(fieldTitle).append(" | ").append(fieldName).append(" | ").append(contents).append(" |\n");
                }
            }
            markdown.append("\n");
        }
        return markdown.toString();
    }
}

