/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.pptGeneration;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.QuestionPlanningReq;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.KnowledgemapsService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAppAndVersion4PPTGenerationExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchAppAndVersion4PPTGenerationExecutor.class);

    public Output doProcess(JSONObject context) {
        String tenantId;
        String tenantVersion;
        List tenantAppCodes;
        QuestionPlanningReq req = (QuestionPlanningReq)context.getObject("questionPlanningReq", QuestionPlanningReq.class);
        String routerKey = req.getRouterKey();
        String userToken = req.getToken();
        String userId = req.getUserId();
        log.info("SearchAppAndVersionExecutor routerKey is exist: {}", (Object)routerKey);
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            return Output.through((String)"version", (Object)"2.0");
        }
        JSONObject input = new JSONObject();
        input.put("userToken", (Object)userToken);
        input.put("routerKey", (Object)routerKey);
        input.put("userId", (Object)userId);
        try {
            KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
            JSONObject res = bean.getUserAppAndVersion(userToken, routerKey, userId);
            JSONArray tenantAppInfos = res.getJSONObject("response").getJSONArray("appCodes");
            tenantAppCodes = tenantAppInfos.stream().map(Object::toString).collect(Collectors.toList());
            tenantVersion = res.getJSONObject("response").getString("tenantVersion");
            tenantId = res.getJSONObject("profile").getString("tenantId");
            userId = res.getJSONObject("profile").getString("userId");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25:{}", (Throwable)e);
            return Output.finish().keep("reply", (Object)"\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25");
        }
        return Output.through((String)"version", (Object)tenantVersion).keep("applicationCodes", StringUtils.isEmpty((CharSequence)req.getAppCode()) ? tenantAppCodes : Arrays.asList(req.getAppCode())).keep("tenantId", (Object)tenantId).keep("userId", (Object)userId);
    }
}

