/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.output;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.QuestionPlanningRes;
import com.digiwin.chatbi.beans.vos.ChatResultQuestionPlanningVo;
import com.digiwin.chatbi.common.enums.ChatResult4MetricCode;
import com.digiwin.chatbi.common.enums.MetricIntentType;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.EnumMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputQuestionPlanningExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(OutputQuestionPlanningExecutor.class);
    public static final String OUTPUT_KEY = "finalResult";
    private final EnumMap<MetricIntentType, Function<JSONObject, Output>> intentMap = new EnumMap(MetricIntentType.class);

    public OutputQuestionPlanningExecutor() {
        this.intentMap.put(MetricIntentType.GRAPH, context -> this.finishWithResultVo(context, arg_0 -> this.ofQuestionPlanning(arg_0), ChatResult4MetricCode.GRAPH));
        this.intentMap.put(MetricIntentType.APP, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultQuestionPlanningVo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResult4MetricCode)ChatResult4MetricCode.APP)));
        this.intentMap.put(MetricIntentType.REPLY, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultQuestionPlanningVo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResult4MetricCode)ChatResult4MetricCode.REPLY)));
        this.intentMap.put(MetricIntentType.METRIC, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultQuestionPlanningVo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResult4MetricCode)ChatResult4MetricCode.METRIC)));
    }

    public Output doProcess(JSONObject context) {
        Boolean success = (Boolean)context.getOrDefault((Object)"success", (Object)false);
        MetricIntentType intentType = MetricIntentType.REPLY;
        if (Boolean.TRUE.equals(success)) {
            intentType = MetricIntentType.GRAPH;
        }
        Function<JSONObject, Output> action = this.intentMap.getOrDefault(intentType, data -> this.finishWithResultVo(data, jsonObject -> new QuestionPlanningRes(), ChatResult4MetricCode.UNKNOWN));
        return action.apply(context);
    }

    private QuestionPlanningRes ofQuestionPlanning(JSONObject context) {
        return (QuestionPlanningRes)context.getObject("questionPlanningRes", QuestionPlanningRes.class);
    }

    private Output finishWithResultVo(JSONObject context, Function<JSONObject, QuestionPlanningRes> replyGetter, ChatResult4MetricCode resultCode) {
        return Output.finish((String)OUTPUT_KEY, (Object)ChatResultQuestionPlanningVo.createResult((JSONObject)context, replyGetter, (ChatResult4MetricCode)resultCode));
    }
}

