/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.prompt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.enums.IntentType;
import com.digiwin.chatbi.common.util.DateTimeUtil;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisPlanningPromptExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(AnalysisPlanningPromptExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
    }

    public Output doProcess(JSONObject context) {
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        JSONArray jsonArray = Optional.ofNullable(context.getJSONObject("Dimension")).map(e -> e.getJSONArray("group_by")).orElse(new JSONArray());
        JSONObject input = new JSONObject();
        input.put("Dimension", (Object)jsonArray);
        String analysisPlanningPromptName = context.keySet().stream().filter(key -> key.endsWith("AnalysisPlanning")).findFirst().orElse("AnalysisPlanning");
        String targetName = Optional.ofNullable((List)context.getObject("targets", List.class)).map(targets -> {
            for (Object t : targets) {
                JSONObject jsonObject = (JSONObject)t;
                if (!StringUtils.isNotEmpty((String)context.getString("datasourceId")) || !context.getString("datasourceId").equals(jsonObject.getString("datasourceId"))) continue;
                return jsonObject.getString("datasourceName");
            }
            return context.getString("datasourceId");
        }).orElse("");
        input.put("targetName", (Object)targetName);
        if (StringUtils.isNotEmpty((String)context.getString("tempLateReply"))) {
            List allDimensions = (List)context.getOrDefault((Object)"allDimensions", new ArrayList());
            JSONArray promptsDimensionJsonArray = Optional.ofNullable(context.getJSONObject("Dimension")).map(e -> e.getJSONArray("group_by")).orElse(new JSONArray());
            JSONArray promptsDimension = new JSONArray();
            List schemas = ((List)((JSONObject)context.getOrDefault((Object)"schemas", (Object)new JSONObject())).getOrDefault((Object)"Schemas", new ArrayList())).stream().map(inner_hit -> inner_hit.getString("name")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)promptsDimensionJsonArray)) {
                jsonArray.forEach(json -> allDimensions.forEach(dimension -> {
                    JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dimension));
                    if (jsonObject.getString("name").equals(json) && schemas.contains(json)) {
                        promptsDimension.add(json);
                    }
                }));
            }
            JSONArray dimensions = CollectionUtils.isEmpty((Collection)promptsDimension) ? new JSONArray() : new JSONArray(promptsDimension.stream().distinct().collect(Collectors.toList()));
            ArrayList dimensionNames = new ArrayList();
            List schemaList = (List)((JSONObject)context.getOrDefault((Object)"schemas", (Object)new JSONObject())).getOrDefault((Object)"Schemas", new ArrayList());
            for (JSONObject t : schemaList) {
                if (!CollectionUtils.isNotEmpty((Collection)dimensions)) continue;
                dimensions.forEach(d -> {
                    if (d.toString().equals(t.getString("name"))) {
                        dimensionNames.add(t.getString("title"));
                    }
                });
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(PipelineFactory.PipelineKey.INTENT_CODE.getKey(), (Object)IntentType.OTHER.getCode());
            jsonObject.put("reply", (Object)context.getString(analysisPlanningPromptName));
            jsonObject.put("intent", (Object)PipelineFactory.PipelineKey.QUESTION.getKey());
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject result = new JSONObject();
            result.put(PipelineFactory.PipelineKey.INTENT_CODE.getKey(), (Object)IntentType.OTHER.getCode());
            logCheckDto.buildParams("AnalysisPlanningPrompt", context.containsKey((Object)"scelect_scene_metric_mix") ? LogUtils.WARING : "U.SCRUMBI.901.0217", input.toJSONString(), "\u672a\u80fd\u8bc6\u522b\u5230\u3010target\u3011\u7684\u8be2\u95ee\u6a21\u677f\u6216\u8be5\u6a21\u677f\u4e0d\u5b58\u5728".replace("target", targetName), "1.\u6253\u5f00\u8bbe\u8ba1\u5668\u7684\u573a\u666f\u914d\u7f6e\u754c\u9762\uff0c\u627e\u5230\u76ee\u6807\u4e0b\u7684\u573a\u666f\u6a21\u677f\u3002\n2.\u82e5\u4e0d\u5b58\u5728\uff0c\u6dfb\u52a0\u65b0\u573a\u666f\u6a21\u677f\u5e76\u8bbe\u7f6e\u76f8\u5173\u6307\u6807\u3002\n3.\u4fdd\u5b58\u914d\u7f6e\uff0c\u8fdb\u884c\u53d1\u7248\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u4ecd\u6709\u95ee\u9898\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.through((String)PipelineFactory.PipelineKey.ANALYSIS_PLANNING_RESULT.getKey(), Arrays.asList(jsonObject)).keep("reply", (Object)context.getString("tempLateReply")).keep("logProblemDescription", (Object)((String)Constants.NO_TEMPLATE_LOG_VALUE.get(0)).replace("target", targetName)).keep("logTimestamp", (Object)DateTimeUtil.format((Date)new Date())).keep("logErrorContent", (Object)((String)Constants.NO_TEMPLATE_LOG_VALUE.get(1)).replace("target", targetName).replace("dimensions", ((Object)dimensionNames).toString())).keep("logTroubleGuide", Constants.NO_TEMPLATE_LOG_VALUE.get(2)).keep("no_template", (Object)"Y").keep("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}").keep("logCheckDtos", logCheckDtos);
        }
        if (analysisPlanningPromptName.startsWith("NOT_JSON_")) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(PipelineFactory.PipelineKey.INTENT_CODE.getKey(), (Object)IntentType.OTHER.getCode());
            jsonObject.put("reply", (Object)context.getString(analysisPlanningPromptName));
            jsonObject.put("intent", (Object)PipelineFactory.PipelineKey.QUESTION.getKey());
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject result = new JSONObject();
            result.put(PipelineFactory.PipelineKey.INTENT_CODE.getKey(), (Object)IntentType.OTHER.getCode());
            logCheckDto.buildParams("AnalysisPlanningPrompt", context.containsKey((Object)"scelect_scene_metric_mix") ? LogUtils.WARING : "U.SCRUMBI.901.0217", input.toJSONString(), "\u672a\u80fd\u8bc6\u522b\u5230\u3010target\u3011\u7684\u8be2\u95ee\u6a21\u677f\u6216\u8be5\u6a21\u677f\u4e0d\u5b58\u5728".replace("target", targetName), "1.\u6253\u5f00\u8bbe\u8ba1\u5668\u7684\u573a\u666f\u914d\u7f6e\u754c\u9762\uff0c\u627e\u5230\u76ee\u6807\u4e0b\u7684\u573a\u666f\u6a21\u677f\u3002\n2.\u82e5\u4e0d\u5b58\u5728\uff0c\u6dfb\u52a0\u65b0\u573a\u666f\u6a21\u677f\u5e76\u8bbe\u7f6e\u76f8\u5173\u6307\u6807\u3002\n3.\u4fdd\u5b58\u914d\u7f6e\uff0c\u8fdb\u884c\u53d1\u7248\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u4ecd\u6709\u95ee\u9898\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.through((String)PipelineFactory.PipelineKey.ANALYSIS_PLANNING_RESULT.getKey(), Arrays.asList(jsonObject)).keep("logProblemDescription", (Object)((String)Constants.NO_TEMPLATE_LOG_VALUE.get(0)).replace("target", targetName)).keep("logTimestamp", (Object)DateTimeUtil.format((Date)new Date())).keep("logErrorContent", (Object)((String)Constants.NO_TEMPLATE_LOG_VALUE.get(1)).replace("target", targetName).replace("dimensions", jsonArray.toString())).keep("logTroubleGuide", Constants.NO_TEMPLATE_LOG_VALUE.get(2)).keep("no_template", (Object)"Y").keep("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}").keep("logCheckDtos", logCheckDtos);
        }
        LogCheckDto logCheckDto = new LogCheckDto();
        JSONObject result = new JSONObject();
        Output keep = Output.through((String)PipelineFactory.PipelineKey.INTENT_CODE.getKey(), Objects.isNull(context.getJSONObject(analysisPlanningPromptName)) ? null : context.getJSONObject(analysisPlanningPromptName).getString("intent_code")).keep("reply", (Object)context.getJSONObject(analysisPlanningPromptName).getString("reply"));
        if (Objects.isNull(context.getJSONObject(analysisPlanningPromptName)) || "0".equals(context.getJSONObject(analysisPlanningPromptName).getString("intent_code"))) {
            logCheckDto.buildParams("AnalysisPlanningPrompt", context.containsKey((Object)"scelect_scene_metric_mix") ? LogUtils.WARING : "U.SCRUMBI.901.0217", input.toJSONString(), "\u672a\u80fd\u8bc6\u522b\u5230\u3010target\u3011\u7684\u8be2\u95ee\u6a21\u677f\u6216\u8be5\u6a21\u677f\u4e0d\u5b58\u5728".replace("target", targetName), "1.\u6253\u5f00\u8bbe\u8ba1\u5668\u7684\u573a\u666f\u914d\u7f6e\u754c\u9762\uff0c\u627e\u5230\u76ee\u6807\u4e0b\u7684\u573a\u666f\u6a21\u677f\u3002\n2.\u82e5\u4e0d\u5b58\u5728\uff0c\u6dfb\u52a0\u65b0\u573a\u666f\u6a21\u677f\u5e76\u8bbe\u7f6e\u76f8\u5173\u6307\u6807\u3002\n3.\u4fdd\u5b58\u914d\u7f6e\uff0c\u8fdb\u884c\u53d1\u7248\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u4ecd\u6709\u95ee\u9898\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            keep.keep("logProblemDescription", (Object)((String)Constants.NO_TEMPLATE_LOG_VALUE.get(0)).replace("target", targetName)).keep("logTimestamp", (Object)DateTimeUtil.format((Date)new Date())).keep("logErrorContent", (Object)((String)Constants.NO_TEMPLATE_LOG_VALUE.get(1)).replace("target", targetName).replace("dimensions", jsonArray.toString())).keep("logTroubleGuide", Constants.NO_TEMPLATE_LOG_VALUE.get(2)).keep("no_template", (Object)"Y").keep("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}").keep("reply", (Object)context.getString("tempLateReply"));
        } else {
            result.put(PipelineFactory.PipelineKey.INTENT_CODE.getKey(), Objects.isNull(context.getJSONObject(analysisPlanningPromptName)) ? null : context.getJSONObject(analysisPlanningPromptName).getString("intent_code"));
            logCheckDto.buildParams("AnalysisPlanningPrompt", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        }
        logCheckDtos.add(logCheckDto);
        return keep.keep("logCheckDtos", logCheckDtos);
    }
}

