/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.optimizer;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.optimizer.ast.StepNode;
import com.digiwin.chatbi.reasoning.optimizer.parser.SolutionStepParser;
import com.digiwin.chatbi.reasoning.optimizer.rule.OptimizationRule;
import com.digiwin.chatbi.reasoning.optimizer.rule.R1FilterGClauseRule;
import com.digiwin.chatbi.reasoning.optimizer.rule.R2RemoveORule;
import com.digiwin.chatbi.reasoning.optimizer.rule.R3RemoveLRule;
import com.digiwin.chatbi.reasoning.optimizer.rule.R4RemoveRedundantWFilterRule;
import com.digiwin.chatbi.reasoning.optimizer.rule.R5RemoveSortedFieldRule;
import com.digiwin.chatbi.reasoning.optimizer.rule.R6RemoveUnreferencedFieldsRule;
import com.digiwin.chatbi.reasoning.optimizer.rule.R7OptimizeJoinTypeRule;
import com.digiwin.chatbi.reasoning.optimizer.rule.R8MergeStepsRule;
import java.util.ArrayList;
import java.util.List;

public class SolutionStepOptimizer {
    private final SolutionStepParser parser = new SolutionStepParser();
    private final List<OptimizationRule> rules = new ArrayList();

    public SolutionStepOptimizer() {
        this.registerRules();
    }

    private void registerRules() {
        this.rules.add(new R1FilterGClauseRule());
        this.rules.add(new R2RemoveORule());
        this.rules.add(new R3RemoveLRule());
        this.rules.add(new R4RemoveRedundantWFilterRule());
        this.rules.add(new R5RemoveSortedFieldRule());
        this.rules.add(new R6RemoveUnreferencedFieldsRule());
        this.rules.add(new R7OptimizeJoinTypeRule());
        this.rules.add(new R8MergeStepsRule());
    }

    public JSONObject parseDsl(String dsl) throws Exception {
        List steps = this.parser.parse(dsl);
        return this.convertToDsl(steps);
    }

    public JSONObject optimize(String dsl) throws Exception {
        boolean changed;
        List steps = this.parser.parse(dsl);
        block0: do {
            changed = false;
            for (OptimizationRule rule : this.rules) {
                if (!rule.apply(steps)) continue;
                changed = true;
                continue block0;
            }
        } while (changed);
        return this.convertToDsl(steps);
    }

    private JSONObject convertToDsl(List<StepNode> steps) {
        JSONObject json = new JSONObject();
        json.put("step", steps);
        return json;
    }
}

