/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.TtlCallable;
import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.beans.dtos.chart.BusinessCreateReqDto;
import com.digiwin.chatbi.beans.dtos.chart.BusinessCreateResDto;
import com.digiwin.chatbi.beans.dtos.chart.DatasetExtInfoDto;
import com.digiwin.chatbi.beans.dtos.chart.ExtInfoCreateReqDto;
import com.digiwin.chatbi.beans.dtos.chart.ExtInfoResDto;
import com.digiwin.chatbi.beans.dtos.chart.ModuleDto;
import com.digiwin.chatbi.beans.dtos.chart.QuestionRecommendTReqDto;
import com.digiwin.chatbi.beans.pojos.AgileDataEchoParam;
import com.digiwin.chatbi.beans.pojos.AgileDataEchoSchema;
import com.digiwin.chatbi.beans.pojos.DataAnalysisReq;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.QuestionDemo;
import com.digiwin.chatbi.beans.pojos.QuestionLite;
import com.digiwin.chatbi.beans.vos.ResultBeanExtra;
import com.digiwin.chatbi.client.GPT_MODEL;
import com.digiwin.chatbi.client.GPT_PROVIDER;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.enums.ChatResult4MetricCode;
import com.digiwin.chatbi.common.enums.DebugMode;
import com.digiwin.chatbi.common.enums.MockGptQuestion;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.common.util.JSONUtils;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.config.ThreadPoolManager;
import com.digiwin.chatbi.reasoning.constant.Strategy;
import com.digiwin.chatbi.reasoning.context.SseContext;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import com.digiwin.chatbi.reasoning.pipeline.PipelineFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.process.LogRecordUtil;
import com.digiwin.chatbi.reasoning.prompt.TemplateLocalFileBroker;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.reasoning.search.config.GroundModelConfig;
import com.digiwin.chatbi.reasoning.search.config.ModelConfig;
import com.digiwin.chatbi.reasoning.sse.SseSendService;
import com.digiwin.chatbi.service.AdtService;
import com.digiwin.chatbi.service.AgileDataEchoService;
import com.digiwin.chatbi.service.DeepSeekService;
import com.digiwin.chatbi.service.TableIndexAugment;
import com.digiwin.chatbi.service.TranslateService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChatProcess {
    private static final Logger log = LoggerFactory.getLogger(ChatProcess.class);
    @Autowired
    private TranslateService translateService;
    @Autowired
    private AgileDataEchoService agileDataEchoService;
    @Autowired
    private SseSendService sseSendService;
    @Autowired
    private AdtService adtService;
    @Autowired
    private DeepSeekService deepSeekService;
    @Resource
    private Executor designPhaseExecutorScrumbi;
    public static Integer MAX_SUMMARY_DATA = 100;

    public JSONObject doProcess(Question question) {
        JSONArray jsonArray;
        JSONObject outPutResult = this.getOutPutResult(question);
        if (null != outPutResult && "dataflow".equals(outPutResult.getString("method")) && CollectionUtils.isNotEmpty((Collection)(jsonArray = outPutResult.getJSONArray("dataflow")))) {
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            this.reportEchoLog(question, jsonObject);
            outPutResult.getJSONArray("dataflow").getJSONObject(0).remove((Object)"dataEchoParam");
            outPutResult.getJSONArray("dataflow").getJSONObject(0).remove((Object)"dataEchoSchema");
        }
        return outPutResult;
    }

    public JSONObject doProcessV2(Question question) {
        JSONArray jsonArray;
        JSONObject outPutResult = this.getOutPutResultV2(question);
        if (null != outPutResult && "dataflow".equals(outPutResult.getString("method")) && CollectionUtils.isNotEmpty((Collection)(jsonArray = outPutResult.getJSONArray("dataflow")))) {
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            this.reportEchoLog(question, jsonObject);
            outPutResult.getJSONArray("dataflow").getJSONObject(0).remove((Object)"dataEchoParam");
            outPutResult.getJSONArray("dataflow").getJSONObject(0).remove((Object)"dataEchoSchema");
        }
        return outPutResult;
    }

    public JSONObject metricValidation(Question question) {
        JSONObject outPutResult = this.doMetricValidation(question);
        return outPutResult;
    }

    private void reportEchoLog(Question question, JSONObject outPutJson) {
        log.info("dataflow \u4e0a\u62a5agileDataEcho\u65e5\u5fd7");
        String routerKey = question.getRouterKey();
        String token = question.getToken();
        try {
            AgileDataEchoParam dataEchoParam = (AgileDataEchoParam)outPutJson.getObject("dataEchoParam", AgileDataEchoParam.class);
            AgileDataEchoSchema dataEchoSchema = (AgileDataEchoSchema)outPutJson.getObject("dataEchoSchema", AgileDataEchoSchema.class);
            if (dataEchoParam != null) {
                this.agileDataEchoService.agileDataEchoLog(dataEchoParam, token, routerKey);
            }
            if (dataEchoSchema != null) {
                this.agileDataEchoService.agileDataEchoSchema(dataEchoSchema, token, routerKey);
            }
        }
        catch (Exception e) {
            log.error("ChatResultVo \u4e0a\u62a5agileDataEcho\u65e5\u5fd7\u62a5\u9519\uff1a{} ", (Object)e.getMessage());
        }
    }

    private JSONObject getOutPutResult(Question question) {
        if (!question.isMultiDialogue()) {
            JSONObject jsonObject = this.processSingleDialogue(question);
            LogRecordUtil.recordLog((List)((List)jsonObject.get((Object)"outputTrace")));
            return jsonObject;
        }
        this.assemblyContext(question);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        LogRecordUtil.recordLog((List)outputTrace);
        JSONObject jsonObject = this.analyzeSemantics(question);
        if (jsonObject.isEmpty()) {
            log.error("\u89e3\u6790\u8bed\u4e49\u5f02\u5e38");
            jsonObject = new JSONObject();
        }
        timeTrace.addAll((List)jsonObject.getOrDefault((Object)"timeTrace", new ArrayList()));
        outputTrace.addAll((List)jsonObject.getOrDefault((Object)"outputTrace", new ArrayList()));
        jsonObject.put("timeTrace", (Object)timeTrace);
        jsonObject.put("outputTrace", (Object)outputTrace);
        return jsonObject;
    }

    private JSONObject getOutPutResultV2(Question question) {
        if (!question.isMultiDialogue()) {
            JSONObject jsonObject = this.processSingleDialogueV2(question);
            LogRecordUtil.recordLog((List)((List)jsonObject.get((Object)"outputTrace")));
            return jsonObject;
        }
        this.assemblyContext(question);
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        LogRecordUtil.recordLog((List)outputTrace);
        JSONObject jsonObject = this.processSingleDialogueV2(question);
        if (jsonObject.isEmpty()) {
            log.error("\u89e3\u6790\u8bed\u4e49\u5f02\u5e38");
            jsonObject = new JSONObject();
        }
        timeTrace.addAll((List)jsonObject.getOrDefault((Object)"timeTrace", new ArrayList()));
        outputTrace.addAll((List)jsonObject.getOrDefault((Object)"outputTrace", new ArrayList()));
        jsonObject.put("timeTrace", (Object)timeTrace);
        jsonObject.put("outputTrace", (Object)outputTrace);
        return jsonObject;
    }

    private JSONObject doMetricValidation(Question question) {
        question.setMultiDialogue(false);
        JSONObject jsonObject = this.processSingleDialogue4Validation(question);
        return jsonObject;
    }

    private JSONObject analyzeSemantics(Question question) {
        try {
            Future sceneFuture = ThreadPoolManager.getScenePool().submit(TtlCallable.get(() -> {
                try {
                    MdcUtil.setTraceId((String)question.getPtxId());
                    List jsonObjects = this.sceneProcess(question);
                    List timeTrace = Pipeline.getTimeTrace();
                    List outputTrace = Pipeline.getOutputTrace();
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("timeTrace", (Object)timeTrace);
                    jsonObject.put("outputTrace", (Object)outputTrace);
                    jsonObject.put("result", (Object)jsonObjects);
                    JSONObject jSONObject = jsonObject;
                    return jSONObject;
                }
                finally {
                    MdcUtil.clear();
                }
            }));
            Future metricFuture = ThreadPoolManager.getMetricPool().submit(TtlCallable.get(() -> {
                try {
                    MdcUtil.setTraceId((String)question.getPtxId());
                    JSONObject metricProcessResult = this.metricProcess(question);
                    List timeTrace = Pipeline.getTimeTrace();
                    List outputTrace = Pipeline.getOutputTrace();
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("timeTrace", (Object)timeTrace);
                    jsonObject.put("outputTrace", (Object)outputTrace);
                    jsonObject.put("result", (Object)metricProcessResult);
                    JSONObject jSONObject = jsonObject;
                    return jSONObject;
                }
                finally {
                    MdcUtil.clear();
                }
            }));
            JSONObject metricProcessResultWithExplain = (JSONObject)metricFuture.get();
            JSONObject metricProcessResult = (JSONObject)metricProcessResultWithExplain.getOrDefault((Object)"result", (Object)new JSONObject());
            Integer code = metricProcessResult.getInteger("code");
            Integer noMetricUseGptFlag = metricProcessResult.getInteger("noMetricUseGptFlag");
            if ("metric".equals(question.getMethod())) {
                LogRecordUtil.recordLog((List)((List)metricProcessResultWithExplain.getOrDefault((Object)"outputTrace", new ArrayList())));
                return this.buildMetricResult(metricProcessResultWithExplain);
            }
            if ("dataflow".equals(question.getMethod())) {
                JSONObject sceneProcessResultWithExplain = new JSONObject();
                try {
                    sceneProcessResultWithExplain = (JSONObject)sceneFuture.get();
                }
                catch (Exception e) {
                    log.error("\u573a\u666f\u7ebf\u7a0b\u6c60\u6267\u884c\u5931\u8d25:{}", (Throwable)e);
                }
                LogRecordUtil.recordLog((List)((List)sceneProcessResultWithExplain.getOrDefault((Object)"outputTrace", new ArrayList())));
                return this.buildSceneResult(sceneProcessResultWithExplain);
            }
            if (Objects.nonNull(code) && (ChatResult4MetricCode.GRAPH.getCode() == code.intValue() || ChatResult4MetricCode.APP.getCode() == code.intValue()) && Objects.isNull(noMetricUseGptFlag)) {
                LogRecordUtil.recordLog((List)((List)metricProcessResultWithExplain.getOrDefault((Object)"outputTrace", new ArrayList())));
                return this.buildMetricResult(metricProcessResultWithExplain);
            }
            JSONObject sceneProcessResultWithExplain = new JSONObject();
            try {
                sceneProcessResultWithExplain = (JSONObject)sceneFuture.get();
            }
            catch (Exception e) {
                log.error("\u573a\u666f\u7ebf\u7a0b\u6c60\u6267\u884c\u5931\u8d25:{}", (Throwable)e);
            }
            List sceneProcessResult = (List)sceneProcessResultWithExplain.getOrDefault((Object)"result", new ArrayList());
            Boolean sceneResult = false;
            Boolean sceneNoPermission = false;
            if (CollectionUtils.isEmpty((Collection)sceneProcessResult)) {
                log.warn("\u8001\u573a\u666f\u5f02\u5e38\uff1a{}", (Object)sceneProcessResultWithExplain);
            } else {
                sceneNoPermission = ((JSONObject)sceneProcessResult.get(0)).getBoolean("scenePermission");
                sceneResult = CollectionUtils.isNotEmpty((Collection)((JSONObject)sceneProcessResult.get(0)).getJSONArray("scenes"));
                Integer targetSize = ((JSONObject)sceneProcessResult.get(0)).getInteger("targetSize");
                if (Objects.nonNull(targetSize) && targetSize > 1) {
                    sceneResult = true;
                }
            }
            if (sceneResult.booleanValue() || sceneNoPermission.booleanValue()) {
                LogRecordUtil.recordLog((List)((List)sceneProcessResultWithExplain.getOrDefault((Object)"outputTrace", new ArrayList())));
                return this.buildSceneResult(sceneProcessResultWithExplain);
            }
            LogRecordUtil.recordLog((List)((List)metricProcessResultWithExplain.getOrDefault((Object)"outputTrace", new ArrayList())));
            return this.buildMetricResult(metricProcessResultWithExplain);
        }
        catch (Exception e) {
            log.error("\u7ebf\u7a0b\u6c60\u6267\u884c\u5f02\u5e38{}", (Throwable)e);
            return new JSONObject();
        }
    }

    private JSONObject metricProcess(Question question) {
        Output output = question.isIfStream() ? Strategy.METRIC_STREAM.getPipeline().accept("question", (Object)question) : Strategy.METRIC.getPipeline().accept("question", (Object)question);
        return output.getOutputContext().getJSONObject("finalResult");
    }

    private List<JSONObject> sceneProcess(Question question) {
        Output output = Strategy.BALANCE.getPipeline().accept("question", (Object)question);
        return Collections.singletonList(output.getOutputContext().getJSONObject("finalResult"));
    }

    private List<JSONObject> metricSceneMixProcess(Question question) {
        Output output = Strategy.BALANCE.getPipeline().accept("question", (Object)question);
        return Collections.singletonList(output.getOutputContext().getJSONObject("finalResult"));
    }

    private void assemblyContext(Question question) {
        JSONObject outputContext = Strategy.BALANCE.getMultiQuestionPipeline().accept("question", (Object)question).getOutputContext();
        String finallyQuestion = outputContext.getJSONObject("finalResult").getString("finallyQuestion");
        question.setOriginFinallyQuestion(StringUtils.isNotEmpty((CharSequence)finallyQuestion) ? finallyQuestion : question.getMessage());
        if ("zh_TW".equals(question.getLocale()) && StringUtils.isNotEmpty((CharSequence)finallyQuestion)) {
            finallyQuestion = this.translateService.zh2Hant(finallyQuestion);
        }
        question.setOriginMessage(question.getMessage());
        question.setMessage(StringUtils.isNotEmpty((CharSequence)finallyQuestion) ? finallyQuestion : question.getMessage());
    }

    private JSONObject processSingleDialogue(Question question) {
        String debugMode = question.getDebugMode();
        String sceneCode = question.getSceneCode();
        String targetId = question.getTargetId();
        List metricIds = question.getMetricIdList();
        if (StringUtils.isNotEmpty((CharSequence)debugMode) && (debugMode.equals(DebugMode.PARAM.getCode()) || debugMode.equals(DebugMode.PR_PARAM.getCode()) || debugMode.equals(DebugMode.DEBUG.getCode())) || StringUtils.isNotEmpty((CharSequence)sceneCode) || StringUtils.isNotEmpty((CharSequence)targetId) || "dataflow".equals(question.getMethod())) {
            Integer autoChoiceScene;
            Output output = question.getStrategy().getPipeline().accept("question", (Object)question);
            if (!Objects.isNull(output.getOutputContext().getJSONObject("finalResult")) && !Objects.isNull(autoChoiceScene = output.getOutputContext().getJSONObject("finalResult").getInteger("autoChoiceScene"))) {
                question.setDebugMode(DebugMode.DEBUG.getCode());
                Output autoChoiceSceneOutput = question.getStrategy().getPipeline().accept("question", (Object)question);
                List<JSONObject> jsonObjects = Collections.singletonList(autoChoiceSceneOutput.getOutputContext().getJSONObject("finalResult"));
                List timeTrace = Pipeline.getTimeTrace();
                List outputTrace = Pipeline.getOutputTrace();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("timeTrace", (Object)timeTrace);
                jsonObject.put("outputTrace", (Object)outputTrace);
                jsonObject.put("result", jsonObjects);
                return this.buildSceneResult(jsonObject);
            }
            List<JSONObject> jsonObjects = Collections.singletonList(output.getOutputContext().getJSONObject("finalResult"));
            List timeTrace = Pipeline.getTimeTrace();
            List outputTrace = Pipeline.getOutputTrace();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("timeTrace", (Object)timeTrace);
            jsonObject.put("outputTrace", (Object)outputTrace);
            jsonObject.put("result", jsonObjects);
            return this.buildSceneResult(jsonObject);
        }
        if (CollectionUtils.isNotEmpty((Collection)metricIds) || StringUtils.isNotEmpty((CharSequence)debugMode) && debugMode.equals(DebugMode.DEBUG_METRIC.getCode()) || "metric".equals(question.getMethod())) {
            JSONObject metricProcessResult = this.metricProcess(question);
            List timeTrace = Pipeline.getTimeTrace();
            List outputTrace = Pipeline.getOutputTrace();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("timeTrace", (Object)timeTrace);
            jsonObject.put("outputTrace", (Object)outputTrace);
            jsonObject.put("result", (Object)metricProcessResult);
            return this.buildMetricResult(jsonObject);
        }
        return this.analyzeSemantics(question);
    }

    private JSONObject processSingleDialogueV2(Question question) {
        Output output = ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(question.getProductVersion()) ? Strategy.DATASET.getPipeline().accept("question", (Object)question) : Strategy.METRIC_SCENE_MIX.getPipeline().accept("question", (Object)question);
        List<JSONObject> jsonObjects = Collections.singletonList(output.getOutputContext().getJSONObject("finalResult"));
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        LogRecordUtil.recordLog((List)outputTrace);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("timeTrace", (Object)timeTrace);
        jsonObject.put("outputTrace", (Object)outputTrace);
        jsonObject.put("result", jsonObjects);
        return this.buildMixResult(jsonObject);
    }

    private JSONObject processSingleDialogue4Validation(Question question) {
        Output output = Strategy.METRIC_SCENE_MIX_4_VALIDATION.getPipeline().accept("question", (Object)question);
        return output.getOutputContext();
    }

    private JSONObject buildSceneResult(JSONObject jsonObject) {
        JSONObject result = new JSONObject();
        result.put("method", (Object)"dataflow");
        result.put("dataflow", jsonObject.getOrDefault((Object)"result", new ArrayList()));
        result.put("timeTrace", jsonObject.get((Object)"timeTrace"));
        result.put("outputTrace", jsonObject.get((Object)"outputTrace"));
        return result;
    }

    private JSONObject buildMetricResult(JSONObject jsonObject) {
        JSONObject result = new JSONObject();
        result.put("method", (Object)"metric");
        result.put("metric", (Object)jsonObject.getJSONObject("result"));
        result.put("timeTrace", jsonObject.get((Object)"timeTrace"));
        result.put("outputTrace", jsonObject.get((Object)"outputTrace"));
        return result;
    }

    private JSONObject buildMixResult(JSONObject jsonObject) {
        JSONObject result = new JSONObject();
        List mixRes = (List)jsonObject.getOrDefault((Object)"result", new ArrayList());
        JSONObject resObject = (JSONObject)mixRes.get(0);
        result.put("method", (Object)resObject.getString("method"));
        if (result.getString("method").equalsIgnoreCase("metric") || result.getString("method").equalsIgnoreCase("dataset")) {
            result.put(result.getString("method"), mixRes.get(0));
        } else {
            result.put("dataflow", (Object)mixRes);
        }
        result.put("timeTrace", jsonObject.get((Object)"timeTrace"));
        result.put("outputTrace", jsonObject.get((Object)"outputTrace"));
        return result;
    }

    public JSONObject tesGpt(Question question) {
        Output output = PipelineFactory.TEST_GPT_PIPELINE.accept("question", (Object)question);
        return output.getOutputContext().getJSONObject("V2NL2SQL");
    }

    public ResultBean<String> generatingFunctionByGpt(String prompt) {
        Question question = new Question();
        question.setMessage(prompt);
        question.setGptProvider(GPT_PROVIDER.RH);
        question.setGptModel(GPT_MODEL.GPT3_5_TURBO);
        JSONObject context = new JSONObject();
        context.put("maxToken", (Object)4096);
        context.put("question", (Object)question);
        context.put("currentDate", (Object)this.formatDate(new Date()));
        context.put("user_requirement", (Object)prompt);
        Output output = ExecutorFactory.CALL_GPT_WITH_GENERATE_FUNCTION_PROMPT.doProcess(context);
        JSONObject res = output.getOutputContext().getJSONObject("DesignJs");
        String error = output.getOutputContext().getString("NOT_JSON_promptsDesignJs");
        if (Objects.isNull(res)) {
            return ResultBean.fail((String)error);
        }
        String reply = res.getString("reply");
        return ResultBean.ok((Object)reply);
    }

    private String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public List<JSONObject> doProcessDemo(QuestionDemo question) {
        Output output = question.getStrategy().getPipeline().accept("question", (Object)question);
        return Collections.singletonList(output.getOutputContext().getJSONObject("finalResult"));
    }

    public List<JSONObject> doProcessLite(QuestionLite question) {
        Output output = question.getStrategy().getPipeline().accept("question", (Object)question);
        return Collections.singletonList(output.getOutputContext().getJSONObject("finalResult"));
    }

    public List<JSONObject> doProcessLiteV2(QuestionLite question) {
        return this.doProcessLite(question);
    }

    public ResultBeanExtra<JSONObject> doProcess4StreamV2(Question question) {
        JSONObject chatResult = this.doProcessV2(question);
        List timeTrace = (List)chatResult.get((Object)"timeTrace");
        List outputTrace = (List)chatResult.get((Object)"outputTrace");
        chatResult.remove((Object)"timeTrace");
        chatResult.remove((Object)"outputTrace");
        ResultBeanExtra res = ResultBeanExtra.ok((Object)chatResult).withTimeTrace(question.isTimeTrace(), timeTrace).withExplain(question.isExplain(), outputTrace);
        this.sseSendService.sendResult(question, JSONObject.toJSONString((Object)res));
        if (Objects.nonNull(SseContext.getSseEmitter((String)question.getId()))) {
            SseContext.getSseEmitter((String)question.getId()).complete();
        }
        SseContext.cleanUpChat((String)question.getId());
        return res;
    }

    public ResultBean<JSONObject> dataAnalysisDemo(String snapshotId, String token, String routerKey, String locale, List<String> userPromptList) {
        JSONObject result = new JSONObject();
        JSONObject adtSnapshotInfo = this.adtService.querySnapshotInfo(token, routerKey, snapshotId);
        if (Objects.isNull(adtSnapshotInfo) || adtSnapshotInfo.isEmpty()) {
            return ResultBean.fail((String)"\u6839\u636e\u5feb\u7167ID\u67e5\u8be2\u5feb\u7167\u4fe1\u606f\u4e3a\u7a7a");
        }
        log.info("dataAnalysisDemo get adtSnapshotInfo :{}", (Object)adtSnapshotInfo);
        JSONObject snapshotData = new JSONObject();
        snapshotData.put("snapshotData", (Object)JSONUtils.buildFormattedString((Object)adtSnapshotInfo));
        snapshotData.put("currentDate", (Object)this.formatDate(new Date()));
        if (CollectionUtils.isNotEmpty(userPromptList)) {
            StringBuilder adminRule = new StringBuilder();
            for (int i = 0; i < userPromptList.size(); ++i) {
                adminRule.append(i + 1 + "\u3001").append(userPromptList.get(i) + "\n" + System.lineSeparator());
            }
            snapshotData.put("adminRule", (Object)adminRule);
        }
        try {
            JSONObject jsonObject = this.deepSeekService.callDeepSeek(this.userMessage(snapshotData, "DataExplain"));
            if (Objects.isNull(jsonObject) || jsonObject.isEmpty() || !jsonObject.containsKey((Object)"content")) {
                return ResultBean.fail((String)"\u8c03\u7528\u5927\u6a21\u578b\u7ed3\u679c\u4e3a\u7a7a");
            }
            result.put("reason", (Object)jsonObject.getString("think"));
            result.put("data", (Object)jsonObject.getString("content"));
        }
        catch (Exception e) {
            log.error("dataAnalysisDemo gptResult error:{}", (Throwable)e);
        }
        return ResultBean.ok((Object)result);
    }

    private String userMessage(JSONObject context, String name) {
        return ((TemplateLocalFileBroker)SpringContextUtil.getBean(TemplateLocalFileBroker.class)).get("prompts", name).getContent((Map)context);
    }

    public String resultAnalysis(DataAnalysisReq req, String locale) throws BussinessException {
        String analysisResult;
        JSONObject context = new JSONObject();
        context.put("currentDate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        context.put("QueryData", (Object)req.getResultData());
        context.put("userQuestion", (Object)req.getQuestion());
        context.put("questionRegion", (Object)("zh_TW".equals(locale) ? "\u81fa\u7063" : "\u5927\u9646"));
        context.put("locale_zh", (Object)("zh_TW".equalsIgnoreCase(locale) ? "\u7e41\u4f53\u4e2d\u6587" : "\u7b80\u4f53\u4e2d\u6587"));
        String user = "\u7528\u6237\u95ee\u53e5:" + req.getQuestion() + "\n\u7ed3\u679c\u96c6:" + JSONObject.toJSONString((Object)req.getResultData()) + "\n\u8bed\u8a00\u522b\uff1a" + ("zh_TW".equalsIgnoreCase(locale) ? "\u7e41\u4f53\u4e2d\u6587" : "\u7b80\u4f53\u4e2d\u6587");
        JSONArray data = JSONObject.parseObject((String)req.getResultData()).getJSONArray("data");
        context.put("dataSize", (Object)data.size());
        try {
            String res;
            if (MockGptQuestion.allQuestion().contains(req.getQuestion())) {
                try {
                    List mock = Optional.ofNullable(Retrieve.MOCK.retrieveSentence(new String[]{"mock"})).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source").getString("mock")).collect(Collectors.toList())).orElse(null);
                    if (CollectionUtils.isNotEmpty((Collection)mock) && mock.contains("1")) {
                        String responseBody = MockGptQuestion.getResultByQuestionAndType((String)req.getQuestion(), (String)"result_summary");
                        return responseBody;
                    }
                }
                catch (Exception e) {
                    log.error("mock\u5931\u8d25");
                }
            }
            analysisResult = res = ExecutorFactory.DATA_INSIGHT.callGpt(this.systemMessage(context, "data_insight"), user, null, Integer.valueOf(4000), "0.7", Pipeline.getUserToken());
        }
        catch (Exception e) {
            throw new BussinessException("\u7ed3\u679c\u603b\u7ed3\u5f02\u5e38");
        }
        return analysisResult;
    }

    public List<String> questionsRecommended(QuestionRecommendTReqDto req, String token, String locale) throws BussinessException {
        JSONObject context = new JSONObject();
        context.put("questionRecommendTReqDto", (Object)req);
        try {
            Output output = ExecutorFactory.CALL_GPT_WITH_AUTO_COMPLETE_PROMPT.doProcess(context);
            return (List)output.getOutputContext().getObject("recommendationQuestions", List.class);
        }
        catch (Exception e) {
            log.error("questionsRecommended\u5f02\u5e38\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public String systemMessage(JSONObject context, String name, String type) {
        ModelConfig modelConfig = (ModelConfig)SpringContextUtil.getBean(ModelConfig.class);
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        String enableCustomModel = modelConfig.getEnableCustomModel();
        if ("local".equals(groundModelConfig.getGroundDeployment()) && !"true".equals(enableCustomModel)) {
            type = "prompts_ground";
        }
        return ((TemplateLocalFileBroker)SpringContextUtil.getBean(TemplateLocalFileBroker.class)).get(type, name).getContent((Map)context);
    }

    public String systemMessage(JSONObject context, String name) {
        return this.systemMessage(context, name, "prompts");
    }

    public List<BusinessCreateResDto> createBusiness(List<BusinessCreateReqDto> req) throws BussinessException {
        JSONArray fieldSchema;
        JSONObject context = new JSONObject();
        try {
            String gptRes = ExecutorFactory.BUSINESSTYPE_IDENTIFICATION.callGpt(this.systemMessage(context, "businessTypeIdentification"), JSONObject.toJSONString(req), null, Integer.valueOf(4000), null, Pipeline.getUserToken());
            JSONObject jsonObject = JSONObject.parseObject((String)gptRes);
            fieldSchema = jsonObject.getJSONArray("fieldSchema");
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u7c7b\u578b\u751f\u6210\u5f02\u5e38");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)fieldSchema)) {
            return new ArrayList<BusinessCreateResDto>();
        }
        ArrayList<BusinessCreateResDto> res = new ArrayList<BusinessCreateResDto>();
        for (Object o : fieldSchema) {
            BusinessCreateResDto buildMetricResult = new BusinessCreateResDto();
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(o));
            buildMetricResult.setBusinessType(jsonObject.getString("businessType"));
            buildMetricResult.setName(jsonObject.getString("name"));
            res.add(buildMetricResult);
        }
        return res;
    }

    public DatasetExtInfoDto doCreateExtInfo(ExtInfoCreateReqDto req) {
        JSONObject jsonObject;
        JSONObject context = new JSONObject();
        Map systemModels = Constants.systemModels;
        try {
            if (CollectionUtils.isNotEmpty((Collection)req.getHistryExtInfo())) {
                HashSet metric_names = new HashSet(req.getHistryExtInfo().stream().filter(his -> CollectionUtils.isNotEmpty((Collection)his.getMetrics())).flatMap(his -> his.getMetrics().stream()).collect(Collectors.toList()));
                HashSet entity_names = new HashSet(req.getHistryExtInfo().stream().filter(his -> CollectionUtils.isNotEmpty((Collection)his.getEntities())).flatMap(his -> his.getEntities().stream()).collect(Collectors.toList()));
                for (DatasetExtInfoDto datasetExtInfoDto : req.getHistryExtInfo()) {
                    if (!CollectionUtils.isNotEmpty((Collection)datasetExtInfoDto.getModules())) continue;
                    List modules = datasetExtInfoDto.getModules();
                    for (ModuleDto module2 : modules) {
                        if (CollectionUtils.isNotEmpty((Collection)((Collection)systemModels.get(module2.getName())))) {
                            HashSet sub_systems_distinct = new HashSet();
                            List sub_systems_org = (List)systemModels.get(module2.getName());
                            List sub_systems_new = module2.getSubsystems();
                            sub_systems_distinct.addAll(sub_systems_org);
                            sub_systems_distinct.addAll(sub_systems_new);
                            systemModels.put(module2.getName(), new ArrayList(sub_systems_distinct));
                            continue;
                        }
                        systemModels.put(module2.getName(), module2.getSubsystems());
                    }
                }
                if (CollectionUtils.isNotEmpty(metric_names)) {
                    context.put("metric_names", (Object)TableIndexAugment.convertMetricNames(metric_names));
                }
                if (CollectionUtils.isNotEmpty(entity_names)) {
                    context.put("entity_names", (Object)TableIndexAugment.convertEntityNames(entity_names));
                }
                context.put("modules", (Object)TableIndexAugment.convertModules((Map)systemModels));
            }
            JSONObject param = new JSONObject();
            param.put("datasetId", (Object)req.getDatasetId());
            param.put("datasetName", (Object)req.getDatasetName());
            param.put("datasetDesc", (Object)req.getDatasetDesc());
            JSONArray jsonArray = new JSONArray();
            for (BusinessCreateReqDto fieldSchema : req.getFieldSchemas()) {
                JSONObject fieldSchemaParam = new JSONObject();
                fieldSchemaParam.put("name", (Object)fieldSchema.getName());
                fieldSchemaParam.put("title", (Object)fieldSchema.getTitle());
                fieldSchemaParam.put("description", (Object)fieldSchema.getDescription());
                jsonArray.add((Object)fieldSchemaParam);
            }
            param.put("fieldSchemas", (Object)jsonArray);
            String gptRes = ExecutorFactory.TABLE_INDEX_AUGMENT.callGpt(this.systemMessage(context, "TableIndexAugment"), JSONObject.toJSONString((Object)param), null, Integer.valueOf(4000), null, Pipeline.getUserToken());
            jsonObject = JSONObject.parseObject((String)gptRes);
        }
        catch (Exception e) {
            log.error("\u6269\u5c55\u4fe1\u606f\u751f\u6210\u5f02\u5e38");
            return null;
        }
        JSONArray metrics = jsonObject.getJSONArray("metrics");
        JSONArray entities = jsonObject.getJSONArray("entities");
        JSONArray modules = jsonObject.getJSONArray("modules");
        DatasetExtInfoDto res = new DatasetExtInfoDto();
        if (CollectionUtils.isNotEmpty((Collection)metrics)) {
            res.setMetrics(metrics.stream().map(metric -> ((JSONObject)metric).getString("name")).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            res.setEntities(entities.stream().map(entity -> ((JSONObject)entity).getString("name")).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)modules)) {
            res.setModules(modules.stream().map(module -> (ModuleDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)module), ModuleDto.class)).collect(Collectors.toList()));
        }
        return res;
    }

    public ExtInfoResDto createExtInfo(ExtInfoCreateReqDto req) {
        ExtInfoResDto extInfoResDto = new ExtInfoResDto();
        CompletableFuture<List> businessCreateFuture = CompletableFuture.supplyAsync(() -> {
            try {
                List collect = req.getFieldSchemas().stream().filter(businessCreateReqDto -> Objects.nonNull(businessCreateReqDto.getType())).filter(businessCreateReqDto -> 1 == businessCreateReqDto.getType()).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    return new ArrayList();
                }
                return this.createBusiness(collect);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u6267\u884c\u4efb\u52a1\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }, this.designPhaseExecutorScrumbi);
        CompletableFuture<DatasetExtInfoDto> extInfoCreateFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return this.doCreateExtInfo(req);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u6267\u884c\u4efb\u52a1\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }, this.designPhaseExecutorScrumbi);
        try {
            extInfoResDto.setExtInfoDto(extInfoCreateFuture.get());
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6269\u5c55\u4fe1\u606f\u5f02\u5e38");
        }
        try {
            extInfoResDto.setBusinessCreateResDtos(businessCreateFuture.get());
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6269\u5c55\u4fe1\u606f\u5f02\u5e38");
        }
        return extInfoResDto;
    }
}

