/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.prompt;

import com.digiwin.chatbi.common.util.TemplateBroker;
import com.digiwin.chatbi.config.PromptAssemblyConfig;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.loader.YamlPromptConfigLoader;
import com.digiwin.chatbi.reasoning.prompt.TemplateFormatter;
import com.digiwin.chatbi.reasoning.search.template.Dsl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="prompt", name={"loader"}, havingValue="assembled")
public class AssembledTemplateLocalFileBroker
implements TemplateBroker {
    private static final Logger log = LoggerFactory.getLogger(AssembledTemplateLocalFileBroker.class);
    private final PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    @Autowired
    private YamlPromptConfigLoader yamlConfigLoader;

    @PostConstruct
    public void loadPrompts() {
        this.loadYamlBasedPrompts();
    }

    private void loadYamlBasedPrompts() {
        try {
            List configs = this.yamlConfigLoader.loadAllConfigs();
            List yamlTemplates = configs.stream().map(arg_0 -> this.processYamlConfig(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            this.put(yamlTemplates);
        }
        catch (Exception e) {
            log.error("Failed to load YAML-based prompts", (Throwable)e);
        }
    }

    private TemplateFormatter processYamlConfig(PromptAssemblyConfig config) {
        try {
            String filePath = config.getFilePath();
            List sortedComponents = config.getComponents();
            StringBuilder assembledContent = new StringBuilder();
            Object lastType = null;
            String betweenTypes = "\n";
            for (int i = 0; i < sortedComponents.size(); ++i) {
                String componentContent;
                PromptAssemblyConfig.ComponentConfig component = (PromptAssemblyConfig.ComponentConfig)sortedComponents.get(i);
                if (i > 0) {
                    assembledContent.append(betweenTypes);
                }
                if (!(componentContent = this.loadComponentContent(filePath + component.getPath())).trim().isEmpty()) {
                    String trimmedContent = componentContent.trim();
                    assembledContent.append(trimmedContent);
                    continue;
                }
                log.error("\u7ec4\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u6216\u52a0\u8f7d\u5931\u8d25: {}", (Object)component.getPath());
            }
            String finalContent = assembledContent.toString();
            return Dsl.New((String)config.getName(), (String)config.getType(), (String)finalContent);
        }
        catch (Exception e) {
            log.error("\u5904\u7406YAML\u914d\u7f6e\u5931\u8d25: {}", (Object)config.getName(), (Object)e);
            return null;
        }
    }

    private String loadComponentContent(String componentPath) {
        try {
            String fullPath = "classpath:" + componentPath;
            Resource resource = this.resourceResolver.getResource(fullPath);
            if (!resource.exists()) {
                log.error("Component file not found: {}", (Object)componentPath);
                return "<!-- Component file not found: " + componentPath + " -->";
            }
            StringBuilder content = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
            }
            return content.toString();
        }
        catch (Exception e) {
            log.error("Failed to load component file: {}", (Object)componentPath, (Object)e);
            return "<!-- Error loading component file: " + componentPath + " - " + e.getMessage() + " -->";
        }
    }
}

