/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.chart.TableRelationsDto;
import com.digiwin.chatbi.beans.dtos.chart.TableRelationshipsDto;
import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.reasoning.search.dto.BulkDto;
import com.digiwin.chatbi.service.KnowledgemapsService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncDataService.class);
    @Autowired
    private KnowledgemapsService knowledgemapsService;

    public void addApplicationName() throws Exception {
        JSONObject aggregationsParam = new JSONObject();
        JSONObject aggregationsRes = Retrieve.SCENE_AGG.retrieve(aggregationsParam);
        if (Objects.isNull(aggregationsRes) || Objects.isNull(aggregationsRes.getJSONObject("aggregations")) || Objects.isNull(aggregationsRes.getJSONObject("aggregations").getJSONObject("applicationCode_agg")) || CollectionUtils.isEmpty((Collection)aggregationsRes.getJSONObject("aggregations").getJSONObject("applicationCode_agg").getJSONArray("buckets"))) {
            log.info("\u65b0\u589e\u5e94\u7528\u540d\u79f0\u65e0\u5e94\u7528");
            return;
        }
        List applicationCodes = aggregationsRes.getJSONObject("aggregations").getJSONObject("applicationCode_agg").getJSONArray("buckets").stream().map(bucket -> ((JSONObject)bucket).getString("key")).collect(Collectors.toList());
        List jsonObjects = this.knowledgemapsService.queryApplicationName(Pipeline.getUserToken(), applicationCodes);
        if (CollectionUtils.isEmpty((Collection)jsonObjects)) {
            log.error("km\u672a\u67e5\u8be2\u5e94\u7528\u540d\u79f0\u7ed3\u679c\u4e3a\u7a7a");
        }
        JSONObject application = new JSONObject();
        for (JSONObject jsonObject : jsonObjects) {
            application.put(jsonObject.getString("code"), (Object)jsonObject.getString("name"));
        }
        for (String applicationCode : applicationCodes) {
            String applicationName = application.getString(applicationCode);
            if (StringUtils.isEmpty((CharSequence)applicationName)) {
                log.error("km\u672a\u67e5\u8be2\u5230{}\u7684\u5e94\u7528\u540d\u79f0", (Object)applicationCode);
                continue;
            }
            JSONObject updateParam = new JSONObject();
            JSONObject script = new JSONObject();
            script.put("source", (Object)"ctx._source.applicationName = params.applicationName");
            JSONObject param = new JSONObject();
            param.put("applicationName", (Object)applicationName);
            script.put("params", (Object)param);
            updateParam.put("script", (Object)script);
            JSONObject query = new JSONObject();
            JSONObject term = new JSONObject();
            term.put("applicationCode", (Object)applicationCode);
            query.put("term", (Object)term);
            updateParam.put("query", (Object)query);
            Retrieve.SCENE.updateByQuery(updateParam);
        }
    }

    public void deleteAllRelations(String applicationCode, String version) {
        if (StringUtils.isEmpty((CharSequence)applicationCode) || StringUtils.isEmpty((CharSequence)version)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("applicationCode", applicationCode);
        map.put("version", version);
        Retrieve.MATCH_TABLE_RELATIONSHIPS.deleteByCondition(map, Boolean.valueOf(true));
        Retrieve.MATCH_TABLE_RELATIONS.deleteByCondition(map, Boolean.valueOf(true));
    }

    public void pushTableRelationships(List<TableRelationshipsDto> tableRelationshipsDtos) {
        String application_code = tableRelationshipsDtos.get(0).getApplicationCode();
        String version = tableRelationshipsDtos.get(0).getVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("applicationCode", application_code);
        map.put("version", version);
        Retrieve.MATCH_TABLE_RELATIONSHIPS.deleteByCondition(map, Boolean.valueOf(true));
        List bulkDtos = tableRelationshipsDtos.stream().map(tableRelationship -> {
            BulkDto bulkDto = new BulkDto();
            String id = UUID.randomUUID().toString().replace("-", "") + "_" + tableRelationship.getVersion();
            bulkDto.setId(id);
            bulkDto.setSource(JSONObject.parseObject((String)JSONObject.toJSONString((Object)tableRelationship)));
            return bulkDto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Retrieve.MATCH_TABLE_RELATIONSHIPS.bulkInsert(bulkDtos);
    }

    public void pushTableRelations(List<TableRelationsDto> tableRelationsDtos) {
        String application_code = tableRelationsDtos.get(0).getApplicationCode();
        String version = tableRelationsDtos.get(0).getVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("applicationCode", application_code);
        map.put("version", version);
        Retrieve.MATCH_TABLE_RELATIONS.deleteByCondition(map, Boolean.valueOf(true));
        List bulkDtos = tableRelationsDtos.stream().map(dto -> {
            BulkDto bulkDto = new BulkDto();
            String id = UUID.randomUUID().toString().replace("-", "") + "_" + dto.getVersion();
            bulkDto.setId(id);
            bulkDto.setSource(JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto)));
            return bulkDto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Retrieve.MATCH_TABLE_RELATIONS.bulkInsert(bulkDtos);
    }
}

