/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.beans.pojos.gpt.FieldModelAI;
import com.digiwin.chatbi.beans.pojos.gpt.ModelAI;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsQo;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsResult;
import com.digiwin.chatbi.common.annotations.LogRecord;
import com.digiwin.chatbi.common.enums.KnowledgeBaseRequest;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="VectorDataSourceService")
public class VectorDataSourceService {
    private static final Logger log = LoggerFactory.getLogger(VectorDataSourceService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${vector.prefix}")
    private String vectorPrefix;
    private static final Pattern SAFE_FILENAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_.-]+$");

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/json;charset=UTF-8"));
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        headers.add("Accept-Charset", "UTF-8");
        return headers;
    }

    @LogRecord(isGpt="1")
    public List<SearchDocsResult> searchDocs(SearchDocsQo searchDocsQo, String methodName) throws Exception {
        HttpHeaders headers = this.getHeaders();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", searchDocsQo.getQuery());
        params.put("knowledge_base_name", searchDocsQo.getKnowledge_base_name());
        params.put("top_k", searchDocsQo.getTop_k());
        params.put("score_threshold", searchDocsQo.getScore_threshold());
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        log.info("\u641c\u7d22\u77e5\u8bc6\u5e93\u5f00\u59cb...");
        long start = System.currentTimeMillis();
        ResponseEntity exchangeData = this.restTemplate.exchange(KnowledgeBaseRequest.SEARCH_DOCS.getUrl(), HttpMethod.POST, httpEntity, String.class, new Object[0]);
        long end = System.currentTimeMillis();
        log.info("\u641c\u7d22\u77e5\u8bc6\u5e93\u8017\u65f6\uff1a" + (end - start) + "ms");
        String resultRemote = (String)exchangeData.getBody();
        Gson gson = new Gson();
        List searchDocsResults = (List)gson.fromJson(resultRemote, new /* Unavailable Anonymous Inner Class!! */.getType());
        return searchDocsResults;
    }

    public String queryDataSourceVoList(List<ModelAI> modelAIList) {
        ArrayList<String> list = new ArrayList<String>();
        for (ModelAI modelAI : modelAIList) {
            Set collect = modelAI.getSchema().stream().map(FieldModelAI::getTitle).collect(Collectors.toSet());
            ArrayList<FieldModelAI> fieldModelAIList = new ArrayList<FieldModelAI>();
            for (String stringName : collect) {
                FieldModelAI fieldModelAI = new FieldModelAI();
                fieldModelAI.setTitle(stringName);
                fieldModelAIList.add(fieldModelAI);
            }
            modelAI.setSchema(fieldModelAIList);
        }
        StringBuilder result = new StringBuilder();
        for (int j = 0; j < modelAIList.size(); ++j) {
            ModelAI modelAI = modelAIList.get(j);
            if (!Objects.nonNull(modelAIList.get(j))) continue;
            StringBuilder outputString = new StringBuilder();
            outputString.append("{");
            outputString.append("name:").append(modelAI.getTableName()).append(",");
            outputString.append("datasourceId:").append(modelAI.getDatasourceId()).append(",");
            outputString.append("schema:[{");
            if (!CollectionUtils.isNotEmpty((Collection)modelAI.getSchema())) continue;
            for (int i = 0; i < modelAI.getSchema().size(); ++i) {
                outputString.append(((FieldModelAI)modelAI.getSchema().get(i)).getTitle());
                if (i == modelAI.getSchema().size() - 1) continue;
                outputString.append("~~");
            }
            outputString.append("}");
            outputString.append("]");
            outputString.append("}");
            list.add(outputString.toString());
            result.append(outputString.toString());
            if (j == modelAIList.size() - 1) continue;
            result.append("//");
        }
        return result.toString();
    }

    public ResultBean uploadDoc(String fileName, String tenantSid) {
        HttpHeaders headers = this.getHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        FileSystemResource fileSystemResource = new FileSystemResource(fileName);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"file", (Object)fileSystemResource);
        params.add((Object)"knowledge_base_name", (Object)String.valueOf(tenantSid));
        params.add((Object)"override", (Object)true);
        params.add((Object)"not_refresh_vs_cache", (Object)false);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)params, (MultiValueMap)headers);
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230\u77e5\u8bc6\u5e93\u5f00\u59cb...");
        long start = System.currentTimeMillis();
        String result = (String)this.restTemplate.postForObject(KnowledgeBaseRequest.UPLOAD_DOC.getUrl(), (Object)requestEntity, String.class, new Object[0]);
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230\u77e5\u8bc6\u5e93\u8fd4\u56de\uff1a" + result);
        long end = System.currentTimeMillis();
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230\u77e5\u8bc6\u5e93\u8017\u65f6\uff1a" + (end - start) + "ms");
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (Objects.nonNull(jsonObject) && "200".equals(jsonObject.getString("code"))) {
            String msg = jsonObject.getString("msg");
            return ResultBean.ok((Object)msg);
        }
        return ResultBean.fail((String)("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + result));
    }

    public ResultBean vectorSync(List<ModelAI> modelAIList) {
        ResultBean resultBean = this.create(modelAIList);
        return resultBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public ResultBean create(List<ModelAI> modelAIList) {
        String knowledgeBaseName = "_model_center_test";
        String tenantSidStr = this.vectorPrefix + knowledgeBaseName;
        List list = null;
        try {
            list = this.queryKnowledgeBases();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u77e5\u8bc6\u5e93\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty((Collection)list) && !list.contains(tenantSidStr) || CollectionUtils.isEmpty((Collection)list)) {
            try {
                String knowledgeBase = this.createKnowledgeBase(tenantSidStr);
                if (Objects.nonNull(knowledgeBase) && "200".equals(knowledgeBase)) {
                    log.info("\u521b\u5efa\u77e5\u8bc6\u5e93\u6210\u529f");
                }
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u77e5\u8bc6\u5e93\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        String dataSourceVoList = this.queryDataSourceVoList(modelAIList);
        String inputFileName = "file";
        String safeFileName = VectorDataSourceService.validateAndGetSafeFileName((String)inputFileName);
        if (safeFileName == null) {
            return null;
        }
        String currentDir = new File(FilenameUtils.getName((String)".")).getAbsolutePath();
        File file = new File(FilenameUtils.getName((String)currentDir), FilenameUtils.getName((String)safeFileName));
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = file + File.separator + tenantSidStr + ".tt";
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.getFile((String[])new String[]{fileName})), "UTF-8"));
            bufferedWriter.write(dataSourceVoList);
            log.info("\u6587\u4ef6\u751f\u6210\u6210\u529f\u3002");
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ResultBean resultBean = null;
        try {
            resultBean = this.uploadDoc(fileName, tenantSidStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Objects.nonNull(resultBean) && 200 == resultBean.getCode()) {
            log.info("\u5411\u91cf\u5e93\u6587\u4ef6\u751f\u6210\u6210\u529f");
            return ResultBean.ok((Object)"\u6210\u529f");
        }
        log.error("\u5411\u91cf\u5e93\u6587\u4ef6\u751f\u6210\u5931\u8d25");
        return ResultBean.fail((String)"\u5931\u8d25");
    }

    private static String validateAndGetSafeFileName(String input) {
        String name = FilenameUtils.getName((String)input);
        if (SAFE_FILENAME_PATTERN.matcher(name).matches()) {
            return name;
        }
        return null;
    }

    @LogRecord(isGpt="1")
    public List<String> queryKnowledgeBases() throws Exception {
        JSONArray data;
        HttpHeaders headers = this.getHeaders();
        HashMap params = new HashMap();
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        log.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u5217\u8868\u5f00\u59cb...");
        long start = System.currentTimeMillis();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        URIBuilder uriBuilder = new URIBuilder(KnowledgeBaseRequest.LIST_KNOWLEDGE_BASES.getUrl());
        HttpGet httpGet = new HttpGet(uriBuilder.build().toString());
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        String resultRemote = EntityUtils.toString((HttpEntity)response.getEntity());
        long end = System.currentTimeMillis();
        log.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u5217\u8868\u8017\u65f6\uff1a" + (end - start) + "ms");
        JSONObject jsonObject = JSONObject.parseObject((String)resultRemote);
        if (Objects.nonNull(jsonObject) && "200".equals(jsonObject.getString("code")) && Objects.nonNull(data = jsonObject.getJSONArray("data"))) {
            List list = JSONArray.parseArray((String)data.toJSONString(), String.class);
            return list;
        }
        return null;
    }

    public String createKnowledgeBase(String tenantSid) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(KnowledgeBaseRequest.CREATE_KNOWLEDGE_BASE.getUrl());
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("knowledge_base_name", String.valueOf(tenantSid));
        params.put("vector_store_type", "faiss");
        params.put("embed_model", "text-embedding-ada-002");
        StringEntity requestEntity = new StringEntity(JSONObject.toJSONString(params), ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)requestEntity);
        log.info("\u521b\u5efa\u77e5\u8bc6\u5e93\u5f00\u59cb...");
        long start = System.currentTimeMillis();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        long end = System.currentTimeMillis();
        log.info("\u521b\u5efa\u77e5\u8bc6\u5e93\u8017\u65f6\uff1a" + (end - start) + "ms");
        String resultRemote = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonObject = JSONObject.parseObject((String)resultRemote);
        if (Objects.nonNull(jsonObject) && "200".equals(jsonObject.getString("code"))) {
            return jsonObject.getString("code");
        }
        return null;
    }
}

