<任务目标>
基于以下几部分输入，撰写一份结构严谨、内容丰富的企业经营分析报告：
1. **title**: 报告名称
    - 这是报告最终的标题，需直接作为报告封面标题使用。
2. **report**: 报告正文所需的章节原始内容
    - report 由多个章节组成，每个章节包含以下部分：
        - **调研章节 (section)**：章节对应的主题名称或分类。
        - **调研目标 (researchGoal)**：对该章节分析的具体目标说明，通常涉及时间范围、数据维度、业务范围等。
        - **结论 (summary / conclusion)**：基于搜索引擎搜索结果的分析结果，可能包含趋势、对比、归因、预测、风险或异常点。
        - **图表 URL (charts)**：预先生成的 QuickChart 图表 URL，用于可视化展示该章节核心数据。
3. **refs**: 报告所需的全部引用来源
    - 来自外部网页的洞察或新闻，如 [2]: [xxxx](https://xxxx.com)
    - refs 中的序号对应 report 中的引用角标
    
<注意事项>
- 输入的各字段（如 *调研目标*、*结论*、*图表 URL*）仅作为写作参考素材，不得在最终报告中以原始字段名或逐条复述形式出现。
- 你需要对输入内容进行 **融合、提炼和改写**，重新组织成完整的自然语言分析，而不是照搬。
- 报告正文必须使用自然段落的叙述方式，例如：“2025 年上半年，公司净利润实现增长，主要得益于成本优化和收入稳步提升[¹]。”
- **禁止**在正文中出现“调研目标：”“结论：”“图表 URL：”等表述。
- 图表必须在合适的章节内自然嵌入（使用 <img> 标签），并且只能选择经过验证且有价值的图表。


<报告撰写规则>
1. **JSON 输入结构设计**：
   - **title**: 报告名称
   - **report**: 各章节内容（包括调研目标、结论、图表 URL）
   - **refs**: 所有网页链接引用，已附带序号

2. **内容分析与重组**：
   - 报告分为四个大部分：
     - **第一部分：报告名称与引言**
       - 报告名称严格使用title中指定的报告名称
       - 引言部分围绕报告名称并结合概述报告后续各章节的主要内容安排。
     - **第二部分：正文内容**
       - 按逻辑组织 **4–5 个章节**（不少于4个，不超过5个），避免机械对应输入字段
       - 每个章节要有洞察性，例如：“一、客户回款总体情况与趋势分析”、“二、低回款率客户画像与订单行为特征分析”，避免简单的输出，如“客户回款分析”
       - 结合互联网搜索内容的说明和分析，包括（数据分布占比，趋势判断，同环比，增长率，对比，归因，预测）等
       - 每个章节控制在200字左右
     - **第三部分：总体结论与建议**
       - **总字数控制在300-500字之间。**
       - 在该章节内分为三段文字，但三段之间不要设置额外的小标题，保持自然过渡:
          - 首先开门见山，用一两句话概括整体表现，然后立即点出最关键的核心问题或矛盾点。
          - 然后直接陈述导致核心问题的2-3个根本原因，并给出一定的说明分析。
          - 最后总结战略方向，然后列出3条左右最优先、最具操作性的商业建议，并尽可能量化其预期影响。
     - **第四部分：数据来源与参考**
       - 网页来源（互联网引用链接）
   - 报告正文中只需要体现章节，不需要显示“三大部分”的划分。
   - 确认除了<引言>章节以外的每个二级标题，都使用大写数字做为序号，如"## X、总体结论与建议",X需要根据位置设置合理的数字，确认不要遗漏任何二级标题。
   
3. **图表与图片引用**：
   - 数据对比或趋势可视化时，在需要时，请合理选择 report 中已有的 QuickChart 图表 URL。
   - 在将图表纳入最终报告前，必须逐一验证每个生成的图表：
    - 图表必须直接服务于当前章节的研究内容，与分析主题紧密相关；
    - 图表中展示的指标必须来自输入数据，且能为结论提供直观支持；
    - 若图表仅重复已有结论、缺乏增量信息，或与主题关联度低，应直接舍弃。
    - 对于不符合要求或无关紧要的图表，应直接舍弃，不得出现在最终报告中。
   - 报告正文中插入图表时，仍使用 HTML `<img>` 标签，以便在 Markdown 中正常展示，例如：
     ```html
     <img src="https://quickchart.io/chart?...params..." alt="图表标题" />

4. **搜索网页引用与来源处理**：
   - **图片来源不需要注明引用**
   - **报告正文中的引用的格式与输入中的`report`中的只有单中括号的引用格式有所区别，正文使用可点击链接角标，使用双中括号并带超链接，格式：[[²]](https://xxx.com)
   - **报告末尾列出与正文引用标签对应的引用链接**，链接的序号要与正文中的引用序号正确匹配，未引用的链接将不再列出
    - 例如：
      ```
      1. [网页A](https://xxx.com)
      2. [网页B](https://xxx.com)
      ```

5. **内容增强**：
   - 提高语言清晰度与可读性，突出重点
   - 强化数据洞察和商业价值解读
   - 结论部分需提供可执行的建议，避免仅仅复述原始数据

6. **格式标准化**：
   - 章节清晰，层级分明
   - 保持全文 Markdown 格式一致

7. **质量标准**：
   - 专业语气，适合企业管理层阅读
   - 保证逻辑性、流畅性和完整性
   - 不得生成空图表或空分析

8. **输出语种**