/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.beans.pojos;

import com.digiwin.chatbi.client.GPT_MODEL;
import com.digiwin.chatbi.client.GPT_PROVIDER;
import com.digiwin.chatbi.common.enums.DebugMode;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.constant.Strategy;
import com.digiwin.chatbi.service.ApolloService;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(value="\u95ee\u7b54\u5bf9\u8c61")
public class Question {
    @ApiModelProperty(example="\u60a8\u7684\u95ee\u53e5")
    private String message;
    @ApiModelProperty(value="\u60a8\u7684\u539f\u59cb\u95ee\u53e5", hidden=true)
    private String originMessage;
    @ApiModelProperty(value="\u7ec4\u88c5\u540e\u7684\u539f\u59cb\u95ee\u53e5", hidden=true)
    private String originFinallyQuestion;
    @ApiModelProperty(example="RH")
    private GPT_PROVIDER gptProvider;
    private boolean timeTrace = false;
    private boolean explain = false;
    @ApiModelProperty(example="BALANCE", hidden=true)
    private Strategy strategy = Strategy.BALANCE;
    @ApiModelProperty(example="GPT3_5_TURBO", hidden=true)
    private Integer sceneTopK = 3;
    @ApiModelProperty(example="GPT3_5_TURBO")
    private GPT_MODEL gptModel;
    @ApiModelProperty(hidden=true)
    private String simpleMessage;
    @ApiModelProperty(hidden=true)
    private String locale;
    @ApiModelProperty(hidden=true)
    private String token;
    @ApiModelProperty(hidden=true)
    private String sid;
    @ApiModelProperty(hidden=true)
    private String routerKey;
    @ApiModelProperty(hidden=true)
    private String userId;
    @ApiModelProperty(hidden=true)
    private String userName;
    @ApiModelProperty(example="true")
    private boolean multiDialogue = true;
    @ApiModelProperty(example="S202405160001", hidden=true)
    private String sceneCode;
    @ApiModelProperty(example="1:param (sceneCode\u5fc5\u4f20);2:pr-param\uff1b3:debug(sceneCode\u5fc5\u4f20)\uff1b4:test(sceneCode\u5fc5\u4f20)", hidden=true)
    private String debugMode;
    @ApiModelProperty(hidden=true)
    private String messageId;
    @ApiModelProperty(hidden=true)
    private String ptxId;
    @ApiModelProperty(hidden=true)
    private String sessionId;
    @ApiModelProperty(example="reneve", hidden=true)
    private String targetId;
    @ApiModelProperty(example="\u8425\u6536\u91d1\u989d", hidden=true)
    private String targetName;
    @ApiModelProperty(example="\u5e94\u7528\u7f16\u7801", hidden=true)
    private String appCode;
    @ApiModelProperty(example="\u7248\u672c\u53f7", hidden=true)
    private String version;
    @ApiModelProperty(example="\u6307\u6807id\u5217\u8868\uff0c\u53ef\u4ee5\u662f\u591a\u4e2a\u6307\u6807\uff0c\u7528\u4e8e\u8ba2\u9605\u548c\u6307\u6807\u5bfc\u6b63", hidden=true)
    private List<String> metricIdList;
    @ApiModelProperty(example="\u6570\u636e\u96c6id\u5217\u8868\uff0c\u53ef\u4ee5\u662f\u591a\u4e2a\uff0c\u7528\u4e8e\u8ba2\u9605\u548c\u6307\u6807\u5bfc\u6b63", hidden=true)
    private List<String> datasetIdList;
    @ApiModelProperty(example="\u5f53\u524d\u6570\u636e\u6d41\u7684\u6a21\u5f0f\uff0cmetric\u6307\u6807\uff0cdataflow\u573a\u666f\u6570\u636e\u6d41", hidden=true)
    private String method;
    @ApiModelProperty(example="\u52a9\u7406\u4ee3\u53f7", hidden=true)
    private String asaCode;
    @ApiModelProperty(example="\u4e0a\u4e0b\u2f42\u7ec4\u5408\u6d88\u606f", hidden=true)
    private String combinationMsg;
    @ApiModelProperty(example="\u6d88\u606fid", hidden=true)
    private String id;
    @ApiModelProperty(example="\u662f\u5426\u662f\u6d41\u5f0f\u8f93\u51fa", hidden=true)
    private boolean ifStream = false;
    @ApiModelProperty(example="\u5f3a\u5236\u5173\u95ed\u6d41\u5f0f\u8f93\u51fa")
    private boolean closeStream = false;
    @ApiModelProperty(example="V1:\u6807\u51c6\u7248;V2:\u65d7\u8230\u7248")
    private String productVersion = "V1";
    @ApiModelProperty(example="V1: 1.0 \u5e94\u7528; V2: 2.0 \u5e94\u7528")
    private String appVersion = "V1";
    @ApiModelProperty(example="\u6bb5\u843did")
    private String sectionId;
    @ApiModelProperty(example="\u5a1c\u5a1c\u4f1a\u8bddid")
    private String messageId4Ania;
    @ApiModelProperty(example="\u4f1a\u8bdd\u7f16\u53f7")
    private String conversationId;

    public Strategy getStrategy() {
        return Objects.isNull(this.strategy) ? Strategy.BALANCE : this.strategy;
    }

    public GPT_MODEL getGptModel() {
        return Objects.isNull(this.gptModel) ? this.strategy.getGptModel() : this.gptModel;
    }

    public void setMessage(String message) {
        ApolloService bean = (ApolloService)SpringContextUtil.getBean(ApolloService.class);
        String value = bean.getQuestionQuotationMarksSwitch();
        this.message = "1".equals(value) ? message : message.replace("\"", "\\\"");
        this.simpleMessage = ZhConverterUtil.toSimple((String)this.message);
    }

    public String getMessage() {
        return Objects.isNull(this.strategy) ? this.message : this.strategy.boostMessage(this.message);
    }

    public String getDebugMode() {
        if ((DebugMode.PARAM.getCode().equals(this.debugMode) || DebugMode.DEBUG.getCode().equals(this.debugMode) || DebugMode.TEST.getCode().equals(this.debugMode)) && Objects.isNull(this.sceneCode)) {
            return null;
        }
        return this.debugMode;
    }

    public String getOriginMessage() {
        return this.originMessage;
    }

    public String getOriginFinallyQuestion() {
        return this.originFinallyQuestion;
    }

    public GPT_PROVIDER getGptProvider() {
        return this.gptProvider;
    }

    public boolean isTimeTrace() {
        return this.timeTrace;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public Integer getSceneTopK() {
        return this.sceneTopK;
    }

    public String getSimpleMessage() {
        return this.simpleMessage;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getToken() {
        return this.token;
    }

    public String getSid() {
        return this.sid;
    }

    public String getRouterKey() {
        return this.routerKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isMultiDialogue() {
        return this.multiDialogue;
    }

    public String getSceneCode() {
        return this.sceneCode;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getPtxId() {
        return this.ptxId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getMetricIdList() {
        return this.metricIdList;
    }

    public List<String> getDatasetIdList() {
        return this.datasetIdList;
    }

    public String getMethod() {
        return this.method;
    }

    public String getAsaCode() {
        return this.asaCode;
    }

    public String getCombinationMsg() {
        return this.combinationMsg;
    }

    public String getId() {
        return this.id;
    }

    public boolean isIfStream() {
        return this.ifStream;
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public String getMessageId4Ania() {
        return this.messageId4Ania;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setOriginMessage(String originMessage) {
        this.originMessage = originMessage;
    }

    public void setOriginFinallyQuestion(String originFinallyQuestion) {
        this.originFinallyQuestion = originFinallyQuestion;
    }

    public void setGptProvider(GPT_PROVIDER gptProvider) {
        this.gptProvider = gptProvider;
    }

    public void setTimeTrace(boolean timeTrace) {
        this.timeTrace = timeTrace;
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public void setSceneTopK(Integer sceneTopK) {
        this.sceneTopK = sceneTopK;
    }

    public void setGptModel(GPT_MODEL gptModel) {
        this.gptModel = gptModel;
    }

    public void setSimpleMessage(String simpleMessage) {
        this.simpleMessage = simpleMessage;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setRouterKey(String routerKey) {
        this.routerKey = routerKey;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setMultiDialogue(boolean multiDialogue) {
        this.multiDialogue = multiDialogue;
    }

    public void setSceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
    }

    public void setDebugMode(String debugMode) {
        this.debugMode = debugMode;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setPtxId(String ptxId) {
        this.ptxId = ptxId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMetricIdList(List<String> metricIdList) {
        this.metricIdList = metricIdList;
    }

    public void setDatasetIdList(List<String> datasetIdList) {
        this.datasetIdList = datasetIdList;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setAsaCode(String asaCode) {
        this.asaCode = asaCode;
    }

    public void setCombinationMsg(String combinationMsg) {
        this.combinationMsg = combinationMsg;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIfStream(boolean ifStream) {
        this.ifStream = ifStream;
    }

    public void setCloseStream(boolean closeStream) {
        this.closeStream = closeStream;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public void setMessageId4Ania(String messageId4Ania) {
        this.messageId4Ania = messageId4Ania;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Question)) {
            return false;
        }
        Question other = (Question)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isTimeTrace() != other.isTimeTrace()) {
            return false;
        }
        if (this.isExplain() != other.isExplain()) {
            return false;
        }
        if (this.isMultiDialogue() != other.isMultiDialogue()) {
            return false;
        }
        if (this.isIfStream() != other.isIfStream()) {
            return false;
        }
        if (this.isCloseStream() != other.isCloseStream()) {
            return false;
        }
        Integer this$sceneTopK = this.getSceneTopK();
        Integer other$sceneTopK = other.getSceneTopK();
        if (this$sceneTopK == null ? other$sceneTopK != null : !((Object)this$sceneTopK).equals(other$sceneTopK)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$originMessage = this.getOriginMessage();
        String other$originMessage = other.getOriginMessage();
        if (this$originMessage == null ? other$originMessage != null : !this$originMessage.equals(other$originMessage)) {
            return false;
        }
        String this$originFinallyQuestion = this.getOriginFinallyQuestion();
        String other$originFinallyQuestion = other.getOriginFinallyQuestion();
        if (this$originFinallyQuestion == null ? other$originFinallyQuestion != null : !this$originFinallyQuestion.equals(other$originFinallyQuestion)) {
            return false;
        }
        GPT_PROVIDER this$gptProvider = this.getGptProvider();
        GPT_PROVIDER other$gptProvider = other.getGptProvider();
        if (this$gptProvider == null ? other$gptProvider != null : !this$gptProvider.equals(other$gptProvider)) {
            return false;
        }
        Strategy this$strategy = this.getStrategy();
        Strategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy)) {
            return false;
        }
        GPT_MODEL this$gptModel = this.getGptModel();
        GPT_MODEL other$gptModel = other.getGptModel();
        if (this$gptModel == null ? other$gptModel != null : !this$gptModel.equals(other$gptModel)) {
            return false;
        }
        String this$simpleMessage = this.getSimpleMessage();
        String other$simpleMessage = other.getSimpleMessage();
        if (this$simpleMessage == null ? other$simpleMessage != null : !this$simpleMessage.equals(other$simpleMessage)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$sid = this.getSid();
        String other$sid = other.getSid();
        if (this$sid == null ? other$sid != null : !this$sid.equals(other$sid)) {
            return false;
        }
        String this$routerKey = this.getRouterKey();
        String other$routerKey = other.getRouterKey();
        if (this$routerKey == null ? other$routerKey != null : !this$routerKey.equals(other$routerKey)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$sceneCode = this.getSceneCode();
        String other$sceneCode = other.getSceneCode();
        if (this$sceneCode == null ? other$sceneCode != null : !this$sceneCode.equals(other$sceneCode)) {
            return false;
        }
        String this$debugMode = this.getDebugMode();
        String other$debugMode = other.getDebugMode();
        if (this$debugMode == null ? other$debugMode != null : !this$debugMode.equals(other$debugMode)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$ptxId = this.getPtxId();
        String other$ptxId = other.getPtxId();
        if (this$ptxId == null ? other$ptxId != null : !this$ptxId.equals(other$ptxId)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$targetId = this.getTargetId();
        String other$targetId = other.getTargetId();
        if (this$targetId == null ? other$targetId != null : !this$targetId.equals(other$targetId)) {
            return false;
        }
        String this$targetName = this.getTargetName();
        String other$targetName = other.getTargetName();
        if (this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List this$metricIdList = this.getMetricIdList();
        List other$metricIdList = other.getMetricIdList();
        if (this$metricIdList == null ? other$metricIdList != null : !((Object)this$metricIdList).equals(other$metricIdList)) {
            return false;
        }
        List this$datasetIdList = this.getDatasetIdList();
        List other$datasetIdList = other.getDatasetIdList();
        if (this$datasetIdList == null ? other$datasetIdList != null : !((Object)this$datasetIdList).equals(other$datasetIdList)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$asaCode = this.getAsaCode();
        String other$asaCode = other.getAsaCode();
        if (this$asaCode == null ? other$asaCode != null : !this$asaCode.equals(other$asaCode)) {
            return false;
        }
        String this$combinationMsg = this.getCombinationMsg();
        String other$combinationMsg = other.getCombinationMsg();
        if (this$combinationMsg == null ? other$combinationMsg != null : !this$combinationMsg.equals(other$combinationMsg)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$productVersion = this.getProductVersion();
        String other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !this$productVersion.equals(other$productVersion)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$sectionId = this.getSectionId();
        String other$sectionId = other.getSectionId();
        if (this$sectionId == null ? other$sectionId != null : !this$sectionId.equals(other$sectionId)) {
            return false;
        }
        String this$messageId4Ania = this.getMessageId4Ania();
        String other$messageId4Ania = other.getMessageId4Ania();
        if (this$messageId4Ania == null ? other$messageId4Ania != null : !this$messageId4Ania.equals(other$messageId4Ania)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        return !(this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Question;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTimeTrace() ? 79 : 97);
        result = result * 59 + (this.isExplain() ? 79 : 97);
        result = result * 59 + (this.isMultiDialogue() ? 79 : 97);
        result = result * 59 + (this.isIfStream() ? 79 : 97);
        result = result * 59 + (this.isCloseStream() ? 79 : 97);
        Integer $sceneTopK = this.getSceneTopK();
        result = result * 59 + ($sceneTopK == null ? 43 : ((Object)$sceneTopK).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $originMessage = this.getOriginMessage();
        result = result * 59 + ($originMessage == null ? 43 : $originMessage.hashCode());
        String $originFinallyQuestion = this.getOriginFinallyQuestion();
        result = result * 59 + ($originFinallyQuestion == null ? 43 : $originFinallyQuestion.hashCode());
        GPT_PROVIDER $gptProvider = this.getGptProvider();
        result = result * 59 + ($gptProvider == null ? 43 : $gptProvider.hashCode());
        Strategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        GPT_MODEL $gptModel = this.getGptModel();
        result = result * 59 + ($gptModel == null ? 43 : $gptModel.hashCode());
        String $simpleMessage = this.getSimpleMessage();
        result = result * 59 + ($simpleMessage == null ? 43 : $simpleMessage.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $sid = this.getSid();
        result = result * 59 + ($sid == null ? 43 : $sid.hashCode());
        String $routerKey = this.getRouterKey();
        result = result * 59 + ($routerKey == null ? 43 : $routerKey.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $sceneCode = this.getSceneCode();
        result = result * 59 + ($sceneCode == null ? 43 : $sceneCode.hashCode());
        String $debugMode = this.getDebugMode();
        result = result * 59 + ($debugMode == null ? 43 : $debugMode.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $ptxId = this.getPtxId();
        result = result * 59 + ($ptxId == null ? 43 : $ptxId.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $targetId = this.getTargetId();
        result = result * 59 + ($targetId == null ? 43 : $targetId.hashCode());
        String $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List $metricIdList = this.getMetricIdList();
        result = result * 59 + ($metricIdList == null ? 43 : ((Object)$metricIdList).hashCode());
        List $datasetIdList = this.getDatasetIdList();
        result = result * 59 + ($datasetIdList == null ? 43 : ((Object)$datasetIdList).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $asaCode = this.getAsaCode();
        result = result * 59 + ($asaCode == null ? 43 : $asaCode.hashCode());
        String $combinationMsg = this.getCombinationMsg();
        result = result * 59 + ($combinationMsg == null ? 43 : $combinationMsg.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : $productVersion.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $sectionId = this.getSectionId();
        result = result * 59 + ($sectionId == null ? 43 : $sectionId.hashCode());
        String $messageId4Ania = this.getMessageId4Ania();
        result = result * 59 + ($messageId4Ania == null ? 43 : $messageId4Ania.hashCode());
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        return result;
    }

    public String toString() {
        return "Question(message=" + this.getMessage() + ", originMessage=" + this.getOriginMessage() + ", originFinallyQuestion=" + this.getOriginFinallyQuestion() + ", gptProvider=" + this.getGptProvider() + ", timeTrace=" + this.isTimeTrace() + ", explain=" + this.isExplain() + ", strategy=" + this.getStrategy() + ", sceneTopK=" + this.getSceneTopK() + ", gptModel=" + this.getGptModel() + ", simpleMessage=" + this.getSimpleMessage() + ", locale=" + this.getLocale() + ", token=" + this.getToken() + ", sid=" + this.getSid() + ", routerKey=" + this.getRouterKey() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", multiDialogue=" + this.isMultiDialogue() + ", sceneCode=" + this.getSceneCode() + ", debugMode=" + this.getDebugMode() + ", messageId=" + this.getMessageId() + ", ptxId=" + this.getPtxId() + ", sessionId=" + this.getSessionId() + ", targetId=" + this.getTargetId() + ", targetName=" + this.getTargetName() + ", appCode=" + this.getAppCode() + ", version=" + this.getVersion() + ", metricIdList=" + this.getMetricIdList() + ", datasetIdList=" + this.getDatasetIdList() + ", method=" + this.getMethod() + ", asaCode=" + this.getAsaCode() + ", combinationMsg=" + this.getCombinationMsg() + ", id=" + this.getId() + ", ifStream=" + this.isIfStream() + ", closeStream=" + this.isCloseStream() + ", productVersion=" + this.getProductVersion() + ", appVersion=" + this.getAppVersion() + ", sectionId=" + this.getSectionId() + ", messageId4Ania=" + this.getMessageId4Ania() + ", conversationId=" + this.getConversationId() + ")";
    }
}

