/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.beans.pojos.knowledgebase;

import com.digiwin.chatbi.common.exception.KnowledgeBaseOperationAssert;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public interface KnowledgeFile {
    default public void doInvalidCheck() {
        KnowledgeBaseOperationAssert.DATA_SOURCE_NAME_NOT_NULL_ASSERT.notEmpty(this.ofKnowledgeBaseName(), new Object[0]);
        KnowledgeBaseOperationAssert.DATA_SOURCE_FILE_NAME_NOT_NULL_ASSERT.notEmpty(this.ofFileName(), new Object[0]);
        KnowledgeBaseOperationAssert.DATA_SOURCE_FILE_CONTENT_NOT_NULL_ASSERT.notEmpty(this.ofFileContent(), new Object[0]);
    }

    public String ofKnowledgeBaseName();

    public String ofFileName();

    public String ofFileContent();

    default public String ofFullName() {
        return this.ofFileName() + ".tt";
    }

    public String ofFullContent();

    default public String ofNameFullPath() {
        File file = new File(new File(".").getAbsolutePath() + File.separator + "file");
        KnowledgeBaseOperationAssert.FILE_PATH_AVAILABLE_ASSERT.isTrue(file.exists() || file.mkdirs(), new Object[0]);
        return file + File.separator + this.ofFullName();
    }

    default public void createTTFile() {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(this.ofNameFullPath(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(this.ofFileContent());
            writer.flush();
        }
        catch (IOException e) {
            throw KnowledgeBaseOperationAssert.FILE_CREATE_FAILED_ASSERT.newException(new Object[]{e.getMessage()});
        }
    }
}

