/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.beans.vos;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.AgileDataEchoParam;
import com.digiwin.chatbi.beans.pojos.AgileDataEchoSchema;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.vos.FilterDateFieldDelegate;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.enums.ChatResultCode;
import com.digiwin.chatbi.common.enums.DebugMode;
import com.digiwin.chatbi.common.enums.SpecialModeEnum;
import com.digiwin.chatbi.common.util.CommonUtil;
import com.digiwin.chatbi.common.util.DateTimeUtil;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.search.config.ExperienceAppConfig;
import com.digiwin.chatbi.service.KnowledgemapsService;
import com.digiwin.chatbi.service.MessageUtils;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChatResultVo {
    private static final Logger log = LoggerFactory.getLogger(ChatResultVo.class);
    private String intent;
    private int code;
    private ChatResultCode type;
    private String datasourceId;
    private String client;
    private String templateCode;
    private String target;
    private JSONArray dimension;
    private Integer dimensionCnt;
    private String finallyQuestion;
    private String combinationQuestion;
    private String noneHistory;
    private String sceneCode;
    private List<JSONObject> scenes;
    private List<JSONObject> targets;
    private Integer targetSize = 0;
    private String method;
    private Boolean scenePermission = false;
    private List<String> sentences;
    private List<JSONObject> eocMaps;
    private Object data;
    private String pointLog;
    private String RHErrorLog;
    private Integer autoChoiceScene;
    private String questionUnderstand;
    private Integer specialMode;
    private AgileDataEchoSchema dataEchoSchema;
    private AgileDataEchoParam dataEchoParam;
    private List<JSONObject> productLineInfo;
    private static HashMap<String, String> opMap = new HashMap();

    public static ChatResultVo createResult(JSONObject context, Function<JSONObject, ?> data, ChatResultCode chatResultCode) {
        return new ChatResultVo().consumeParams(chatResVO -> {
            String understand;
            chatResVO.setMethod("dataflow");
            CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
            chatResVO.setRHErrorLog(context.getString("RHErrorLog"));
            if (StringUtils.isNotBlank((String)chatResVO.getRHErrorLog())) {
                context.put("logProblemDescription", Constants.RH_ERROR_LOG_VALUE.get(0));
                context.put("logTimestamp", (Object)DateTimeUtil.format((Date)new Date()));
                context.put("logErrorContent", (Object)((String)Constants.RH_ERROR_LOG_VALUE.get(1)).replace("rhError", chatResVO.getRHErrorLog()));
                context.put("logTroubleGuide", Constants.RH_ERROR_LOG_VALUE.get(2));
                context.put("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}".replace("{logProblemDescription}", context.getString("logProblemDescription")).replace("{logErrorContent}", context.getString("logErrorContent")).replace("{logTimestamp}", context.getString("logTimestamp")).replace("{logTroubleGuide}", context.getString("logTroubleGuide")));
            }
            String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
            String debugMode = ((Question)context.getObject("question", Question.class)).getDebugMode();
            String sceneCode = ((Question)context.getObject("question", Question.class)).getSceneCode();
            String locale = ((Question)context.getObject("question", Question.class)).getLocale();
            chatResVO.setCombinationQuestion(question.replace("\\\"", "\""));
            chatResVO.setIntent(context.getString("intent"));
            chatResVO.setCode(chatResultCode.getCode());
            chatResVO.setType(chatResultCode);
            chatResVO.setDatasourceId(context.getString("datasourceId"));
            chatResVO.setTargetSize(Integer.valueOf(!Objects.isNull(context.getInteger("target_size")) ? context.getInteger("target_size") : 0));
            chatResVO.setTemplateCode(context.getString("templateCode"));
            List schemas = ((List)((JSONObject)context.getOrDefault((Object)"schemas", (Object)new JSONObject())).getOrDefault((Object)"Schemas", new ArrayList())).stream().map(inner_hit -> inner_hit.getString("name")).collect(Collectors.toList());
            List res = new ArrayList();
            if (!Objects.isNull(res)) {
                res = (List)data.apply(context);
            }
            if (CollectionUtils.isNotEmpty(res) && !Objects.isNull(((JSONObject)res.get(0)).getJSONObject("condition")) && CollectionUtils.isNotEmpty((Collection)((JSONObject)res.get(0)).getJSONObject("condition").getJSONArray("items"))) {
                JSONArray jsonArray = new JSONArray();
                ((JSONObject)res.get(0)).getJSONObject("condition").getJSONArray("items").forEach(item -> {
                    JSONObject temp = (JSONObject)item;
                    if (schemas.contains(temp.getString("left"))) {
                        jsonArray.add((Object)temp);
                    }
                });
                ((JSONObject)res.get(0)).getJSONObject("condition").put("items", (Object)jsonArray);
            }
            chatResVO.setData(data.apply(context));
            chatResVO.setClient(context.getString("GPT_CLIENT"));
            chatResVO.setDimension(context.getJSONArray("final_dimension"));
            chatResVO.setDimensionCnt(Integer.valueOf(chatResVO.getDimension().size()));
            chatResVO.setTarget(context.getString("datasourceId"));
            chatResVO.setSentences((List)context.get((Object)"sentences"));
            Integer specialMode = context.getInteger("special_mode");
            if (!Objects.isNull(specialMode) && SpecialModeEnum.MORE_SCENE.getValue().equals(specialMode)) {
                chatResVO.setCode(ChatResultCode.OTHER_QUESTION.getCode());
                chatResVO.setType(ChatResultCode.OTHER_QUESTION);
            }
            chatResVO.setSpecialMode(specialMode);
            if (!Objects.isNull(chatResVO.getSpecialMode())) {
                chatResVO.setSentences(null);
            }
            if (StringUtils.isNotEmpty((String)sceneCode) && (DebugMode.DEBUG.getCode().equals(debugMode) || DebugMode.PR_PARAM.getCode().equals(debugMode))) {
                chatResVO.setSceneCode(sceneCode);
            }
            String token = ((Question)context.getObject("question", Question.class)).getToken();
            ChatResultVo.setFilterDate((JSONObject)context, (ChatResultVo)chatResVO, res, (String)token);
            chatResVO.setAutoChoiceScene(context.getInteger("autoChoiceScene"));
            List scenes = (List)context.getOrDefault((Object)"scenes", new ArrayList());
            chatResVO.setScenes(scenes);
            List finalProductLineInfo = (List)context.getOrDefault((Object)"finalProductLineInfo", new ArrayList());
            chatResVO.setProductLineInfo(finalProductLineInfo);
            if (CollectionUtils.isNotEmpty((Collection)chatResVO.getScenes())) {
                JSONObject input = new JSONObject();
                input.put("targetName", (Object)chatResVO.getTargetName(context));
                input.put("templateName", (Object)chatResVO.getTemplateName(context));
                input.put("dimensionNames", (Object)chatResVO.getDimensionNames(context));
                LogCheckDto logCheckDto = new LogCheckDto();
                JSONObject result = new JSONObject();
                result.put("scenes", (Object)chatResVO.getScenes());
                logCheckDto.buildParams("ChatResultVo", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
                logCheckDtos.add(logCheckDto);
            }
            chatResVO.questionFactorAnalysis(context);
            if ((!CollectionUtils.isNotEmpty((Collection)chatResVO.getScenes()) || chatResVO.getScenes().size() <= 1) && StringUtils.isNotBlank((String)(understand = chatResVO.buildQuestionUnderstand(context, CommonUtil.isLastCharPunctuation((String)chatResVO.getCombinationQuestion()))))) {
                MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                String param = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)(StringUtils.isBlank((String)chatResVO.getCombinationQuestion()) ? understand : chatResVO.getCombinationQuestion() + understand)) : (StringUtils.isBlank((String)chatResVO.getCombinationQuestion()) ? understand : chatResVO.getCombinationQuestion() + understand);
                String questionUnderstand = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.large.model.understands", locale, new Object[]{param});
                log.info("scrumbi questionUnderstand 189:{}", (Object)questionUnderstand);
                chatResVO.setQuestionUnderstand(questionUnderstand);
            }
            try {
                if (DebugMode.PARAM.getCode().equals(debugMode)) {
                    chatResVO.setData((Object)chatResVO.buildParamResult(context));
                    chatResVO.setCode(ChatResultCode.KNOWLEDGE_GRAPH.getCode());
                    chatResVO.setType(ChatResultCode.KNOWLEDGE_GRAPH);
                }
                if (DebugMode.PR_PARAM.getCode().equals(debugMode)) {
                    chatResVO.setData((Object)chatResVO.buildPrParamResult());
                    chatResVO.setCode(ChatResultCode.KNOWLEDGE_GRAPH.getCode());
                    chatResVO.setType(ChatResultCode.KNOWLEDGE_GRAPH);
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u8bd5\u53c2\u6570\u8bbe\u7f6e\u5931\u8d25:", (Throwable)e);
            }
        });
    }

    private static void setFilterDate(JSONObject context, ChatResultVo chatResVO, List<JSONObject> res, String token) {
        try {
            if (CollectionUtils.isNotEmpty(res) && !Objects.isNull(res.get(0).getJSONObject("condition")) && CollectionUtils.isNotEmpty((Collection)res.get(0).getJSONObject("condition").getJSONArray("items"))) {
                Set dateFiledSet;
                log.info("start items {}", (Object)res.get(0).getJSONObject("condition").getJSONArray("items"));
                res.get(0).getJSONObject("condition").put("items", (Object)FilterDateFieldDelegate.buidNewItemArray((JSONArray)res.get(0).getJSONObject("condition").getJSONArray("items")));
                JSONArray itemArray = res.get(0).getJSONObject("condition").getJSONArray("items");
                log.info("deal end  items {}", (Object)itemArray);
                ArrayList leftMapList = new ArrayList();
                JSONArray questionDateFilter = new JSONArray();
                JSONArray questionOtherFilter = new JSONArray();
                itemArray.forEach(item -> {
                    HashMap<String, String> leftMap;
                    JSONObject temp = (JSONObject)item;
                    if ("datetime".equals(temp.getString("right_value_type"))) {
                        questionDateFilter.add(item);
                    } else {
                        questionOtherFilter.add(item);
                    }
                    if ("eoc_company_name".equals(temp.getString("left"))) {
                        leftMap = new HashMap<String, String>();
                        leftMap.put("eoc_company_name", temp.getString("right"));
                        leftMapList.add(leftMap);
                    }
                    if ("eoc_company_id".equals(temp.getString("left"))) {
                        leftMap = new HashMap();
                        leftMap.put("eoc_company_id", temp.getString("right"));
                        leftMapList.add(leftMap);
                    }
                });
                context.put("questionDateFilter", (Object)questionDateFilter);
                context.put("questionOtherFilter", (Object)questionOtherFilter);
                chatResVO.multiCompanySetEocMaps(leftMapList, context);
                String code = null;
                if (StringUtils.isNotBlank((String)chatResVO.getSceneCode())) {
                    code = chatResVO.getSceneCode();
                } else {
                    List scenesList = chatResVO.getScenes();
                    if (CollectionUtils.isNotEmpty((Collection)scenesList) && 1 == scenesList.size()) {
                        code = ((JSONObject)scenesList.get(0)).getString("sceneCode");
                    }
                }
                if (StringUtils.isNotBlank((String)code) && CollectionUtils.isNotEmpty((Collection)(dateFiledSet = FilterDateFieldDelegate.getSchemasBySceneCode((String)code, (String)token, (JSONObject)context)))) {
                    res.get(0).getJSONObject("condition").put("items", (Object)FilterDateFieldDelegate.replaceItemArrayDate((JSONArray)itemArray, (Set)dateFiledSet));
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u573a\u666f\u65f6\u95f4\u5b57\u6bb5\u8bbe\u7f6efilter\u65e5\u671f\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
        }
    }

    public static ChatResultVo createResult(JSONObject context, String data, ChatResultCode chatResultCode) {
        return new ChatResultVo().consumeParams(chatResVO -> {
            AgileDataEchoParam param;
            String experienceAppPrompts;
            CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
            String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
            chatResVO.setMethod("dataflow");
            if (context.containsKey((Object)"version")) {
                chatResVO.questionFactorAnalysis(context);
                String understand = chatResVO.buildQuestionUnderstand(context, CommonUtil.isLastCharPunctuation((String)question));
                if (StringUtils.isNotBlank((String)understand)) {
                    String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                    MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                    String param2 = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)(question + understand)) : question + understand;
                    String questionUnderstand = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.large.model.understands", locale, new Object[]{param2});
                    log.info("scrumbi questionUnderstand 289:{}", (Object)questionUnderstand);
                    chatResVO.setQuestionUnderstand(questionUnderstand);
                }
            }
            chatResVO.setRHErrorLog(context.getString("RHErrorLog"));
            if (StringUtils.isNotBlank((String)chatResVO.getRHErrorLog())) {
                context.put("logProblemDescription", Constants.RH_ERROR_LOG_VALUE.get(0));
                context.put("logTimestamp", (Object)DateTimeUtil.format((Date)new Date()));
                context.put("logErrorContent", (Object)((String)Constants.RH_ERROR_LOG_VALUE.get(1)).replace("rhError", chatResVO.getRHErrorLog()));
                context.put("logTroubleGuide", Constants.RH_ERROR_LOG_VALUE.get(2));
                context.put("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}");
            }
            chatResVO.setFinallyQuestion(context.getString("finally_question"));
            chatResVO.setNoneHistory(context.getString("noneHistory"));
            chatResVO.setIntent(context.getString("intent"));
            chatResVO.setCode(chatResultCode.getCode());
            chatResVO.setType(chatResultCode);
            chatResVO.setTargetSize(Integer.valueOf(!Objects.isNull(context.getInteger("target_size")) ? context.getInteger("target_size") : 0));
            if ((context.containsKey((Object)"tempLateReply") || context.containsKey((Object)"no_target") && "Y".equals(context.getString("no_target"))) && StringUtils.isNotBlank((String)(experienceAppPrompts = chatResVO.getExperienceAppPrompts(context)))) {
                context.put("reply", (Object)experienceAppPrompts);
            }
            chatResVO.setDatasourceId(Objects.equals(0, chatResultCode.getCode()) ? null : context.getString("datasourceId"));
            MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
            String defaultReply = messageUtils.getMessageByLangName("message.scrumbi.no.target.alike", ((Question)context.getObject("question", Question.class)).getLocale());
            String ZNReply = StringUtils.isEmpty((String)context.getString("reply")) ? defaultReply : context.get((Object)"reply");
            String locale = ((Question)context.getObject("question", Question.class)).getLocale();
            if (Objects.nonNull(ZNReply)) {
                chatResVO.setData((Object)(ZNReply.toString().startsWith("message.scrumbi") ? messageUtils.getMessageByLangName(ZNReply.toString(), locale) : ZNReply.toString()));
            }
            chatResVO.setClient(context.getString("GPT_CLIENT"));
            chatResVO.setSentences((List)context.get((Object)"sentences"));
            chatResVO.setSpecialMode(context.getInteger("special_mode"));
            if (!Objects.isNull(chatResVO.getSpecialMode())) {
                chatResVO.setSentences(null);
            }
            if (!Objects.isNull(chatResVO.getSpecialMode()) && SpecialModeEnum.MORE_TARGET.getValue().intValue() == chatResVO.getSpecialMode().intValue()) {
                chatResVO.setTargets((List)context.getOrDefault((Object)"more_target", new ArrayList()));
            }
            if (Objects.nonNull(context.getBoolean("scenePermission"))) {
                chatResVO.setScenePermission(context.getBoolean("scenePermission"));
            }
            if (StringUtils.isNotEmpty((String)context.getString("logKey"))) {
                if (Objects.nonNull(context.getBoolean("no_target")) && context.getBoolean("no_target").booleanValue() || Objects.nonNull(context.getBoolean("no_template")) && context.getBoolean("no_template").booleanValue()) {
                    log.info("\u8001\u573a\u666f\u95ee\u53e5\u9519\u8bef\u65e5\u5fd7,question = {},log={}", (Object)((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", ""), (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}".replace("{logProblemDescription}", context.getString("logProblemDescription")).replace("{logErrorContent}", context.getString("logErrorContent")).replace("{logTimestamp}", context.getString("logTimestamp")).replace("{logTroubleGuide}", context.getString("logTroubleGuide")));
                    param = new AgileDataEchoParam();
                    param.setContent(context.getString("logErrorContent")).setDescription(context.getString("logProblemDescription")).setExtend(context.getString("logTroubleGuide")).setPixBackendId(((Question)context.getObject("question", Question.class)).getPtxId()).setMessageId(((Question)context.getObject("question", Question.class)).getMessageId());
                    chatResVO.setDataEchoParam(param);
                } else {
                    log.info("\u8001\u573a\u666f\u95ee\u53e5\u9519\u8bef\u65e5\u5fd7,question = {},log={}", (Object)question, (Object)context.getString("logKey"));
                }
                chatResVO.setPointLog("\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}".replace("{logProblemDescription}", context.getString("logProblemDescription")).replace("{logErrorContent}", context.getString("logErrorContent")).replace("{logTimestamp}", context.getString("logTimestamp")).replace("{logTroubleGuide}", context.getString("logTroubleGuide")));
            } else {
                context.put("logTimestamp", (Object)DateTimeUtil.format((Date)new Date()));
                if (chatResVO.getScenePermission().booleanValue()) {
                    context.put("logProblemDescription", (Object)messageUtils.getMessageByLangName("message.scrumbi.no.scene.permission", locale));
                    context.put("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n");
                    chatResVO.setPointLog("\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n".replace("{logProblemDescription}", context.getString("logProblemDescription")).replace("{logTimestamp}", context.getString("logTimestamp")));
                } else if (context.containsKey((Object)"scelect_scene")) {
                    String targetName = chatResVO.getTargetName(context);
                    chatResVO.setTemplateCode(context.getString("templateCode"));
                    String templateName = chatResVO.getTemplateName(context);
                    chatResVO.setDimension(context.getJSONArray("final_dimension"));
                    List dimensionNames = chatResVO.getDimensionNames(context);
                    JSONObject input = new JSONObject();
                    input.put("targetName", (Object)targetName);
                    input.put("templateName", (Object)templateName);
                    input.put("dimensionNames", (Object)dimensionNames);
                    LogCheckDto logCheckDto = new LogCheckDto();
                    logCheckDto.buildParams("ChatResultVo", context.containsKey((Object)"scelect_scene_metric_mix") ? LogUtils.WARING : "U.SCRUMBI.901.0218", input.toJSONString(), "\u672a\u5339\u914d\u5230\u5408\u9002\u573a\u666f,\u53ef\u80fd\u56e0\u4e3a\u6ca1\u6709\u914d\u7f6e\u8be5\u573a\u666f\uff0c\u6216\u6ca1\u6709\u53d1\u7248\u5bfc\u81f4\u5df2\u914d\u7f6e\u7684\u573a\u666f\u6ca1\u6709\u751f\u6548", "1.\u4f9d\u6b21\u68c0\u67e5\u573a\u666f\u4e2d\u76ee\u6807=target\uff0c\u89d2\u5ea6=template\uff0c\u7ef4\u5ea6=dimensions\u7684\u914d\u7f6e\u3002\n2.\u5bf9\u4e8e\u672a\u914d\u7f6e\u7684\u90e8\u5206\uff0c\u6dfb\u52a0\u76f8\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\uff0c\u5df2\u914d\u7f6e\u7684\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002\n3.\u4fdd\u5b58\u914d\u7f6e\uff0c\u8fdb\u884c\u53d1\u7248\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u4ecd\u6709\u95ee\u9898\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002".replace("template", templateName).replace("target", targetName).replace("dimensions", dimensionNames.toString()));
                    logCheckDtos.add(logCheckDto);
                    context.put("logCheckDtos", logCheckDtos);
                    context.put("logProblemDescription", Constants.NO_SCENE_LOG_VALUE.get(0));
                    context.put("logErrorContent", (Object)((String)Constants.NO_SCENE_LOG_VALUE.get(1)).replace("template", templateName).replace("target", targetName).replace("dimensions", dimensionNames.toString()));
                    context.put("logTroubleGuide", Constants.NO_SCENE_LOG_VALUE.get(2));
                    context.put("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}");
                    log.info("\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}".replace("{logProblemDescription}", context.getString("logProblemDescription")).replace("{logErrorContent}", context.getString("logErrorContent")).replace("{logTimestamp}", context.getString("logTimestamp")).replace("{logTroubleGuide}", context.getString("logTroubleGuide")));
                    chatResVO.setPointLog("\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}".replace("{logProblemDescription}", context.getString("logProblemDescription")).replace("{logErrorContent}", context.getString("logErrorContent")).replace("{logTimestamp}", context.getString("logTimestamp")).replace("{logTroubleGuide}", context.getString("logTroubleGuide")));
                    String experienceAppPrompts2 = chatResVO.getExperienceAppPrompts(context);
                    if (StringUtils.isNotBlank((String)experienceAppPrompts2)) {
                        chatResVO.setData((Object)experienceAppPrompts2);
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)context.getString("logKey"))) {
                param = new AgileDataEchoParam();
                param.setContent(context.getString("logProblemDescription")).setPixBackendId(((Question)context.getObject("question", Question.class)).getPtxId()).setMessageId(((Question)context.getObject("question", Question.class)).getMessageId());
                if (!chatResVO.getScenePermission().booleanValue()) {
                    param.setDescription(context.getString("logErrorContent")).setExtend(context.getString("logTroubleGuide"));
                }
                chatResVO.setDataEchoParam(param);
            }
        });
    }

    public void multiCompanySetEocMaps(List<Map<String, String>> leftMapList, JSONObject context) {
        if (CollectionUtils.isNotEmpty(leftMapList)) {
            JSONObject jsonObject;
            List companyWords = (List)context.getOrDefault((Object)"originalStandardWords", new ArrayList());
            ArrayList<JSONObject> eocMaps = new ArrayList<JSONObject>();
            if (CollectionUtils.isNotEmpty((Collection)companyWords)) {
                for (Map<String, String> map : leftMapList) {
                    jsonObject = new JSONObject();
                    companyWords.forEach(companyWord -> {
                        if (map.containsKey("eoc_company_name") && ((String)map.get("eoc_company_name")).equals(companyWord.getString("standard_name")) && "\u516c\u53f8\u540d\u79f0".equals(companyWord.getString("entity_type"))) {
                            String eocCompanyId = ConvertorJsonCommonMethod.getEocCompanyId((JSONObject)context, (String)companyWord.getString("standard_name"));
                            if (StringUtils.isBlank((String)eocCompanyId)) {
                                MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                                String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                                String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.not.match.company", locale, new Object[]{companyWord.getString("standard_name")});
                                this.setData((Object)reply);
                                this.setCode(ChatResultCode.COMPANY_NOT_MATCH.getCode());
                                this.setType(ChatResultCode.COMPANY_NOT_MATCH);
                            }
                            jsonObject.put("eocCompanyId", (Object)eocCompanyId);
                            jsonObject.put("eocCompanyName", (Object)companyWord.getString("standard_name"));
                        }
                    });
                    if (Objects.isNull(jsonObject) || !StringUtils.isNotEmpty((String)jsonObject.getString("eocCompanyName"))) continue;
                    eocMaps.add(jsonObject);
                }
            }
            for (Map<String, String> map : leftMapList) {
                if (!map.containsKey("eoc_company_id")) continue;
                jsonObject = new JSONObject();
                String eocCompanyId = map.get("eoc_company_id");
                String eocCompanyName = ConvertorJsonCommonMethod.getEocCompanyName((JSONObject)context, (String)eocCompanyId);
                if (StringUtils.isBlank((String)eocCompanyName)) {
                    log.warn("getEocCompanyName is null eocCompanyId={}", (Object)eocCompanyId);
                    MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                    this.setData((Object)messageUtils.getMessageByLangName("message.scrumbi.not.found.company.id", ((Question)context.getObject("question", Question.class)).getLocale()));
                    this.setCode(ChatResultCode.COMPANY_NOT_MATCH.getCode());
                    this.setType(ChatResultCode.COMPANY_NOT_MATCH);
                }
                jsonObject.put("eocCompanyId", (Object)eocCompanyId);
                jsonObject.put("eocCompanyName", (Object)eocCompanyName);
                if (Objects.isNull(jsonObject) || !StringUtils.isNotEmpty((String)jsonObject.getString("eocCompanyName"))) continue;
                eocMaps.add(jsonObject);
            }
            this.setEocMaps(eocMaps);
        }
    }

    public String getExperienceAppPrompts(JSONObject context) {
        ExperienceAppConfig experienceAppConfig = (ExperienceAppConfig)SpringContextUtil.getBean(ExperienceAppConfig.class);
        String experienceAppCodes = experienceAppConfig.getAppCodes();
        if (StringUtils.isNotBlank((String)experienceAppCodes)) {
            List<String> list = Arrays.asList(experienceAppCodes.split(","));
            JSONArray jsonArray = context.getJSONArray("applicationCodes");
            if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
                boolean match = jsonArray.stream().anyMatch(list::contains);
                if (match) {
                    String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                    MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                    return messageUtils.getMessageByLangName("message.scrumbi.experience.app.prompts", locale);
                }
            }
        }
        return null;
    }

    public String getTargetName(JSONObject context) {
        String targetName = Optional.ofNullable(context.getObject("targets", List.class)).map(targets -> {
            for (Object t : targets) {
                JSONObject jsonObject = (JSONObject)t;
                if (!StringUtils.isNotEmpty((String)context.getString("datasourceId")) || !context.getString("datasourceId").equals(jsonObject.getString("datasourceId"))) continue;
                return jsonObject.getString("datasourceName");
            }
            return context.getString("datasourceId");
        }).orElse("");
        return targetName;
    }

    public String getTemplateName(JSONObject context) {
        String templateName = Optional.ofNullable(context.getObject("templates", List.class)).map(templates -> {
            for (Object t : templates) {
                JSONObject jsonObject = (JSONObject)t;
                if (!StringUtils.isNotEmpty((String)this.getTemplateCode()) || !this.getTemplateCode().equals(jsonObject.getString("templateCode"))) continue;
                return jsonObject.getString("templateName");
            }
            return this.getTemplateCode();
        }).orElse("");
        return templateName;
    }

    public void questionFactorAnalysis(JSONObject context) {
        String messageId = ((Question)context.getObject("question", Question.class)).getMessageId();
        if (StringUtils.isBlank((String)messageId)) {
            return;
        }
        String token = ((Question)context.getObject("question", Question.class)).getToken();
        AgileDataEchoSchema param = new AgileDataEchoSchema();
        ArrayList dimensionList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)this.getDimension())) {
            this.getDimension().forEach(item -> dimensionList.add(this.getLeftFieldName(context, item.toString())));
        }
        String group = dimensionList.size() == 0 ? null : String.join((CharSequence)",", dimensionList);
        JSONObject sortAndLimit = this.getSortAndLimit(context);
        param.setMessageId(messageId).setToken(token).setUserId(((Question)context.getObject("question", Question.class)).getUserId()).setTenantId(context.getString("tenantId")).setSceneCode(this.getSceneCode()).setTarget(this.getTargetName(context)).setPoint(this.getTemplateName(context)).setSchemaGroup(group).setSchemaCondition(this.getQuestionOtherFilter(context)).setSchemaSort(sortAndLimit.getString("sortMethod")).setSchemaRestrict(sortAndLimit.getString("limit")).setSchemaTime(this.getQuestionDateFilter(context)).setSessionId(((Question)context.getObject("question", Question.class)).getSessionId()).setCreateTime(DateTimeUtil.format((Date)new Date()));
        log.info("questionFactorAnalysis agileDataEchoSchema param:{}", (Object)param);
        this.setDataEchoSchema(param);
    }

    public JSONObject getSortAndLimit(JSONObject context) {
        String sortMethod = null;
        Integer limit = null;
        if (context.containsKey((Object)"SortAndLimit")) {
            limit = Optional.ofNullable(context.getJSONObject("SortAndLimit").get((Object)"limit")).map(j -> {
                JSONObject conJ = (JSONObject)j;
                if (!conJ.containsKey((Object)"statistics") || conJ.getJSONArray("statistics").size() == 0) {
                    return null;
                }
                JSONObject statistics = (JSONObject)conJ.getJSONArray("statistics").get(0);
                String endPos = statistics.getString("endPos");
                if (StringUtils.isBlank((String)endPos)) {
                    return null;
                }
                return Integer.valueOf(endPos) + 1;
            }).orElse(null);
            sortMethod = Optional.ofNullable(context.getJSONObject("SortAndLimit").get((Object)"sort")).map(j -> {
                JSONObject conJ = (JSONObject)j;
                if (!conJ.containsKey((Object)"statistics") || conJ.getJSONArray("statistics").size() == 0) {
                    return null;
                }
                String type = ((JSONObject)conJ.getJSONArray("statistics").get(0)).getString("type");
                return "desc".equals(type) ? "\u5012\u5e8f" : "\u6b63\u5e8f";
            }).orElse(null);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sortMethod", sortMethod);
        jsonObject.put("limit", (Object)limit);
        return jsonObject;
    }

    public List<String> getDimensionNames(JSONObject context) {
        ArrayList<String> dimensionNames = new ArrayList<String>();
        List schemaList = (List)((JSONObject)context.getOrDefault((Object)"schemas", (Object)new JSONObject())).getOrDefault((Object)"Schemas", new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)schemaList)) {
            for (JSONObject t : schemaList) {
                if (!CollectionUtils.isNotEmpty((Collection)this.getDimension())) continue;
                this.getDimension().forEach(d -> {
                    if (d.toString().equals(t.getString("name"))) {
                        dimensionNames.add(t.getString("title"));
                    }
                });
            }
        }
        return dimensionNames;
    }

    public String getLeftFieldName(JSONObject context, String leftField) {
        List schemaList = (List)((JSONObject)context.getOrDefault((Object)"schemas", (Object)new JSONObject())).getOrDefault((Object)"Schemas", new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)schemaList)) {
            for (JSONObject jsonObject : schemaList) {
                if (!jsonObject.getString("name").equals(leftField)) continue;
                return jsonObject.getString("title");
            }
        }
        return leftField;
    }

    public String getQuestionOtherFilter(JSONObject context) {
        JSONArray questionOtherFilter = context.getJSONArray("questionOtherFilter");
        if (CollectionUtils.isEmpty((Collection)questionOtherFilter)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object item : questionOtherFilter) {
            String rightValueType;
            String leftField = ((JSONObject)item).getString("left");
            String leftFieldName = this.getLeftFieldName(context, leftField);
            String operation = (String)opMap.get(((JSONObject)item).getString("op"));
            String rightValue = ((JSONObject)item).getString("right");
            String type = ((JSONObject)item).getString("type");
            if (StringUtils.isNotBlank((String)type) && type.equals("column")) {
                rightValue = this.getLeftFieldName(context, rightValue);
            }
            if ((rightValueType = ((JSONObject)item).getString("right_value_type")).equals("string")) {
                rightValue = "\"" + rightValue + "\"";
            }
            list.add(leftFieldName + operation + rightValue);
        }
        return list.stream().collect(Collectors.joining(","));
    }

    public String getQuestionDateFilter(JSONObject context) {
        JSONArray questionDateFilter = context.getJSONArray("questionDateFilter");
        if (CollectionUtils.isEmpty((Collection)questionDateFilter)) {
            return null;
        }
        HashMap<String, StringBuilder> groupedResults = new HashMap<String, StringBuilder>();
        for (int i = 0; i < questionDateFilter.size(); ++i) {
            JSONObject obj = questionDateFilter.getJSONObject(i);
            String left = obj.getString("left");
            String op = obj.getString("op");
            String right = obj.getString("right").replace("-", ".");
            if (groupedResults.containsKey(left)) {
                if (op.equals("gte")) {
                    ((StringBuilder)groupedResults.get(left)).insert(0, right + "~");
                    continue;
                }
                if (!op.equals("lte")) continue;
                ((StringBuilder)groupedResults.get(left)).append("~").append(right);
                continue;
            }
            if (op.equals("gte")) {
                groupedResults.put(left, new StringBuilder(right));
                continue;
            }
            if (!op.equals("lte")) continue;
            groupedResults.put(left, new StringBuilder(right));
        }
        List<StringBuilder> sortedValues = groupedResults.values().stream().sorted(Comparator.comparing(StringBuilder::toString)).collect(Collectors.toList());
        if (sortedValues.size() > 1) {
            sortedValues.forEach(sb -> sb.insert(0, "\u300c").append("\u300d"));
        }
        return sortedValues.stream().collect(Collectors.joining("~"));
    }

    public String buildQuestionUnderstand(JSONObject context, boolean isPunctuation) {
        String targetName = this.getTargetName(context);
        if (StringUtils.isBlank((String)targetName)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!isPunctuation) {
            sb.append("\uff0c");
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getDimension())) {
            ArrayList dimensionList = new ArrayList();
            this.getDimension().forEach(item -> dimensionList.add(this.getLeftFieldName(context, item.toString())));
            String dimensionNames = String.join((CharSequence)",", dimensionList);
            String questionDateFilter = this.getQuestionDateFilter(context);
            if (StringUtils.isNotBlank((String)questionDateFilter)) {
                sb.append("\u7b5b\u9009\u51fa").append(questionDateFilter).append("\u7684\u8bb0\u5f55\uff0c");
            }
            sb.append("\u6309").append(dimensionNames).append("\u5206\u7ec4\u67e5\u770b");
            sb.append(targetName).append("\u6570\u636e");
            String questionOtherFilter = this.getQuestionOtherFilter(context);
            if (StringUtils.isNotBlank((String)questionOtherFilter)) {
                sb.append("\uff0c\u5e76\u5bf9\u5176\u4e2d").append(questionOtherFilter).append("\u7684\u6570\u636e\u8fdb\u884c\u8fc7\u6ee4");
            }
        } else {
            sb.append("\u7b5b\u9009\u51fa");
            String questionDateFilter = this.getQuestionDateFilter(context);
            String questionOtherFilter = this.getQuestionOtherFilter(context);
            if (StringUtils.isNotBlank((String)questionDateFilter)) {
                sb.append(questionDateFilter);
            }
            if (StringUtils.isNotBlank((String)questionOtherFilter)) {
                if (StringUtils.isNotBlank((String)questionDateFilter)) {
                    sb.append("\u3001");
                }
                sb.append(questionOtherFilter);
            }
            sb.append("\u7684").append(targetName).append("\u6570\u636e");
        }
        return sb.toString();
    }

    public JSONObject buildPrParamResult() {
        List list = (List)this.getData();
        String sortMethod = null;
        Integer limit = null;
        JSONArray fields = new JSONArray();
        for (JSONObject j : list) {
            if ("filter".equals(j.get((Object)"name"))) {
                JSONArray items = j.getJSONObject("condition").getJSONArray("items");
                if (CollectionUtils.isEmpty((Collection)items)) continue;
                for (Object item : items) {
                    JSONObject field = new JSONObject();
                    field.put("name", (Object)((JSONObject)item).getString("left"));
                    field.put("operation", opMap.get(((JSONObject)item).getString("op")));
                    field.put("value", (Object)((JSONObject)item).getString("right"));
                    fields.add((Object)field);
                }
            }
            if ("limit".equals(j.get((Object)"name"))) {
                String endPos = ((JSONObject)j.getJSONObject("condition").getJSONArray("statistics").get(0)).getString("endPos");
                limit = Integer.valueOf(endPos) + 1;
            }
            if (!"sort".equals(j.get((Object)"name"))) continue;
            String type = ((JSONObject)j.getJSONObject("condition").getJSONArray("statistics").get(0)).getString("type");
            sortMethod = "desc".equals(type) ? "\u5012\u5e8f" : "\u6b63\u5e8f";
        }
        String sceneCode = CollectionUtils.isEmpty((Collection)this.getScenes()) ? null : this.getScenes().stream().map(s -> s.getString("sceneCode")).collect(Collectors.joining(", "));
        String target = this.getTarget();
        String templateCode = this.getTemplateCode();
        JSONArray dimension = this.getDimension();
        String finalSortMethod = sortMethod;
        Integer finalLimit = limit;
        JSONObject jsonObject = new JSONObject();
        JSONObject sceneConditionObject = new JSONObject();
        sceneConditionObject.put("traget", (Object)target);
        sceneConditionObject.put("templateCode", (Object)templateCode);
        sceneConditionObject.put("dimension", (Object)dimension);
        JSONObject sortObject = new JSONObject();
        sortObject.put("sortMethod", (Object)finalSortMethod);
        sortObject.put("limit", (Object)finalLimit);
        jsonObject.put("sceneCode", (Object)sceneCode);
        jsonObject.put("sceneCondition", (Object)sceneConditionObject);
        jsonObject.put("sort", (Object)sortObject);
        jsonObject.put("fields", (Object)fields);
        return jsonObject;
    }

    public JSONObject buildParamResult(JSONObject context) {
        String questionTarget = this.getTarget();
        String questionTemplateCode = this.getTemplateCode();
        JSONArray questionDimension = this.getDimension();
        String sceneTarget = null;
        String sceneTemplateCode = null;
        JSONArray sceneDimension = new JSONArray();
        KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
        JSONObject params = new JSONObject();
        String code = ((Question)context.getObject("question", Question.class)).getSceneCode();
        params.put("sceneCode", (Object)code);
        try {
            ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
            params.put("applicationCodes", applicationCodes);
            params.put("version", (Object)context.getString("version"));
            JSONObject jsonObject = bean.querySceneMaps(params, context);
            if (!Objects.isNull(jsonObject)) {
                sceneTarget = jsonObject.getString("targetId");
                sceneTemplateCode = jsonObject.getString("templateCode");
                if (CollectionUtils.isNotEmpty((Collection)jsonObject.getJSONArray("dimensions"))) {
                    sceneDimension.addAll((Collection)jsonObject.getJSONArray("dimensions").stream().map(j -> ((JSONObject)j).getString("name")).collect(Collectors.toList()));
                }
            }
        }
        catch (Exception e) {
            log.error("Param\u6784\u9020\u5f02\u5e38\uff1a", (Throwable)e);
        }
        boolean tragetResult = false;
        boolean templateResult = false;
        boolean dimensionResult = false;
        if (StringUtils.isNotEmpty((String)questionTarget) && StringUtils.isNotEmpty(sceneTarget)) {
            tragetResult = questionTarget.equals(sceneTarget);
        }
        if (StringUtils.isNotEmpty((String)questionTemplateCode) && StringUtils.isNotEmpty(sceneTemplateCode)) {
            templateResult = questionTemplateCode.equals(sceneTemplateCode);
        }
        if (CollectionUtils.isEmpty((Collection)questionDimension) && CollectionUtils.isEmpty((Collection)sceneDimension)) {
            dimensionResult = true;
        } else if (CollectionUtils.isNotEmpty((Collection)questionDimension) && CollectionUtils.isNotEmpty((Collection)sceneDimension) && questionDimension.size() == sceneDimension.size()) {
            HashSet hashSet = new HashSet(questionDimension);
            int size = hashSet.size();
            sceneDimension.forEach(s -> hashSet.add(s.toString()));
            if (size == hashSet.size()) {
                dimensionResult = true;
            }
        }
        boolean result = templateResult && tragetResult && dimensionResult;
        String finalsceneTarget = sceneTarget;
        boolean finalDimensionResult = dimensionResult;
        String finalsceneTemplateCode = sceneTemplateCode;
        boolean finalTragetResult = tragetResult;
        boolean finalTemplateResult = templateResult;
        JSONObject jsonObject = new JSONObject();
        JSONObject tragetJsonObject = new JSONObject();
        tragetJsonObject.put("success", (Object)finalTragetResult);
        tragetJsonObject.put("questionResult", (Object)questionTarget);
        tragetJsonObject.put("sceneResult", (Object)finalsceneTarget);
        JSONObject templateCodeJsonObject = new JSONObject();
        templateCodeJsonObject.put("success", (Object)finalTemplateResult);
        templateCodeJsonObject.put("questionResult", (Object)questionTemplateCode);
        templateCodeJsonObject.put("sceneResult", (Object)finalsceneTemplateCode);
        JSONObject dimensionJsonObject = new JSONObject();
        dimensionJsonObject.put("success", (Object)finalDimensionResult);
        dimensionJsonObject.put("questionResult", (Object)questionDimension);
        dimensionJsonObject.put("sceneResult", (Object)sceneDimension);
        jsonObject.put("result", (Object)result);
        jsonObject.put("question", (Object)((Question)context.getObject("question", Question.class)).getMessage());
        jsonObject.put("sceneCode", (Object)code);
        jsonObject.put("traget", (Object)tragetJsonObject);
        jsonObject.put("templateCode", (Object)templateCodeJsonObject);
        jsonObject.put("dimension", (Object)dimensionJsonObject);
        return jsonObject;
    }

    public ChatResultVo consumeParams(Consumer<ChatResultVo> consumer) {
        consumer.accept(this);
        return this;
    }

    public String getIntent() {
        return this.intent;
    }

    public int getCode() {
        return this.code;
    }

    public ChatResultCode getType() {
        return this.type;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public String getClient() {
        return this.client;
    }

    public String getTemplateCode() {
        return this.templateCode;
    }

    public String getTarget() {
        return this.target;
    }

    public JSONArray getDimension() {
        return this.dimension;
    }

    public Integer getDimensionCnt() {
        return this.dimensionCnt;
    }

    public String getFinallyQuestion() {
        return this.finallyQuestion;
    }

    public String getCombinationQuestion() {
        return this.combinationQuestion;
    }

    public String getNoneHistory() {
        return this.noneHistory;
    }

    public String getSceneCode() {
        return this.sceneCode;
    }

    public List<JSONObject> getScenes() {
        return this.scenes;
    }

    public List<JSONObject> getTargets() {
        return this.targets;
    }

    public Integer getTargetSize() {
        return this.targetSize;
    }

    public String getMethod() {
        return this.method;
    }

    public Boolean getScenePermission() {
        return this.scenePermission;
    }

    public List<String> getSentences() {
        return this.sentences;
    }

    public List<JSONObject> getEocMaps() {
        return this.eocMaps;
    }

    public Object getData() {
        return this.data;
    }

    public String getPointLog() {
        return this.pointLog;
    }

    public String getRHErrorLog() {
        return this.RHErrorLog;
    }

    public Integer getAutoChoiceScene() {
        return this.autoChoiceScene;
    }

    public String getQuestionUnderstand() {
        return this.questionUnderstand;
    }

    public Integer getSpecialMode() {
        return this.specialMode;
    }

    public AgileDataEchoSchema getDataEchoSchema() {
        return this.dataEchoSchema;
    }

    public AgileDataEchoParam getDataEchoParam() {
        return this.dataEchoParam;
    }

    public List<JSONObject> getProductLineInfo() {
        return this.productLineInfo;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setType(ChatResultCode type) {
        this.type = type;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setDimension(JSONArray dimension) {
        this.dimension = dimension;
    }

    public void setDimensionCnt(Integer dimensionCnt) {
        this.dimensionCnt = dimensionCnt;
    }

    public void setFinallyQuestion(String finallyQuestion) {
        this.finallyQuestion = finallyQuestion;
    }

    public void setCombinationQuestion(String combinationQuestion) {
        this.combinationQuestion = combinationQuestion;
    }

    public void setNoneHistory(String noneHistory) {
        this.noneHistory = noneHistory;
    }

    public void setSceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
    }

    public void setScenes(List<JSONObject> scenes) {
        this.scenes = scenes;
    }

    public void setTargets(List<JSONObject> targets) {
        this.targets = targets;
    }

    public void setTargetSize(Integer targetSize) {
        this.targetSize = targetSize;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setScenePermission(Boolean scenePermission) {
        this.scenePermission = scenePermission;
    }

    public void setSentences(List<String> sentences) {
        this.sentences = sentences;
    }

    public void setEocMaps(List<JSONObject> eocMaps) {
        this.eocMaps = eocMaps;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setPointLog(String pointLog) {
        this.pointLog = pointLog;
    }

    public void setRHErrorLog(String RHErrorLog) {
        this.RHErrorLog = RHErrorLog;
    }

    public void setAutoChoiceScene(Integer autoChoiceScene) {
        this.autoChoiceScene = autoChoiceScene;
    }

    public void setQuestionUnderstand(String questionUnderstand) {
        this.questionUnderstand = questionUnderstand;
    }

    public void setSpecialMode(Integer specialMode) {
        this.specialMode = specialMode;
    }

    public void setDataEchoSchema(AgileDataEchoSchema dataEchoSchema) {
        this.dataEchoSchema = dataEchoSchema;
    }

    public void setDataEchoParam(AgileDataEchoParam dataEchoParam) {
        this.dataEchoParam = dataEchoParam;
    }

    public void setProductLineInfo(List<JSONObject> productLineInfo) {
        this.productLineInfo = productLineInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatResultVo)) {
            return false;
        }
        ChatResultVo other = (ChatResultVo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Integer this$dimensionCnt = this.getDimensionCnt();
        Integer other$dimensionCnt = other.getDimensionCnt();
        if (this$dimensionCnt == null ? other$dimensionCnt != null : !((Object)this$dimensionCnt).equals(other$dimensionCnt)) {
            return false;
        }
        Integer this$targetSize = this.getTargetSize();
        Integer other$targetSize = other.getTargetSize();
        if (this$targetSize == null ? other$targetSize != null : !((Object)this$targetSize).equals(other$targetSize)) {
            return false;
        }
        Boolean this$scenePermission = this.getScenePermission();
        Boolean other$scenePermission = other.getScenePermission();
        if (this$scenePermission == null ? other$scenePermission != null : !((Object)this$scenePermission).equals(other$scenePermission)) {
            return false;
        }
        Integer this$autoChoiceScene = this.getAutoChoiceScene();
        Integer other$autoChoiceScene = other.getAutoChoiceScene();
        if (this$autoChoiceScene == null ? other$autoChoiceScene != null : !((Object)this$autoChoiceScene).equals(other$autoChoiceScene)) {
            return false;
        }
        Integer this$specialMode = this.getSpecialMode();
        Integer other$specialMode = other.getSpecialMode();
        if (this$specialMode == null ? other$specialMode != null : !((Object)this$specialMode).equals(other$specialMode)) {
            return false;
        }
        String this$intent = this.getIntent();
        String other$intent = other.getIntent();
        if (this$intent == null ? other$intent != null : !this$intent.equals(other$intent)) {
            return false;
        }
        ChatResultCode this$type = this.getType();
        ChatResultCode other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$datasourceId = this.getDatasourceId();
        String other$datasourceId = other.getDatasourceId();
        if (this$datasourceId == null ? other$datasourceId != null : !this$datasourceId.equals(other$datasourceId)) {
            return false;
        }
        String this$client = this.getClient();
        String other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$templateCode = this.getTemplateCode();
        String other$templateCode = other.getTemplateCode();
        if (this$templateCode == null ? other$templateCode != null : !this$templateCode.equals(other$templateCode)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        JSONArray this$dimension = this.getDimension();
        JSONArray other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$finallyQuestion = this.getFinallyQuestion();
        String other$finallyQuestion = other.getFinallyQuestion();
        if (this$finallyQuestion == null ? other$finallyQuestion != null : !this$finallyQuestion.equals(other$finallyQuestion)) {
            return false;
        }
        String this$combinationQuestion = this.getCombinationQuestion();
        String other$combinationQuestion = other.getCombinationQuestion();
        if (this$combinationQuestion == null ? other$combinationQuestion != null : !this$combinationQuestion.equals(other$combinationQuestion)) {
            return false;
        }
        String this$noneHistory = this.getNoneHistory();
        String other$noneHistory = other.getNoneHistory();
        if (this$noneHistory == null ? other$noneHistory != null : !this$noneHistory.equals(other$noneHistory)) {
            return false;
        }
        String this$sceneCode = this.getSceneCode();
        String other$sceneCode = other.getSceneCode();
        if (this$sceneCode == null ? other$sceneCode != null : !this$sceneCode.equals(other$sceneCode)) {
            return false;
        }
        List this$scenes = this.getScenes();
        List other$scenes = other.getScenes();
        if (this$scenes == null ? other$scenes != null : !((Object)this$scenes).equals(other$scenes)) {
            return false;
        }
        List this$targets = this.getTargets();
        List other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        List this$sentences = this.getSentences();
        List other$sentences = other.getSentences();
        if (this$sentences == null ? other$sentences != null : !((Object)this$sentences).equals(other$sentences)) {
            return false;
        }
        List this$eocMaps = this.getEocMaps();
        List other$eocMaps = other.getEocMaps();
        if (this$eocMaps == null ? other$eocMaps != null : !((Object)this$eocMaps).equals(other$eocMaps)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$pointLog = this.getPointLog();
        String other$pointLog = other.getPointLog();
        if (this$pointLog == null ? other$pointLog != null : !this$pointLog.equals(other$pointLog)) {
            return false;
        }
        String this$RHErrorLog = this.getRHErrorLog();
        String other$RHErrorLog = other.getRHErrorLog();
        if (this$RHErrorLog == null ? other$RHErrorLog != null : !this$RHErrorLog.equals(other$RHErrorLog)) {
            return false;
        }
        String this$questionUnderstand = this.getQuestionUnderstand();
        String other$questionUnderstand = other.getQuestionUnderstand();
        if (this$questionUnderstand == null ? other$questionUnderstand != null : !this$questionUnderstand.equals(other$questionUnderstand)) {
            return false;
        }
        AgileDataEchoSchema this$dataEchoSchema = this.getDataEchoSchema();
        AgileDataEchoSchema other$dataEchoSchema = other.getDataEchoSchema();
        if (this$dataEchoSchema == null ? other$dataEchoSchema != null : !this$dataEchoSchema.equals(other$dataEchoSchema)) {
            return false;
        }
        AgileDataEchoParam this$dataEchoParam = this.getDataEchoParam();
        AgileDataEchoParam other$dataEchoParam = other.getDataEchoParam();
        if (this$dataEchoParam == null ? other$dataEchoParam != null : !this$dataEchoParam.equals(other$dataEchoParam)) {
            return false;
        }
        List this$productLineInfo = this.getProductLineInfo();
        List other$productLineInfo = other.getProductLineInfo();
        return !(this$productLineInfo == null ? other$productLineInfo != null : !((Object)this$productLineInfo).equals(other$productLineInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatResultVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Integer $dimensionCnt = this.getDimensionCnt();
        result = result * 59 + ($dimensionCnt == null ? 43 : ((Object)$dimensionCnt).hashCode());
        Integer $targetSize = this.getTargetSize();
        result = result * 59 + ($targetSize == null ? 43 : ((Object)$targetSize).hashCode());
        Boolean $scenePermission = this.getScenePermission();
        result = result * 59 + ($scenePermission == null ? 43 : ((Object)$scenePermission).hashCode());
        Integer $autoChoiceScene = this.getAutoChoiceScene();
        result = result * 59 + ($autoChoiceScene == null ? 43 : ((Object)$autoChoiceScene).hashCode());
        Integer $specialMode = this.getSpecialMode();
        result = result * 59 + ($specialMode == null ? 43 : ((Object)$specialMode).hashCode());
        String $intent = this.getIntent();
        result = result * 59 + ($intent == null ? 43 : $intent.hashCode());
        ChatResultCode $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $datasourceId = this.getDatasourceId();
        result = result * 59 + ($datasourceId == null ? 43 : $datasourceId.hashCode());
        String $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $templateCode = this.getTemplateCode();
        result = result * 59 + ($templateCode == null ? 43 : $templateCode.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        JSONArray $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $finallyQuestion = this.getFinallyQuestion();
        result = result * 59 + ($finallyQuestion == null ? 43 : $finallyQuestion.hashCode());
        String $combinationQuestion = this.getCombinationQuestion();
        result = result * 59 + ($combinationQuestion == null ? 43 : $combinationQuestion.hashCode());
        String $noneHistory = this.getNoneHistory();
        result = result * 59 + ($noneHistory == null ? 43 : $noneHistory.hashCode());
        String $sceneCode = this.getSceneCode();
        result = result * 59 + ($sceneCode == null ? 43 : $sceneCode.hashCode());
        List $scenes = this.getScenes();
        result = result * 59 + ($scenes == null ? 43 : ((Object)$scenes).hashCode());
        List $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        List $sentences = this.getSentences();
        result = result * 59 + ($sentences == null ? 43 : ((Object)$sentences).hashCode());
        List $eocMaps = this.getEocMaps();
        result = result * 59 + ($eocMaps == null ? 43 : ((Object)$eocMaps).hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $pointLog = this.getPointLog();
        result = result * 59 + ($pointLog == null ? 43 : $pointLog.hashCode());
        String $RHErrorLog = this.getRHErrorLog();
        result = result * 59 + ($RHErrorLog == null ? 43 : $RHErrorLog.hashCode());
        String $questionUnderstand = this.getQuestionUnderstand();
        result = result * 59 + ($questionUnderstand == null ? 43 : $questionUnderstand.hashCode());
        AgileDataEchoSchema $dataEchoSchema = this.getDataEchoSchema();
        result = result * 59 + ($dataEchoSchema == null ? 43 : $dataEchoSchema.hashCode());
        AgileDataEchoParam $dataEchoParam = this.getDataEchoParam();
        result = result * 59 + ($dataEchoParam == null ? 43 : $dataEchoParam.hashCode());
        List $productLineInfo = this.getProductLineInfo();
        result = result * 59 + ($productLineInfo == null ? 43 : ((Object)$productLineInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ChatResultVo(intent=" + this.getIntent() + ", code=" + this.getCode() + ", type=" + this.getType() + ", datasourceId=" + this.getDatasourceId() + ", client=" + this.getClient() + ", templateCode=" + this.getTemplateCode() + ", target=" + this.getTarget() + ", dimension=" + this.getDimension() + ", dimensionCnt=" + this.getDimensionCnt() + ", finallyQuestion=" + this.getFinallyQuestion() + ", combinationQuestion=" + this.getCombinationQuestion() + ", noneHistory=" + this.getNoneHistory() + ", sceneCode=" + this.getSceneCode() + ", scenes=" + this.getScenes() + ", targets=" + this.getTargets() + ", targetSize=" + this.getTargetSize() + ", method=" + this.getMethod() + ", scenePermission=" + this.getScenePermission() + ", sentences=" + this.getSentences() + ", eocMaps=" + this.getEocMaps() + ", data=" + this.getData() + ", pointLog=" + this.getPointLog() + ", RHErrorLog=" + this.getRHErrorLog() + ", autoChoiceScene=" + this.getAutoChoiceScene() + ", questionUnderstand=" + this.getQuestionUnderstand() + ", specialMode=" + this.getSpecialMode() + ", dataEchoSchema=" + this.getDataEchoSchema() + ", dataEchoParam=" + this.getDataEchoParam() + ", productLineInfo=" + this.getProductLineInfo() + ")";
    }

    static {
        opMap.put("eq", "\u7b49\u4e8e");
        opMap.put("neq", "\u4e0d\u7b49\u4e8e");
        opMap.put("gt", "\u5927\u4e8e");
        opMap.put("gte", "\u5927\u4e8e\u7b49\u4e8e");
        opMap.put("lt", "\u5c0f\u4e8e");
        opMap.put("lte", "\u5c0f\u4e8e\u7b49\u4e8e");
        opMap.put("ne", "\u4e0d\u7b49\u4e8e");
    }
}

