/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.reasoning.search.config.KnowledgemapsHostConfig;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class KnowledgemapsServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(KnowledgemapsServiceInvoker.class);
    @Autowired
    private KnowledgemapsHostConfig knowledgemapsHostConfig;
    @Autowired
    private RestTemplate restTemplate;
    private static final String HISTORY_MESSAGE_URL = "/restful/service/knowledgegraph/tenant/appsInfo";
    private static final String USER_APP_AUTH_URL = "/restful/service/knowledgegraph/tenant/userAppAuth";
    private static final String KMSCENE_CODE_URL = "/restful/service/knowledgegraph/scene/querySceneByTemplateAndTarget";
    private static final String SCENE_SCHEMA_URL = "/restful/service/knowledgegraph/scene/sceneSchema";
    private static final String QUERY_SCENEMAPS_URL = "/restful/service/knowledgegraph/scene/querySceneMaps";
    private static final String PERMISSION_METRIC_SCENE_URL = "/restful/service/knowledgegraph/tenant/queryPermissionSceneByCode";
    private static final String APPLICATIONSBYCODES_URL = "/restful/service/knowledgegraph/app/queryApplicationsNameByCodeList";
    private static final String TOKEN = "token";
    private static final String LOCALE = "locale";
    private String ERR_MESSAGE = "\u67e5\u8be2km\u7cfb\u7edf\u5f02\u5e38";
    private static final String ROUTERKEY = "routerKey";

    public JSONObject getTenantAppAndVersion(String token, String routerKey) throws BussinessException {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BussinessException("\u67e5\u8be2\u79df\u6237\u5e94\u7528\u548c\u7248\u672ctoken\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.knowledgemapsHostConfig.getUrl().concat(HISTORY_MESSAGE_URL), HttpMethod.GET, entity, JSONObject.class, new Object[0]);
            log.info("getTenantAppAndVersion responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return (JSONObject)responseEntity.getBody();
            }
            log.info("\u67e5\u8be2\u79df\u6237\u5e94\u7528\u548c\u7248\u672c\u5931\u8d25:{}", (Object)Optional.ofNullable(responseEntity.getBody()).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u79df\u6237\u5e94\u7528\u548c\u7248\u672c\u5931\u8d25\uff1a{} ", (Throwable)e2);
        }
        return null;
    }

    public List<JSONObject> getKmScenes(Map<String, Object> params, String locale, String token, String routerKey, JSONObject context) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)locale)) {
            headers.add(LOCALE, locale);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(params), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.knowledgemapsHostConfig.getUrl().concat(KMSCENE_CODE_URL), (Object)httpEntity, String.class, new Object[0]);
            log.info("getKmScenesresponseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
                Object response = JSONObject.parseObject((String)((String)responseEntity.getBody())).get((Object)"response");
                ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
                String version = context.getString("version");
                if (response instanceof JSONArray) {
                    JSONArray response1 = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("response");
                    response1.stream().filter(res -> {
                        if (CollectionUtils.isEmpty((Collection)applicationCodes) || StringUtils.isBlank((CharSequence)version)) {
                            return false;
                        }
                        return applicationCodes.contains(((JSONObject)res).getString("appCode")) && version.equals(((JSONObject)res).getString("version"));
                    }).forEach(res -> {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("sceneCode", (Object)((JSONObject)res).getString("code"));
                        jsonObject.put("sceneTitle", (Object)((JSONObject)res).getString("sceneTitle"));
                        jsonObject.put("appCode", (Object)((JSONObject)res).getString("appCode"));
                        jsonObject.put("billingGoodsId", (Object)((JSONObject)res).getString("billingGoodsId"));
                        List productLines = (List)((JSONObject)res).getOrDefault((Object)"productLine", new ArrayList());
                        jsonObject.put("productLine", (Object)productLines);
                        context.getString("applicationCodes");
                        jsonObjects.add(jsonObject);
                    });
                } else {
                    JSONObject res2 = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response");
                    if (!Objects.isNull(res2)) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("sceneCode", (Object)res2.getString("code"));
                        jsonObject.put("sceneTitle", (Object)res2.getString("sceneTitle"));
                        jsonObject.put("appCode", (Object)res2.getString("appCode"));
                        jsonObjects.add(jsonObject);
                    }
                }
                return jsonObjects;
            }
            log.info("\u83b7\u53d6KM\u573a\u666f\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u83b7\u53d6KM\u573a\u666f\u5931\u8d25", params, e2});
        }
        return null;
    }

    public List<JSONObject> getKmScenes(JSONObject params, String locale) {
        if (Objects.isNull(params) || StringUtils.isEmpty((CharSequence)params.getString("templateCode")) || StringUtils.isEmpty((CharSequence)params.getString("targetId")) || CollectionUtils.isEmpty((Collection)((List)params.getOrDefault((Object)"applicationCodes", new ArrayList()))) || StringUtils.isEmpty((CharSequence)params.getString("version"))) {
            log.error("getKmScenes\u5165\u53c2\u5f02\u5e38");
            return null;
        }
        try {
            params.put("checkDimension", (Object)"1");
            List scenes = Optional.ofNullable(Retrieve.SCENE.retrieve(params)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)scenes)) {
                ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
                scenes.stream().forEach(res -> {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("sceneCode", (Object)res.getString("sceneCode"));
                    jsonObject.put("sceneTitle", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)res.getString("sceneTitle")) : ZhConverterUtil.toSimple((String)res.getString("sceneTitle"))));
                    jsonObject.put("appCode", (Object)res.getString("applicationCode"));
                    jsonObject.put("appName", (Object)res.getString("applicationName"));
                    jsonObject.put("billingGoodsId", (Object)res.getString("billingGoodsId"));
                    List productLines = (List)res.getOrDefault((Object)"productLine", new ArrayList());
                    jsonObject.put("productLine", (Object)productLines);
                    jsonObjects.add(jsonObject);
                });
                return jsonObjects;
            }
            log.info("\u83b7\u53d6KM\u573a\u666f\u4e3a\u7a7a");
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u83b7\u53d6KM\u573a\u666f\u5931\u8d25", params, e});
        }
        return null;
    }

    public JSONObject getSchemasBySceneCode(Map<String, Object> params, String token, String routerKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.knowledgemapsHostConfig.getUrl().concat(SCENE_SCHEMA_URL).concat("?sceneCode=").concat(params.get("sceneCode").toString()), HttpMethod.GET, entity, String.class, new Object[0]);
            log.info("getSchemasBySceneCode responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONArray collect = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("response").stream().flatMap(res -> {
                    JSONArray jsonArray = Optional.ofNullable(((JSONObject)res).getJSONArray("schemas")).orElse(new JSONArray());
                    return jsonArray.stream();
                }).collect(Collectors.toCollection(JSONArray::new));
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCode", (Object)((JSONObject)JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("response").get(0)).getString("appCode"));
                jsonObject.put("version", (Object)((JSONObject)JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("response").get(0)).getString("version"));
                jsonObject.put("schemas", (Object)collect);
                return jsonObject;
            }
            log.info("\u6839\u636e\u573a\u666f\u7f16\u7801\u83b7\u53d6schemas\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("\u6839\u636e\u573a\u666f\u7f16\u7801\u83b7\u53d6schemas\u5931\u8d25\uff1a{} ", (Throwable)e2);
        }
        return null;
    }

    public JSONObject getSchemasBySceneCode(String sceneCode, JSONObject context) {
        if (StringUtils.isEmpty((CharSequence)sceneCode)) {
            log.error("getSchemasBySceneCode\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        try {
            JSONObject params = new JSONObject();
            List applicationCodes = (List)context.getObject("applicationCodes", List.class);
            params.put("sceneCode", (Object)sceneCode);
            params.put("version", (Object)context.getString("version"));
            params.put("applicationCodes", (Object)applicationCodes);
            List scenes = Optional.ofNullable(Retrieve.SCENE.retrieve(params)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)scenes)) {
                JSONArray collect = scenes.stream().flatMap(res -> {
                    JSONArray jsonArray = Optional.ofNullable(res.getJSONArray("schemas")).orElse(new JSONArray());
                    return jsonArray.stream();
                }).collect(Collectors.toCollection(JSONArray::new));
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCode", (Object)((JSONObject)scenes.get(0)).getString("applicationCode"));
                jsonObject.put("version", (Object)((JSONObject)scenes.get(0)).getString("version"));
                jsonObject.put("schemas", (Object)collect);
                return jsonObject;
            }
            log.info("\u6839\u636e\u573a\u666f\u7f16\u7801\u83b7\u53d6schemas\u4e3a\u7a7a");
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u573a\u666f\u7f16\u7801\u83b7\u53d6schemas\u5931\u8d25\uff1a{} ", (Throwable)e);
        }
        return null;
    }

    public JSONObject getUserAppAndVersion(String token, String routerKey, String userId) throws BussinessException {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BussinessException("\u67e5\u8be2\u7528\u6237\u5e94\u7528\u548c\u7248\u672ctoken\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add(ROUTERKEY, routerKey);
        }
        log.info("KnowledgemapsServiceInvoker userId is exist: {}", (Object)userId);
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = null;
            responseEntity = StringUtils.isNotEmpty((CharSequence)userId) ? this.restTemplate.exchange(this.knowledgemapsHostConfig.getUrl().concat(USER_APP_AUTH_URL).concat("?userId=").concat(userId), HttpMethod.GET, entity, JSONObject.class, new Object[0]) : this.restTemplate.exchange(this.knowledgemapsHostConfig.getUrl().concat(USER_APP_AUTH_URL), HttpMethod.GET, entity, JSONObject.class, new Object[0]);
            log.info("getUserAppAndVersion responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return (JSONObject)responseEntity.getBody();
            }
            log.info("\u67e5\u8be2\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u5931\u8d25:{}", (Object)Optional.ofNullable(responseEntity.getBody()).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.knowledgemapsHostConfig.getUrl().concat(USER_APP_AUTH_URL), HttpMethod.GET, entity, JSONObject.class, new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return (JSONObject)responseEntity.getBody();
            }
            log.info("\u67e5\u8be2\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u5931\u8d25:{}", (Object)Optional.ofNullable(responseEntity.getBody()).map(e1 -> e1.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        return null;
    }

    public JSONObject querySceneMaps(Map<String, Object> params, String token, String routerKey, JSONObject context) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(params), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntityStr = this.restTemplate.postForEntity(this.knowledgemapsHostConfig.getUrl().concat(QUERY_SCENEMAPS_URL), (Object)httpEntity, String.class, new Object[0]);
            log.info("querySceneMaps responseEntity\uff1a{}", responseEntityStr.getBody());
            if (responseEntityStr.getStatusCode().is2xxSuccessful()) {
                ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
                String version = context.getOrDefault((Object)"version", (Object)"").toString();
                JSONObject response = JSONObject.parseObject((String)((String)responseEntityStr.getBody())).getJSONObject("response");
                if (Objects.isNull(response)) {
                    log.info("\u67e5\u8be2\u5230\u7684\u573a\u666f\u4e3a\u7a7a");
                    return null;
                }
                if (!applicationCodes.contains(response.getString("appCode")) || !version.equals(response.getString("version"))) {
                    log.info("\u67e5\u8be2\u5230\u7684\u573a\u666f\u548c\u7528\u6237\u5e94\u7528\u7248\u672c\u4e0d\u5339\u914d");
                    return null;
                }
                response.put("applicationCode", (Object)response.getString("appCode"));
                return response;
            }
            log.info("\u67e5\u8be2\u573a\u666f\u8be6\u60c5\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntityStr.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u67e5\u8be2\u573a\u666f\u8be6\u60c5\u5931\u8d25", params, e2});
        }
        return null;
    }

    public JSONObject querySceneMaps(JSONObject params) {
        if (Objects.isNull(params) || StringUtils.isEmpty((CharSequence)params.getString("sceneCode")) || CollectionUtils.isEmpty((Collection)((List)params.getOrDefault((Object)"applicationCodes", new ArrayList()))) || StringUtils.isEmpty((CharSequence)params.getString("version"))) {
            log.error("querySceneMaps\u5165\u53c2\u5f02\u5e38");
            return null;
        }
        try {
            List scenes = Optional.ofNullable(Retrieve.SCENE.retrieve(params)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)scenes)) {
                if (scenes.size() > 1) {
                    log.error("querySceneMaps\u67e5\u8be2\u5230\u591a\u4e2a\u573a\u666f");
                }
                return (JSONObject)scenes.get(0);
            }
            log.info("\u67e5\u8be2\u573a\u666f\u8be6\u60c5\u4e3a\u7a7a");
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u67e5\u8be2\u573a\u666f\u8be6\u60c5\u5931\u8d25", params, e});
        }
        return null;
    }

    public JSONObject queryPermissionSceneOrMetric(String token, String routerKey, String userId, List<String> appCodes, List<String> metricOrSceneCodes) throws Exception {
        log.info("queryPermissionSceneOrMetric queryMetricOrScene appCodes={},metricOrSceneCodes={}", appCodes, metricOrSceneCodes);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BussinessException("\u67e5\u8be2\u7528\u6237\u6307\u6807\u548c\u573a\u666ftoken\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        headers.add(TOKEN, token);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("appCodes", appCodes);
        params.put("codes", metricOrSceneCodes);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.knowledgemapsHostConfig.getUrl().concat(PERMISSION_METRIC_SCENE_URL), HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
            log.info("queryPermissionSceneOrMetric responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return (JSONObject)responseEntity.getBody();
            }
            log.info("queryPermissionSceneOrMetric \u83b7\u53d6\u7528\u6237\u6307\u6807\u573a\u666f\u6743\u9650\u5931\u8d25:{}", (Object)Optional.ofNullable(responseEntity.getBody()).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (RestClientException e2) {
            log.error("queryPermissionSceneOrMetric \u83b7\u53d6\u7528\u6237\u6307\u6807\u573a\u666f\u6743\u9650\u62a5\u9519\uff1a{} ", (Object)e2.getMessage());
        }
        return null;
    }

    public List<JSONObject> queryApplicationName(String token, List<String> appCodes) throws BussinessException {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BussinessException("\u67e5\u8be2\u5e94\u7528\u540d\u79f0token\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codes", appCodes);
        params.put("appType", 6);
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(params), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntityStr = this.restTemplate.postForEntity(this.knowledgemapsHostConfig.getUrl().concat(APPLICATIONSBYCODES_URL), (Object)httpEntity, String.class, new Object[0]);
            log.info("queryApplicationName responseEntity\uff1a{}", responseEntityStr.getBody());
            if (responseEntityStr.getStatusCode().is2xxSuccessful()) {
                List response = (List)JSONObject.parseObject((String)((String)responseEntityStr.getBody())).getObject("response", List.class);
                if (Objects.isNull(response)) {
                    log.info("\u67e5\u8be2\u5230\u7684\u5e94\u7528\u540d\u79f0\u4e3a\u7a7a");
                    return null;
                }
                return response;
            }
            log.info("\u67e5\u8be2\u5e94\u7528\u540d\u79f0\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntityStr.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u67e5\u8be2\u5e94\u7528\u540d\u79f0\u5931\u8d25", params, e2});
        }
        return null;
    }
}

