/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.entity.UserReportRelationEntity;
import com.digiwin.chatbi.beans.entity.UserReportsEntity;
import com.digiwin.chatbi.beans.pojos.QuestionLite;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.util.CommonUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.mapper.mysql.onlyRead.ReportReadMapper;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.ReportService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSheetTable4LiteExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(CheckSheetTable4LiteExecutor.class);
    public static final String LINE_BREAK = "\n\n";

    public Output doProcess(JSONObject context) {
        boolean isMultiDialogue = ((QuestionLite)context.getObject("question", QuestionLite.class)).isMultiDialogue();
        String tableId = ((QuestionLite)context.getObject("question", QuestionLite.class)).getTableId();
        if (StringUtils.isNotBlank((CharSequence)tableId) && !isMultiDialogue) {
            return Output.through((String)"gpt_chose_table", (Object)"N");
        }
        context.put("userQuestion", (Object)((QuestionLite)context.getObject("question", QuestionLite.class)).getMessage());
        if (StringUtils.isNotBlank((CharSequence)tableId)) {
            String tableName = ((QuestionLite)context.getObject("question", QuestionLite.class)).getTableName();
            return Output.through((String)"checkSheetDatasource", (Object)this.buildGtpParam(tableId, tableName)).keep("gpt_chose_table", (Object)"Y");
        }
        List userReportsList = null;
        Integer useDemo = ((QuestionLite)context.getObject("question", QuestionLite.class)).getUseDemo();
        if (Constants.LITE_USE_DEMO.equals(useDemo)) {
            ReportService reportService = (ReportService)SpringContextUtil.getBean(ReportService.class);
            String fileUrl = ((QuestionLite)context.getObject("question", QuestionLite.class)).getFileUrl();
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                return null;
            }
            List userReportRelationEntities = reportService.selectCommonReport(fileUrl);
            if (CollectionUtils.isNotEmpty((Collection)userReportRelationEntities)) {
                Integer relationId = ((UserReportRelationEntity)userReportRelationEntities.get(0)).getId();
                userReportsList = reportService.selectReportByRelationId(relationId);
            }
        } else {
            userReportsList = this.getUserReportsByUseIdAndTenantId(context);
            if (userReportsList != null) {
                userReportsList.removeAll(Collections.singleton(null));
            }
        }
        if (CollectionUtils.isEmpty((Collection)userReportsList)) {
            return Output.through((String)"gpt_chose_table", (Object)"N");
        }
        context.put("sheet_list_info", (Object)userReportsList);
        context.put("gpt_chose_table", (Object)"Y");
        StringBuilder bf = new StringBuilder();
        for (UserReportsEntity userReportsEntity : userReportsList) {
            String tableName = userReportsEntity.getTableName();
            String sheetName = userReportsEntity.getSheetName();
            bf.append(this.buildGtpParam(tableName, sheetName));
        }
        return Output.through((String)"checkSheetDatasource", (Object)bf.toString());
    }

    private String buildGtpParam(String tableName, String sheetName) {
        ReportReadMapper reportReadMapper = (ReportReadMapper)SpringContextUtil.getBean(ReportReadMapper.class);
        String tableDDL = "";
        String exampleDataStr = "";
        List tableSchemaList = null;
        try {
            Map createTableSQL = reportReadMapper.getCreatTableSQL(tableName);
            if (!createTableSQL.isEmpty()) {
                tableDDL = (String)createTableSQL.get("Create Table");
            }
            tableSchemaList = reportReadMapper.queryTableStructureInfo(tableName);
            Integer count = reportReadMapper.getCount(tableName);
            List sampleIndexs = StringUtil.fetchBalancedSampleIndexs((int)count, (int)5);
            List exampleDataList = reportReadMapper.getExampleData(tableName, sampleIndexs.stream().map(String::valueOf).collect(Collectors.joining(", ", "(", ")")));
            this.buildExampleData(tableSchemaList, exampleDataList);
            exampleDataStr = CommonUtil.mapToString((List)exampleDataList);
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5GPT\u793a\u4f8b\u6570\u636e\u5931\u8d25\uff1a{} ", (Object)e.getMessage());
        }
        return tableDDL + LINE_BREAK + "#" + sheetName + "#" + LINE_BREAK + exampleDataStr + LINE_BREAK;
    }

    private List<UserReportsEntity> getUserReportsByUseIdAndTenantId(JSONObject context) {
        List userReportsList = null;
        try {
            String userId = context.getString("userId");
            String tenantId = context.getString("tenantId");
            log.info("\u6839\u636etenantId userId\u67e5\u8be2\u7528\u6237\u591asheet\u53c2\u6570\uff1auserId:{},tenantId:{}", (Object)userId, (Object)tenantId);
            if (userId == null || tenantId == null) {
                return null;
            }
            ReportService reportService = (ReportService)SpringContextUtil.getBean(ReportService.class);
            userReportsList = reportService.getUserReportsByUseIdAndTenantId(userId, tenantId);
        }
        catch (Exception e) {
            log.error("\u6839\u636etenantId userId\u67e5\u8be2\u7528\u6237\u591asheet\u5931\u8d25\uff1a{} ", (Object)e.getMessage());
        }
        return userReportsList;
    }

    private void buildExampleData(List<LinkedHashMap<String, Object>> tableSchemaList, List<LinkedHashMap<String, Object>> exampleDataList) {
        if (CollectionUtils.isNotEmpty(exampleDataList)) {
            HashMap<String, String> schemaMap = new HashMap<String, String>();
            for (LinkedHashMap<String, Object> tableSchema : tableSchemaList) {
                String field = (String)tableSchema.get("field");
                String comment = (String)tableSchema.get("comment");
                schemaMap.put(field, comment != null && !comment.isEmpty() ? comment : field);
            }
            LinkedHashMap fieldComment = new LinkedHashMap();
            exampleDataList.get(0).keySet().forEach(key -> {
                String comment = schemaMap.getOrDefault(key, (String)key);
                fieldComment.put(key, comment);
            });
            exampleDataList.add(0, fieldComment);
        }
    }
}

