/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.constant.SolutionStepConstants;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.MessageUtils;
import com.github.houbb.opencc4j.util.ZhTwConverterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyConvertorWrapperExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(EasyConvertorWrapperExecutor.class);
    public static final String NL2SQL_EASY = "nl2ele_easy";
    public static final Pattern dateFormatContentPattern = Pattern.compile("DateFormat\\(([^)]+)\\)");
    public static final Pattern overPattern = Pattern.compile("(?i)\\b(\\w+)\\s*\\(.*?\\)\\s+over\\s*\\(\\s*(.*?)\\s*\\)");
    public static final Pattern partitionPattern = Pattern.compile("(?i)partition\\s+by\\s+(.*?)(?=\\s+(order\\s+by|\\)))");
    public static final Pattern orderPattern = Pattern.compile("(?i)order\\s+by\\s+(?:\\w+\\(\\s*(\\w+)\\s*,.*?\\)|(\\w+))\\s*(asc|desc)?\\s*\\)");

    public Output testEasySql() {
        JSONArray solutionStep = new JSONArray();
        JSONObject context = new JSONObject();
        String s = "{\"F\":\"DS202506261355411mB9s26J\",\"S\":[\"repayment_method\",\"Sum(repayment_amount)#Total_repayment_amount#\u56de\u6b3e\u91d1\u989d\u603b\u548c\"],\"G\":[\"repayment_method\"],\"mainDimension\":\"repayment_method\",\"timeDimension\":[],\"T\":\"\u4e0d\u540c\u56de\u6b3e\u65b9\u5f0f\u7684\u56de\u6b3e\u91d1\u989d\u603b\u548c\",\"V\":\"0\"}";
        JSONObject GPTEasyJson = JSONObject.parseObject((String)s);
        try {
            if (null == GPTEasyJson) {
                return Output.finish((String)"success", (Object)false);
            }
            if (GPTEasyJson.containsKey((Object)"R")) {
                log.error("analysis GPT JSON is error {}", (Object)GPTEasyJson.getString("R"));
                context.put("metric_schema_info_miss", (Object)1);
                return Output.finish((String)"success", (Object)false);
            }
            log.info("gpt output GPTEasyJson {}", (Object)GPTEasyJson);
            String jsonString = GPTEasyJson.toJSONString();
            if (jsonString.contains("CASE WHEN")) {
                log.error("GPT JSON has caseWhen== {}", (Object)GPTEasyJson);
                return Output.finish((String)"success", (Object)false);
            }
            JSONObject easySqlJson = (JSONObject)JSON.parseObject((String)jsonString, JSONObject.class);
            context.put("orgOutPutSql", (Object)easySqlJson);
            log.info("after java supplement easySqlJson {}", (Object)easySqlJson);
            ConvertorJsonCommonMethod.buildSynonymsMap((JSONObject)context);
            JSONObject step = new JSONObject();
            if (easySqlJson.containsKey((Object)"F")) {
                this.processTableInfo(step, easySqlJson.getString("F"), context);
                JSONArray metricInfo = step.getJSONArray("metricInfo");
                if (CollectionUtils.isEmpty((Collection)metricInfo)) {
                    return Output.finish((String)"success", (Object)false);
                }
            }
            HashMap supplementSelectOrderMap = new HashMap();
            this.supplementGPTGroupElement(easySqlJson);
            log.info("after java supplement easySqlJson {}", (Object)easySqlJson);
            Boolean convertIsError = false;
            if (CollectionUtils.isNotEmpty((Collection)easySqlJson.getJSONArray("S"))) {
                convertIsError = this.processSelect(easySqlJson.getJSONArray("S"), step, context, convertIsError);
                if (convertIsError.booleanValue()) {
                    return Output.finish((String)"success", (Object)false);
                }
                ConvertorJsonCommonMethod.setDimensionCount((JSONObject)step, (JSONObject)context);
                this.newFieldPutInFront(step, supplementSelectOrderMap);
            }
            this.buildFilter(context, easySqlJson, step);
            ConvertorJsonCommonMethod.buildSimpleShowDefine((JSONObject)context, (JSONObject)easySqlJson);
            this.processGroupBy(step, easySqlJson.getJSONArray("G"));
            if (easySqlJson.containsKey((Object)"H") && Objects.nonNull(easySqlJson.getJSONObject("H"))) {
                JSONObject havingJson = new JSONObject();
                this.processFilterOrHaving(easySqlJson.getJSONObject("H"), havingJson, step, false, context);
                if (!havingJson.isEmpty()) {
                    step.put("having", (Object)havingJson);
                }
            }
            this.processOrderBy(easySqlJson, step);
            ConvertorJsonCommonMethod.processLimit((JSONObject)easySqlJson, (JSONObject)step);
            step.remove((Object)"metricInfo");
            if (context.containsKey((Object)"synonymsMap")) {
                step.remove((Object)"synon2Detail");
            }
            step.put("alias", (Object)this.getMetricId(step));
            if (ConvertorJsonCommonMethod.checkIsNeedAddSort((JSONObject)step) && !ConvertorJsonCommonMethod.checkEasyIsDetailSelect((JSONObject)easySqlJson)) {
                ConvertorJsonCommonMethod.addDefaultSort((JSONObject)step);
            }
            solutionStep.add((Object)step);
            if (solutionStep.size() > 0) {
                JSONArray select = solutionStep.getJSONObject(solutionStep.size() - 1).getJSONArray("select");
                if (CollectionUtils.isEmpty((Collection)select)) {
                    return Output.finish((String)"success", (Object)false);
                }
                ConvertorJsonCommonMethod.reBuildSorts((JSONArray)solutionStep, (JSONArray)select);
                List timeDimension = (List)easySqlJson.getOrDefault((Object)"timeDimension", new ArrayList());
                context.put("dataTag", (Object)ConvertorJsonCommonMethod.buildFieldTypeInDataTag((List)((List)context.getOrDefault((Object)"dataTag", new ArrayList())), (JSONArray)select, (List)timeDimension, (String)SolutionStepConstants.IS_TIME));
                String mainDimension = easySqlJson.getString("mainDimension");
                if (StringUtils.isNotEmpty((CharSequence)mainDimension)) {
                    context.put("dataTag", (Object)ConvertorJsonCommonMethod.buildFieldTypeInDataTag((List)((List)context.getOrDefault((Object)"dataTag", new ArrayList())), (JSONArray)select, Arrays.asList(mainDimension), (String)SolutionStepConstants.IS_MAIN_DIMENSION));
                }
            }
        }
        catch (Exception e) {
            if (e instanceof BussinessException && "checkFieldIsFalse".equals(e.getMessage())) {
                return Output.finish((String)"success", (Object)false);
            }
            log.error("easy type convertor error: ", (Throwable)e);
        }
        return Output.through((String)"solutionStep", (Object)solutionStep);
    }

    public Output doProcess(JSONObject context) {
        JSONArray solutionStep = new JSONArray();
        String name = NL2SQL_EASY;
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        String replyKey = "message.scrumbi.gpt.analysis.question.error";
        if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            name = name + "_V1";
            replyKey = "message.scrumbi.gpt.analysis.dataset.question.error";
        } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            name = name + "_V2";
            replyKey = "message.scrumbi.gpt.analysis.dataset.question.error";
        }
        JSONObject GPTEasyJson = context.getJSONObject(name);
        JSONArray finalMetric = context.getJSONArray("final_metric");
        if (context.containsKey((Object)"scelect_dataSet")) {
            finalMetric = context.getJSONArray("final_dataSet");
        }
        List mertricNames = finalMetric.stream().map(metric -> ((JSONObject)metric).getString("metricName")).collect(Collectors.toList());
        MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        String param = mertricNames.toString();
        String reply = messageUtils.getMessageByLangNameWithFormat(replyKey, locale, new Object[]{param});
        try {
            if (null == GPTEasyJson) {
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
            }
            if (GPTEasyJson.containsKey((Object)"R")) {
                log.error("analysis GPT JSON is error {}", (Object)GPTEasyJson.getString("R"));
                context.put("metric_schema_info_miss", (Object)1);
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
            }
            log.info("gpt output GPTEasyJson {}", (Object)GPTEasyJson);
            String jsonString = GPTEasyJson.toJSONString();
            if (jsonString.contains("CASE WHEN")) {
                log.error("GPT JSON has caseWhen== {}", (Object)GPTEasyJson);
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
            }
            JSONObject easySqlJson = (JSONObject)JSON.parseObject((String)jsonString, JSONObject.class);
            context.put("orgOutPutSql", (Object)easySqlJson);
            log.info("after java supplement easySqlJson {}", (Object)easySqlJson);
            ConvertorJsonCommonMethod.buildSynonymsMap((JSONObject)context);
            JSONObject step = new JSONObject();
            if (easySqlJson.containsKey((Object)"F")) {
                this.processTableInfo(step, easySqlJson.getString("F"), context);
                JSONArray metricInfo = step.getJSONArray("metricInfo");
                if (CollectionUtils.isEmpty((Collection)metricInfo)) {
                    return Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                }
            }
            HashMap supplementSelectOrderMap = new HashMap();
            this.supplementGPTGroupElement(easySqlJson);
            log.info("after java supplement easySqlJson {}", (Object)easySqlJson);
            Boolean convertIsError = false;
            if (CollectionUtils.isNotEmpty((Collection)easySqlJson.getJSONArray("S"))) {
                convertIsError = this.processSelect(easySqlJson.getJSONArray("S"), step, context, convertIsError);
                if (convertIsError.booleanValue()) {
                    return Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                }
                ConvertorJsonCommonMethod.setDimensionCount((JSONObject)step, (JSONObject)context);
                this.newFieldPutInFront(step, supplementSelectOrderMap);
            }
            this.buildFilter(context, easySqlJson, step);
            ConvertorJsonCommonMethod.buildSimpleShowDefine((JSONObject)context, (JSONObject)easySqlJson);
            this.processGroupBy(step, easySqlJson.getJSONArray("G"));
            if (easySqlJson.containsKey((Object)"H") && Objects.nonNull(easySqlJson.getJSONObject("H"))) {
                JSONObject havingJson = new JSONObject();
                this.processFilterOrHaving(easySqlJson.getJSONObject("H"), havingJson, step, false, context);
                if (!havingJson.isEmpty()) {
                    step.put("having", (Object)havingJson);
                }
            }
            this.processOrderBy(easySqlJson, step);
            ConvertorJsonCommonMethod.processLimit((JSONObject)easySqlJson, (JSONObject)step);
            step.remove((Object)"metricInfo");
            if (context.containsKey((Object)"synonymsMap")) {
                step.remove((Object)"synon2Detail");
            }
            step.put("alias", (Object)this.getMetricId(step));
            if (ConvertorJsonCommonMethod.checkIsNeedAddSort((JSONObject)step) && !ConvertorJsonCommonMethod.checkEasyIsDetailSelect((JSONObject)easySqlJson)) {
                ConvertorJsonCommonMethod.addDefaultSort((JSONObject)step);
            }
            solutionStep.add((Object)step);
            if (solutionStep.size() > 0) {
                JSONArray select = solutionStep.getJSONObject(solutionStep.size() - 1).getJSONArray("select");
                if (CollectionUtils.isEmpty((Collection)select)) {
                    return Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                }
                ConvertorJsonCommonMethod.reBuildSorts((JSONArray)solutionStep, (JSONArray)select);
                List timeDimension = (List)easySqlJson.getOrDefault((Object)"timeDimension", new ArrayList());
                context.put("dataTag", (Object)ConvertorJsonCommonMethod.buildFieldTypeInDataTag((List)((List)context.getOrDefault((Object)"dataTag", new ArrayList())), (JSONArray)select, (List)timeDimension, (String)SolutionStepConstants.IS_TIME));
                String mainDimension = easySqlJson.getString("mainDimension");
                if (StringUtils.isNotEmpty((CharSequence)mainDimension)) {
                    context.put("dataTag", (Object)ConvertorJsonCommonMethod.buildFieldTypeInDataTag((List)((List)context.getOrDefault((Object)"dataTag", new ArrayList())), (JSONArray)select, Arrays.asList(mainDimension), (String)SolutionStepConstants.IS_MAIN_DIMENSION));
                }
            }
        }
        catch (Exception e) {
            if (e instanceof BussinessException && "checkFieldIsFalse".equals(e.getMessage())) {
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
            }
            log.error("easy type convertor error: ", (Throwable)e);
        }
        return Output.through((String)"solutionStep", (Object)solutionStep);
    }

    private void newFieldPutInFront(JSONObject step, Map<String, Integer> supplementSelectOrderMap) {
        if (supplementSelectOrderMap.isEmpty()) {
            return;
        }
        JSONArray selectList = step.getJSONArray("select");
        if (CollectionUtils.isEmpty((Collection)selectList)) {
            return;
        }
        log.info("before newFieldPutInFront selectList {}", (Object)selectList);
        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
        for (int i = 0; i < selectList.size(); ++i) {
            jsonObjectList.add(selectList.getJSONObject(i));
        }
        try {
            Collections.sort(jsonObjectList, new /* Unavailable Anonymous Inner Class!! */);
            JSONArray sortedJsonObjects = new JSONArray();
            for (JSONObject jsonObject : jsonObjectList) {
                sortedJsonObjects.add((Object)jsonObject);
            }
            log.info("after newFieldPutInFront selectList {}", (Object)sortedJsonObjects);
            step.put("select", (Object)sortedJsonObjects);
        }
        catch (Exception e) {
            log.error("newFieldPutInFront error: ", (Throwable)e);
        }
    }

    private void supplementGPTSelectElement(JSONObject step, JSONObject easySqlJson, Map<String, Integer> supplementSelectOrderMap) {
        if (easySqlJson.containsKey((Object)"W") && Objects.nonNull(easySqlJson.getJSONObject("W"))) {
            JSONObject filterJson = easySqlJson.getJSONObject("W");
            String outLogical = filterJson.containsKey((Object)"and") ? "and" : "or";
            filterJson = ConvertorJsonCommonMethod.getFormatObj((JSONObject)filterJson, (String)outLogical);
            Object logicalJson = filterJson.get((Object)outLogical);
            JSONArray allItem = new JSONArray();
            ArrayList<String> inFieldList = new ArrayList<String>();
            if (logicalJson instanceof JSONObject) {
                JSONArray orItems = ((JSONObject)logicalJson).getJSONArray("or");
                JSONArray andItems = ((JSONObject)logicalJson).getJSONArray("and");
                allItem.add((Object)orItems);
                allItem.add((Object)andItems);
            } else if (logicalJson instanceof JSONArray) {
                allItem = (JSONArray)logicalJson;
            }
            for (int i = 0; i < allItem.size(); ++i) {
                String[] filterItem = ConvertorJsonCommonMethod.customSplit((String)allItem.get(i).toString());
                if (filterItem.length != 4) continue;
                String fieldName = filterItem[0].trim();
                String operate = filterItem[1].trim();
                String dataType = this.getDataType(fieldName, step);
                if (ConvertorJsonCommonMethod.isMeasure((String)dataType) || !"in".equals(operate) && !"not_in".equals(operate)) continue;
                inFieldList.add(fieldName);
            }
            if (CollectionUtils.isEmpty(inFieldList)) {
                return;
            }
            if (CollectionUtils.isNotEmpty((Collection)easySqlJson.getJSONArray("S"))) {
                JSONArray selectArray = easySqlJson.getJSONArray("S");
                if (selectArray.size() == 1 && selectArray.get(0).equals("*")) {
                    return;
                }
                ArrayList selectAliasList = new ArrayList();
                selectArray.forEach(item -> {
                    String[] split = item.toString().split("#");
                    if (split.length == 3) {
                        selectAliasList.add(split[1].trim());
                    } else {
                        selectAliasList.add(split[0].trim());
                    }
                });
                List selectList = selectArray.toJavaList(String.class);
                int count = 1;
                for (String fieldName : inFieldList) {
                    if (selectAliasList.contains(fieldName)) continue;
                    supplementSelectOrderMap.put(fieldName, count);
                    selectList.add(fieldName);
                }
                easySqlJson.put("S", (Object)selectList);
            }
        }
    }

    private void supplementGPTGroupElement(JSONObject easySqlJson) {
        if (CollectionUtils.isNotEmpty((Collection)easySqlJson.getJSONArray("S"))) {
            JSONArray selectArray = easySqlJson.getJSONArray("S");
            if (selectArray.size() == 1 && selectArray.get(0).equals("*")) {
                return;
            }
            boolean hasAggregate = false;
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (int i = 0; i < selectArray.size(); ++i) {
                String[] split = selectArray.get(i).toString().split("#");
                if (split.length == 3) {
                    String aggregate = split[0];
                    if (aggregate.indexOf("(") >= 0) {
                        String aggFunction = aggregate.substring(0, aggregate.indexOf("(")).trim();
                        if (SolutionStepConstants.getGroupByList().contains(aggFunction)) {
                            hasAggregate = true;
                        }
                        if ("DateFormat".equals(aggFunction)) {
                            fieldList.add(split[1]);
                        }
                    } else {
                        selectArray.set(i, (Object)split[0]);
                    }
                }
                if (split.length != 1) continue;
                String fieldName = split[0];
                fieldList.add(fieldName);
            }
            if (!hasAggregate || CollectionUtils.isEmpty(fieldList)) {
                return;
            }
            JSONArray groupArray = easySqlJson.getJSONArray("G");
            if (CollectionUtils.isEmpty((Collection)groupArray)) {
                easySqlJson.put("G", fieldList);
                return;
            }
            ArrayList<String> groupFieldList = new ArrayList<String>();
            for (Object group : groupArray) {
                String groupName = group.toString();
                groupFieldList.add(groupName);
            }
            ArrayList tempFieldList = new ArrayList(fieldList);
            tempFieldList.removeAll(groupFieldList);
            groupFieldList.addAll(tempFieldList);
            easySqlJson.put("G", groupFieldList);
        }
    }

    private void buildFilter(JSONObject context, JSONObject easySqlJson, JSONObject step) {
        JSONObject filterJson = new JSONObject();
        if (easySqlJson.containsKey((Object)"W") && Objects.nonNull(easySqlJson.getJSONObject("W"))) {
            this.processFilterOrHaving(easySqlJson.getJSONObject("W"), filterJson, step, true, context);
        }
        if (!filterJson.isEmpty() && filterJson.containsKey((Object)"children") && CollectionUtils.isNotEmpty((Collection)filterJson.getJSONArray("children"))) {
            step.put("filter", (Object)filterJson);
        }
    }

    private void processOrderBy(JSONObject simpleJson, JSONObject step) throws BussinessException {
        if (simpleJson.containsKey((Object)"O") && CollectionUtils.isNotEmpty((Collection)simpleJson.getJSONArray("O"))) {
            JSONArray sortArray = new JSONArray();
            String metricId = this.getMetricId(step);
            for (Object item : simpleJson.getJSONArray("O")) {
                JSONObject orderByJson = new JSONObject();
                String[] orderByItem = item.toString().split("#");
                String fieldName = orderByItem[0];
                String content = "";
                String dataType = "";
                if (fieldName.startsWith("DateFormat(")) {
                    List contentList = this.getDateFormatContent(fieldName);
                    content = (String)contentList.get(0);
                    String fmtType = (String)contentList.get(1);
                    fieldName = this.processDateCompute(step, content, fmtType);
                    dataType = "string";
                } else {
                    content = fieldName;
                    dataType = this.getDataType(content, step);
                }
                if (ConvertorJsonCommonMethod.checkFieldInSchema((String)content, (JSONObject)step, null)) {
                    throw new BussinessException("checkFieldIsFalse");
                }
                String orderByType = orderByItem[1];
                orderByJson.put("order", (Object)orderByType);
                orderByJson.put("dataObject", (Object)ConvertorJsonCommonMethod.buildDataObject((String)fieldName, (String)metricId, (String)dataType, (String)this.getContentType(step, fieldName)));
                sortArray.add((Object)orderByJson);
            }
            step.put("sort", (Object)sortArray);
        }
    }

    private void processGroupBy(JSONObject step, JSONArray gArray) throws BussinessException {
        if (CollectionUtils.isEmpty((Collection)gArray)) {
            return;
        }
        String metricId = this.getMetricId(step);
        JSONArray groupArray = new JSONArray();
        for (Object item : gArray) {
            JSONObject groupByJson = new JSONObject();
            if (item.toString().startsWith("DateFormat(")) {
                List contentList = this.getDateFormatContent(item.toString());
                String content = (String)contentList.get(0);
                if (ConvertorJsonCommonMethod.checkFieldInSchema((String)content, (JSONObject)step, null)) {
                    throw new BussinessException("checkFieldIsFalse");
                }
                String fmtType = (String)contentList.get(1);
                groupByJson = ConvertorJsonCommonMethod.buildDataObject((String)this.processDateCompute(step, content, fmtType), (String)metricId, (String)"string", (String)"calculate");
                groupByJson.put("alias", (Object)"");
            } else {
                if (ConvertorJsonCommonMethod.checkFieldInSchema((String)item.toString(), (JSONObject)step, null)) {
                    throw new BussinessException("checkFieldIsFalse");
                }
                groupByJson = ConvertorJsonCommonMethod.buildDataObject((String)item.toString(), (String)metricId, (String)this.getDataType(item.toString(), step), (String)this.getContentType(step, item.toString()));
                groupByJson.put("alias", (Object)"");
            }
            groupArray.add((Object)groupByJson);
        }
        if (CollectionUtils.isNotEmpty((Collection)groupArray)) {
            step.put("groupby", (Object)groupArray);
        }
    }

    private void processTableInfo(JSONObject step, String gptMetricId, JSONObject context) {
        JSONArray allMetricInfo = ConvertorJsonCommonMethod.getMetricInfo((JSONObject)context);
        JSONArray metricInfo = new JSONArray();
        allMetricInfo.forEach(item -> {
            JSONObject metricItem = (JSONObject)item;
            String metricId = metricItem.getString("metricId");
            if (metricId.equals(gptMetricId)) {
                metricInfo.add((Object)metricItem);
            }
        });
        if (CollectionUtils.isEmpty((Collection)metricInfo)) {
            log.warn("gptOutPutMetric not in input metricId {},allMetricInfo {}", (Object)gptMetricId, (Object)allMetricInfo);
        }
        if (context.containsKey((Object)"scelect_dataSet")) {
            context.put("final_dataSet", (Object)metricInfo);
        } else {
            context.put("final_metric", (Object)metricInfo);
        }
        context.put("metric_size", (Object)metricInfo.size());
        step.put("metricInfo", (Object)metricInfo);
        JSONObject datasetObject = new JSONObject();
        datasetObject.put("metric", (Object)gptMetricId);
        datasetObject.put("datasetType", (Object)ConvertorJsonCommonMethod.getDatasetType((JSONObject)context));
        datasetObject.put("alias", (Object)gptMetricId);
        step.put("datasetObject", (Object)datasetObject);
    }

    private String getMetricId(JSONObject step) {
        String alias;
        String metricId = null;
        JSONObject datasetObject = step.getJSONObject("datasetObject");
        if (datasetObject != null && (alias = datasetObject.getString("alias")) != null) {
            metricId = alias;
        }
        return metricId;
    }

    private Boolean processSelect(JSONArray data, JSONObject step, JSONObject context, Boolean init) throws BussinessException {
        Boolean convertIsError = init;
        if (data.size() == 1 && data.get(0).equals("*")) {
            this.buildDetailSelect(step, context);
            return convertIsError;
        }
        Boolean ifDistinct = false;
        String metricId = this.getMetricId(step);
        JSONArray selectArray = new JSONArray();
        ArrayList<JSONObject> dataTagList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> aliasGrainList = new ArrayList<JSONObject>();
        for (Object item : data) {
            if (item.toString().startsWith("distinct ")) {
                item = item.toString().replace("distinct ", "");
                ifDistinct = true;
            }
            JSONObject dataTag = new JSONObject();
            JSONObject aliasGrain = new JSONObject();
            String[] split = item.toString().split("#");
            if (split.length == 2) {
                split = split[0].split("\\.");
            }
            JSONObject selectObj = new JSONObject();
            JSONObject dataObject = new JSONObject();
            JSONObject language = new JSONObject();
            if (split.length == 3) {
                String title = split[2];
                String fieldName = split[0].substring(split[0].indexOf("(") + 1, split[0].indexOf(")")).trim();
                if ((fieldName = fieldName.split(",")[0]).contains("distinct ")) {
                    fieldName = fieldName.replace("distinct ", "");
                }
                if (ConvertorJsonCommonMethod.checkFieldInSchema((String)fieldName, (JSONObject)step, null)) {
                    throw new BussinessException("checkFieldIsFalse");
                }
                convertIsError = this.processCompute(step, item.toString(), convertIsError.booleanValue());
                String alias = split[1];
                String dataType = this.getDataType(fieldName, step);
                if (ConvertorJsonCommonMethod.isMeasure((String)dataType)) {
                    dataTag = this.buildDataTag(step, alias, fieldName);
                }
                if ("datetime".equals(dataType)) {
                    dataType = "string";
                    String content = split[0].substring(split[0].indexOf("(") + 1, split[0].indexOf(")")).trim();
                    String[] dateSplit = content.split(",");
                    if (dateSplit.length == 2) {
                        aliasGrain.put("alias", (Object)alias);
                        aliasGrain.put("grain", (Object)SolutionStepConstants.getDateGrainMap().getOrDefault(dateSplit[1].trim(), dateSplit[1].trim()));
                    }
                }
                dataObject = ConvertorJsonCommonMethod.buildDataObject((String)alias, (String)metricId, (String)dataType, (String)"calculate");
                dataObject.put("title", (Object)title);
                dataObject.put("alias", (Object)alias);
                JSONObject languageTitle = new JSONObject();
                languageTitle.put("zh_CN", (Object)ZhTwConverterUtil.toSimple((String)title));
                languageTitle.put("zh_TW", (Object)ZhTwConverterUtil.toTraditional((String)title));
                language.put("title", (Object)languageTitle);
            }
            if (split.length == 1 && !ConvertorJsonCommonMethod.checkFieldInSchema((String)split[0], (JSONObject)step, null)) {
                String fieldName = split[0];
                dataTag = this.buildSelectNormalField(step, fieldName, dataObject, metricId, dataTag, language, context);
            }
            dataObject.put("language", (Object)language);
            selectObj.put("dataObject", (Object)dataObject);
            selectArray.add((Object)selectObj);
            if (!dataTag.isEmpty()) {
                dataTagList.add(dataTag);
            }
            if (aliasGrain.isEmpty()) continue;
            aliasGrainList.add(aliasGrain);
        }
        step.put("select", (Object)selectArray);
        if (ifDistinct.booleanValue()) {
            step.put("distinct", (Object)true);
        }
        context.put("dataTag", dataTagList);
        context.put("aliasGrain", aliasGrainList);
        return convertIsError;
    }

    private void buildDetailSelect(JSONObject step, JSONObject context) {
        String metricId = this.getMetricId(step);
        ArrayList dataTagList = new ArrayList();
        JSONArray fieldSchemaList = step.getJSONArray("metricInfo").getJSONObject(0).getJSONArray("fieldSchema");
        JSONArray selectArray = new JSONArray();
        fieldSchemaList.forEach(item -> {
            JSONObject dataTag = new JSONObject();
            JSONObject fieldSchema = (JSONObject)item;
            JSONObject selectObj = new JSONObject();
            JSONObject dataObject = new JSONObject();
            JSONObject language = new JSONObject();
            String fieldName = fieldSchema.getString("name");
            String title = fieldSchema.getString("title").trim();
            String metricDataType = fieldSchema.getString("dataType");
            String dataType = SolutionStepConstants.getDataTypeMap().getOrDefault(metricDataType, metricDataType);
            if (ConvertorJsonCommonMethod.isMeasure((String)dataType)) {
                dataTag = this.buildDataTag(step, fieldName, fieldName);
            }
            dataObject = ConvertorJsonCommonMethod.buildDataObject((String)fieldName, (String)metricId, (String)dataType, (String)"field");
            dataObject.put("alias", (Object)fieldName);
            dataObject.put("title", (Object)title);
            selectObj.put("dataObject", (Object)dataObject);
            ConvertorJsonCommonMethod.getLanguage((JSONObject)fieldSchema, (JSONObject)language);
            dataObject.put("language", (Object)language);
            selectArray.add((Object)selectObj);
            if (!dataTag.isEmpty()) {
                dataTagList.add(dataTag);
            }
        });
        step.put("select", (Object)selectArray);
        context.put("dataTag", dataTagList);
    }

    private JSONObject buildSelectNormalField(JSONObject step, String fieldName, JSONObject dataObject, String metricId, JSONObject dataTag, JSONObject language, JSONObject context) {
        JSONObject fieldSchema = this.getMetricFieldSchema(fieldName, step);
        dataObject.put("content", (Object)fieldName);
        dataObject.put("source", (Object)metricId);
        dataObject.put("contentType", (Object)"field");
        String dataType = this.getDataType(fieldName, step);
        if (ConvertorJsonCommonMethod.isMeasure((String)dataType)) {
            dataTag = this.buildDataTag(step, fieldName, fieldName);
        }
        dataObject.put("dataType", (Object)dataType);
        dataObject.put("alias", (Object)fieldName);
        if (fieldSchema != null) {
            dataObject.put("title", (Object)fieldSchema.getString("title").trim());
            ConvertorJsonCommonMethod.getLanguage((JSONObject)fieldSchema, (JSONObject)language);
        }
        return dataTag;
    }

    public JSONObject buildDataTag(JSONObject step, String alias, String fieldName) {
        JSONObject dataTag = new JSONObject();
        JSONObject metricInfo = step.getJSONArray("metricInfo").getJSONObject(0);
        dataTag.put("alias", (Object)alias);
        dataTag.put("formula", (Object)metricInfo.getString("formula"));
        dataTag.put("language", (Object)"");
        JSONObject fieldSchema = this.getMetricFieldSchema(fieldName, step);
        if (StringUtils.isNotEmpty((CharSequence)fieldSchema.getString("businessType"))) {
            dataTag.put("businessType", (Object)fieldSchema.getString("businessType"));
        } else {
            dataTag.put("businessType", (Object)metricInfo.getString("businessType"));
        }
        if (this.ifCount(fieldName, step)) {
            dataTag.put("businessType", (Object)"Quantity");
        }
        if (null != metricInfo.getJSONObject("lang")) {
            JSONObject formulaLang = metricInfo.getJSONObject("lang").getJSONObject("formula");
            JSONObject formulaLangObj = new JSONObject();
            formulaLangObj.put("formula", (Object)formulaLang);
            dataTag.put("language", (Object)formulaLangObj);
        }
        return dataTag;
    }

    private void processFilterOrHaving(JSONObject filterJsonObj, JSONObject filterJson, JSONObject step, boolean isFilter, JSONObject context) {
        String outLogical = filterJsonObj.containsKey((Object)"and") ? "and" : "or";
        try {
            filterJsonObj = ConvertorJsonCommonMethod.getFormatObj((JSONObject)filterJsonObj, (String)outLogical);
            filterJsonObj = this.dateFormatFilter(step, filterJsonObj, outLogical);
            filterJsonObj = ConvertorJsonCommonMethod.filterInvalidField((JSONObject)step, (JSONObject)filterJsonObj, (String)outLogical);
            String string = outLogical = filterJsonObj.containsKey((Object)"and") ? "and" : "or";
            if (filterJsonObj.containsKey((Object)outLogical)) {
                Object logicalJson = filterJsonObj.get((Object)outLogical);
                if (Objects.isNull(logicalJson)) {
                    return;
                }
                filterJson.put("logic", (Object)outLogical);
                this.processLogicalJson(filterJson, logicalJson, step, isFilter, context);
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362filterJsonObj\u5f02\u5e38", (Throwable)e);
        }
    }

    private void processLogicalJson(JSONObject filterJson, Object logicalJson, JSONObject step, boolean isFilter, JSONObject context) throws BussinessException {
        ArrayList leftMapList = new ArrayList();
        if (logicalJson instanceof JSONObject) {
            this.dealObjectFilter(filterJson, (JSONObject)logicalJson, step, isFilter, context, leftMapList);
        } else if (logicalJson instanceof JSONArray) {
            this.dealArrayFilter(filterJson, (JSONArray)logicalJson, step, isFilter, context, leftMapList);
        }
    }

    private void dealObjectFilter(JSONObject filterJson, JSONObject logicalJson, JSONObject step, boolean isFilter, JSONObject context, List<Map<String, String>> leftMapList) throws BussinessException {
        JSONArray filterItems = new JSONArray();
        JSONObject orObject = new JSONObject();
        JSONArray orItems = logicalJson.getJSONArray("or");
        JSONArray andItems = logicalJson.getJSONArray("and");
        if (CollectionUtils.isNotEmpty((Collection)andItems)) {
            this.dealAndItems(filterJson, step, isFilter, leftMapList, andItems, filterItems, context);
        }
        if (CollectionUtils.isNotEmpty((Collection)orItems)) {
            this.dealOrItems(step, isFilter, leftMapList, orObject, orItems, context);
        }
        if (!orObject.isEmpty()) {
            filterItems.add((Object)orObject);
        }
        context.put("multiCompanySetEocMaps", leftMapList);
    }

    private void dealOrItems(JSONObject step, boolean isFilter, List<Map<String, String>> leftMapList, JSONObject orObject, JSONArray orItems, JSONObject context) throws BussinessException {
        orObject.put("logic", (Object)"or");
        JSONArray chdOrArray = new JSONArray();
        for (Object item : orItems) {
            String[] splitOrBlankItem = this.splitBlank(item.toString(), step);
            String rightOrType = ConvertorJsonCommonMethod.getRightType((String[])splitOrBlankItem);
            List<String> stringOrList = Arrays.asList(splitOrBlankItem[0], splitOrBlankItem[1], splitOrBlankItem[2]);
            if (ConvertorJsonCommonMethod.checkFieldInSchema((String)stringOrList.get(0).trim(), (JSONObject)step, null)) {
                throw new BussinessException("checkFieldIsFalse");
            }
            if (!CollectionUtils.isNotEmpty(stringOrList) || stringOrList.size() != 3) continue;
            String optOr = stringOrList.get(1);
            if ("btw".equals(optOr)) {
                this.buildBtwFilter(step, chdOrArray, stringOrList, rightOrType, context);
                continue;
            }
            if ("in".equals(optOr) || "not_in".equals(optOr)) {
                this.buildOperatorIn(step, stringOrList, rightOrType, chdOrArray);
                continue;
            }
            this.buildNotBtwFilter(step, isFilter, context, leftMapList, stringOrList, rightOrType, chdOrArray);
        }
        orObject.put("children", (Object)chdOrArray);
    }

    private void buildOperatorIn(JSONObject step, List<String> stringList, String rightType, JSONArray filterItems) {
        String operator = stringList.get(1);
        JSONObject coJson = new JSONObject();
        JSONArray rightArray = new JSONArray();
        String leftContent = stringList.get(0).trim();
        String dataType = this.getDataType(leftContent, step);
        if ("datetime".equals(dataType)) {
            dataType = "string";
        }
        JSONObject leftObject = ConvertorJsonCommonMethod.buildDataObject((String)leftContent, (String)this.getMetricId(step), (String)dataType, (String)this.getContentType(step, leftContent));
        String rightContent = stringList.get(2).trim();
        String trimmedInput = rightContent.substring(1, rightContent.length() - 1);
        String[] inContentArr = trimmedInput.split(",");
        if (ConvertorJsonCommonMethod.isMeasure((String)dataType)) {
            List resultList = Arrays.stream(inContentArr).map(Integer::parseInt).collect(Collectors.toList());
            for (Integer content : resultList) {
                JSONObject rightObject = new JSONObject();
                rightObject.put("content", (Object)content);
                rightObject.put("dataType", (Object)dataType);
                rightObject.put("source", (Object)this.getMetricId(step));
                rightObject.put("contentType", (Object)rightType);
                JSONObject rightDataObject = new JSONObject();
                rightDataObject.put("dataObject", (Object)rightObject);
                rightArray.add((Object)rightDataObject);
            }
        } else {
            for (String content : inContentArr) {
                JSONObject rightDataObject = new JSONObject();
                rightDataObject.put("dataObject", (Object)ConvertorJsonCommonMethod.buildDataObject((String)content.trim(), (String)this.getMetricId(step), (String)dataType, (String)rightType));
                rightArray.add((Object)rightDataObject);
            }
        }
        coJson.put("left", (Object)leftObject);
        coJson.put("operator", (Object)SolutionStepConstants.getOpMap().getOrDefault(operator, operator));
        coJson.put("right", (Object)rightArray);
        filterItems.add((Object)coJson);
    }

    private void dealAndItems(JSONObject filterJson, JSONObject step, boolean isFilter, List<Map<String, String>> leftMapList, JSONArray andItems, JSONArray filterItems, JSONObject context) throws BussinessException {
        for (int i = 0; i < andItems.size(); ++i) {
            String[] splitBlankItem = this.splitBlank(andItems.get(i).toString(), step);
            String rightType = ConvertorJsonCommonMethod.getRightType((String[])splitBlankItem);
            List<String> stringList = Arrays.asList(splitBlankItem[0], splitBlankItem[1], splitBlankItem[2]);
            if (ConvertorJsonCommonMethod.checkFieldInSchema((String)stringList.get(0).trim(), (JSONObject)step, null)) {
                throw new BussinessException("checkFieldIsFalse");
            }
            if (!CollectionUtils.isNotEmpty(stringList) || stringList.size() != 3) continue;
            String operator = stringList.get(1);
            if ("btw".equals(operator)) {
                this.buildBtwFilter(step, filterItems, stringList, rightType, context);
                continue;
            }
            if ("in".equals(operator) || "not_in".equals(operator)) {
                this.buildOperatorIn(step, stringList, rightType, filterItems);
                continue;
            }
            this.buildNotBtwFilter(step, isFilter, context, leftMapList, stringList, rightType, filterItems);
        }
        filterJson.put("children", (Object)filterItems);
    }

    private void buildBtwFilter(JSONObject step, JSONArray filterItems, List<String> stringList, String rightType, JSONObject context) {
        String dataType = this.getDataType(stringList.get(0).trim(), step);
        String metricId = this.getMetricId(step);
        String[] dateItem = stringList.get(2).split("#");
        for (int j = 0; j < dateItem.length; ++j) {
            JSONObject leftDateObject = ConvertorJsonCommonMethod.buildDataObject((String)stringList.get(0), (String)metricId, (String)dataType, (String)this.getContentType(step, stringList.get(0)));
            JSONArray rightDateArray = new JSONArray();
            JSONObject dateObj = new JSONObject();
            JSONObject rightObject = ConvertorJsonCommonMethod.buildDataObject((String)dateItem[j], (String)metricId, (String)dataType, (String)rightType);
            JSONObject rightDataObject = new JSONObject();
            rightDataObject.put("dataObject", (Object)rightObject);
            rightDateArray.add((Object)rightDataObject);
            if (j == 0) {
                dateObj.put("operator", (Object)"gte");
            } else if (j == 1) {
                dateObj.put("operator", (Object)"lte");
            }
            dateObj.put("left", (Object)leftDateObject);
            dateObj.put("right", (Object)rightDateArray);
            filterItems.add((Object)dateObj);
        }
    }

    private void dealArrayFilter(JSONObject filterJson, JSONArray logicalJson, JSONObject step, boolean isFilter, JSONObject context, List<Map<String, String>> leftMapList) throws BussinessException {
        JSONArray filterItems = new JSONArray();
        for (Object item : logicalJson) {
            String[] splitBlankItem = this.splitBlankFilter(item.toString(), step);
            String rightType = ConvertorJsonCommonMethod.getRightType((String[])splitBlankItem);
            List<String> stringList = Arrays.asList(splitBlankItem[0], splitBlankItem[1], splitBlankItem[2]);
            if (ConvertorJsonCommonMethod.checkFieldInSchema((String)stringList.get(0).trim(), (JSONObject)step, null)) {
                throw new BussinessException("checkFieldIsFalse");
            }
            if (!CollectionUtils.isNotEmpty(stringList) || stringList.size() != 3) continue;
            String operator = stringList.get(1);
            if ("btw".equals(operator)) {
                this.buildBtwFilter(step, filterItems, stringList, rightType, context);
                continue;
            }
            if ("in".equals(operator) || "not_in".equals(operator)) {
                this.buildOperatorIn(step, stringList, rightType, filterItems);
                continue;
            }
            this.buildNotBtwFilter(step, isFilter, context, leftMapList, stringList, rightType, filterItems);
        }
        context.put("multiCompanySetEocMaps", leftMapList);
        filterJson.put("children", (Object)filterItems);
    }

    private void buildNotBtwFilter(JSONObject step, boolean isFilter, JSONObject context, List<Map<String, String>> leftMapList, List<String> stringList, String rightType, JSONArray filterItems) {
        String operator = stringList.get(1);
        JSONObject coJson = new JSONObject();
        JSONArray rightArray = new JSONArray();
        String leftContent = stringList.get(0).trim();
        JSONObject leftObject = ConvertorJsonCommonMethod.buildDataObject((String)leftContent, (String)this.getMetricId(step), (String)this.getDataType(leftContent, step), (String)this.getContentType(step, leftContent));
        JSONObject rightObject = new JSONObject();
        String rightContent = stringList.get(2).trim();
        if ("like".equals(operator)) {
            if (rightContent.startsWith("%") && rightContent.endsWith("%") || rightContent.startsWith("'%") && rightContent.endsWith("%'")) {
                operator = "fm";
            } else if (rightContent.startsWith("%") || rightContent.startsWith("'%")) {
                operator = "sm";
            }
            if (rightContent.startsWith("'%") || rightContent.endsWith("%'")) {
                rightContent = StringUtils.stripStart((String)rightContent, (String)"'%");
                rightContent = StringUtils.stripEnd((String)rightContent, (String)"%'");
            } else {
                rightContent = StringUtils.strip((String)rightContent, (String)"%");
            }
        }
        rightObject.put("content", (Object)rightContent);
        if (isFilter) {
            HashMap<String, String> leftMap;
            rightObject.put("content", (Object)ConvertorJsonCommonMethod.synonymReplaceStandard((String)leftContent, (String)rightContent, (JSONObject)step, (JSONObject)context));
            if ("eoc_company_name".equals(leftContent)) {
                leftMap = new HashMap<String, String>();
                leftMap.put("eoc_company_name", rightObject.getString("content"));
                leftMapList.add(leftMap);
            }
            if ("eoc_company_id".equals(leftContent)) {
                leftMap = new HashMap();
                leftMap.put("eoc_company_id", rightObject.getString("content"));
                leftMapList.add(leftMap);
            }
        }
        rightObject.put("dataType", (Object)this.getDataType(rightContent, step));
        if ("const".equals(rightType)) {
            rightObject.put("dataType", (Object)leftObject.getString("dataType"));
        }
        operator = SolutionStepConstants.getOpMap().getOrDefault(operator, operator);
        if ("datetime".equals(rightObject.getString("dataType"))) {
            String dateContent = rightObject.getString("content");
            rightObject.put("content", (Object)ConvertorJsonCommonMethod.getYMDDateContent((String)dateContent, (String)operator, (JSONObject)this.getMetricFieldSchema(dateContent, step)));
        }
        rightObject.put("source", (Object)this.getMetricId(step));
        rightObject.put("contentType", (Object)rightType);
        if ("is".equalsIgnoreCase(operator) && ("null".equalsIgnoreCase(rightContent) || "not null".equalsIgnoreCase(rightContent))) {
            operator = "null".equalsIgnoreCase(rightContent) ? "is_null" : "is_not_null";
            rightType = "const";
            rightObject.put("contentType", (Object)rightType);
            rightObject.put("content", (Object)"");
        }
        JSONObject rightDataObject = new JSONObject();
        rightDataObject.put("dataObject", (Object)rightObject);
        rightArray.add((Object)rightDataObject);
        coJson.put("left", (Object)leftObject);
        coJson.put("operator", (Object)operator);
        coJson.put("right", (Object)rightArray);
        filterItems.add((Object)coJson);
    }

    private Boolean processCompute(JSONObject step, String item, boolean init) {
        JSONObject computeObj = null;
        Boolean convertIsError = init;
        computeObj = step.containsKey((Object)"computeList") ? step.getJSONObject("computeList") : new JSONObject();
        String[] orderByItem = item.split("#");
        if (orderByItem.length == 3) {
            boolean ifDistinct = false;
            JSONObject calFunctionObj = new JSONObject();
            JSONArray calFunctionList = new JSONArray();
            String aggregate = orderByItem[0];
            if (aggregate.contains("distinct ")) {
                ifDistinct = true;
                aggregate = aggregate.replace("distinct ", "");
            }
            String aggFunction = aggregate.substring(0, aggregate.indexOf("(")).trim();
            if (!SolutionStepConstants.getcalFuctionTypeList().contains(aggFunction.toUpperCase())) {
                convertIsError = true;
                log.error("compute\u8ba1\u7b97\u5b57\u6bb5\u65b9\u6cd5\u6682\u4e0d\u652f\u6301\uff1a{}", (Object)item);
            }
            String aggContent = aggregate.substring(aggregate.indexOf("(") + 1, aggregate.indexOf(")")).trim();
            String alias = orderByItem[1];
            calFunctionObj.put("newField", (Object)alias);
            calFunctionObj.put("calFunction", (Object)aggFunction);
            JSONArray params = new JSONArray();
            if (StringUtils.isNotBlank((CharSequence)aggContent)) {
                List<String> paramsList = Arrays.asList(aggContent.split(","));
                for (int i = 0; i < paramsList.size(); ++i) {
                    Object param = paramsList.get(i).trim();
                    JSONObject fieldObj = new JSONObject();
                    fieldObj.put("source", (Object)this.getMetricId(step));
                    fieldObj.put("content", (Object)ConvertorJsonCommonMethod.getPostDotElement(param));
                    fieldObj.put("contentType", (Object)this.getContentType(step, ConvertorJsonCommonMethod.getPostDotElement(param)));
                    if (i == 1 && "DateFormat".equals(aggFunction)) {
                        fieldObj.put("contentType", (Object)"dateFormat");
                    }
                    fieldObj.put("dataType", (Object)this.getDataType(ConvertorJsonCommonMethod.getPostDotElement(param), step));
                    params.add((Object)fieldObj);
                }
            }
            ArrayList<String> types = new ArrayList<String>();
            for (Object param : params) {
                types.add(((JSONObject)param).getString("dataType"));
            }
            if (types.size() == 1) {
                types.add(null);
            }
            calFunctionObj.put("valueType", (Object)ConvertorJsonCommonMethod.determineResultType((String)aggFunction.toUpperCase(), (String)((String)types.get(0)), (String)((String)types.get(1))));
            calFunctionObj.put("params", (Object)params);
            if (ifDistinct) {
                calFunctionObj.put("distinct", (Object)true);
            }
            calFunctionList.add((Object)calFunctionObj);
            computeObj.put(alias, (Object)calFunctionList);
        }
        step.put("computeList", (Object)computeObj);
        return convertIsError;
    }

    private String processDateCompute(JSONObject step, String fieldName, String fmtType) {
        String newFieldName;
        JSONObject computeList = null;
        computeList = step.containsKey((Object)"computeList") ? step.getJSONObject("computeList") : new JSONObject();
        if (computeList.containsKey((Object)(newFieldName = fieldName + "_" + fmtType))) {
            return newFieldName;
        }
        if (ConvertorJsonCommonMethod.checkFieldInSchema((String)fieldName, (JSONObject)step, null)) {
            return null;
        }
        JSONObject calFunction = new JSONObject();
        JSONArray calFunctionList = new JSONArray();
        calFunction.put("newField", (Object)newFieldName);
        calFunction.put("calFunction", (Object)"DateFormat");
        calFunction.put("valueType", (Object)"string");
        JSONArray params = new JSONArray();
        JSONObject paramsFirst = ConvertorJsonCommonMethod.buildDataObject((String)fieldName, (String)this.getMetricId(step), (String)"datetime", (String)"field");
        params.add((Object)paramsFirst);
        JSONObject paramsSecond = ConvertorJsonCommonMethod.buildDataObject((String)fmtType, (String)this.getMetricId(step), (String)"string", (String)"dateFormat");
        params.add((Object)paramsSecond);
        calFunction.put("params", (Object)params);
        calFunctionList.add((Object)calFunction);
        computeList.put(newFieldName, (Object)calFunctionList);
        step.put("computeList", (Object)computeList);
        return newFieldName;
    }

    private String[] splitBlank(String input, JSONObject step) {
        String[] parts = input.split("\\s+");
        if (parts.length == 4) {
            parts[3] = "c".equals(parts[3]) ? "const" : this.getContentType(step, parts[0]);
        }
        return parts;
    }

    private String[] splitBlankFilter(String input, JSONObject step) {
        String[] parts = ConvertorJsonCommonMethod.customSplit((String)input);
        if (parts.length == 4) {
            parts[3] = "c".equals(parts[3]) ? "const" : this.getContentType(step, parts[0]);
        }
        return parts;
    }

    private String getContentType(JSONObject step, String fieldName) {
        JSONObject metricFieldSchema = this.getMetricFieldSchema(fieldName, step);
        if (null != metricFieldSchema) {
            return "field";
        }
        JSONObject computeObj = step.getJSONObject("computeList");
        if (null != computeObj && computeObj.containsKey((Object)fieldName)) {
            return "calculate";
        }
        return "const";
    }

    private String getDataType(String fieldName, JSONObject step) {
        String dataType;
        if (this.ifCount(fieldName, step)) {
            return "number";
        }
        JSONObject metricFieldSchema = this.getMetricFieldSchema(fieldName, step);
        if (null != metricFieldSchema && StringUtils.isNotBlank((CharSequence)(dataType = metricFieldSchema.getString("dataType")))) {
            return SolutionStepConstants.getDataTypeMap().getOrDefault(dataType, dataType);
        }
        JSONObject computeObj = step.getJSONObject("computeList");
        if (computeObj == null) {
            return "string";
        }
        JSONArray fieldArr = computeObj.getJSONArray(fieldName);
        if (CollectionUtils.isNotEmpty((Collection)fieldArr)) {
            return fieldArr.getJSONObject(0).getString("valueType");
        }
        return "string";
    }

    private boolean ifCount(String fieldName, JSONObject step) {
        JSONObject computeObject = step.getJSONObject("computeList");
        if (computeObject != null) {
            for (Map.Entry stringObjectEntry : computeObject.entrySet()) {
                JSONObject jsonObject = (JSONObject)((JSONArray)stringObjectEntry.getValue()).get(0);
                JSONArray params = jsonObject.getJSONArray("params");
                if (!fieldName.equalsIgnoreCase(((JSONObject)params.get(0)).getString("content")) || !"count".equalsIgnoreCase(jsonObject.getString("calFunction"))) continue;
                return true;
            }
        }
        return false;
    }

    public JSONObject getMetricFieldSchema(String fieldName, JSONObject step) {
        JSONObject metricInfo = step.getJSONArray("metricInfo").getJSONObject(0);
        if (metricInfo == null || !metricInfo.containsKey((Object)"fieldSchema")) {
            return null;
        }
        JSONArray fieldSchema = metricInfo.getJSONArray("fieldSchema");
        if (CollectionUtils.isNotEmpty((Collection)fieldSchema)) {
            for (Object field : fieldSchema) {
                JSONObject fieldObj;
                String name;
                if (!(field instanceof JSONObject) || !fieldName.equals(name = (fieldObj = (JSONObject)field).getString("name"))) continue;
                return fieldObj;
            }
        }
        return null;
    }

    private JSONObject dateFormatFilter(JSONObject step, JSONObject filterJsonObj, String outLogical) {
        Object logicalJson = filterJsonObj.get((Object)outLogical);
        if (Objects.isNull(logicalJson)) {
            return filterJsonObj;
        }
        if (logicalJson instanceof JSONObject) {
            JSONArray newOrItems = new JSONArray();
            JSONArray orItems = ((JSONObject)logicalJson).getJSONArray("or");
            for (int i = 0; i < orItems.size(); ++i) {
                String filterItem = orItems.getString(i).toString();
                String newFilterItem = this.formatDateFilter(step, filterItem);
                if (!StringUtils.isNotBlank((CharSequence)newFilterItem)) continue;
                newOrItems.add((Object)newFilterItem);
            }
            JSONArray andItems = ((JSONObject)logicalJson).getJSONArray("and");
            JSONArray newAndItems = new JSONArray();
            for (int i = 0; i < andItems.size(); ++i) {
                String filterItem = andItems.getString(i).toString();
                String newFilterItem = this.formatDateFilter(step, filterItem);
                if (!StringUtils.isNotBlank((CharSequence)newFilterItem)) continue;
                newAndItems.add((Object)newFilterItem);
            }
            JSONObject newFilterJson = new JSONObject();
            if (CollectionUtils.isNotEmpty((Collection)newOrItems) && CollectionUtils.isNotEmpty((Collection)newAndItems)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("or", (Object)newOrItems);
                jsonObject.put("and", (Object)newAndItems);
                newFilterJson.put("and", (Object)jsonObject);
            }
            if (CollectionUtils.isNotEmpty((Collection)newOrItems) && CollectionUtils.isEmpty((Collection)newAndItems)) {
                newFilterJson.put("or", (Object)newOrItems);
            }
            if (CollectionUtils.isNotEmpty((Collection)newAndItems) && CollectionUtils.isEmpty((Collection)newOrItems)) {
                newFilterJson.put("and", (Object)newAndItems);
            }
            filterJsonObj = newFilterJson;
            return filterJsonObj;
        }
        if (logicalJson instanceof JSONArray) {
            JSONArray newItems = new JSONArray();
            JSONArray jsonArray = (JSONArray)logicalJson;
            for (int i = 0; i < jsonArray.size(); ++i) {
                String filterItem = jsonArray.getString(i).toString();
                String newFilterItem = this.formatDateFilter(step, filterItem);
                if (!StringUtils.isNotBlank((CharSequence)newFilterItem)) continue;
                newItems.add((Object)newFilterItem);
            }
            if (CollectionUtils.isEmpty((Collection)newItems)) {
                return new JSONObject();
            }
            filterJsonObj.put(outLogical, (Object)newItems);
            return filterJsonObj;
        }
        return filterJsonObj;
    }

    private String formatDateFilter(JSONObject step, String filterItem) {
        List contentList;
        if (filterItem.startsWith("DateFormat(") && CollectionUtils.isNotEmpty((Collection)(contentList = this.getDateFormatContent(filterItem)))) {
            String newFieldName = this.processDateCompute(step, (String)contentList.get(0), (String)contentList.get(1));
            if (StringUtils.isEmpty((CharSequence)newFieldName)) {
                return null;
            }
            return this.replaceFilterField(filterItem, newFieldName);
        }
        return filterItem;
    }

    private List<String> getDateFormatContent(String dateFormatStr) {
        Matcher matcher = dateFormatContentPattern.matcher(dateFormatStr);
        if (matcher.find()) {
            String extracted = matcher.group(1);
            String[] array = extracted.split(",");
            return Arrays.stream(array).map(String::trim).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private String replaceFilterField(String oldFilterContent, String newField) {
        String newFilterContent = oldFilterContent.replaceAll("DateFormat\\(.*?\\)", newField);
        return newFilterContent;
    }
}

