/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.SseSendService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPTMetricIntegrationExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(GPTMetricIntegrationExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        Output output = Output.through();
        String noMetricGptName = "Metric_with_app";
        String oneMoreMetricGptName = "Metric_without_app";
        JSONObject noMetricGptResult = context.getJSONObject(noMetricGptName);
        JSONObject oneMoreMetricGptResult = context.getJSONObject(oneMoreMetricGptName);
        if (MetricSearchResultEnum.NO_METRIC.getValue().equals(context.getString(MetricSearchResultEnum.NO_METRIC.getKey()))) {
            return this.getNoMetricOutput(context, noMetricGptResult);
        }
        return output;
    }

    private Output getNoMetricOutput(JSONObject context, JSONObject noMetricGptResult) {
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        LogCheckDto logCheckDto = new LogCheckDto();
        String originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getOriginFinallyQuestion();
        if (StringUtils.isEmpty((String)originFinallyQuestion)) {
            originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getMessage();
        }
        context.put("origin_finally_question", (Object)originFinallyQuestion);
        List metricList = Optional.ofNullable(Retrieve.METRIC_ALIKE.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        if (Objects.isNull(noMetricGptResult)) {
            return Output.through((String)"success", (Object)false).keep("need_sentences_4_without_metric", (Object)true).keep("sentences_param_4_without_metric", (Object)StringUtil.buildSentencesParamNoneMetric((List)metricList, (String)locale)).keep("reply", (Object)"message.scrumbi.no.metric.4.sentence");
        }
        List apps = (List)context.get((Object)"no_metric_apps");
        HashMap groupedMetrics = (HashMap)context.get((Object)"all_metric_list");
        if (StringUtils.isEmpty((String)noMetricGptResult.getString("selected_application_index")) || CollectionUtils.isEmpty((Collection)noMetricGptResult.getJSONArray("matched_metrics"))) {
            logCheckDto.setCode("U.SCRUMBI.901.0111");
            logCheckDto.setStep("GPTMetricIntegration");
            logCheckDto.setInput(JSONObject.toJSONString((Object)noMetricGptResult));
            logCheckDto.setResult("LLM\u672a\u5339\u914d\u5230\u5408\u9002\u7684\u6307\u6807\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\n1.\u53e5\u5b50\u4e2d\u63d0\u5230\u7684\u6307\u6807\u672a\u914d\u7f6e\uff0c\n2.\u914d\u7f6e\u4e86\u6307\u6807\u4f46\u63cf\u8ff0\u4e0d\u660e\u786e\uff0c\n3.\u914d\u7f6e\u4e86\u6307\u6807\u4f46\u672a\u53d1\u7248\uff08\u5207\u7248\uff09\n4.\u540c\u4e49\u8bcd\u914d\u9519");
            logCheckDto.setSuggestion("1.\u6253\u5f00\u6307\u6807\u548c\u540c\u4e49\u8bcd\u7684\u914d\u7f6e\u9875\u9762\u3002\n2.\u786e\u8ba4\u6240\u9700\u6307\u6807\u662f\u5426\u5df2\u914d\u7f6e\uff0c\u6307\u6807\u4fe1\u606f\u662f\u5426\u5b8c\u6574\u3002\n3.\u68c0\u67e5\u6307\u6807\u7684\u540c\u4e49\u8bcd\u662f\u5426\u5df2\u8bbe\u7f6e\uff0c\u786e\u4fdd\u5176\u51c6\u786e\u6027\u3002\n4.\u6267\u884c\u53d1\u7248\u6216\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.through((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.4.sentence").keep("need_sentences_4_without_metric", (Object)true).keep("sentences_param_4_without_metric", (Object)StringUtil.buildSentencesParamNoneMetric((List)metricList, (String)locale)).keep("logCheckDtos", logCheckDtos);
        }
        String appIndex = noMetricGptResult.getString("selected_application_index");
        List metricNames = noMetricGptResult.getJSONArray("matched_metrics").stream().map(j -> ((JSONObject)j).getString("metric_name")).collect(Collectors.toList());
        String appCode = (String)apps.get(Integer.valueOf(appIndex) - 1);
        List metrics = ((List)groupedMetrics.get(appCode)).stream().filter(metric -> metricNames.contains(metric.getString("metricName"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(metrics)) {
            logCheckDto.setCode("U.SCRUMBI.901.0111");
            logCheckDto.setStep("GPTMetricIntegration");
            logCheckDto.setInput(JSONObject.toJSONString((Object)metrics));
            logCheckDto.setResult("LLM\u672a\u5339\u914d\u5230\u5408\u9002\u7684\u6307\u6807\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\n1.\u53e5\u5b50\u4e2d\u63d0\u5230\u7684\u6307\u6807\u672a\u914d\u7f6e\uff0c\n2.\u914d\u7f6e\u4e86\u6307\u6807\u4f46\u63cf\u8ff0\u4e0d\u660e\u786e\uff0c\n3.\u914d\u7f6e\u4e86\u6307\u6807\u4f46\u672a\u53d1\u7248\uff08\u5207\u7248\uff09\n4.\u540c\u4e49\u8bcd\u914d\u9519");
            logCheckDto.setSuggestion("1.\u6253\u5f00\u6307\u6807\u548c\u540c\u4e49\u8bcd\u7684\u914d\u7f6e\u9875\u9762\u3002\n2.\u786e\u8ba4\u6240\u9700\u6307\u6807\u662f\u5426\u5df2\u914d\u7f6e\uff0c\u6307\u6807\u4fe1\u606f\u662f\u5426\u5b8c\u6574\u6216\u7e41\u7b80\u4f53\u662f\u5426\u4e00\u81f4\n3.\u68c0\u67e5\u6307\u6807\u7684\u540c\u4e49\u8bcd\u662f\u5426\u5df2\u8bbe\u7f6e\uff0c\u786e\u4fdd\u5176\u51c6\u786e\u6027\u3002\n4.\u6267\u884c\u53d1\u7248\u6216\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.through((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.4.sentence").keep("need_sentences_4_without_metric", (Object)true).keep("sentences_param_4_without_metric", (Object)StringUtil.buildSentencesParamNoneMetric((List)metricList, (String)locale)).keep("logCheckDtos", logCheckDtos);
        }
        if (ConvertorJsonCommonMethod.queryMetricSwitch((JSONObject)context).booleanValue() && CollectionUtils.isEmpty((Collection)(metrics = ConvertorJsonCommonMethod.filterMetricPermission((JSONObject)context, metrics)))) {
            logCheckDto.buildParams("GPTMetricIntegration", "U.SCRUMBI.901.0109", JSONObject.toJSONString((Object)metrics), "\u8bc6\u522b\u5230\u7528\u6237\u65e0\u6b64\u6307\u6807" + context.getOrDefault((Object)"noPermissionMetrics", new HashSet()).toString() + "\u6743\u9650", "1.\u767b\u5f55\u9f0e\u6377\u4e91\u7684\u6743\u9650\u7ba1\u7406\u90e8\u5206\uff0c\u9009\u62e9\u76f8\u5e94\u7528\u6237\u548c\u5e94\u7528\u3002\n2.\u67e5\u627e\u76f8\u5173\u6307\u6807\uff0c\u67e5\u770b\u5176\u6743\u9650\u8bbe\u7f6e\u3002\n3.\u786e\u4fdd\u7528\u6237\u6216\u7528\u6237\u7ec4\u6709\u76f8\u5e94\u7684\u6307\u6807\u8bbf\u95ee\u6743\u9650\u3002\n4.\u82e5\u6743\u9650\u7f3a\u5931\uff0c\u6dfb\u52a0\u6743\u9650\uff0c\u91cd\u65b0\u6d4b\u8bd5\u6307\u6807\u8bbf\u95ee\uff0c\u82e5\u95ee\u9898\u5b58\u5728\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.permission").keep("no_metric_permission_flag", (Object)1).keep("logCheckDtos", logCheckDtos);
        }
        Question question = (Question)context.getObject("question", Question.class);
        SseSendService sseSendService = (SseSendService)SpringContextUtil.getBean(SseSendService.class);
        String names = metrics.stream().map(metric -> metric.getString("metricName")).collect(Collectors.toList()).toString();
        sseSendService.asyncSendAQDetailAndSCTitle(question, names, question.isIfStream(), context);
        return Output.through((String)MetricSearchResultEnum.NO_METRIC.getKey(), (Object)MetricSearchResultEnum.NO_METRIC.getValue()).keep("final_metric", (Object)metrics).keep("metric_size", (Object)(CollectionUtils.isEmpty((Collection)metrics) ? 0 : metrics.size())).keep("billingGoodsId", (Object)((JSONObject)metrics.get(0)).getString("billingGoodsId")).keep("sentences_param_4_schemas_check", (Object)StringUtil.buildSentencesParam4Metric((List)metrics, (String)locale)).keep("no_metric_use_gpt_flag", (Object)1);
    }
}

