/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.StepFieldInfo;
import com.digiwin.chatbi.beans.pojos.dataAttribution.DataAttributionRequest;
import com.digiwin.chatbi.beans.pojos.dataAttribution.FluctuateRequest;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.constant.SolutionStepConstants;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.common.util.FunctionUtil;
import com.digiwin.chatbi.common.util.JSONUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.MessageUtils;
import com.github.houbb.opencc4j.util.ZhTwConverterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeneralConvertorWrapperExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(GeneralConvertorWrapperExecutor.class);
    public static TransmittableThreadLocal<List<Map<String, List<StepFieldInfo>>>> selectInfoCacheList = new TransmittableThreadLocal();
    public static TransmittableThreadLocal<JSONObject> GPTJson = new TransmittableThreadLocal();
    public static TransmittableThreadLocal<List<String>> rowNumberList = new TransmittableThreadLocal();
    public static final Pattern rankOverPattern = Pattern.compile("(?i)(\\w+)\\(\\)\\s+over\\s+\\((.*?)\\)#(\\w+)#");
    public static final Pattern partitionPattern = Pattern.compile("(?i)(partition\\s+by\\s+)(.*?)(?=(\\s+order\\s+by)|(\\s*$))");
    public static final Pattern orderPattern = Pattern.compile("(?i)order\\s+by\\s+(.*)");
    public static final Pattern overPattern = Pattern.compile("(?i)\\b(\\w+)\\s*\\(.*?\\)\\s+over\\s*\\(\\s*(.*?)\\s*\\)");
    public static final Pattern overPartitionPattern = Pattern.compile("(?i)partition\\s+by\\s+(.*?)(?=\\s+(order\\s+by|\\)))");
    public static final Pattern overOrderPattern = Pattern.compile("(?i)order\\s+by\\s+([\\w.,\\s]+?(?:asc|desc)?\\s*)\\s*\\)");
    private static final Pattern orderItemPattern = Pattern.compile("\\s*([\\w.]+)\\s*(asc|desc)?\\s*", 2);
    public static final Pattern sumContentPattern = Pattern.compile("(?i)sum\\s*\\(\\s*(.*?)\\s*\\)");
    public static final Pattern maxContentPattern = Pattern.compile("(?i)max\\s*\\(\\s*(.*?)\\s*\\)");
    public static final Pattern minContentPattern = Pattern.compile("(?i)min\\s*\\(\\s*(.*?)\\s*\\)");

    public static synchronized void addRowNumberList(String rowNumber) {
        if (Objects.isNull(rowNumberList.get())) {
            rowNumberList.set(new ArrayList());
        }
        ((List)rowNumberList.get()).add(rowNumber);
    }

    public static List<String> getRowNumberList() {
        if (Objects.isNull(rowNumberList.get())) {
            return Collections.emptyList();
        }
        return (List)rowNumberList.get();
    }

    public static synchronized void addSelectInfoCacheList(Map<String, List<StepFieldInfo>> step) {
        if (Objects.isNull(selectInfoCacheList.get())) {
            selectInfoCacheList.set(new ArrayList());
        }
        ((List)selectInfoCacheList.get()).add(step);
    }

    public static List<Map<String, List<StepFieldInfo>>> getSelectInfoCacheList() {
        if (Objects.isNull(selectInfoCacheList.get())) {
            return Collections.emptyList();
        }
        return (List)selectInfoCacheList.get();
    }

    public static void putGPTJson(JSONObject gptJson) {
        GPTJson.set((Object)gptJson);
    }

    public static JSONObject getGPTJson() {
        if (Objects.isNull(GPTJson.get())) {
            return new JSONObject();
        }
        return (JSONObject)GPTJson.get();
    }

    public void testSql2Json() {
        try {
            JSONArray solutionSteps = new JSONArray();
            String sqlStr = "{\"step\":[{\"as\":\"Step1\",\"F\":{\"metric\":\"DS20250702102044Vdp7YENZ\"},\"C\":{\"MonthlyTotalAmount|amount\":[\"Sum(total_amount)#MonthlyTotalAmount#\u8ba2\u5355\u91d1\u989d\"],\"Month|date\":[\"DateFormat(order_time,y_M)#Month#\u6708\u4efd\"]},\"W\":{\"and\":[\"order_time btw DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 YEAR), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c\"]},\"G\":[\"product_name\",\"Month\"],\"S\":{\"field\":[\"product_name\",\"Month\",\"MonthlyTotalAmount\"]}},{\"as\":\"Step2\",\"F\":{\"step\":\"Step1\"},\"C\":{\"CumulativeAmount|SUM_OVER\":[\"sum(MonthlyTotalAmount) over (partition by product_name order by Month)#CumulativeAmount#\u7d2f\u8ba1\u91d1\u989d\"]},\"S\":{\"field\":[\"product_name\",\"Month\",\"MonthlyTotalAmount\",\"CumulativeAmount\"]}}],\"mainDimension\":\"product_name\",\"timeDimension\":[\"Month\"],\"showDefine\":{\"showType\":{\"type\":{\"title\":\"\u8fd1\u4e09\u5e74\u5404\u4ea7\u54c1\u5404\u6708\u7d2f\u8ba1\u91d1\u989d\",\"value\":\"0\"}}}}";
            JSONObject generalSql = JSON.parseObject((String)sqlStr);
            log.info("gpt output generalSql {}", (Object)generalSql);
            JSONArray stepSimpleArray = generalSql.getJSONArray("step");
            String ss = "[{\"quickQuestion\":\"AI\",\"metricName\":\"\u8ba2\u5355\",\"modelId\":\"137\",\"datasetName\":\"\u8ba2\u5355\",\"questions\":[{\"question\":\"\u67e5\u770b\u6bcf\u4e2a\u4e1a\u52a1\u5458\u7684\u603b\u9500\u552e\u989d\u3002\",\"lang\":{\"question\":{\"zh_TW\":\"\u67e5\u770b\u6bcf\u500b\u696d\u52d9\u54e1\u7684\u7e3d\u92b7\u552e\u984d\u3002\",\"en_US\":\"\u67e5\u770b\u6bcf\u4e2a\u4e1a\u52a1\u5458\u7684\u603b\u9500\u552e\u989d\u3002\",\"zh_CN\":\"\u67e5\u770b\u6bcf\u4e2a\u4e1a\u52a1\u5458\u7684\u603b\u9500\u552e\u989d\u3002\"}}},{\"question\":\"\u5206\u6790\u4e0d\u540c\u4ea7\u54c1\u7684\u5e73\u5747\u5355\u4ef7\u53d8\u5316\u8d8b\u52bf\u3002\",\"lang\":{\"question\":{\"zh_TW\":\"\u5206\u6790\u4e0d\u540c\u7522\u54c1\u7684\u5e73\u5747\u55ae\u50f9\u8b8a\u5316\u8da8\u52e2\u3002\",\"en_US\":\"\u5206\u6790\u4e0d\u540c\u4ea7\u54c1\u7684\u5e73\u5747\u5355\u4ef7\u53d8\u5316\u8d8b\u52bf\u3002\",\"zh_CN\":\"\u5206\u6790\u4e0d\u540c\u4ea7\u54c1\u7684\u5e73\u5747\u5355\u4ef7\u53d8\u5316\u8d8b\u52bf\u3002\"}}},{\"question\":\"\u7edf\u8ba1\u6bcf\u4f4d\u5ba2\u6237\u7684\u8d2d\u4e70\u6570\u91cf\u6392\u540d\u60c5\u51b5\u3002\",\"lang\":{\"question\":{\"zh_TW\":\"\u7d71\u8a08\u6bcf\u4f4d\u5ba2\u6236\u7684\u8cfc\u8cb7\u6578\u91cf\u6392\u540d\u60c5\u6cc1\u3002\",\"en_US\":\"\u7edf\u8ba1\u6bcf\u4f4d\u5ba2\u6237\u7684\u8d2d\u4e70\u6570\u91cf\u6392\u540d\u60c5\u51b5\u3002\",\"zh_CN\":\"\u7edf\u8ba1\u6bcf\u4f4d\u5ba2\u6237\u7684\u8d2d\u4e70\u6570\u91cf\u6392\u540d\u60c5\u51b5\u3002\"}}}],\"description\":\"\u8ba2\u5355\u4fe1\u606f\",\"fieldSchema\":[{\"enums\":[],\"dataType\":\"string\",\"name\":\"order_id\",\"description\":\"\u8ba2\u5355id\",\"title\":\"\u8ba2\u5355\u7f16\u53f7\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"customer_id\",\"title\":\"\u5ba2\u6237\u7f16\u53f7\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"customer_name\",\"title\":\"\u5ba2\u6237\u540d\u79f0\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"salesman_id\",\"title\":\"\u4e1a\u52a1\u5458\u7f16\u53f7\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"salesman_name\",\"title\":\"\u4e1a\u52a1\u5458\u59d3\u540d\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"product_id\",\"title\":\"\u4ea7\u54c1\u7f16\u53f7\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"product_name\",\"title\":\"\u4ea7\u54c1\u540d\u79f0\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"date\",\"name\":\"order_time\",\"title\":\"\u8ba2\u5355\u7b7e\u8ba2\u65f6\u95f4\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"date\",\"name\":\"createdate\",\"title\":\"\u521b\u5efa\u65e5\u671f\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"date\",\"name\":\"modifydate\",\"title\":\"\u4fee\u6539\u65e5\u671f\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"date\",\"name\":\"close_time\",\"title\":\"\u8ba2\u5355\u5173\u95ed\u65e5\u671f\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"decimal\",\"name\":\"total_amount\",\"title\":\"\u603b\u4ef7\",\"businessType\":\"amount\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"numeric\",\"name\":\"quantity\",\"title\":\"\u8d2d\u4e70\u6570\u91cf\",\"businessType\":\"Quantity\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"decimal\",\"name\":\"unit_price\",\"title\":\"\u4ea7\u54c1\u5355\u4ef7\",\"businessType\":\"amount\",\"needPullData\":false,\"nullStyle\":\"-\"}],\"version\":\"1.0\",\"modules\":[{\"name\":\"\u9500\u552e\u7ba1\u7406\",\"subsystems\":[\"\u8ba2\u5355\u7ba1\u7406\",\"\u5ba2\u6237\u7ba1\u7406\",\"\u4ea7\u54c1\u7ba1\u7406\"]}],\"measures\":[{\"enums\":[],\"data_name\":\"total_amount\",\"data_type\":\"decimal\",\"name\":\"\u603b\u4ef7\",\"businessType\":\"amount\",\"needPullData\":false,\"map_field\":\"sales_order__total_amount\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"quantity\",\"data_type\":\"numeric\",\"name\":\"\u8d2d\u4e70\u6570\u91cf\",\"businessType\":\"Quantity\",\"needPullData\":false,\"map_field\":\"sales_order__quantity\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"unit_price\",\"data_type\":\"decimal\",\"name\":\"\u4ea7\u54c1\u5355\u4ef7\",\"businessType\":\"amount\",\"needPullData\":false,\"map_field\":\"sales_order__unit_price\",\"nullStyle\":\"-\"}],\"metricId\":\"DS20250702102044Vdp7YENZ\",\"entities\":[\"\u8ba2\u5355\",\"\u5ba2\u6237\",\"\u4e1a\u52a1\u5458\",\"\u4ea7\u54c1\"],\"modelCode\":\"sales_order\",\"datasetId\":\"DS20250702102044Vdp7YENZ\",\"metrics\":[\"\u9500\u552e\u603b\u989d\",\"\u5e73\u5747\u8ba2\u5355\u91d1\u989d\",\"\u8ba2\u5355\u6570\u91cf\",\"\u5e73\u5747\u8d2d\u4e70\u6570\u91cf\",\"\u5355\u4ef6\u5229\u6da6\"],\"lang\":{\"name\":{\"zh_TW\":\"\u8a02\u55ae\",\"en_US\":\"\u8ba2\u5355\",\"zh_CN\":\"\u8ba2\u5355\"},\"description\":{\"zh_TW\":\"\u8a02\u55ae\u8cc7\u8a0a\",\"en_US\":\"\u8ba2\u5355\u4fe1\u606f\",\"zh_CN\":\"\u8ba2\u5355\u4fe1\u606f\"}},\"applicationCode\":\"Mfe0920564AT\",\"applicationName\":\"\u9648\u8a00\u6d4b\u8bd5 2.0\",\"dimensions\":[{\"enums\":[],\"data_name\":\"order_id\",\"data_type\":\"string\",\"name\":\"\u8ba2\u5355\u7f16\u53f7\",\"description\":\"\u8ba2\u5355id\",\"needPullData\":false,\"map_field\":\"sales_order__order_id\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"customer_id\",\"data_type\":\"string\",\"name\":\"\u5ba2\u6237\u7f16\u53f7\",\"needPullData\":false,\"map_field\":\"sales_order__customer_id\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"customer_name\",\"data_type\":\"string\",\"name\":\"\u5ba2\u6237\u540d\u79f0\",\"needPullData\":false,\"map_field\":\"sales_order__customer_name\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"salesman_id\",\"data_type\":\"string\",\"name\":\"\u4e1a\u52a1\u5458\u7f16\u53f7\",\"needPullData\":false,\"map_field\":\"sales_order__salesman_id\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"salesman_name\",\"data_type\":\"string\",\"name\":\"\u4e1a\u52a1\u5458\u59d3\u540d\",\"needPullData\":false,\"map_field\":\"sales_order__salesman_name\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"product_id\",\"data_type\":\"string\",\"name\":\"\u4ea7\u54c1\u7f16\u53f7\",\"needPullData\":false,\"map_field\":\"sales_order__product_id\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"product_name\",\"data_type\":\"string\",\"name\":\"\u4ea7\u54c1\u540d\u79f0\",\"needPullData\":false,\"map_field\":\"sales_order__product_name\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"order_time\",\"data_type\":\"date\",\"name\":\"\u8ba2\u5355\u7b7e\u8ba2\u65f6\u95f4\",\"needPullData\":false,\"map_field\":\"sales_order__order_time\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"createdate\",\"data_type\":\"date\",\"name\":\"\u521b\u5efa\u65e5\u671f\",\"needPullData\":false,\"map_field\":\"sales_order__createdate\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"modifydate\",\"data_type\":\"date\",\"name\":\"\u4fee\u6539\u65e5\u671f\",\"needPullData\":false,\"map_field\":\"sales_order__modifydate\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"close_time\",\"data_type\":\"date\",\"name\":\"\u8ba2\u5355\u5173\u95ed\u65e5\u671f\",\"needPullData\":false,\"map_field\":\"sales_order__close_time\",\"nullStyle\":\"-\"}]},{\"quickQuestion\":\"AI\",\"metricName\":\"\u5229\u6da6\",\"modelId\":\"135\",\"datasetName\":\"\u5229\u6da6\",\"questions\":[{\"question\":\"\u67e5\u770b\u4e0d\u540c\u4ea7\u54c1\u7684\u5229\u6da6\u603b\u989d\u3002\",\"lang\":{\"question\":{\"zh_TW\":\"\u67e5\u770b\u4e0d\u540c\u7522\u54c1\u7684\u5229\u6f64\u7e3d\u984d\u3002\",\"en_US\":\"\u67e5\u770b\u4e0d\u540c\u4ea7\u54c1\u7684\u5229\u6da6\u603b\u989d\u3002\",\"zh_CN\":\"\u67e5\u770b\u4e0d\u540c\u4ea7\u54c1\u7684\u5229\u6da6\u603b\u989d\u3002\"}}},{\"question\":\"\u5206\u6790\u5ba2\u6237\u540d\u79f0\u4e0e\u5229\u6da6\u4e4b\u95f4\u7684\u5173\u7cfb\u3002\",\"lang\":{\"question\":{\"zh_TW\":\"\u5206\u6790\u5ba2\u6236\u540d\u7a31\u8207\u5229\u6f64\u4e4b\u9593\u7684\u95dc\u4fc2\u3002\",\"en_US\":\"\u5206\u6790\u5ba2\u6237\u540d\u79f0\u4e0e\u5229\u6da6\u4e4b\u95f4\u7684\u5173\u7cfb\u3002\",\"zh_CN\":\"\u5206\u6790\u5ba2\u6237\u540d\u79f0\u4e0e\u5229\u6da6\u4e4b\u95f4\u7684\u5173\u7cfb\u3002\"}}},{\"question\":\"\u89c2\u5bdf\u5229\u6da6\u5728\u4e0d\u540c\u65f6\u95f4\u6bb5\u7684\u53d8\u5316\u8d8b\u52bf\u3002\",\"lang\":{\"question\":{\"zh_TW\":\"\u89c0\u5bdf\u5229\u6f64\u5728\u4e0d\u540c\u6642\u9593\u6bb5\u7684\u8b8a\u5316\u8da8\u52e2\u3002\",\"en_US\":\"\u89c2\u5bdf\u5229\u6da6\u5728\u4e0d\u540c\u65f6\u95f4\u6bb5\u7684\u53d8\u5316\u8d8b\u52bf\u3002\",\"zh_CN\":\"\u89c2\u5bdf\u5229\u6da6\u5728\u4e0d\u540c\u65f6\u95f4\u6bb5\u7684\u53d8\u5316\u8d8b\u52bf\u3002\"}}}],\"description\":\"\u5229\u6da6\",\"fieldSchema\":[{\"enums\":[],\"dataType\":\"string\",\"name\":\"order_id\",\"title\":\"\u8ba2\u5355\u7f16\u53f7\",\"needPullData\":true,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"customer_id\",\"title\":\"\u5ba2\u6237\u7f16\u53f7\",\"needPullData\":true,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"product_id\",\"title\":\"\u4ea7\u54c1\u7f16\u53f7\",\"needPullData\":true,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"customer_name\",\"title\":\"\u5ba2\u6237\u540d\u79f0\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"string\",\"name\":\"product_name\",\"title\":\"\u4ea7\u54c1\u540d\u79f0\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"date\",\"name\":\"createdate\",\"title\":\"\u521b\u5efa\u65e5\u671f\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"date\",\"name\":\"modifydate\",\"title\":\"\u4fee\u6539\u65e5\u671f\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"numeric\",\"name\":\"quantity\",\"description\":\"\u8d2d\u4e70\u6570\u91cf\",\"title\":\"\u8d2d\u4e70\u6570\u91cf\",\"businessType\":\"Quantity\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"decimal\",\"name\":\"sale_price\",\"description\":\"\",\"title\":\"\u9500\u552e\u5355\u4ef7\",\"businessType\":\"amount\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"decimal\",\"name\":\"purchase_price\",\"description\":\"\",\"title\":\"\u91c7\u8d2d\u5355\u4ef7\",\"businessType\":\"amount\",\"needPullData\":false,\"nullStyle\":\"-\"},{\"enums\":[],\"dataType\":\"decimal\",\"name\":\"profit\",\"description\":\"\",\"title\":\"\u5229\u6da6\",\"businessType\":\"amount\",\"needPullData\":false,\"nullStyle\":\"-\"}],\"version\":\"1.0\",\"modules\":[{\"name\":\"\u8d22\u52a1\u7ba1\u7406\",\"subsystems\":[\"\u5229\u6da6\u5206\u6790\"]},{\"name\":\"\u9500\u552e\u7ba1\u7406\",\"subsystems\":[\"\u8ba2\u5355\u7ba1\u7406\",\"\u9500\u552e\u7edf\u8ba1\"]}],\"measures\":[{\"enums\":[],\"data_name\":\"quantity\",\"data_type\":\"numeric\",\"name\":\"\u8d2d\u4e70\u6570\u91cf\",\"description\":\"\u8d2d\u4e70\u6570\u91cf\",\"businessType\":\"Quantity\",\"needPullData\":false,\"map_field\":\"profit_analysis__quantity\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"sale_price\",\"data_type\":\"decimal\",\"name\":\"\u9500\u552e\u5355\u4ef7\",\"description\":\"\",\"businessType\":\"amount\",\"needPullData\":false,\"map_field\":\"profit_analysis__sale_price\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"purchase_price\",\"data_type\":\"decimal\",\"name\":\"\u91c7\u8d2d\u5355\u4ef7\",\"description\":\"\",\"businessType\":\"amount\",\"needPullData\":false,\"map_field\":\"profit_analysis__purchase_price\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"profit\",\"data_type\":\"decimal\",\"name\":\"\u5229\u6da6\",\"description\":\"\",\"businessType\":\"amount\",\"needPullData\":false,\"map_field\":\"profit_analysis__profit\",\"nullStyle\":\"-\"}],\"metricId\":\"DS202507021404025zRt1c84\",\"entities\":[\"\u8ba2\u5355\",\"\u5ba2\u6237\",\"\u4ea7\u54c1\"],\"modelCode\":\"profit_analysis\",\"datasetId\":\"DS202507021404025zRt1c84\",\"metrics\":[\"\u9500\u552e\u603b\u989d\",\"\u8ba2\u5355\u6570\u91cf\",\"\u5e73\u5747\u8ba2\u5355\u91d1\u989d\",\"\u5355\u4ef6\u5229\u6da6\",\"\u5e73\u5747\u8d2d\u4e70\u6570\u91cf\",\"\u5229\u6da6\u603b\u989d\"],\"lang\":{\"name\":{\"zh_TW\":\"\u5229\u6f64\",\"en_US\":\"\u5229\u6da6\",\"zh_CN\":\"\u5229\u6da6\"},\"description\":{\"zh_TW\":\"\u5229\u6f64\",\"en_US\":\"\u5229\u6da6\",\"zh_CN\":\"\u5229\u6da6\"}},\"applicationCode\":\"Mfe0920564AT\",\"applicationName\":\"\u9648\u8a00\u6d4b\u8bd5 2.0\",\"dimensions\":[{\"enums\":[],\"data_name\":\"order_id\",\"data_type\":\"string\",\"name\":\"\u8ba2\u5355\u7f16\u53f7\",\"needPullData\":true,\"map_field\":\"profit_analysis__order_id\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"customer_id\",\"data_type\":\"string\",\"name\":\"\u5ba2\u6237\u7f16\u53f7\",\"needPullData\":true,\"map_field\":\"profit_analysis__customer_id\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"product_id\",\"data_type\":\"string\",\"name\":\"\u4ea7\u54c1\u7f16\u53f7\",\"needPullData\":true,\"map_field\":\"profit_analysis__product_id\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"customer_name\",\"data_type\":\"string\",\"name\":\"\u5ba2\u6237\u540d\u79f0\",\"needPullData\":false,\"map_field\":\"profit_analysis__customer_name\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"product_name\",\"data_type\":\"string\",\"name\":\"\u4ea7\u54c1\u540d\u79f0\",\"needPullData\":false,\"map_field\":\"profit_analysis__product_name\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"createdate\",\"data_type\":\"date\",\"name\":\"\u521b\u5efa\u65e5\u671f\",\"needPullData\":false,\"map_field\":\"profit_analysis__createdate\",\"nullStyle\":\"-\"},{\"enums\":[],\"data_name\":\"modifydate\",\"data_type\":\"date\",\"name\":\"\u4fee\u6539\u65e5\u671f\",\"needPullData\":false,\"map_field\":\"profit_analysis__modifydate\",\"nullStyle\":\"-\"}]}]";
            JSONArray metricInfo = JSONArray.parseArray((String)ss);
            JSONObject context = new JSONObject();
            Question question = new Question();
            question.setProductVersion("V2");
            question.setMessage("\u67e5\u770b\u6bcf\u4e2a\u4e1a\u52a1\u5458\u7684\u603b\u9500\u552e\u989d");
            context.put("scelect_dataSet", (Object)true);
            context.put("question", (Object)question);
            context.put("final_dataSet", (Object)metricInfo);
            Boolean convertIsError = false;
            HashMap otherInfoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)stepSimpleArray) && CollectionUtils.isNotEmpty((Collection)metricInfo)) {
                metricInfo = this.filterMetricInfo(context, metricInfo, stepSimpleArray);
                ConvertorJsonCommonMethod.buildSynonymsMap((JSONObject)context);
                if (stepSimpleArray.size() == 1) {
                    this.supplementGPTGroupElement(stepSimpleArray);
                    log.info("after java supplement generalSql {}", (Object)generalSql);
                }
                if ((convertIsError = this.analysisJson(context, stepSimpleArray, metricInfo, otherInfoMap, solutionSteps, generalSql)).booleanValue()) {
                    return;
                }
                if (solutionSteps.size() > 0) {
                    JSONArray select = solutionSteps.getJSONObject(solutionSteps.size() - 1).getJSONArray("select");
                    if (CollectionUtils.isEmpty((Collection)select)) {
                        return;
                    }
                    ConvertorJsonCommonMethod.reBuildSorts((JSONArray)solutionSteps, (JSONArray)select);
                    List timeDimension = (List)generalSql.getOrDefault((Object)"timeDimension", new ArrayList());
                    context.put("dataTag", (Object)ConvertorJsonCommonMethod.buildFieldTypeInDataTag((List)((List)context.getOrDefault((Object)"dataTag", new ArrayList())), (JSONArray)select, (List)timeDimension, (String)SolutionStepConstants.IS_TIME));
                    String mainDimension = generalSql.getString("mainDimension");
                    if (StringUtils.isNotEmpty((CharSequence)mainDimension)) {
                        context.put("dataTag", (Object)ConvertorJsonCommonMethod.buildFieldTypeInDataTag((List)((List)context.getOrDefault((Object)"dataTag", new ArrayList())), (JSONArray)select, Arrays.asList(mainDimension), (String)SolutionStepConstants.IS_MAIN_DIMENSION));
                    }
                }
            }
            this.fullJoinRename(solutionSteps);
            System.out.println();
        }
        catch (JSONException | BussinessException e) {
            log.error("general type convertor error: ", e);
            if ("checkFieldIsFalse".equals(e.getMessage())) {
                System.out.println("aaa");
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output doProcess(JSONObject context) {
        Question question = (Question)context.getObject("question", Question.class);
        if (Objects.isNull(question)) {
            question = new Question();
            FluctuateRequest fluctuateRequest = (FluctuateRequest)context.getObject("fluctuateRequest", FluctuateRequest.class);
            if (Objects.nonNull(fluctuateRequest)) {
                question.setProductVersion(ProductVersionEnum.FLAGSHIP_VERSION.getCode());
                question.setLocale(fluctuateRequest.getLocale());
                question.setMessage(fluctuateRequest.getQuestion());
                context.put("question", (Object)question);
                context.put("scelect_dataSet", (Object)true);
            } else {
                DataAttributionRequest dataAttributionRequest = (DataAttributionRequest)context.getObject("dataAttributionRequest", DataAttributionRequest.class);
                question.setProductVersion(ProductVersionEnum.FLAGSHIP_VERSION.getCode());
                question.setLocale(dataAttributionRequest.getLocale());
                question.setMessage(dataAttributionRequest.getQuestion());
                context.put("question", (Object)question);
                context.put("scelect_dataSet", (Object)true);
            }
        }
        JSONArray solutionSteps = new JSONArray();
        String NL2SQL_GENERAL = "nl2sql_general";
        String NL2SQL_NEST = "nl2sql_nest";
        String replyKey = "message.scrumbi.gpt.analysis.question.error";
        String productVersion = null;
        if (Objects.nonNull(context.getObject("question", Question.class))) {
            productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        }
        if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            NL2SQL_GENERAL = NL2SQL_GENERAL + "_V1";
            NL2SQL_NEST = NL2SQL_NEST + "_V1";
            replyKey = "message.scrumbi.gpt.analysis.dataset.question.error";
        } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            NL2SQL_GENERAL = NL2SQL_GENERAL + "_V2";
            NL2SQL_NEST = NL2SQL_NEST + "_V2";
            replyKey = "message.scrumbi.gpt.analysis.dataset.question.error";
        }
        JSONObject GPTGeneralSql = context.getJSONObject(NL2SQL_GENERAL);
        JSONArray finalMetric = context.getJSONArray("final_metric");
        if (CollectionUtils.isEmpty((Collection)finalMetric)) {
            finalMetric = context.getJSONArray("final_dataSet");
        }
        List mertricNames = finalMetric.stream().map(metric -> ((JSONObject)metric).getString("metricName")).collect(Collectors.toList());
        MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        String param = mertricNames.toString();
        String reply = messageUtils.getMessageByLangNameWithFormat(replyKey, locale, new Object[]{param});
        try {
            if (null == GPTGeneralSql && null == (GPTGeneralSql = context.getJSONObject(NL2SQL_NEST))) {
                Output output = Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                return output;
            }
            if (GPTGeneralSql.containsKey((Object)"R")) {
                context.put("metric_schema_info_miss", (Object)1);
                log.error("analysis GPT JSON is error {}", (Object)GPTGeneralSql.getString("R"));
                Output output = Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                return output;
            }
            String jsonString = JSON.toJSONString((Object)GPTGeneralSql);
            if (jsonString.contains("*") || jsonString.contains("CASE WHEN")) {
                log.error("GPT JSON has * or caseWhen== {}", (Object)GPTGeneralSql);
                Output output = Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                return output;
            }
            JSONObject generalSql = (JSONObject)JSON.parseObject((String)GPTGeneralSql.toJSONString(), JSONObject.class, (Feature[])new Feature[]{Feature.OrderedField});
            context.put("orgOutPutSql", (Object)generalSql);
            log.info("gpt output generalSql {}", (Object)generalSql);
            JSONArray stepSimpleArray = generalSql.getJSONArray("step");
            JSONArray metricInfo = ConvertorJsonCommonMethod.getMetricInfo((JSONObject)context);
            HashMap otherInfoMap = new HashMap();
            Boolean convertIsError = false;
            if (CollectionUtils.isNotEmpty((Collection)stepSimpleArray) && CollectionUtils.isNotEmpty((Collection)metricInfo)) {
                if (CollectionUtils.isEmpty((Collection)(metricInfo = this.filterMetricInfo(context, metricInfo, stepSimpleArray)))) {
                    Output output = Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                    return output;
                }
                ConvertorJsonCommonMethod.buildSynonymsMap((JSONObject)context);
                if (stepSimpleArray.size() == 1) {
                    this.supplementGPTGroupElement(stepSimpleArray);
                    log.info("after java supplement generalSql {}", (Object)generalSql);
                }
                if ((convertIsError = this.analysisJson(context, stepSimpleArray, metricInfo, otherInfoMap, solutionSteps, generalSql)).booleanValue()) {
                    Output output = Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                    return output;
                }
                if (solutionSteps.size() > 0) {
                    JSONArray select = solutionSteps.getJSONObject(solutionSteps.size() - 1).getJSONArray("select");
                    if (CollectionUtils.isEmpty((Collection)select)) {
                        Output output = Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                        return output;
                    }
                    ConvertorJsonCommonMethod.reBuildSorts((JSONArray)solutionSteps, (JSONArray)select);
                    List timeDimension = (List)generalSql.getOrDefault((Object)"timeDimension", new ArrayList());
                    context.put("dataTag", (Object)ConvertorJsonCommonMethod.buildFieldTypeInDataTag((List)((List)context.getOrDefault((Object)"dataTag", new ArrayList())), (JSONArray)select, (List)timeDimension, (String)SolutionStepConstants.IS_TIME));
                    String mainDimension = generalSql.getString("mainDimension");
                    if (StringUtils.isNotEmpty((CharSequence)mainDimension)) {
                        context.put("dataTag", (Object)ConvertorJsonCommonMethod.buildFieldTypeInDataTag((List)((List)context.getOrDefault((Object)"dataTag", new ArrayList())), (JSONArray)select, Arrays.asList(mainDimension), (String)SolutionStepConstants.IS_MAIN_DIMENSION));
                    }
                }
            }
            this.fullJoinRename(solutionSteps);
        }
        catch (Exception e) {
            if (e instanceof BussinessException && "checkFieldIsFalse".equals(e.getMessage())) {
                Output output = Output.finish((String)"success", (Object)false).keep("reply", (Object)reply);
                return output;
            }
            log.error("general type convertor error: ", (Throwable)e);
        }
        finally {
            selectInfoCacheList.remove();
            GPTJson.remove();
            rowNumberList.remove();
        }
        return Output.through((String)"solutionStep", (Object)solutionSteps).keep("dataTag", (Object)context.getJSONArray("dataTag"));
    }

    private void supplementGPTGroupElement(JSONArray stepSimpleArray) {
        JSONObject stepItemJson = stepSimpleArray.getJSONObject(0);
        JSONArray selectArray = stepItemJson.getJSONObject("S").getJSONArray("field");
        if (!stepItemJson.containsKey((Object)"C") || stepItemJson.getJSONObject("C") == null) {
            return;
        }
        JSONObject computeJson = stepItemJson.getJSONObject("C");
        HashMap<Object, String> computeMap = new HashMap<Object, String>();
        ArrayList list = new ArrayList(computeJson.keySet());
        boolean hasAggregate = false;
        for (Object key : list) {
            JSONArray subArray = computeJson.getJSONArray((String)key);
            String[] keyAndType = ((String)key).split("\\|");
            if (keyAndType.length == 2) {
                key = keyAndType[0];
            }
            for (Object child : subArray) {
                String childStr = child.toString();
                String[] computeArray = childStr.split("#");
                if (computeArray.length != 3) continue;
                String aggregate = computeArray[0];
                if (!aggregate.contains("(")) {
                    return;
                }
                String aggFunction = aggregate.substring(0, aggregate.indexOf("(")).trim();
                computeMap.put(key, aggFunction);
            }
        }
        if (computeMap.isEmpty()) {
            return;
        }
        ArrayList<Object> fieldList = new ArrayList<Object>();
        for (Object select : selectArray) {
            Object selectStr = select.toString();
            String[] selectAlias = ((String)selectStr).split("#");
            if (computeMap.containsKey(selectStr = selectAlias[0])) {
                String aggFunction = (String)computeMap.get(selectStr);
                if (SolutionStepConstants.getGroupByList().contains(aggFunction)) {
                    hasAggregate = true;
                }
                if (!"DateFormat".equals(aggFunction)) continue;
                fieldList.add(selectStr);
                continue;
            }
            fieldList.add(selectStr);
        }
        if (!hasAggregate || CollectionUtils.isEmpty(fieldList)) {
            return;
        }
        JSONArray groupArray = stepItemJson.getJSONArray("G");
        if (CollectionUtils.isEmpty((Collection)groupArray)) {
            stepItemJson.put("G", fieldList);
            return;
        }
        ArrayList<String> groupFieldList = new ArrayList<String>();
        for (Object group : groupArray) {
            String groupName = group.toString();
            groupFieldList.add(groupName);
        }
        ArrayList tempFieldList = new ArrayList(fieldList);
        tempFieldList.removeAll(groupFieldList);
        groupFieldList.addAll(tempFieldList);
        stepItemJson.put("G", groupFieldList);
    }

    /*
     * WARNING - void declaration
     */
    private void fullJoinRename(JSONArray solutionSteps) {
        ArrayList fullJoinCopyStepList = new ArrayList(1);
        if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
            JSONObject lastStep = (JSONObject)solutionSteps.get(solutionSteps.size() - 1);
            if (CollectionUtils.isNotEmpty((Collection)lastStep.getJSONArray("join"))) {
                void var5_6;
                JSONArray joinList = lastStep.getJSONArray("join");
                boolean bl = false;
                while (var5_6 < joinList.size()) {
                    JSONObject datasetObject;
                    JSONObject step = joinList.getJSONObject((int)var5_6);
                    if ("FULL JOIN".equalsIgnoreCase(String.valueOf(step.get((Object)"joinType"))) && "step".equalsIgnoreCase((datasetObject = step.getJSONObject("datasetObject")).getString("datasetType"))) {
                        HashMap sourceKContentV = new HashMap(1);
                        String needCopyStepName = datasetObject.getString("step");
                        String copyStepName = needCopyStepName + "_COPY";
                        datasetObject.put("step", (Object)copyStepName);
                        if (CollectionUtils.isNotEmpty((Collection)step.getJSONArray("on"))) {
                            JSONArray onList = step.getJSONArray("on");
                            HashMap<String, String> contentMap = new HashMap<String, String>(1);
                            for (int j = 0; j < onList.size(); ++j) {
                                JSONObject onObject = onList.getJSONObject(j);
                                JSONObject leftObject = onObject.getJSONObject("left");
                                JSONObject rightObject = onObject.getJSONObject("right");
                                if (leftObject == null || rightObject == null) continue;
                                String content = leftObject.getString("content");
                                String oldContent = rightObject.getString("content");
                                contentMap.put(oldContent, content);
                                sourceKContentV.put(needCopyStepName, contentMap);
                                rightObject.put("content", (Object)content);
                            }
                        }
                        fullJoinCopyStepList.add(sourceKContentV);
                    }
                    ++var5_6;
                }
            }
            if (CollectionUtils.isNotEmpty(fullJoinCopyStepList)) {
                for (Map map : fullJoinCopyStepList) {
                    if (map == null || !CollectionUtils.isNotEmpty(map.keySet())) continue;
                    block3: for (String stepName : map.keySet()) {
                        Map contentMap = (Map)map.get(stepName);
                        if (contentMap == null || !CollectionUtils.isNotEmpty(contentMap.keySet())) continue;
                        String copyStepName = stepName + "_COPY";
                        for (int i = 0; i < solutionSteps.size() - 1; ++i) {
                            JSONObject step = solutionSteps.getJSONObject(i);
                            if (!stepName.equals(step.getString("alias"))) continue;
                            JSONObject copyStep = new JSONObject();
                            copyStep.put("select", this.buildFullJoinCopySelect(step.getJSONArray("select"), contentMap));
                            copyStep.put("alias", (Object)copyStepName);
                            copyStep.put("datasetObject", this.buildFullJoinCopyDataObject(stepName, step));
                            solutionSteps.add(solutionSteps.size() - 1, (Object)copyStep);
                            continue block3;
                        }
                    }
                }
            }
        }
    }

    private Object buildFullJoinCopySelect(JSONArray selectArray, Map<String, String> contentMap) {
        JSONArray newSelectArray = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)selectArray)) {
            ArrayList<JSONObject> copyObject = new ArrayList<JSONObject>();
            for (String oldAlias : contentMap.keySet()) {
                for (int i = 0; i < selectArray.size(); ++i) {
                    JSONObject selectField = selectArray.getJSONObject(i).getJSONObject("dataObject");
                    JSONObject copyField = this.buildCopyField(selectField);
                    if (oldAlias.equals(selectField.getString("alias"))) {
                        copyField.put("alias", (Object)contentMap.get(oldAlias));
                    } else {
                        copyField.put("alias", (Object)selectField.getString("alias"));
                    }
                    JSONObject newField = new JSONObject();
                    newField.put("dataObject", (Object)copyField);
                    copyObject.add(newField);
                }
            }
            newSelectArray.addAll(copyObject);
        }
        return newSelectArray;
    }

    private JSONObject buildCopyField(JSONObject selectField) {
        JSONObject copyField = new JSONObject();
        copyField.put("dataType", selectField.get((Object)"dataType"));
        copyField.put("language", selectField.get((Object)"language"));
        copyField.put("source", selectField.get((Object)"source"));
        copyField.put("title", selectField.get((Object)"title"));
        copyField.put("content", selectField.get((Object)"alias"));
        copyField.put("contentType", (Object)"field");
        return copyField;
    }

    private Object buildFullJoinCopyDataObject(String stepName, JSONObject step) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("datasetType", (Object)"step");
        dataObject.put("step", (Object)stepName);
        dataObject.put("alias", (Object)step.getJSONObject("datasetObject").getString("alias"));
        return dataObject;
    }

    private JSONArray filterMetricInfo(JSONObject context, JSONArray allMetricList, JSONArray stepList) {
        HashSet<String> metricValues = new HashSet<String>();
        for (int i = 0; i < stepList.size(); ++i) {
            JSONObject fObject;
            JSONObject step = stepList.getJSONObject(i);
            if (step.containsKey((Object)"F") && (fObject = step.getJSONObject("F")).containsKey((Object)"metric")) {
                metricValues.add(fObject.getString("metric"));
            }
            if (!step.containsKey((Object)"J")) continue;
            JSONArray jArray = step.getJSONArray("J");
            for (Object o : jArray) {
                JSONObject fObject2 = ((JSONObject)o).getJSONObject("F");
                if (!fObject2.containsKey((Object)"metric")) continue;
                metricValues.add(fObject2.getString("metric"));
            }
        }
        if (CollectionUtils.isEmpty(metricValues)) {
            return allMetricList;
        }
        Map<String, JSONObject> metricMap = allMetricList.stream().map(schema -> (JSONObject)schema).collect(Collectors.toMap(schema -> schema.getString("metricId"), schema -> schema));
        JSONArray finalMetricArray = new JSONArray();
        for (String metricValue : metricValues) {
            JSONObject metric = metricMap.get(metricValue);
            if (metric != null) {
                finalMetricArray.add((Object)metric);
                continue;
            }
            log.warn("metricId not found: {},allMetric:{}", (Object)metricValue, (Object)allMetricList);
            return new JSONArray();
        }
        context.put("final_metric", (Object)finalMetricArray);
        if (context.containsKey((Object)"scelect_dataSet")) {
            context.put("final_dataSet", (Object)finalMetricArray);
        } else {
            context.put("final_metric", (Object)finalMetricArray);
        }
        context.put("metric_size", (Object)finalMetricArray.size());
        return finalMetricArray;
    }

    private Boolean analysisJson(JSONObject context, JSONArray stepSimpleArray, JSONArray metricInfo, Map<String, String> otherInfoMap, JSONArray solutionSteps, JSONObject generalSql) throws BussinessException {
        boolean isLast = false;
        HashMap computeMap = new HashMap();
        Boolean convertIsError = false;
        for (int i = 0; i < stepSimpleArray.size(); ++i) {
            HashMap selectInfoCacheMap = new HashMap();
            if (i == stepSimpleArray.size() - 1) {
                isLast = true;
            }
            JSONObject stepItemJson = (JSONObject)stepSimpleArray.get(i);
            GeneralConvertorWrapperExecutor.putGPTJson((JSONObject)stepItemJson);
            JSONObject stepItem = new JSONObject();
            stepItem.put("metricInfo", (Object)metricInfo);
            if (stepItemJson.containsKey((Object)"as")) {
                stepItem.put("alias", (Object)stepItemJson.getString("as"));
            }
            if (stepItemJson.containsKey((Object)"F")) {
                this.processTableInfo(stepItemJson.getJSONObject("F"), stepItem, Integer.valueOf(i), isLast, context);
            }
            convertIsError = this.getComputeJson(otherInfoMap, solutionSteps, stepItemJson, stepItem, computeMap, convertIsError);
            this.getWhereFilter(context, solutionSteps, stepItemJson, stepItem);
            this.getGroupJson(solutionSteps, stepItemJson, stepItem);
            this.getHavingJson(context, solutionSteps, stepItemJson, stepItem);
            this.getSelectJson(context, otherInfoMap, solutionSteps, stepItemJson, stepItem, isLast, computeMap, selectInfoCacheMap);
            if (!selectInfoCacheMap.isEmpty()) {
                GeneralConvertorWrapperExecutor.addSelectInfoCacheList(selectInfoCacheMap);
            }
            if (stepItemJson.containsKey((Object)"J") && CollectionUtils.isNotEmpty((Collection)stepItemJson.getJSONArray("J"))) {
                this.processJoin(stepItemJson.getJSONArray("J"), stepItem, solutionSteps, context);
            }
            if (stepItemJson.containsKey((Object)"O") && CollectionUtils.isNotEmpty((Collection)stepItemJson.getJSONArray("O"))) {
                this.processOrderBy(stepItemJson, stepItem, solutionSteps);
            }
            ConvertorJsonCommonMethod.processLimit((JSONObject)stepItemJson, (JSONObject)stepItem);
            if (isLast) {
                List existSort = solutionSteps.stream().filter(s -> Objects.nonNull(((JSONObject)s).get((Object)"sort"))).collect(Collectors.toList());
                if (ConvertorJsonCommonMethod.checkIsNeedAddSort((JSONObject)stepItem) && !ConvertorJsonCommonMethod.checkGeneralIsDetailSelect((JSONObject)stepItemJson) && CollectionUtils.isEmpty((Collection)GeneralConvertorWrapperExecutor.getRowNumberList()) && CollectionUtils.isEmpty(existSort)) {
                    ConvertorJsonCommonMethod.addDefaultSort((JSONObject)stepItem);
                }
            }
            stepItem.remove((Object)"metricInfo");
            solutionSteps.add((Object)stepItem);
        }
        if (generalSql.containsKey((Object)"showDefine")) {
            ConvertorJsonCommonMethod.buildGeneralShowDefine((JSONObject)context, (JSONObject)generalSql);
        }
        return convertIsError;
    }

    private Boolean getComputeJson(Map<String, String> otherInfoMap, JSONArray solutionSteps, JSONObject stepItemJson, JSONObject stepItem, Map<String, JSONObject> computeMap, Boolean convertIsError) throws BussinessException {
        if (stepItemJson.containsKey((Object)"C") && stepItemJson.getJSONObject("C") != null) {
            HashMap aliasMap = new HashMap();
            convertIsError = this.processComputeList(stepItemJson.getJSONObject("C"), stepItem, otherInfoMap, solutionSteps, convertIsError, aliasMap);
            if (JSONUtils.isEmptyObject((JSONObject)stepItemJson.getJSONObject("C"))) {
                stepItemJson.put("C", null);
            }
            if (MapUtils.isNotEmpty(aliasMap)) {
                this.replaceAliasFields(stepItemJson, aliasMap);
            }
            this.buildComputeMap(computeMap, stepItemJson, stepItem);
        }
        return convertIsError;
    }

    private void replaceAliasFields(JSONObject stepItemJson, Map<String, String> aliasMap) {
        if (stepItemJson == null || aliasMap == null || aliasMap.isEmpty()) {
            return;
        }
        JSONObject s = stepItemJson.getJSONObject("S");
        if (s == null) {
            return;
        }
        JSONArray fields = s.getJSONArray("field");
        if (fields == null || fields.isEmpty()) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            String mappedValue;
            String currentField;
            Object fieldValue = fields.get(i);
            if (!(fieldValue instanceof String) || !aliasMap.containsKey(currentField = (String)fieldValue) || (mappedValue = aliasMap.get(currentField)) == null) continue;
            fields.set(i, (Object)mappedValue);
        }
    }

    private void getGroupJson(JSONArray solutionSteps, JSONObject stepItemJson, JSONObject stepItem) throws BussinessException {
        if (stepItemJson.containsKey((Object)"G") && CollectionUtils.isNotEmpty((Collection)stepItemJson.getJSONArray("G"))) {
            this.processGroupBy(stepItem, stepItemJson.getJSONArray("G"), solutionSteps);
        }
    }

    private void getSelectJson(JSONObject context, Map<String, String> otherInfoMap, JSONArray solutionSteps, JSONObject stepItemJson, JSONObject stepItem, boolean isLast, Map<String, JSONObject> computeMap, Map<String, List<StepFieldInfo>> selectInfoCacheMap) throws BussinessException {
        if (stepItemJson.containsKey((Object)"S") && stepItemJson.getJSONObject("S") != null) {
            this.processSelect(stepItemJson.getJSONObject("S"), stepItem, otherInfoMap, solutionSteps, selectInfoCacheMap, computeMap);
            if (isLast) {
                List aliasGrainList;
                List dataTagList = this.buildDataTag(computeMap, stepItem, solutionSteps, context);
                if (CollectionUtils.isNotEmpty((Collection)dataTagList)) {
                    context.put("dataTag", (Object)dataTagList);
                }
                if (CollectionUtils.isNotEmpty((Collection)(aliasGrainList = this.buildAliasGrain(stepItem, solutionSteps)))) {
                    context.put("aliasGrain", (Object)aliasGrainList);
                }
                ConvertorJsonCommonMethod.setDimensionCount((JSONObject)stepItem, (JSONObject)context);
            }
        }
    }

    private void getHavingJson(JSONObject context, JSONArray solutionSteps, JSONObject stepItemJson, JSONObject stepItem) {
        if (stepItemJson.containsKey((Object)"H") && stepItemJson.getJSONObject("H") != null) {
            JSONObject havingJson = new JSONObject();
            this.processWhereOrHaving(stepItemJson.getJSONObject("H"), havingJson, stepItem, solutionSteps, context, false);
            if (!havingJson.isEmpty()) {
                stepItem.put("having", (Object)havingJson);
            }
        }
    }

    private void getWhereFilter(JSONObject context, JSONArray solutionSteps, JSONObject stepItemJson, JSONObject stepItem) {
        if (stepItemJson.containsKey((Object)"W")) {
            JSONObject whereJson = new JSONObject();
            this.processWhereOrHaving(stepItemJson.getJSONObject("W"), whereJson, stepItem, solutionSteps, context, true);
            if (!whereJson.isEmpty() && whereJson.containsKey((Object)"children") && CollectionUtils.isNotEmpty((Collection)whereJson.getJSONArray("children"))) {
                stepItem.put("filter", (Object)whereJson);
            }
        }
    }

    private void buildComputeMap(Map<String, JSONObject> computeMap, JSONObject stepItemJson, JSONObject stepItem) {
        JSONObject computeJson = stepItemJson.getJSONObject("C");
        if (Objects.isNull(computeJson)) {
            return;
        }
        Set keys = computeJson.keySet();
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            for (String key : keys) {
                String[] keyAndType = key.split("\\|");
                if (keyAndType.length != 2 || !SolutionStepConstants.getBusinessTypeList().contains(keyAndType[1]) || GeneralConvertorWrapperExecutor.getRowNumberList().contains(keyAndType[0])) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("alias", (Object)stepItem.getString("alias"));
                jsonObject.put("datasetObject", (Object)stepItem.getString("datasetObject"));
                jsonObject.put("businessType", (Object)keyAndType[1]);
                computeMap.put(keyAndType[0], jsonObject);
            }
        }
    }

    public List<JSONObject> buildDataTag(Map<String, JSONObject> computeMap, JSONObject stepItem, JSONArray solutionSteps, JSONObject context) {
        JSONArray jsonArray = stepItem.getJSONArray("select");
        ArrayList<JSONObject> dataTagList = new ArrayList<JSONObject>();
        jsonArray.forEach(item -> {
            JSONObject datasetObj = (JSONObject)item;
            JSONObject select = datasetObj.getJSONObject("dataObject");
            String dataType = select.getString("dataType");
            if (!ConvertorJsonCommonMethod.isMeasure((String)dataType)) {
                return;
            }
            JSONObject dataTag = new JSONObject();
            dataTag.put("alias", (Object)select.getString("alias"));
            dataTag.put("formula", (Object)"");
            dataTag.put("language", (Object)"");
            String content = select.getString("content");
            String[] split = content.split("#");
            if (split.length == 3) {
                content = split[2];
            }
            if (GeneralConvertorWrapperExecutor.getRowNumberList().contains(content)) {
                return;
            }
            if (!computeMap.containsKey(content)) {
                JSONObject jsonObject = new JSONObject();
                String alias = select.getString("source");
                jsonObject.put("alias", (Object)alias);
                for (Object solutionStep : solutionSteps) {
                    JSONObject solutionStepObj = (JSONObject)solutionStep;
                    if (!alias.equals(solutionStepObj.getString("alias"))) continue;
                    jsonObject.put("datasetObject", (Object)solutionStepObj.getString("datasetObject"));
                    break;
                }
                jsonObject.put("businessType", null);
                computeMap.put(content, jsonObject);
            }
            String replaceBusinessType = this.replaceBusinessType(stepItem, content, computeMap, solutionSteps, context);
            dataTag.put("businessType", (Object)replaceBusinessType);
            dataTagList.add(dataTag);
        });
        return dataTagList;
    }

    private String replaceBusinessType(JSONObject stepItem, String content, Map<String, JSONObject> computeMap, JSONArray solutionSteps, JSONObject context) {
        String metricBusinessType;
        String gptBusinessType;
        block14: {
            JSONArray metricInfoList;
            JSONObject jsonObject;
            block12: {
                block13: {
                    jsonObject = computeMap.get(content);
                    gptBusinessType = jsonObject.getString("businessType");
                    if ("Rate".equals(gptBusinessType)) {
                        return gptBusinessType;
                    }
                    metricInfoList = stepItem.getJSONArray("metricInfo");
                    metricBusinessType = "";
                    if (metricInfoList.size() != 1) break block12;
                    if (!context.containsKey((Object)"scelect_dataSet")) break block13;
                    JSONObject fieldSchema = this.getFieldSchema(content, metricInfoList.getJSONObject(0));
                    if (!Objects.nonNull(fieldSchema)) break block14;
                    metricBusinessType = fieldSchema.getString("businessType");
                    break block14;
                }
                metricBusinessType = metricInfoList.getJSONObject(0).getString("businessType");
                break block14;
            }
            JSONObject dataObject = jsonObject.getJSONObject("datasetObject");
            if (null != dataObject) {
                String metricId = null;
                String dataSetType = dataObject.getString("datasetType");
                if (SolutionStepConstants.ALL_DATA_DATASET_TYPE.contains(dataSetType)) {
                    metricId = dataObject.getString(dataSetType);
                } else if ("step".equals(dataSetType)) {
                    for (int i = 0; i < solutionSteps.size(); ++i) {
                        JSONObject step = solutionSteps.getJSONObject(i);
                        if (!dataObject.getString("alias").equals(step.getString("alias"))) continue;
                        metricId = step.getJSONObject("datasetObject").getString("metric");
                    }
                }
                log.info("metricIDAndContent {},{}", (Object)content, (Object)metricId);
                if (metricId != null) {
                    for (Object metric : metricInfoList) {
                        JSONObject metricObj = (JSONObject)metric;
                        if (!metricObj.getString("metricId").equals(metricId)) continue;
                        metricBusinessType = metricObj.getString("businessType");
                        if (context.containsKey((Object)"scelect_dataSet")) {
                            JSONObject fieldSchema = this.getFieldSchema(content, metricObj);
                            if (!Objects.nonNull(fieldSchema)) break;
                            metricBusinessType = fieldSchema.getString("businessType");
                            break;
                        }
                        metricBusinessType = metricObj.getString("businessType");
                        break;
                    }
                }
            }
        }
        if (gptBusinessType == null) {
            return metricBusinessType;
        }
        if ("amount".equals(gptBusinessType) && "unitPrice".equals(metricBusinessType)) {
            return "unitPrice";
        }
        if ("Quantity".equals(gptBusinessType) && "days".equals(metricBusinessType)) {
            return "days";
        }
        return gptBusinessType;
    }

    private List<JSONObject> buildAliasGrain(JSONObject stepItem, JSONArray solutionSteps) {
        try {
            JSONArray jsonArray = stepItem.getJSONArray("select");
            ArrayList<JSONObject> aliasGrainList = new ArrayList<JSONObject>();
            jsonArray.forEach(item -> {
                JSONArray paramArray;
                JSONObject jsonObject;
                String calFunction;
                JSONObject datasetObj = (JSONObject)item;
                JSONObject select = datasetObj.getJSONObject("dataObject");
                String dataType = select.getString("dataType");
                if (ConvertorJsonCommonMethod.isMeasure((String)dataType)) {
                    return;
                }
                JSONObject aliasGrain = new JSONObject();
                aliasGrain.put("alias", (Object)select.getString("alias"));
                String content = select.getString("content");
                String[] split = content.split("#");
                if (split.length == 3) {
                    content = split[2];
                }
                JSONArray dateComputeArray = new JSONArray();
                if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
                    for (Object solutionStep : solutionSteps) {
                        JSONObject solutionStepObj = (JSONObject)solutionStep;
                        JSONObject allCompute = solutionStepObj.getJSONObject("computeList");
                        if (null == allCompute || !allCompute.containsKey((Object)content)) continue;
                        dateComputeArray = allCompute.getJSONArray(content);
                    }
                } else {
                    JSONObject computeObj = stepItem.getJSONObject("computeList");
                    if (null != computeObj && computeObj.containsKey((Object)content)) {
                        dateComputeArray = computeObj.getJSONArray(content);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)dateComputeArray) && StringUtils.isNotBlank((CharSequence)(calFunction = (jsonObject = dateComputeArray.getJSONObject(0)).getString("calFunction"))) && "DateFormat".equals(calFunction) && CollectionUtils.isNotEmpty((Collection)(paramArray = jsonObject.getJSONArray("params"))) && paramArray.size() == 2) {
                    aliasGrain.put("grain", (Object)paramArray.getJSONObject(1).getString("content"));
                }
                if (aliasGrain.containsKey((Object)"grain") && StringUtils.isNotBlank((CharSequence)aliasGrain.getString("grain"))) {
                    aliasGrainList.add(aliasGrain);
                }
            });
            return aliasGrainList;
        }
        catch (Exception e) {
            log.error("buildAliasGrain is error {}", (Throwable)e);
            return null;
        }
    }

    private void processJoin(JSONArray simpleArray, JSONObject stepItem, JSONArray solutionSteps, JSONObject context) throws BussinessException {
        JSONArray metricInfoList = stepItem.getJSONArray("metricInfo");
        JSONArray joinArray = new JSONArray();
        for (Object item : simpleArray) {
            JSONObject joinObject = new JSONObject();
            JSONObject itemJson = (JSONObject)item;
            JSONObject fromJson = itemJson.getJSONObject("F");
            if (null != fromJson) {
                this.processTableInfo(fromJson, joinObject, null, true, context);
            }
            JSONArray onSimpleArr = itemJson.getJSONArray("on");
            joinObject.put("joinType", (Object)SolutionStepConstants.getGptJoinTypeMap().getOrDefault(itemJson.getString("joinType"), itemJson.getString("joinType")));
            if (CollectionUtils.isNotEmpty((Collection)onSimpleArr)) {
                if (onSimpleArr.size() == 1 && "1 eq 1".equals(onSimpleArr.get(0).toString())) {
                    joinObject.put("joinType", (Object)"CROSS JOIN");
                } else {
                    this.buildJoinOnJson(stepItem, solutionSteps, onSimpleArr, joinObject);
                }
            }
            joinArray.add((Object)joinObject);
        }
        stepItem.put("join", (Object)joinArray);
    }

    private void editJoinType(JSONObject stepItem, JSONObject joinObject) {
        JSONObject datasetObject = stepItem.getJSONObject("datasetObject");
        if (datasetObject != null && datasetObject.containsKey((Object)"metric")) {
            joinObject.put("joinType", (Object)"RIGHT JOIN");
        }
    }

    private String checkJoinType(JSONArray metricInfoList, JSONObject context, String joinType) {
        if (metricInfoList.size() > 1) {
            return "LEFT JOIN";
        }
        if (StringUtils.isNotBlank((CharSequence)joinType)) {
            if ("cross".equals(joinType)) {
                return "CROSS JOIN";
            }
            String name = "Query_Classification";
            String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
            if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
                name = name + "_V1";
            } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
                name = name + "_V2";
            }
            JSONObject jsonObject = context.getJSONObject(name);
            if (Constants.UPDATE_JOIN_TYPE_INTENT_LIST.contains(jsonObject.getString("code"))) {
                return "FULL JOIN";
            }
            return SolutionStepConstants.getGptJoinTypeMap().getOrDefault(joinType, joinType);
        }
        return "FULL JOIN";
    }

    private void buildJoinOnJson(JSONObject stepItem, JSONArray solutionSteps, JSONArray onSimpleArr, JSONObject joinObject) throws BussinessException {
        JSONArray onList = new JSONArray();
        for (Object onItem : onSimpleArr) {
            JSONObject onObject = new JSONObject();
            String onStr = (String)onItem;
            String[] splitBlankItem = this.splitBlank(onStr, stepItem, solutionSteps);
            if (splitBlankItem.length != 3) continue;
            String[] leftParts = splitBlankItem[0].split("\\.");
            JSONObject leftObject = this.getLeftObject(stepItem, solutionSteps, leftParts);
            JSONObject rightObject = this.getRightObject(stepItem, solutionSteps, splitBlankItem, joinObject);
            onObject.put("left", (Object)leftObject);
            onObject.put("right", (Object)rightObject);
            onObject.put("operator", (Object)splitBlankItem[1]);
            onList.add((Object)onObject);
        }
        joinObject.put("on", (Object)onList);
    }

    private JSONObject getLeftObject(JSONObject stepItem, JSONArray solutionSteps, String[] leftParts) throws BussinessException {
        if (leftParts.length == 2) {
            if (ConvertorJsonCommonMethod.checkFieldInSchema((String)leftParts[1], (JSONObject)stepItem, (JSONArray)solutionSteps)) {
                throw new BussinessException("checkFieldIsFalse");
            }
            return ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(leftParts[1], leftParts[0], GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, false), (String)leftParts[0], (String)this.getDataType(leftParts[1], stepItem, solutionSteps), (String)"field");
        }
        if (ConvertorJsonCommonMethod.checkFieldInSchema((String)leftParts[0], (JSONObject)stepItem, (JSONArray)solutionSteps)) {
            throw new BussinessException("checkFieldIsFalse");
        }
        return ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(leftParts[0], this.getSource(stepItem), GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, false), (String)this.getSource(stepItem), (String)this.getDataType(leftParts[0], stepItem, solutionSteps), (String)"field");
    }

    private JSONObject getRightObject(JSONObject stepItem, JSONArray solutionSteps, String[] splitBlankItem, JSONObject joinObject) {
        String[] rightParts = splitBlankItem[2].split("\\.");
        if (rightParts.length == 2) {
            return ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(rightParts[1], rightParts[0], GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, false), (String)rightParts[0], (String)this.getDataType(rightParts[1], stepItem, solutionSteps), (String)"field");
        }
        return ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(rightParts[0], this.getSource(joinObject), GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, false), (String)this.getSource(joinObject), (String)this.getDataType(rightParts[0], stepItem, solutionSteps), (String)"field");
    }

    private void processTableInfo(JSONObject fromJson, JSONObject stepItem, Integer index, boolean isLast, JSONObject context) {
        String type = (String)fromJson.keySet().iterator().next();
        String fromName = fromJson.getString(type);
        JSONObject datasetObject = new JSONObject();
        datasetObject.put(type, (Object)fromName);
        if (SolutionStepConstants.ALL_DATA_DATASET_TYPE.contains(type)) {
            datasetObject.put("datasetType", (Object)ConvertorJsonCommonMethod.getDatasetType((JSONObject)context));
        } else {
            datasetObject.put("datasetType", (Object)type);
        }
        datasetObject.put("alias", (Object)fromName);
        if (SolutionStepConstants.ALL_DATA_DATASET_TYPE.contains(type) && !isLast) {
            datasetObject.put("alias", (Object)(fromName + index));
        }
        stepItem.put("datasetObject", (Object)datasetObject);
    }

    private void processOrderBy(JSONObject simpleJson, JSONObject step, JSONArray solutionSteps) throws BussinessException {
        JSONArray sortArray = new JSONArray();
        for (Object item : simpleJson.getJSONArray("O")) {
            String source = "";
            JSONObject orderByJson = new JSONObject();
            String[] orderByItem = item.toString().split("#");
            String fieldName = orderByItem[0];
            String[] split = fieldName.split("\\.");
            if (split.length == 2) {
                fieldName = split[1];
                source = split[0];
            } else {
                source = this.supplementSource(fieldName, null, GeneralConvertorWrapperExecutor.getGPTJson(), step, true);
            }
            if (ConvertorJsonCommonMethod.checkFieldInSchema((String)fieldName, (JSONObject)step, (JSONArray)solutionSteps)) {
                throw new BussinessException("checkFieldIsFalse");
            }
            String orderByType = orderByItem[1];
            orderByJson.put("order", (Object)orderByType);
            orderByJson.put("dataObject", (Object)ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(fieldName, source, GeneralConvertorWrapperExecutor.getGPTJson(), step, false), (String)source, (String)this.getDataType(fieldName, step, solutionSteps), (String)this.getContentType(step, fieldName, solutionSteps)));
            sortArray.add((Object)orderByJson);
        }
        step.put("sort", (Object)sortArray);
    }

    private void processGroupBy(JSONObject step, JSONArray gArray, JSONArray solutionSteps) throws BussinessException {
        JSONArray groupArray = new JSONArray();
        for (Object item : gArray) {
            String source = "";
            String content = item.toString();
            String[] split = content.split("\\.");
            if (split.length == 2) {
                content = split[1];
                source = split[0];
            } else {
                source = this.supplementSource(content, null, GeneralConvertorWrapperExecutor.getGPTJson(), step, true);
            }
            if (ConvertorJsonCommonMethod.checkFieldInSchema((String)content, (JSONObject)step, (JSONArray)solutionSteps)) {
                throw new BussinessException("checkFieldIsFalse");
            }
            groupArray.add((Object)ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(content, source, GeneralConvertorWrapperExecutor.getGPTJson(), step, false), (String)source, (String)this.getDataType(content, step, solutionSteps), (String)this.getContentType(step, content, solutionSteps)));
        }
        if (CollectionUtils.isNotEmpty((Collection)groupArray)) {
            step.put("groupby", (Object)groupArray);
        }
    }

    private String getSource(JSONObject stepItem) {
        JSONObject datasetObject = stepItem.getJSONObject("datasetObject");
        return datasetObject.getString("alias");
    }

    private void processSelect(JSONObject selectJson, JSONObject stepItem, Map<String, String> selectTitleMap, JSONArray solutionSteps, Map<String, List<StepFieldInfo>> selectInfoCacheMap, Map<String, JSONObject> computeMap) throws BussinessException {
        JSONArray selectArray = new JSONArray();
        JSONArray fieldArray = selectJson.getJSONArray("field");
        JSONArray subQueryArray = selectJson.getJSONArray("dataset");
        Boolean ifDistinct = false;
        if (CollectionUtils.isNotEmpty((Collection)fieldArray)) {
            ArrayList<StepFieldInfo> selectFieldList = new ArrayList<StepFieldInfo>();
            for (Object item2 : fieldArray) {
                if (item2.toString().contains("distinct ")) {
                    item2 = item2.toString().replace("distinct ", "");
                    ifDistinct = true;
                }
                String source = "";
                JSONObject selectObj = new JSONObject();
                JSONObject dataObject = new JSONObject();
                JSONObject language = new JSONObject();
                String fieldContent = item2.toString();
                String[] selectAlias = fieldContent.split("#");
                int selectAliasSize = selectAlias.length;
                if (selectAliasSize == 2) {
                    fieldContent = selectAlias[0];
                }
                String[] split = ConvertorJsonCommonMethod.getContentWithIfConst((JSONObject)stepItem, (JSONArray)solutionSteps, (String)fieldContent);
                String fieldName = fieldContent;
                String alias = "";
                if (split.length == 2) {
                    fieldName = fieldContent.split("\\.")[1];
                    source = fieldContent.split("\\.")[0];
                } else {
                    String metricSource = GeneralConvertorWrapperExecutor.getGPTJson().getJSONObject("F").getString("metric");
                    boolean ifFromCurrentMetric = ConvertorJsonCommonMethod.checkFromCurrentMetric((String)fieldName, (JSONObject)stepItem, (String)metricSource);
                    source = ifFromCurrentMetric ? metricSource : this.supplementSource(fieldName, null, GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, true);
                }
                String title = "";
                if (selectAliasSize == 3) {
                    fieldName = selectAlias[0];
                    alias = selectAlias[1];
                    String[] splitSelect = selectAlias[0].split("\\.");
                    if (splitSelect.length == 2) {
                        fieldName = splitSelect[1];
                        source = splitSelect[0];
                    } else {
                        source = this.supplementSource(fieldName, null, GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, true);
                    }
                    selectTitleMap.put(alias, selectAlias[2]);
                }
                if (ConvertorJsonCommonMethod.checkFieldInSchema((String)fieldName, (JSONObject)stepItem, (JSONArray)solutionSteps)) {
                    throw new BussinessException("checkFieldIsFalse");
                }
                if (Objects.nonNull(computeMap.get(fieldName))) {
                    computeMap.put(alias, computeMap.get(fieldName));
                }
                dataObject.put("content", (Object)this.supplementSource(fieldName, source, GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, false));
                dataObject.put("source", (Object)source);
                String contentType = this.getContentType(stepItem, fieldName, solutionSteps);
                if (!"calculate".equals(contentType) && selectTitleMap.containsKey(fieldName)) {
                    contentType = "field";
                }
                dataObject.put("contentType", (Object)contentType);
                dataObject.put("dataType", (Object)this.getDataType(fieldName, stepItem, solutionSteps));
                if (StringUtils.isBlank((CharSequence)alias)) {
                    alias = source + "#" + stepItem.getString("alias") + "#" + fieldName;
                }
                dataObject.put("alias", (Object)alias);
                StepFieldInfo stepFieldInfo1 = new StepFieldInfo();
                stepFieldInfo1.setFieldName(fieldName).setAliasName(alias);
                selectFieldList.add(stepFieldInfo1);
                StepFieldInfo stepFieldInfo = new StepFieldInfo();
                stepFieldInfo.setFieldName(this.supplementSource(fieldName, source, GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, false)).setAliasName(alias);
                selectFieldList.add(stepFieldInfo);
                if (contentType.equals("calculate") && selectTitleMap.containsKey(fieldName)) {
                    title = selectTitleMap.get(fieldName);
                }
                if (contentType.equals("field")) {
                    title = selectTitleMap.get(alias);
                    if (StringUtils.isBlank((CharSequence)title)) {
                        title = selectTitleMap.get(fieldName);
                    }
                    if (selectAliasSize == 1 && StringUtils.isBlank((CharSequence)title)) {
                        JSONObject fieldSchema = this.getMetricFieldSchema(fieldName, stepItem);
                        title = fieldSchema.getString("title").trim();
                    }
                }
                JSONObject languageTitle = new JSONObject();
                languageTitle.put("zh_CN", (Object)ZhTwConverterUtil.toSimple((String)title));
                languageTitle.put("zh_TW", (Object)ZhTwConverterUtil.toTraditional((String)title));
                language.put("title", (Object)languageTitle);
                dataObject.put("title", (Object)title);
                dataObject.put("contentType", (Object)this.checkSelectContentType(stepItem, fieldName, contentType));
                dataObject.put("language", (Object)language);
                selectObj.put("dataObject", (Object)dataObject);
                selectArray.add((Object)selectObj);
            }
            if (CollectionUtils.isNotEmpty(selectFieldList)) {
                selectInfoCacheMap.put(stepItem.getString("alias"), selectFieldList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)subQueryArray)) {
            subQueryArray.forEach(item -> {
                JSONObject subQueryObj = new JSONObject();
                subQueryObj.put("metric", (Object)"subQuery");
                subQueryObj.put("datasetType", (Object)"subQuery");
                JSONObject dataSetObject = new JSONObject();
                dataSetObject.put("datasetObject", (Object)subQueryObj);
                selectArray.add((Object)dataSetObject);
            });
        }
        stepItem.put("select", (Object)selectArray);
        if (ifDistinct.booleanValue()) {
            stepItem.put("distinct", (Object)true);
        }
    }

    private void processWhereOrHaving(JSONObject filterJsonObj, JSONObject filterJson, JSONObject step, JSONArray solutionSteps, JSONObject context, boolean isFilter) {
        String outLogical = filterJsonObj.containsKey((Object)"and") ? "and" : "or";
        try {
            filterJsonObj = ConvertorJsonCommonMethod.getFormatObj((JSONObject)filterJsonObj, (String)outLogical);
            filterJsonObj = ConvertorJsonCommonMethod.filterInvalidField((JSONObject)step, (JSONObject)filterJsonObj, (String)outLogical);
            String string = outLogical = filterJsonObj.containsKey((Object)"and") ? "and" : "or";
            if (filterJsonObj.containsKey((Object)outLogical)) {
                Object logicalJson = filterJsonObj.get((Object)outLogical);
                if (Objects.isNull(logicalJson)) {
                    return;
                }
                filterJson.put("logic", (Object)outLogical);
                this.processLogicalJson(filterJson, logicalJson, step, solutionSteps, context, isFilter);
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362filterJsonObj\u5f02\u5e38", (Throwable)e);
        }
    }

    private void processLogicalJson(JSONObject filterJson, Object logicalJson, JSONObject step, JSONArray solutionSteps, JSONObject context, boolean isFilter) throws BussinessException {
        if (logicalJson instanceof JSONObject) {
            this.buildObjectFilterJson(filterJson, (JSONObject)logicalJson, step, solutionSteps, context, isFilter);
        } else if (logicalJson instanceof JSONArray) {
            this.buildArrayFilterJson(filterJson, (JSONArray)logicalJson, step, solutionSteps, context, isFilter);
        }
    }

    private void buildArrayFilterJson(JSONObject filterJson, JSONArray logicalJson, JSONObject step, JSONArray solutionSteps, JSONObject context, boolean isFilter) throws BussinessException {
        ArrayList leftMapList = new ArrayList();
        JSONArray filterItems = new JSONArray();
        for (Object subItem : logicalJson) {
            String[] splitBlankItem = this.splitBlankFilter(subItem.toString(), step, solutionSteps);
            String rightType = ConvertorJsonCommonMethod.getRightType((String[])splitBlankItem);
            List<String> stringList = Arrays.asList(splitBlankItem[0], splitBlankItem[1], splitBlankItem[2]);
            boolean checkType = ConvertorJsonCommonMethod.checkFieldInSchema((String)stringList.get(0), (JSONObject)step, (JSONArray)solutionSteps);
            if (!CollectionUtils.isNotEmpty(stringList) || stringList.size() != 3) continue;
            if (checkType) {
                throw new BussinessException("checkFieldIsFalse");
            }
            String operator = stringList.get(1);
            if ("btw".equals(operator)) {
                this.buildBtwFilter(step, context, stringList, rightType, filterItems, this.getDataType(stringList.get(0).trim(), step, solutionSteps), solutionSteps);
                continue;
            }
            if ("in".equals(operator) || "not_in".equals(operator)) {
                filterItems.add((Object)this.buildOperatorIn(step, solutionSteps, stringList, rightType));
                continue;
            }
            filterItems.add((Object)this.buildCommonFilter(step, solutionSteps, context, isFilter, leftMapList, stringList));
        }
        context.put("multiCompanySetEocMaps", leftMapList);
        filterJson.put("children", (Object)filterItems);
    }

    private JSONObject buildCommonFilter(JSONObject step, JSONArray solutionSteps, JSONObject context, boolean isFilter, List<Map<String, String>> leftMapList, List<String> stringList) {
        JSONObject coJson = new JSONObject();
        JSONArray rightArray = new JSONArray();
        String operator = stringList.get(1);
        String leftSource = "";
        String leftContent = stringList.get(0).trim();
        String[] contentSplit = leftContent.split("\\.");
        if (contentSplit.length == 2) {
            leftContent = contentSplit[1];
            leftSource = contentSplit[0];
        } else {
            leftSource = this.supplementSource(leftContent, null, GeneralConvertorWrapperExecutor.getGPTJson(), step, true);
        }
        JSONObject leftObject = ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(leftContent, leftSource, GeneralConvertorWrapperExecutor.getGPTJson(), step, false), (String)leftSource, (String)this.getDataType(leftContent, step, solutionSteps), (String)this.getContentType(step, leftContent, solutionSteps));
        JSONObject rightObject = new JSONObject();
        String rightContent = stringList.get(2).trim();
        String rightType = this.getContentType(step, rightContent, solutionSteps);
        String[] rightContentSplit = ConvertorJsonCommonMethod.getContentWithIfConst((JSONObject)step, (JSONArray)solutionSteps, (String)rightContent);
        String rightSource = "";
        if (rightContentSplit.length == 2 && "field".equals(rightType)) {
            rightContent = rightContentSplit[1];
            rightSource = rightContentSplit[0];
        } else {
            rightSource = this.supplementSource(rightContent, null, GeneralConvertorWrapperExecutor.getGPTJson(), step, true);
        }
        if ("like".equals(operator)) {
            if (rightContent.startsWith("%") && rightContent.endsWith("%") || rightContent.startsWith("'%") && rightContent.endsWith("%'")) {
                operator = "fm";
            } else if (rightContent.startsWith("%") || rightContent.startsWith("'%")) {
                operator = "sm";
            }
            if (rightContent.startsWith("'%") || rightContent.endsWith("%'")) {
                rightContent = StringUtils.stripStart((String)rightContent, (String)"'%");
                rightContent = StringUtils.stripEnd((String)rightContent, (String)"%'");
            } else {
                rightContent = StringUtils.strip((String)rightContent, (String)"%");
            }
        }
        rightObject.put("content", (Object)rightContent);
        if (isFilter) {
            HashMap<String, String> leftMap;
            rightObject.put("content", (Object)this.supplementSource(ConvertorJsonCommonMethod.synonymReplaceStandard((String)leftContent, (String)rightContent, (JSONObject)step, (JSONObject)context), rightSource, GeneralConvertorWrapperExecutor.getGPTJson(), step, false));
            if ("eoc_company_name".equals(leftContent)) {
                leftMap = new HashMap<String, String>();
                leftMap.put("eoc_company_name", rightObject.getString("content"));
                leftMapList.add(leftMap);
            }
            if ("eoc_company_id".equals(leftContent)) {
                leftMap = new HashMap();
                leftMap.put("eoc_company_id", rightObject.getString("content"));
                leftMapList.add(leftMap);
            }
        }
        operator = SolutionStepConstants.getOpMap().getOrDefault(operator, operator);
        if ("datetime".equals(rightObject.getString("dataType"))) {
            String dateContent = rightObject.getString("content");
            rightObject.put("content", (Object)ConvertorJsonCommonMethod.getYMDDateContent((String)dateContent, (String)operator, (JSONObject)this.getMetricFieldSchema(dateContent, step)));
        }
        rightObject.put("dataType", (Object)this.getDataType(leftContent, step, solutionSteps));
        rightObject.put("source", (Object)rightSource);
        rightObject.put("contentType", (Object)rightType);
        if ("is".equalsIgnoreCase(operator) && ("null".equalsIgnoreCase(rightContent) || "not null".equalsIgnoreCase(rightContent))) {
            operator = "null".equalsIgnoreCase(rightContent) ? "is_null" : "is_not_null";
            rightType = "const";
            rightObject.put("contentType", (Object)rightType);
            rightObject.put("content", (Object)"");
        }
        if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
            List aliasList = solutionSteps.stream().map(solutionStep -> ((JSONObject)solutionStep).getString("alias")).collect(Collectors.toList());
            if (aliasList.contains(rightSource) && !"const".equals(rightType)) {
                JSONObject rightDatasetObject = new JSONObject();
                rightDatasetObject.put("datasetType", (Object)"step");
                rightDatasetObject.put("step", (Object)rightSource);
                rightDatasetObject.put("contentType", (Object)rightType);
                rightDatasetObject.put("content", (Object)ConvertorJsonCommonMethod.getAliasBySourceAndContent((JSONArray)solutionSteps, (String)rightObject.getString("source"), (String)rightObject.getString("content"), (List)GeneralConvertorWrapperExecutor.getSelectInfoCacheList()));
                JSONObject rightDataObject = new JSONObject();
                rightDataObject.put("datasetObject", (Object)rightDatasetObject);
                rightArray.add((Object)rightDataObject);
            } else {
                JSONObject rightDataObject = new JSONObject();
                rightDataObject.put("dataObject", (Object)rightObject);
                rightArray.add((Object)rightDataObject);
            }
        } else {
            JSONObject rightDataObject = new JSONObject();
            rightDataObject.put("dataObject", (Object)rightObject);
            rightArray.add((Object)rightDataObject);
        }
        coJson.put("left", (Object)leftObject);
        coJson.put("operator", (Object)operator);
        coJson.put("right", (Object)rightArray);
        return coJson;
    }

    private void buildBtwFilter(JSONObject step, JSONObject context, List<String> stringList, String rightType, JSONArray filterItems, String dataType, JSONArray solutionSteps) {
        boolean dataTypeIsDate = false;
        if ("datetime".equals(dataType)) {
            dataTypeIsDate = true;
        }
        String[] dateItem = stringList.get(2).split("#");
        if (dataTypeIsDate) {
            dateItem = ConvertorJsonCommonMethod.supplementFilterDateFormat((String[])dateItem, (JSONObject)this.getMetricFieldSchema(stringList.get(0), step));
        }
        for (int i = 0; i < dateItem.length; ++i) {
            String content = stringList.get(0).trim();
            String leftSource = "";
            String[] contentSplit = content.split("\\.");
            if (contentSplit.length == 2) {
                content = contentSplit[1];
                leftSource = contentSplit[0];
            } else {
                leftSource = this.supplementSource(content, null, GeneralConvertorWrapperExecutor.getGPTJson(), step, true);
            }
            JSONObject leftDateObject = ConvertorJsonCommonMethod.buildDataObject((String)content, (String)leftSource, (String)dataType, (String)this.getContentType(step, content, solutionSteps));
            JSONArray rightDateArray = new JSONArray();
            JSONObject dateObj = new JSONObject();
            if (ConvertorJsonCommonMethod.ifConst((JSONObject)step, (JSONArray)solutionSteps, (String)dateItem[i]).booleanValue()) {
                rightType = "const";
            }
            JSONObject rightObject = ConvertorJsonCommonMethod.buildDataObject((String)dateItem[i], (String)this.getSource(step), (String)dataType, (String)rightType);
            if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
                List aliasList = solutionSteps.stream().map(solutionStep -> ((JSONObject)solutionStep).getString("alias")).collect(Collectors.toList());
                if (aliasList.contains(rightObject.getString("source")) && !"const".equals(rightType)) {
                    JSONObject rightDatasetObject = new JSONObject();
                    rightDatasetObject.put("datasetType", (Object)"step");
                    rightDatasetObject.put("step", (Object)rightObject.getString("source"));
                    rightDatasetObject.put("contentType", (Object)rightType);
                    rightDatasetObject.put("content", (Object)ConvertorJsonCommonMethod.getContentAlias((String)rightObject.getString("content"), (String)rightObject.getString("source"), (List)GeneralConvertorWrapperExecutor.getSelectInfoCacheList()));
                    JSONObject rightDataObject = new JSONObject();
                    rightDataObject.put("datasetObject", (Object)rightDatasetObject);
                    rightDateArray.add((Object)rightDataObject);
                } else {
                    JSONObject rightDataObject = new JSONObject();
                    rightDataObject.put("dataObject", (Object)rightObject);
                    rightDateArray.add((Object)rightDataObject);
                }
            } else {
                JSONObject rightDataObject = new JSONObject();
                rightDataObject.put("dataObject", (Object)rightObject);
                rightDateArray.add((Object)rightDataObject);
            }
            if (i == 0) {
                dateObj.put("operator", (Object)"gte");
            } else if (i == 1) {
                dateObj.put("operator", (Object)"lte");
            }
            dateObj.put("left", (Object)leftDateObject);
            dateObj.put("right", (Object)rightDateArray);
            filterItems.add((Object)dateObj);
        }
    }

    private JSONObject buildOperatorIn(JSONObject step, JSONArray solutionSteps, List<String> stringList, String rightType) {
        JSONObject coJson = new JSONObject();
        JSONArray rightArray = new JSONArray();
        String operator = stringList.get(1);
        String leftSource = "";
        String leftContent = stringList.get(0).trim();
        String[] contentSplit = leftContent.split("\\.");
        if (contentSplit.length == 2) {
            leftContent = contentSplit[1];
            leftSource = contentSplit[0];
        } else {
            leftSource = this.supplementSource(leftContent, null, GeneralConvertorWrapperExecutor.getGPTJson(), step, true);
        }
        String dataType = this.getDataType(leftContent, step, solutionSteps);
        if ("datetime".equals(dataType)) {
            dataType = "string";
        }
        JSONObject leftObject = ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(leftContent, leftSource, GeneralConvertorWrapperExecutor.getGPTJson(), step, false), (String)leftSource, (String)dataType, (String)this.getContentType(step, leftContent, solutionSteps));
        String rightContent = stringList.get(2).trim();
        String trimmedInput = rightContent.substring(1, rightContent.length() - 1);
        String[] inContentArr = trimmedInput.split(",");
        if (ConvertorJsonCommonMethod.isMeasure((String)dataType)) {
            List resultList = Arrays.stream(inContentArr).map(Integer::parseInt).collect(Collectors.toList());
            for (Integer content : resultList) {
                JSONObject rightObject = new JSONObject();
                String rightSource = this.supplementSource(leftContent, null, GeneralConvertorWrapperExecutor.getGPTJson(), step, true);
                rightObject.put("content", (Object)content);
                rightObject.put("dataType", (Object)dataType);
                rightObject.put("source", (Object)rightSource);
                rightObject.put("contentType", (Object)rightType);
                if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
                    List aliasList = solutionSteps.stream().map(solutionStep -> ((JSONObject)solutionStep).getString("alias")).collect(Collectors.toList());
                    if (aliasList.contains(rightSource) && !"const".equals(rightType)) {
                        JSONObject rightDatasetObject = new JSONObject();
                        rightDatasetObject.put("datasetType", (Object)"step");
                        rightDatasetObject.put("step", (Object)rightSource);
                        rightDatasetObject.put("contentType", (Object)rightType);
                        rightDatasetObject.put("content", rightObject.get((Object)"content"));
                        JSONObject rightDataObject = new JSONObject();
                        rightDataObject.put("datasetObject", (Object)rightDatasetObject);
                        rightArray.add((Object)rightDataObject);
                        continue;
                    }
                    JSONObject rightDataObject = new JSONObject();
                    rightDataObject.put("dataObject", (Object)rightObject);
                    rightArray.add((Object)rightDataObject);
                    continue;
                }
                JSONObject rightDataObject = new JSONObject();
                rightDataObject.put("dataObject", (Object)rightObject);
                rightArray.add((Object)rightDataObject);
            }
        } else {
            for (String content : inContentArr) {
                String[] inSplit;
                if (ConvertorJsonCommonMethod.ifConst((JSONObject)step, (JSONArray)solutionSteps, (String)content).booleanValue()) {
                    rightType = "const";
                }
                String tableSource = (inSplit = ConvertorJsonCommonMethod.getContentWithIfConst((JSONObject)step, (JSONArray)solutionSteps, (String)content)).length > 1 ? inSplit[0] : this.getSource(step);
                JSONObject rightDataObject = new JSONObject();
                rightDataObject.put("dataObject", (Object)ConvertorJsonCommonMethod.buildDataObject((String)(inSplit.length > 1 ? inSplit[1].trim() : content.trim()), (String)tableSource, (String)dataType, (String)rightType));
                if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
                    JSONObject rightObject = rightDataObject.getJSONObject("dataObject");
                    List aliasList = solutionSteps.stream().map(solutionStep -> ((JSONObject)solutionStep).getString("alias")).collect(Collectors.toList());
                    if (aliasList.contains(rightObject.getString("source")) && !"const".equals(rightType)) {
                        JSONObject rightDatasetObject = new JSONObject();
                        rightDatasetObject.put("datasetType", (Object)"step");
                        rightDatasetObject.put("step", (Object)rightObject.getString("source"));
                        rightDatasetObject.put("contentType", (Object)rightType);
                        rightDatasetObject.put("content", (Object)ConvertorJsonCommonMethod.getAliasBySourceAndContent((JSONArray)solutionSteps, (String)rightObject.getString("source"), (String)rightObject.getString("content"), (List)GeneralConvertorWrapperExecutor.getSelectInfoCacheList()));
                        rightDataObject.remove((Object)"dataObject");
                        rightDataObject.put("datasetObject", (Object)rightDatasetObject);
                        rightArray.add((Object)rightDataObject);
                        continue;
                    }
                    rightArray.add((Object)rightDataObject);
                    continue;
                }
                rightArray.add((Object)rightDataObject);
            }
        }
        coJson.put("left", (Object)leftObject);
        coJson.put("operator", (Object)SolutionStepConstants.getOpMap().getOrDefault(operator, operator));
        coJson.put("right", (Object)rightArray);
        return coJson;
    }

    private void buildObjectFilterJson(JSONObject filterJson, JSONObject logicalJson, JSONObject step, JSONArray solutionSteps, JSONObject context, boolean isFilter) throws BussinessException {
        ArrayList leftMapList = new ArrayList();
        JSONArray filterItems = new JSONArray();
        JSONArray andItems = logicalJson.getJSONArray("and");
        if (CollectionUtils.isNotEmpty((Collection)andItems)) {
            filterJson.put("children", (Object)this.buildAndItems(step, solutionSteps, context, isFilter, andItems, filterItems, leftMapList));
        }
        JSONObject orObject = new JSONObject();
        JSONArray orItems = logicalJson.getJSONArray("or");
        if (CollectionUtils.isNotEmpty((Collection)orItems)) {
            this.buildOrItems(step, solutionSteps, context, isFilter, orObject, orItems, leftMapList);
        }
        if (!orObject.isEmpty()) {
            filterItems.add((Object)orObject);
        }
        context.put("multiCompanySetEocMaps", leftMapList);
    }

    private JSONArray buildAndItems(JSONObject step, JSONArray solutionSteps, JSONObject context, boolean isFilter, JSONArray andItems, JSONArray filterItems, List<Map<String, String>> leftMapList) throws BussinessException {
        for (int i = 0; i < andItems.size(); ++i) {
            String[] splitBlankItem = this.splitBlank(andItems.get(i).toString(), step, solutionSteps);
            String rightType = ConvertorJsonCommonMethod.getRightType((String[])splitBlankItem);
            List<String> stringList = Arrays.asList(splitBlankItem[0], splitBlankItem[1], splitBlankItem[2]);
            boolean checkType = ConvertorJsonCommonMethod.checkFieldInSchema((String)stringList.get(0), (JSONObject)step, (JSONArray)solutionSteps);
            if (!CollectionUtils.isNotEmpty(stringList) || stringList.size() != 3) continue;
            if (checkType) {
                throw new BussinessException("checkFieldIsFalse");
            }
            String operator = stringList.get(1);
            if ("btw".equals(operator)) {
                this.buildBtwFilter(step, context, stringList, rightType, filterItems, this.getDataType(stringList.get(0).trim(), step, solutionSteps), solutionSteps);
                continue;
            }
            if ("in".equals(operator) || "not_in".equals(operator)) {
                filterItems.add((Object)this.buildOperatorIn(step, solutionSteps, stringList, rightType));
                continue;
            }
            filterItems.add((Object)this.buildCommonFilter(step, solutionSteps, context, isFilter, leftMapList, stringList));
        }
        return filterItems;
    }

    private void buildOrItems(JSONObject step, JSONArray solutionSteps, JSONObject context, boolean isFilter, JSONObject orObject, JSONArray orItems, List<Map<String, String>> leftMapList) throws BussinessException {
        orObject.put("logic", (Object)"or");
        JSONArray chdOrArray = new JSONArray();
        for (Object item : orItems) {
            String[] splitOrBlankItem = this.splitBlank(item.toString(), step, solutionSteps);
            String rightOrType = ConvertorJsonCommonMethod.getRightType((String[])splitOrBlankItem);
            List<String> stringOrList = Arrays.asList(splitOrBlankItem[0], splitOrBlankItem[1], splitOrBlankItem[2]);
            if (ConvertorJsonCommonMethod.checkFieldInSchema((String)stringOrList.get(0), (JSONObject)step, (JSONArray)solutionSteps)) {
                throw new BussinessException("checkFieldIsFalse");
            }
            if (!CollectionUtils.isNotEmpty(stringOrList) || stringOrList.size() != 3) continue;
            String optOr = stringOrList.get(1);
            if ("btw".equals(optOr)) {
                this.buildBtwFilter(step, context, stringOrList, rightOrType, chdOrArray, this.getDataType(stringOrList.get(0).trim(), step, solutionSteps), solutionSteps);
                continue;
            }
            if ("in".equals(optOr) || "not_in".equals(optOr)) {
                chdOrArray.add((Object)this.buildOperatorIn(step, solutionSteps, stringOrList, rightOrType));
                continue;
            }
            chdOrArray.add((Object)this.buildCommonFilter(step, solutionSteps, context, isFilter, leftMapList, stringOrList));
        }
        orObject.put("children", (Object)chdOrArray);
    }

    private Boolean processComputeList(JSONObject computeJson, JSONObject stepItem, Map<String, String> otherInfoMap, JSONArray solutionSteps, Boolean convertIsError, Map<String, String> aliasMap) throws BussinessException {
        JSONObject computeList = stepItem.containsKey((Object)"computeList") ? stepItem.getJSONObject("computeList") : new JSONObject();
        ArrayList list = new ArrayList(computeJson.keySet());
        if (CollectionUtils.isEmpty(list)) {
            return convertIsError;
        }
        this.growthRateReversed(list);
        for (String key : list) {
            List newList;
            JSONArray calFunctionList = new JSONArray();
            JSONArray subArray = computeJson.getJSONArray(key);
            if (this.functionCheck(subArray, aliasMap)) {
                computeJson.put(key, null);
            }
            if (!CollectionUtils.isEmpty((Collection)(newList = this.nestFunctionProcess(computeJson.getJSONArray(key))))) {
                computeJson.put(key, (Object)newList);
            }
            if (!CollectionUtils.isNotEmpty((Collection)computeJson.getJSONArray(key))) continue;
            convertIsError = this.dealComputeList(stepItem, otherInfoMap, solutionSteps, key, computeJson.getJSONArray(key), calFunctionList, computeList, convertIsError);
        }
        stepItem.put("computeList", (Object)computeList);
        return convertIsError;
    }

    private List<String> nestFunctionProcess(JSONArray subArray) {
        if (CollectionUtils.isEmpty((Collection)subArray)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList();
        try {
            for (int i = 0; i < subArray.size(); ++i) {
                int count = i * 10;
                if (FunctionUtil.isMultiNestedFunction((String)subArray.getString(i))) {
                    result.addAll(FunctionUtil.decomposeNestedFunction((String)subArray.getString(i), (int)count));
                    continue;
                }
                result.add(subArray.getString(i));
            }
        }
        catch (Exception e) {
            result = subArray.toJavaList(String.class);
            log.info("\u62c6\u89e3\u5d4c\u5957\u51fd\u6570\u5931\u8d25\uff0c{}", (Object)e.getMessage());
        }
        return result;
    }

    private boolean functionCheck(JSONArray subArray, Map<String, String> aliasMap) {
        if (CollectionUtils.isEmpty((Collection)subArray)) {
            return false;
        }
        boolean flag = false;
        for (Object child : subArray) {
            String aggregate;
            String childStr = child.toString();
            String[] orderByItem = childStr.split("#");
            if (orderByItem.length != 3 || childStr.contains("distinct ") || (aggregate = orderByItem[0]).contains("(")) continue;
            aliasMap.put(orderByItem[1], childStr);
            flag = true;
        }
        return flag;
    }

    private void growthRateReversed(List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        keys.sort((s1, s2) -> {
            String[] parts1 = s1.split("\\|");
            String[] parts2 = s2.split("\\|");
            if (parts1.length < 2 || parts2.length < 2) {
                return s1.compareTo((String)s2);
            }
            String right1 = parts1[1];
            String right2 = parts2[1];
            if (right1.equals("Rate") && !right2.equals("Rate")) {
                return 1;
            }
            if (!right1.equals("Rate") && right2.equals("Rate")) {
                return -1;
            }
            return s1.compareTo((String)s2);
        });
    }

    private Boolean dealComputeList(JSONObject stepItem, Map<String, String> otherInfoMap, JSONArray solutionSteps, String key, JSONArray subArray, JSONArray calFunctionList, JSONObject computeList, Boolean convertIsError) throws BussinessException {
        String[] keyAndType = key.split("\\|");
        String computeType = "";
        if (keyAndType.length == 2) {
            key = keyAndType[0];
            computeType = keyAndType[1];
        }
        String finalKey = key;
        String finalComputeType = computeType;
        for (Object child : subArray) {
            String aggregate;
            String[] orderByItem;
            String childStr = child.toString();
            Boolean ifDistinct = false;
            if (childStr.contains("distinct ")) {
                childStr = childStr.replace("distinct ", "");
                ifDistinct = true;
            }
            if ((orderByItem = childStr.split("#")).length != 3) continue;
            JSONObject calFunctionObj = new JSONObject();
            if (ifDistinct.booleanValue()) {
                calFunctionObj.put("distinct", (Object)true);
            }
            if (!(aggregate = orderByItem[0]).contains("(")) {
                convertIsError = true;
                log.error("compute\u8ba1\u7b97\u5b57\u6bb5\u9519\u8bef\uff1a{}", (Object)childStr);
                return convertIsError;
            }
            Matcher over = overPattern.matcher(aggregate);
            if ("ROW_NUMBER".equals(finalComputeType)) {
                calFunctionObj = this.parseSQLToJson(childStr, otherInfoMap, stepItem, solutionSteps, computeList);
                if (Objects.isNull(calFunctionObj)) {
                    convertIsError = true;
                }
                GeneralConvertorWrapperExecutor.addRowNumberList((String)finalKey);
            } else if (over.find()) {
                calFunctionObj = this.parseOverToJson(childStr, otherInfoMap, stepItem, solutionSteps, computeList, convertIsError);
                JSONArray params = new JSONArray();
                String aggFunction = aggregate.substring(0, aggregate.indexOf("(")).trim();
                if (!SolutionStepConstants.getcalFuctionTypeList().contains(aggFunction.toUpperCase())) {
                    convertIsError = true;
                    log.error("compute\u8ba1\u7b97\u5b57\u6bb5\u65b9\u6cd5\u6682\u4e0d\u652f\u6301\uff1a{}", (Object)childStr);
                }
                String aggContent = aggregate.substring(aggregate.indexOf("(") + 1, aggregate.indexOf(")")).trim();
                if (subArray.size() == 1 && ConvertorJsonCommonMethod.checkFieldInSchema((String)aggContent.split(",")[0], (JSONObject)stepItem, (JSONArray)solutionSteps)) {
                    throw new BussinessException("checkFieldIsFalse");
                }
                this.dealParamsList(stepItem, solutionSteps, aggContent, aggFunction, params, calFunctionList, computeList);
                ArrayList<String> types = new ArrayList<String>();
                for (Object param : params) {
                    types.add(((JSONObject)param).getString("dataType"));
                }
                if (types.size() == 1) {
                    types.add(null);
                }
                calFunctionObj.put("valueType", (Object)ConvertorJsonCommonMethod.determineResultType((String)aggFunction.toUpperCase(), (String)((String)types.get(0)), (String)((String)types.get(1))));
                calFunctionObj.put("params", (Object)params);
            } else {
                String aggFunction = aggregate.substring(0, aggregate.indexOf("(")).trim();
                if (!SolutionStepConstants.getcalFuctionTypeList().contains(aggFunction.toUpperCase())) {
                    convertIsError = true;
                    log.error("compute\u8ba1\u7b97\u5b57\u6bb5\u65b9\u6cd5\u6682\u4e0d\u652f\u6301\uff1a{}", (Object)childStr);
                }
                String aggContent = aggregate.substring(aggregate.indexOf("(") + 1, aggregate.indexOf(")")).trim();
                if (subArray.size() == 1 && ConvertorJsonCommonMethod.checkFieldInSchema((String)aggContent.split(",")[0], (JSONObject)stepItem, (JSONArray)solutionSteps)) {
                    throw new BussinessException("checkFieldIsFalse");
                }
                String title = orderByItem[2];
                String alias = orderByItem[1];
                otherInfoMap.put(alias, title);
                calFunctionObj.put("newField", (Object)alias);
                calFunctionObj.put("calFunction", (Object)aggFunction);
                JSONArray params = new JSONArray();
                this.dealParamsList(stepItem, solutionSteps, aggContent, aggFunction, params, calFunctionList, computeList);
                ArrayList<String> types = new ArrayList<String>();
                for (Object param : params) {
                    types.add(((JSONObject)param).getString("dataType"));
                }
                if (types.size() == 1) {
                    types.add(null);
                }
                calFunctionObj.put("valueType", (Object)ConvertorJsonCommonMethod.determineResultType((String)aggFunction.toUpperCase(), (String)((String)types.get(0)), (String)((String)types.get(1))));
                calFunctionObj.put("params", (Object)params);
            }
            if (!Objects.nonNull(calFunctionObj) || calFunctionObj.isEmpty()) continue;
            calFunctionList.add((Object)calFunctionObj);
        }
        if (CollectionUtils.isNotEmpty((Collection)calFunctionList)) {
            computeList.put(key, (Object)calFunctionList);
        }
        return convertIsError;
    }

    private JSONObject parseOverToJson(String sqlFragment, Map<String, String> otherInfoMap, JSONObject stepItem, JSONArray solutionSteps, JSONObject computeList, Boolean convertIsError) {
        Matcher orderMatcher;
        String[] orderByItem = sqlFragment.split("#");
        String aggregate = orderByItem[0];
        String newField = orderByItem[1];
        String processed = aggregate.replaceAll("\\s+", " ").trim();
        JSONObject result = new JSONObject();
        Matcher sumContentMatcher = sumContentPattern.matcher(processed);
        Matcher maxContentMatcher = maxContentPattern.matcher(processed);
        Matcher minContentMatcher = minContentPattern.matcher(processed);
        if (sumContentMatcher.find()) {
            result.put("calFunction", (Object)"Sum");
        } else if (maxContentMatcher.find()) {
            result.put("calFunction", (Object)"Max");
        } else if (minContentMatcher.find()) {
            result.put("calFunction", (Object)"Min");
        }
        result.put("newField", (Object)newField);
        result.put("valueType", (Object)"number");
        JSONObject overParamsJson = new JSONObject();
        otherInfoMap.put(orderByItem[1], orderByItem[2]);
        JSONArray partitionBy = new JSONArray();
        JSONArray orderBy = new JSONArray();
        Matcher partitionMatcher = overPartitionPattern.matcher(processed);
        if (partitionMatcher.find()) {
            String[] partitionColumns;
            for (String col : partitionColumns = partitionMatcher.group(1).split(",")) {
                partitionBy.add((Object)this.buildRankOverDataObject(col.trim(), stepItem, solutionSteps, computeList));
            }
        }
        if ((orderMatcher = overOrderPattern.matcher(processed)).find()) {
            String orderContent = orderMatcher.group(1);
            List orderItems = GeneralConvertorWrapperExecutor.parseOrderItems((String)orderContent);
            for (Map item : orderItems) {
                String order = (String)item.get("column");
                String sort = (String)item.get("direction");
                JSONObject orderObj = new JSONObject();
                orderObj.put("dataObject", (Object)this.buildRankOverDataObject(order.trim(), stepItem, solutionSteps, computeList));
                orderObj.put("order", (Object)sort);
                orderBy.add((Object)orderObj);
            }
        }
        if (!partitionBy.isEmpty()) {
            overParamsJson.put("partition", (Object)partitionBy);
        }
        if (!orderBy.isEmpty()) {
            overParamsJson.put("orderBy", (Object)orderBy);
        }
        result.put("overParams", (Object)overParamsJson);
        return result;
    }

    private static List<Map<String, String>> parseOrderItems(String orderContent) {
        ArrayList<Map<String, String>> items = new ArrayList<Map<String, String>>();
        Matcher itemMatcher = orderItemPattern.matcher(orderContent);
        while (itemMatcher.find()) {
            String column = itemMatcher.group(1);
            String direction = itemMatcher.group(2);
            direction = direction == null || direction.isEmpty() ? "asc" : direction.toUpperCase();
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("column", column);
            item.put("direction", direction);
            items.add(item);
        }
        return items;
    }

    private void dealParamsList(JSONObject stepItem, JSONArray solutionSteps, String aggContent, String aggFunction, JSONArray params, JSONArray calFunctionList, JSONObject computeList) {
        if (StringUtils.isNotBlank((CharSequence)aggContent)) {
            List<String> paramsList = Arrays.asList(aggContent.split(","));
            for (int i = 0; i < paramsList.size(); ++i) {
                JSONObject jsonObject;
                String param = paramsList.get(i).trim();
                JSONObject fieldObj = new JSONObject();
                String fieldName = ConvertorJsonCommonMethod.getPostDotElement((String)param);
                fieldObj.put("contentType", (Object)this.getContentType(stepItem, fieldName, solutionSteps));
                if (computeList != null && computeList.containsKey((Object)fieldName)) {
                    fieldObj.put("contentType", (Object)"field");
                }
                if (i == 1 && "DateFormat".equals(aggFunction)) {
                    fieldObj.put("contentType", (Object)"dateFormat");
                }
                if (param.contains(".")) {
                    fieldObj.put("contentType", (Object)"field");
                    fieldObj.put("source", (Object)param.split("\\.")[0]);
                } else {
                    fieldObj.put("source", (Object)this.supplementSource(param, null, GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, true));
                }
                fieldObj.put("content", (Object)this.supplementSource(ConvertorJsonCommonMethod.getPostDotElement((String)param), fieldObj.getString("source"), GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, false));
                if ("GrowthRate".equals(aggFunction)) {
                    fieldObj.put("contentType", (Object)"field");
                }
                String orgDataType = ConvertorJsonCommonMethod.getOrgDataType((JSONArray)solutionSteps, (String)fieldObj.getString("content"), (String)fieldObj.getString("source"));
                if (computeList != null && computeList.containsKey((Object)fieldObj.getString("content"))) {
                    jsonObject = (JSONObject)computeList.getJSONArray(fieldObj.getString("content")).get(0);
                    orgDataType = jsonObject.getString("valueType");
                }
                if (StringUtils.isEmpty((CharSequence)orgDataType)) {
                    fieldObj.put("dataType", (Object)this.getDataType(fieldName, stepItem, solutionSteps));
                    if (computeList != null && computeList.containsKey((Object)fieldName)) {
                        jsonObject = (JSONObject)computeList.getJSONArray(fieldObj.getString(fieldName)).get(0);
                        fieldObj.put("dataType", (Object)jsonObject.getString("valueType"));
                    }
                } else {
                    fieldObj.put("dataType", (Object)orgDataType);
                }
                if (CollectionUtils.isNotEmpty((Collection)calFunctionList)) {
                    for (Object o : calFunctionList) {
                        JSONObject calFunction = (JSONObject)o;
                        String newField = calFunction.getString("newField");
                        if (!fieldObj.getString("content").equalsIgnoreCase(newField)) continue;
                        fieldObj.put("contentType", (Object)"calculate");
                        fieldObj.put("source", (Object)stepItem.getString("alias"));
                        fieldObj.put("dataType", (Object)calFunction.getString("valueType"));
                    }
                }
                if (StringUtil.isNumber((String)param)) {
                    fieldObj.put("contentType", (Object)"const");
                    fieldObj.put("source", (Object)"");
                    fieldObj.put("content", (Object)param);
                    if (SolutionStepConstants.NUMERAL_CALFUCTION_TYPE_LIST.contains(aggFunction.toUpperCase())) {
                        fieldObj.put("dataType", (Object)(param.contains("\\.") ? "decimal" : "number"));
                    }
                }
                params.add((Object)fieldObj);
            }
        }
    }

    private String[] splitBlank(String input, JSONObject step, JSONArray solutionSteps) {
        String[] parts = input.split("\\s+");
        if (parts.length == 4) {
            String[] split;
            parts[3] = "c".equals(parts[3]) ? ((split = parts[2].split("\\.")).length == 2 ? "field" : "const") : ("i".equals(parts[3]) ? "field" : this.getContentType(step, parts[0], solutionSteps));
        }
        return parts;
    }

    private String[] splitBlankFilter(String input, JSONObject step, JSONArray solutionSteps) {
        String[] parts = ConvertorJsonCommonMethod.customSplit((String)input);
        if (parts.length == 4) {
            String[] split;
            parts[3] = "c".equals(parts[3]) ? ((split = parts[2].split("\\.")).length == 2 ? "field" : "const") : ("i".equals(parts[3]) ? "field" : this.getContentType(step, parts[0], solutionSteps));
        }
        return parts;
    }

    private String getContentType(JSONObject step, String fieldName, JSONArray solutionSteps) {
        if (fieldName.contains("\\.") && ConvertorJsonCommonMethod.ifConst((JSONObject)step, (JSONArray)solutionSteps, (String)fieldName).booleanValue()) {
            return "const";
        }
        JSONObject metricFieldSchema = this.getMetricFieldSchema(fieldName, step);
        if (!metricFieldSchema.isEmpty()) {
            return "field";
        }
        JSONObject computeObj = step.getJSONObject("computeList");
        if (null != computeObj && computeObj.containsKey((Object)fieldName)) {
            return "calculate";
        }
        if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
            for (Object solutionStep : solutionSteps) {
                JSONObject solutionStepObj = (JSONObject)solutionStep;
                JSONObject allCompute = solutionStepObj.getJSONObject("computeList");
                if (null == allCompute || !allCompute.containsKey((Object)fieldName)) continue;
                return "field";
            }
        }
        if (CollectionUtils.isEmpty((Collection)solutionSteps)) {
            return "const";
        }
        for (Object solutionStep : solutionSteps) {
            JSONArray selects = ((JSONObject)solutionStep).getJSONArray("select");
            for (Object select : selects) {
                JSONObject dataObj = ((JSONObject)select).getJSONObject("dataObject");
                if (Objects.isNull(dataObj) || !fieldName.equalsIgnoreCase(dataObj.getString("alias")) && !fieldName.equalsIgnoreCase(dataObj.getString("content"))) continue;
                return "field";
            }
        }
        return "const";
    }

    private String checkSelectContentType(JSONObject step, String fieldName, String contentType) {
        if (!"calculate".equals(contentType)) {
            return contentType;
        }
        JSONObject computeObj = step.getJSONObject("computeList");
        if (null != computeObj && computeObj.containsKey((Object)fieldName)) {
            return "calculate";
        }
        return "field";
    }

    private String getDataType(String fieldName, JSONObject step, JSONArray solutionSteps) {
        JSONObject solutionStepObj;
        JSONArray fieldArr;
        String dataType;
        JSONObject metricFieldSchema = this.getMetricFieldSchema(fieldName, step);
        if (!metricFieldSchema.isEmpty() && StringUtils.isNotBlank((CharSequence)(dataType = metricFieldSchema.getString("dataType")))) {
            return SolutionStepConstants.getDataTypeMap().getOrDefault(dataType, dataType);
        }
        JSONObject computeObj = step.getJSONObject("computeList");
        if (computeObj != null && CollectionUtils.isNotEmpty((Collection)(fieldArr = computeObj.getJSONArray(fieldName)))) {
            return fieldArr.getJSONObject(0).getString("valueType");
        }
        for (Object solutionStep : solutionSteps) {
            JSONArray fieldArr2;
            solutionStepObj = (JSONObject)solutionStep;
            JSONObject allCompute = solutionStepObj.getJSONObject("computeList");
            if (null == allCompute || !CollectionUtils.isNotEmpty((Collection)(fieldArr2 = allCompute.getJSONArray(fieldName)))) continue;
            return fieldArr2.getJSONObject(0).getString("valueType");
        }
        for (Object solutionStep : solutionSteps) {
            solutionStepObj = (JSONObject)solutionStep;
            JSONArray selects = solutionStepObj.getJSONArray("select");
            if (!CollectionUtils.isNotEmpty((Collection)selects)) continue;
            for (Object selectObj : selects) {
                JSONObject select = (JSONObject)selectObj;
                JSONObject dataobject = select.getJSONObject("dataObject");
                if (!Objects.nonNull(dataobject) || !fieldName.equals(dataobject.getString("alias"))) continue;
                return dataobject.getString("dataType");
            }
        }
        return "string";
    }

    private String getRowNumberDataType(String fieldName, JSONObject step, JSONArray solutionSteps, JSONObject computeList) {
        Iterator fieldArr;
        String dataType;
        JSONObject metricFieldSchema = this.getMetricFieldSchema(fieldName, step);
        if (!metricFieldSchema.isEmpty() && StringUtils.isNotBlank((CharSequence)(dataType = metricFieldSchema.getString("dataType")))) {
            return SolutionStepConstants.getDataTypeMap().getOrDefault(dataType, dataType);
        }
        JSONObject computeObj = step.getJSONObject("computeList");
        if (computeObj != null && CollectionUtils.isNotEmpty((Collection)((Object)(fieldArr = computeObj.getJSONArray(fieldName))))) {
            return fieldArr.getJSONObject(0).getString("valueType");
        }
        fieldArr = solutionSteps.iterator();
        while (fieldArr.hasNext()) {
            JSONArray fieldArr2;
            Object solutionStep = fieldArr.next();
            JSONObject solutionStepObj = (JSONObject)solutionStep;
            JSONObject allCompute = solutionStepObj.getJSONObject("computeList");
            if (null == allCompute || !CollectionUtils.isNotEmpty((Collection)(fieldArr2 = allCompute.getJSONArray(fieldName)))) continue;
            return fieldArr2.getJSONObject(0).getString("valueType");
        }
        if (computeList != null && CollectionUtils.isNotEmpty((Collection)((Object)(fieldArr = computeList.getJSONArray(fieldName))))) {
            return fieldArr.getJSONObject(0).getString("valueType");
        }
        return "string";
    }

    public JSONObject getMetricFieldSchema(String fieldName, JSONObject stepItem) {
        JSONArray metricArray = stepItem.getJSONArray("metricInfo");
        for (Object metricObj : metricArray) {
            JSONObject metricObjJson = (JSONObject)metricObj;
            JSONArray fieldSchema = metricObjJson.getJSONArray("fieldSchema");
            if (!CollectionUtils.isNotEmpty((Collection)fieldSchema)) continue;
            for (Object field : fieldSchema) {
                JSONObject fieldObj = (JSONObject)field;
                String name = fieldObj.getString("name");
                if (!fieldName.equals(name)) continue;
                return fieldObj;
            }
        }
        return new JSONObject();
    }

    public JSONObject getFieldSchema(String fieldName, JSONObject metricObjJson) {
        JSONArray fieldSchema = metricObjJson.getJSONArray("fieldSchema");
        if (CollectionUtils.isNotEmpty((Collection)fieldSchema)) {
            for (Object field : fieldSchema) {
                JSONObject fieldObj = (JSONObject)field;
                String name = fieldObj.getString("name");
                if (!fieldName.equals(name)) continue;
                return fieldObj;
            }
        }
        return new JSONObject();
    }

    private String supplementSource(String fieldName, String tableSource, JSONObject stepItemJson, JSONObject stepItem, boolean isSource) {
        String sourceOrFieldName = this.getSource(stepItem) + "." + fieldName;
        if (stepItemJson.containsKey((Object)"J") || stepItemJson.getJSONObject("F").containsKey((Object)"step")) {
            ArrayList<String> sourceList = new ArrayList<String>();
            String fromSource = stepItemJson.getJSONObject("F").getString("step");
            if (StringUtils.isBlank((CharSequence)fromSource)) {
                String string = stepItemJson.getJSONObject("F").getString("metric");
            } else {
                sourceList.add(fromSource);
            }
            JSONArray joinArray = stepItemJson.getJSONArray("J");
            if (CollectionUtils.isNotEmpty((Collection)joinArray)) {
                for (Object joinObj : joinArray) {
                    JSONObject joinObjJson = (JSONObject)joinObj;
                    String joinSource = joinObjJson.getJSONObject("F").getString("step");
                    sourceList.add(joinSource);
                }
            }
            List fromJoinList = this.removeKeysNotInList(GeneralConvertorWrapperExecutor.getSelectInfoCacheList(), sourceList);
            if (CollectionUtils.isNotEmpty(sourceList) && CollectionUtils.isNotEmpty((Collection)fromJoinList)) {
                fromJoinList.removeIf(map -> map.isEmpty());
                if (isSource) {
                    List stringList = ConvertorJsonCommonMethod.improveAliases(Arrays.asList(fieldName), (List)fromJoinList);
                    if (CollectionUtils.isNotEmpty((Collection)stringList)) {
                        sourceOrFieldName = (String)stringList.get(0);
                    }
                    return sourceOrFieldName.split("\\.")[0];
                }
                return ConvertorJsonCommonMethod.replaceAlias((String)fieldName, (String)tableSource, (List)fromJoinList);
            }
        }
        if (isSource) {
            return sourceOrFieldName.split("\\.")[0];
        }
        return fieldName;
    }

    public List<Map<String, List<StepFieldInfo>>> removeKeysNotInList(List<Map<String, List<StepFieldInfo>>> mapsList, List<String> keysList) {
        ArrayList<Map<String, List<StepFieldInfo>>> result = new ArrayList<Map<String, List<StepFieldInfo>>>();
        if (CollectionUtils.isEmpty(mapsList)) {
            return result;
        }
        for (Map<String, List<StepFieldInfo>> map : mapsList) {
            for (Map.Entry<String, List<StepFieldInfo>> entry : map.entrySet()) {
                if (!keysList.contains(entry.getKey())) continue;
                result.add(map);
            }
        }
        return result;
    }

    public JSONObject buildRankOverDataObject(String fieldContent, JSONObject stepItem, JSONArray solutionSteps, JSONObject computeList) {
        String[] split = fieldContent.split("\\.");
        String fieldName = fieldContent;
        String source = "";
        if (split.length == 2) {
            fieldName = fieldContent.split("\\.")[1];
            source = fieldContent.split("\\.")[0];
        } else {
            source = this.supplementSource(fieldName, null, GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, true);
        }
        String contentType = this.getContentType(stepItem, fieldName, solutionSteps);
        if (!"calculate".equals(contentType)) {
            contentType = "field";
        }
        return ConvertorJsonCommonMethod.buildDataObject((String)this.supplementSource(fieldName, source, GeneralConvertorWrapperExecutor.getGPTJson(), stepItem, false), (String)source, (String)this.getRowNumberDataType(fieldName, stepItem, solutionSteps, computeList), (String)contentType);
    }

    private JSONObject parseSQLToJson(String sqlFragment, Map<String, String> otherInfoMap, JSONObject stepItem, JSONArray solutionSteps, JSONObject computeList) {
        Matcher orderMatcher;
        Matcher matcher = rankOverPattern.matcher(sqlFragment);
        if (!matcher.find()) {
            log.error("RANK_OVER \u7247\u6bb5\u89e3\u6790\u5931\u8d25 content {}", (Object)sqlFragment);
            return null;
        }
        String[] orderByItem = sqlFragment.split("#");
        String overParams = matcher.group(2);
        String newField = matcher.group(3);
        JSONObject result = new JSONObject();
        result.put("calFunction", (Object)"RowNumber");
        result.put("valueType", (Object)"number");
        JSONObject overParamsJson = new JSONObject();
        result.put("newField", (Object)newField);
        otherInfoMap.put(orderByItem[1], orderByItem[2]);
        JSONArray partitionBy = new JSONArray();
        JSONArray orderBy = new JSONArray();
        Matcher partitionMatcher = partitionPattern.matcher(overParams);
        if (partitionMatcher.find()) {
            String[] partitionColumns;
            for (String col : partitionColumns = partitionMatcher.group(2).split(",")) {
                partitionBy.add((Object)this.buildRankOverDataObject(col.trim(), stepItem, solutionSteps, computeList));
            }
        }
        if ((orderMatcher = orderPattern.matcher(overParams)).find()) {
            String[] orderColumns;
            for (String col : orderColumns = orderMatcher.group(1).split(",")) {
                String[] colParts = col.trim().split("\\s+");
                String columnName = colParts[0];
                String order = colParts.length > 1 ? colParts[1].toLowerCase() : "asc";
                JSONObject orderObj = new JSONObject();
                orderObj.put("dataObject", (Object)this.buildRankOverDataObject(columnName.trim(), stepItem, solutionSteps, computeList));
                orderObj.put("order", (Object)order);
                orderBy.add((Object)orderObj);
            }
        }
        if (partitionBy.size() > 0) {
            overParamsJson.put("partition", (Object)partitionBy);
        }
        if (orderBy.size() > 0) {
            overParamsJson.put("orderBy", (Object)orderBy);
        }
        result.put("overParams", (Object)overParamsJson);
        return result;
    }
}

