/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.SseSendService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasCheckExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SchemasCheckExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        String schemasCheckGptName = "SemanticFuzzyResolver";
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            schemasCheckGptName = schemasCheckGptName + "_V1";
        } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            schemasCheckGptName = schemasCheckGptName + "_V2";
        }
        JSONObject schemasCheckGptResult = context.getJSONObject(schemasCheckGptName);
        Question question = (Question)context.getObject("question", Question.class);
        SseSendService sseSendService = (SseSendService)SpringContextUtil.getBean(SseSendService.class);
        if (Objects.isNull(schemasCheckGptResult)) {
            sseSendService.asyncSendSCDetailAndPSTitle(question, Boolean.valueOf(false), Boolean.valueOf(question.isIfStream()), context);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.schemas.check.error");
        }
        List elementsAnalysis = (List)schemasCheckGptResult.getOrDefault((Object)"elements_analysis", List.class);
        if (CollectionUtils.isEmpty(elementsAnalysis = elementsAnalysis.stream().filter(metric -> !"FOUND".equalsIgnoreCase(metric.getString("match_status"))).collect(Collectors.toList())) || StringUtils.isEmpty((CharSequence)schemasCheckGptResult.getString("suggested_user_clarification"))) {
            log.info("\u5b57\u6bb5\u6821\u9a8c\u6210\u529f");
            sseSendService.asyncSendSCDetailAndPSTitle(question, Boolean.valueOf(true), Boolean.valueOf(question.isIfStream()), context);
            return Output.through();
        }
        sseSendService.asyncSendSCDetailAndPSTitle(question, Boolean.valueOf(false), Boolean.valueOf(question.isIfStream()), context);
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        List sentences = (List)schemasCheckGptResult.getOrDefault((Object)"recommended_questions", new ArrayList());
        String reply = schemasCheckGptResult.getString("suggested_user_clarification") + "\n" + ("zh_TW".equals(locale) ? "\u5efa\u8b70\u60a8\u6253\u958b\u8ffd\u554f\u6a21\u5f0f\u9032\u4e00\u6b65\u660e\u78ba\u5b57\u6bb5\u4fe1\u606f\u3002" : "\u5efa\u8bae\u60a8\u6253\u5f00\u8ffd\u95ee\u6a21\u5f0f\u8fdb\u4e00\u6b65\u660e\u786e\u5b57\u6bb5\u4fe1\u606f\u3002");
        return Output.finish((String)"success", (Object)false).keep("sentences", sentences.stream().distinct().collect(Collectors.toList())).keep("reply", (Object)reply);
    }
}

