/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.SearchStandardWordsExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.SearchStandardWordsRollBackExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.AiService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchStandardWordsExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchStandardWordsExecutor.class);
    public static final String FILTER_APPEND_EX = "%s\u662f%s";
    public static final String FILTER_APPEND_EX_SPECIAL = "\u300c%s\u300d\u662f%s";

    public Output doProcess(JSONObject context) {
        Environment environment = (Environment)SpringContextUtil.getBean(Environment.class);
        boolean synonymOldSwitch = (Boolean)environment.getProperty("synonym.old.switch", Boolean.class);
        if (!Objects.isNull(synonymOldSwitch) && synonymOldSwitch) {
            SearchStandardWordsRollBackExecutor searchStandardWordsRollBackExecutor = (SearchStandardWordsRollBackExecutor)SpringContextUtil.getBean(SearchStandardWordsRollBackExecutor.class);
            return searchStandardWordsRollBackExecutor.doProcess(context);
        }
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        JSONObject input = new JSONObject();
        input.put("tenantId", (Object)context.getString("tenantId"));
        input.put("applicationCodes", (Object)context.getJSONArray("applicationCodes"));
        input.put("version", (Object)context.getString("version"));
        Output output = Output.through();
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        input.put("question", (Object)question);
        AiService aiService = (AiService)SpringContextUtil.getBean(AiService.class);
        JSONArray matchWResult = null;
        JSONArray appMatchWResult = null;
        try {
            matchWResult = aiService.synonymSearch(((Question)context.getObject("question", Question.class)).getToken(), question, null, null, context.getString("tenantId"), "");
            appMatchWResult = aiService.synonymSearch(((Question)context.getObject("question", Question.class)).getToken(), question, context.getJSONArray("applicationCodes"), context.getString("version"), null, "");
        }
        catch (Exception e) {
            log.error("SearchStandardWordsExecutor query ai synonym fail", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchStandardWords", "P.SCRUMBI.901.0202", input.toJSONString(), "\u67e5\u8be2\u540c\u4e49\u8bcd\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684\u5927ai\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f851\u5206\u949f\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u5927ai\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            return Output.through((String)"logCheckDtos", logCheckDtos);
        }
        if (CollectionUtils.isEmpty((Collection)matchWResult) && CollectionUtils.isEmpty((Collection)appMatchWResult)) {
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchStandardWords", LogUtils.WARING, input.toJSONString(), "\u6839\u636e\u95ee\u53e5\u67e5\u4e0d\u5230\u4efb\u4f55\u540c\u4e49\u8bcd\uff0c\u53ef\u80fd\u56e0\u4e3a\u6ca1\u6709\u914d\u7f6e\u540c\u4e49\u8bcd\uff0c\u6216\u7531\u4e8e\u591a\u8bed\u8a00\u3001\u9519\u522b\u5b57\u6216\u6ca1\u6709\u53d1\u7248\u5bfc\u81f4\u5df2\u914d\u7f6e\u7684\u540c\u4e49\u8bcd\u6ca1\u6709\u751f\u6548", "1.\u6253\u5f00\u7cfb\u7edf\u7684\u540c\u4e49\u8bcd\u914d\u7f6e\u7ba1\u7406\u754c\u9762\u3002\n2.\u627e\u5230\u4e0e\u51fa\u73b0\u95ee\u9898\u76f8\u5173\u7684\u540c\u4e49\u8bcd\u914d\u7f6e\u9879\u3002\n3.\u68c0\u67e5\u540c\u4e49\u8bcd\u914d\u7f6e\u662f\u5426\u5b8c\u6574\u4e14\u51c6\u786e\uff0c\u786e\u4fdd\u6bcf\u4e2a\u540c\u4e49\u8bcd\u90fd\u4e0e\u5bf9\u5e94\u7684\u8bcd\u6c47\u6b63\u786e\u5173\u8054\u3002\n4.\u5982\u679c\u914d\u7f6e\u770b\u8d77\u6765\u6ca1\u6709\u95ee\u9898\uff0c\u627e\u5230\u7cfb\u7edf\u7684\u53d1\u7248\u64cd\u4f5c\u5165\u53e3\uff0c\u70b9\u51fb\u8fdb\u884c\u91cd\u65b0\u53d1\u7248\u64cd\u4f5c\u3002\n5.\u53d1\u7248\u5b8c\u6210\u540e\uff0c\u518d\u6b21\u6d4b\u8bd5\u76f8\u5173\u529f\u80fd\uff0c\u67e5\u770b\u540c\u4e49\u8bcd\u5339\u914d\u662f\u5426\u6b63\u5e38\u3002");
            logCheckDtos.add(logCheckDto);
            return output.keep("logCheckDtos", logCheckDtos);
        }
        JSONArray allMatchWResult = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)matchWResult)) {
            allMatchWResult.addAll((Collection)matchWResult);
        }
        if (CollectionUtils.isNotEmpty((Collection)appMatchWResult)) {
            allMatchWResult.addAll((Collection)appMatchWResult);
        }
        allMatchWResult.stream().map(hits -> (JSONObject)hits).collect(Collectors.groupingBy(hit -> WordType.of((String)hit.getOrDefault((Object)"entity_type", (Object)"entity").toString()))).entrySet().stream().map(entry -> {
            List<JSONObject> objects = (List<JSONObject>)entry.getValue();
            Map<String, List<JSONObject>> map = objects.stream().collect(Collectors.groupingBy(j -> Objects.isNull(j.get((Object)"tenant_id")) ? "universal" : j.getString("tenant_id")));
            if (map.size() > 1) {
                objects = map.get(context.get((Object)"tenantId").toString());
            }
            return ((WordType)entry.getKey()).pickKeepData(question, (List)objects, context);
        }).forEach(arg_0 -> ((Output)output).keep(arg_0));
        LogCheckDto logCheckDto = new LogCheckDto();
        JSONObject result = new JSONObject();
        result.put("allMatchWResult", (Object)allMatchWResult);
        logCheckDto.buildParams("SearchStandardWords", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        logCheckDtos.add(logCheckDto);
        return output.keep("logCheckDto", (Object)logCheckDto);
    }
}

