/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.autoData;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.autoData.ReportCreateReq;
import com.digiwin.chatbi.beans.vos.ChatResultMetricVo;
import com.digiwin.chatbi.common.AdtServiceInvoker;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.pipeline.PipelineWithoutTrace;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class DataRetrievalExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(DataRetrievalExecutor.class);
    static PipelineWithoutTrace AUTO_DATA_RETRIEVAL = new PipelineWithoutTrace().execute(new Executor[]{ExecutorFactory.DATASET_ROUTER}).execute(new Executor[]{ExecutorFactory.SEARCH_COMMON_KNOWLEDGE}).execute(new Executor[]{ExecutorFactory.SET_DATE_TIME_PARAM_FOR_PROMPT}).execute(new Executor[]{ExecutorFactory.SEARCH_All_KNOWLEDGE}).execute(new Executor[]{ExecutorFactory.DATASET_PERMISSION_FILTER}).execute(new Executor[]{ExecutorFactory.DATASET_FINDER}).execute(new Executor[]{ExecutorFactory.SEARCH_DIMENSION_ENTITIES}).execute(new Executor[]{ExecutorFactory.SEARCH_DATASET}).execute(new Executor[]{ExecutorFactory.FILTER_USEFUL_KNOWLEDGE}).execute(new Executor[]{ExecutorFactory.SEARCH_DATASET_FEW_SHOT}).execute(new Executor[]{ExecutorFactory.CALL_GPT_WITH_QUESTION_TYPE_PROMPT_V2}).execute(new Executor[]{ExecutorFactory.CLASSFICATION_CHECK_4_DATASET}).execute(new Executor[]{ExecutorFactory.CALL_GPT_WITH_NL2SQL_COT_PROMPT_V2}).execute(new Executor[]{ExecutorFactory.PROBLEM_SOLVING_DATA_PROCESS_EXECUTOR_4_DATASET}).execute(new Executor[]{ExecutorFactory.CALL_GPT_WITH_INTENT_PROMPT_4_DATASET}).execute(new Executor[]{ExecutorFactory.INTENT_TYPE_CONVERTOR_WRAPPER_4_DATASET}).finallyExecute(ExecutorFactory.ALIGN_INDICATOR_OUTPUT_WITH_API);

    public Output doProcess(JSONObject context) {
        JSONObject db_question_generator = context.getJSONObject("DB_question_generator");
        if (Objects.isNull(db_question_generator)) {
            log.warn("\u672a\u751f\u6210\u6570\u636e\u5e93\u95ee\u53e5");
            return Output.through();
        }
        JSONArray sections = db_question_generator.getJSONArray("sections");
        if (CollectionUtils.isEmpty((Collection)sections)) {
            log.warn("\u6570\u636e\u5e93\u751f\u6210\u95ee\u53e5\u4e3b\u9898\u4e3a\u7a7a");
            return Output.through();
        }
        List retrievalDatas = this.parallelDataRetrieval(context, sections);
        if (CollectionUtils.isEmpty((Collection)retrievalDatas)) {
            log.warn("\u53d6\u6570\u4e3a\u7a7a");
            return Output.through();
        }
        return Output.through((String)"retrievalDatas", (Object)retrievalDatas);
    }

    private List<JSONObject> parallelDataRetrieval(JSONObject context, JSONArray sections) {
        List queries = sections.stream().map(section -> (JSONObject)section).flatMap(section -> section.getJSONArray("queries").stream().map(query -> (JSONObject)query)).collect(ArrayList::new, List::add, List::addAll);
        List completableFutures4AutoDatas = this.getCompletableFutures4AutoData(queries, context);
        ArrayList<JSONObject> retrievalDatas = new ArrayList<JSONObject>();
        for (CompletableFuture future : completableFutures4AutoDatas) {
            try {
                JSONObject res = (JSONObject)future.get();
                if (!MapUtils.isNotEmpty((Map)res)) continue;
                retrievalDatas.add(res);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u53d6\u6570\u65f6\u53d1\u751f\u5f02\u5e38,{}", (Throwable)e);
            }
        }
        return retrievalDatas;
    }

    private List<CompletableFuture<JSONObject>> getCompletableFutures4AutoData(List<JSONObject> questions, JSONObject context) {
        java.util.concurrent.Executor autoDataThreadPool = (java.util.concurrent.Executor)SpringContextUtil.getBean((String)"autoDataThreadPool");
        ReportCreateReq reportCreateReq = (ReportCreateReq)context.getObject("reportCreateReq", ReportCreateReq.class);
        ArrayList<CompletableFuture<JSONObject>> futures = new ArrayList<CompletableFuture<JSONObject>>();
        for (JSONObject question : questions) {
            CompletableFuture<JSONObject> future = CompletableFuture.supplyAsync(() -> {
                try {
                    MdcUtil.setTraceId((String)reportCreateReq.getPtxId());
                    JSONObject dataRetrievalParam = this.getDataRetrievalParam(context, reportCreateReq, question);
                    if (Objects.isNull(dataRetrievalParam) || StringUtils.isNotEmpty((CharSequence)dataRetrievalParam.getString("reply"))) {
                        log.error("\u67e5\u8be2solutionstep\u5f02\u5e38\uff1a{},{}", (Object)question, (Object)dataRetrievalParam);
                        JSONObject jSONObject = null;
                        return jSONObject;
                    }
                    String data = this.retrievalData(question, reportCreateReq, (ChatResultMetricVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataRetrievalParam), ChatResultMetricVo.class));
                    if (StringUtils.isEmpty((CharSequence)data)) {
                        log.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38\uff0c\u95ee\u53e5\uff1a{},solutipnStep\uff1a{}", (Object)question, (Object)dataRetrievalParam);
                        JSONObject jSONObject = null;
                        return jSONObject;
                    }
                    JSONObject res = new JSONObject();
                    res.put("question", (Object)question.getString("query_text"));
                    res.put("data", (Object)data);
                    JSONObject jSONObject = res;
                    return jSONObject;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.error("\u53d6\u6570\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    MdcUtil.clear();
                }
                return null;
            }, autoDataThreadPool);
            if (!Objects.nonNull(future)) continue;
            futures.add(future);
        }
        return futures;
    }

    private String retrievalData(JSONObject question, ReportCreateReq req, ChatResultMetricVo chatResultMetricVo) {
        AdtServiceInvoker adtServiceInvoker = (AdtServiceInvoker)SpringContextUtil.getBean(AdtServiceInvoker.class);
        JSONObject res = adtServiceInvoker.autodataGetdata(question.getString("query_text"), chatResultMetricVo.getDatasetList(), chatResultMetricVo.getAppCode(), chatResultMetricVo.getSolutionStep(), chatResultMetricVo.getShowDefine(), req.getToken(), req.getRouterKey());
        if (Objects.isNull(res) || res.getBoolean("exceedSummarizeSize").booleanValue()) {
            log.error(question.getString("query_text") + "\u8d85\u8fc7token\u91cf");
            return null;
        }
        return res.getString("summarizeData");
    }

    private JSONObject getDataRetrievalParam(JSONObject context, ReportCreateReq reportCreateReq, JSONObject dataRetrievalQuestion) {
        Question question = new Question();
        BeanUtils.copyProperties((Object)reportCreateReq, (Object)question);
        question.setMessage(dataRetrievalQuestion.getString("query_text"));
        question.setMultiDialogue(false);
        question.setIfStream(false);
        question.setProductVersion(ProductVersionEnum.FLAGSHIP_VERSION.getCode());
        List datasets = (List)context.getOrDefault((Object)"final_dataSet", new ArrayList());
        List dataSetIds = datasets.stream().filter(dataset -> dataRetrievalQuestion.getJSONArray("target_tables").contains((Object)dataset.getString("datasetName"))).map(dataset -> dataset.getString("datasetId")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataSetIds)) {
            log.error("\u6839\u636e\u95ee\u53e5\u4e2d\u7684\u6570\u636e\u96c6\u540d\u79f0\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e\u96c6");
            return null;
        }
        question.setDatasetIdList(dataSetIds);
        JSONObject subContext = new JSONObject();
        subContext.put("question", (Object)question);
        subContext.put("applicationCodes", context.get((Object)"applicationCodes"));
        subContext.put("version", context.get((Object)"version"));
        return AUTO_DATA_RETRIEVAL.accept((Map)subContext).getOutputContext().getJSONObject("finalResult");
    }
}

