/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.autoData;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.autoData.ReportCreateReq;
import com.digiwin.chatbi.client.GPT_CLIENT;
import com.digiwin.chatbi.common.exception.PromptAssert;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.prompt.PromptExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSummaryPromptExecutor
extends PromptExecutor {
    private static final Logger log = LoggerFactory.getLogger(DataSummaryPromptExecutor.class);

    public static DataSummaryPromptExecutor OfExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Output doProcess(JSONObject context) {
        if (Objects.isNull(context.getJSONObject("DB_question_generator")) || CollectionUtils.isEmpty((Collection)context.getJSONObject("DB_question_generator").getJSONArray("sections")) || Objects.isNull(context.get((Object)"retrievalDatas"))) {
            log.warn("\u6570\u636e\u5e93\u95ee\u53e5\u751f\u6210\u4e3a\u7a7a");
            return Output.through();
        }
        JSONArray queryDatabaseSections = context.getJSONObject("DB_question_generator").getJSONArray("sections");
        List retrievalDatas = (List)context.get((Object)"retrievalDatas");
        for (Object obj : queryDatabaseSections) {
            JSONObject queryDatabaseSection = (JSONObject)obj;
            block3: for (Object queries : queryDatabaseSection.getJSONArray("queries")) {
                for (JSONObject retrievalData : retrievalDatas) {
                    if (!retrievalData.getString("question").equals(((JSONObject)queries).getString("query_text"))) continue;
                    ((JSONObject)queries).put("data", (Object)retrievalData.getString("data"));
                    continue block3;
                }
            }
        }
        List queryDatabaseSectionsWithData = queryDatabaseSections.stream().filter(section_obj -> {
            JSONObject section = (JSONObject)section_obj;
            JSONArray queries = section.getJSONArray("queries");
            if (CollectionUtils.isEmpty((Collection)queries)) {
                return false;
            }
            return queries.stream().anyMatch(query -> {
                String data = ((JSONObject)query).getString("data");
                return StringUtils.isNotEmpty((CharSequence)data);
            });
        }).map(JSONObject.class::cast).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(queryDatabaseSectionsWithData)) {
            log.error("\u6ca1\u6709\u67e5\u8be2\u51fa\u6570\u636e\u7684\u95ee\u9898");
            return Output.through();
        }
        List completableFutures4DataSummary = this.getCompletableFutures4DataSummary(queryDatabaseSectionsWithData, context);
        ArrayList<JSONObject> summaryDatas = new ArrayList<JSONObject>();
        for (CompletableFuture future : completableFutures4DataSummary) {
            try {
                JSONObject res = (JSONObject)future.get();
                if (!MapUtils.isNotEmpty((Map)res)) continue;
                summaryDatas.add(res);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u603b\u7ed3\u65f6\u53d1\u751f\u5f02\u5e38,{}", (Throwable)e);
            }
        }
        if (CollectionUtils.isEmpty(summaryDatas)) {
            log.error("\u6570\u636e\u603b\u7ed3\u4e3a\u7a7a");
            return Output.through();
        }
        return Output.through((String)"internal_data", summaryDatas);
    }

    private List<CompletableFuture<JSONObject>> getCompletableFutures4DataSummary(List<JSONObject> query_database_sections, JSONObject context) {
        Executor autoDataThreadPool = (Executor)SpringContextUtil.getBean((String)"autoDataThreadPool");
        ReportCreateReq reportCreateReq = (ReportCreateReq)context.getObject("reportCreateReq", ReportCreateReq.class);
        ArrayList<CompletableFuture<JSONObject>> futures = new ArrayList<CompletableFuture<JSONObject>>();
        for (JSONObject query_database_section : query_database_sections) {
            CompletableFuture<JSONObject> future = CompletableFuture.supplyAsync(() -> {
                try {
                    MdcUtil.setTraceId((String)reportCreateReq.getPtxId());
                    String gptResult = (String)PromptAssert.PROMPT_CALL_FAIL_ASSERT.tryCatch(() -> super.callGpt(super.systemMessage(context), JSONObject.toJSONString((Object)query_database_section), null, Integer.valueOf(4096), context.getString("temperature"), reportCreateReq.getToken()), e -> "error:" + e.getMessage());
                    JSONObject res = JSONObject.parseObject((String)gptResult);
                    res.put("section", (Object)query_database_section.getString("section"));
                    res.put("researchGoal", (Object)query_database_section.getString("researchGoal"));
                    JSONObject jSONObject = res;
                    return jSONObject;
                }
                catch (Exception e2) {
                    if (e2 instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.error("\u603b\u7ed3\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e2);
                }
                finally {
                    MdcUtil.clear();
                }
                return null;
            }, autoDataThreadPool);
            if (!Objects.nonNull(future)) continue;
            futures.add(future);
        }
        return futures;
    }

    public boolean onCondition(JSONObject context) {
        return true;
    }
}

