/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.autoData;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.autoData.ReportCreateReq;
import com.digiwin.chatbi.client.GPT_CLIENT;
import com.digiwin.chatbi.common.InternetSearch4Aliyuncs;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.prompt.PromptExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.search.config.AliyunConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetSummaryExecutor
extends PromptExecutor {
    private static final Logger log = LoggerFactory.getLogger(InternetSummaryExecutor.class);

    public static InternetSummaryExecutor OfExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Output doProcess(JSONObject context) {
        List query_internet_sections = (List)context.getOrDefault((Object)"query_internet_sections", new ArrayList());
        if (CollectionUtils.isEmpty((Collection)query_internet_sections)) {
            log.info("\u4e92\u8054\u7f51\u4efb\u52a1\u89c4\u5212\u4e3a\u7a7a");
            return Output.through();
        }
        List internetSearchResults = this.parallelInternetSummary(context, query_internet_sections);
        return Output.through((String)"external_insights", (Object)internetSearchResults);
    }

    private List<JSONObject> parallelInternetSummary(JSONObject context, List<JSONObject> query_internet_sections) {
        query_internet_sections.forEach(q -> {
            q.remove((Object)"query_database");
            q.remove((Object)"query_internet");
            q.put("report_subject", (Object)context.getString("tenantName"));
        });
        List completableFutures4InternetSearch = this.getCompletableFutures4InternetSearch(query_internet_sections, context);
        ArrayList<JSONObject> internetSearchResults = new ArrayList<JSONObject>();
        for (CompletableFuture future : completableFutures4InternetSearch) {
            try {
                JSONObject res = (JSONObject)future.get();
                if (!MapUtils.isNotEmpty((Map)res)) continue;
                internetSearchResults.add(res);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u7f51\u7edc\u641c\u7d22\u65f6\u53d1\u751f\u5f02\u5e38,{}", (Throwable)e);
            }
        }
        return internetSearchResults;
    }

    public JSONObject internetSearch(String systemMessage, String userMessage, String apiKey) {
        InternetSearch4Aliyuncs internetSearch4Aliyuncs = (InternetSearch4Aliyuncs)SpringContextUtil.getBean(InternetSearch4Aliyuncs.class);
        return internetSearch4Aliyuncs.call(systemMessage, userMessage, apiKey);
    }

    private List<CompletableFuture<JSONObject>> getCompletableFutures4InternetSearch(List<JSONObject> query_internet_sections, JSONObject context) {
        Executor autoDataThreadPool = (Executor)SpringContextUtil.getBean((String)"autoDataThreadPool");
        ReportCreateReq reportCreateReq = (ReportCreateReq)context.getObject("reportCreateReq", ReportCreateReq.class);
        ArrayList<CompletableFuture<JSONObject>> futures = new ArrayList<CompletableFuture<JSONObject>>();
        for (JSONObject query_internet_section : query_internet_sections) {
            CompletableFuture<JSONObject> future = CompletableFuture.supplyAsync(() -> {
                try {
                    MdcUtil.setTraceId((String)reportCreateReq.getPtxId());
                    AliyunConfig aliyunConfig = (AliyunConfig)SpringContextUtil.getBean(AliyunConfig.class);
                    JSONObject res = this.internetSearch(super.systemMessage(context), JSONObject.toJSONString((Object)query_internet_section), aliyunConfig.getApiKey());
                    if (MapUtils.isEmpty((Map)res)) {
                        JSONObject jSONObject = null;
                        return jSONObject;
                    }
                    JSONObject internetSearchResult = new JSONObject();
                    JSONObject content = JSONObject.parseObject((String)res.getString("content").replaceAll("```json", "").replaceAll("```", ""));
                    internetSearchResult.put("urls", res.get((Object)"searchResults"));
                    internetSearchResult.put("report", (Object)content.getString("report"));
                    internetSearchResult.put("charts", (Object)content.getJSONArray("charts"));
                    internetSearchResult.put("section", (Object)query_internet_section.getString("section"));
                    internetSearchResult.put("researchGoal", (Object)query_internet_section.getString("researchGoal"));
                    JSONObject jSONObject = internetSearchResult;
                    return jSONObject;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.error("\u7f51\u7edc\u641c\u7d22\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    MdcUtil.clear();
                }
                return null;
            }, autoDataThreadPool);
            if (!Objects.nonNull(future)) continue;
            futures.add(future);
        }
        return futures;
    }

    public boolean onCondition(JSONObject context) {
        return true;
    }
}

