/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.autoData;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.autoData.ReportCreateReq;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.SseSendService4AutoData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingOutputDataQueryExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(StreamingOutputDataQueryExecutor.class);

    public Output doProcess(JSONObject context) {
        String template;
        ReportCreateReq reportCreateReq = (ReportCreateReq)context.getObject("reportCreateReq", ReportCreateReq.class);
        List datas_summary_results = (List)context.getOrDefault((Object)"internal_data", new ArrayList());
        List internet_search_results = (List)context.getOrDefault((Object)"external_insights", new ArrayList());
        if (CollectionUtils.isEmpty((Collection)datas_summary_results) && CollectionUtils.isEmpty((Collection)internet_search_results)) {
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.auto.data.summary.error");
        }
        String msg = "";
        if (CollectionUtils.isNotEmpty((Collection)datas_summary_results)) {
            msg = msg + "--- \u4f01\u4e1a\u5185\u6570\u636e\u67e5\u8be2 ---\n";
            for (JSONObject datas_summary_result : datas_summary_results) {
                template = "\n- **\u5206\u6790\u4e3b\u9898\uff1a** %s\n  **\u7814\u7a76\u76ee\u6807\uff1a** %s\n  **\u7814\u7a76\u7ed3\u8bba\uff1a** %s";
                msg = msg + String.format(template, datas_summary_result.getString("section"), datas_summary_result.getString("researchGoal"), datas_summary_result.getString("data_summary")) + "\n";
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            msg = msg + "\n\n";
        }
        if (CollectionUtils.isNotEmpty((Collection)internet_search_results)) {
            msg = msg + "--- \u641c\u7d22\u5f15\u64ce\u67e5\u8be2 ---\n\n";
            for (JSONObject internet_search_result : internet_search_results) {
                template = "\n- **\u5206\u6790\u4e3b\u9898\uff1a** %s\n  **\u7814\u7a76\u76ee\u6807\uff1a** %s\n  **\u7814\u7a76\u7ed3\u8bba\uff1a** %s\n  **\u7f51\u9875\u5f15\u7528\uff1a** \n  %s";
                msg = msg + String.format(template, internet_search_result.getString("section"), internet_search_result.getString("researchGoal"), internet_search_result.getString("report"), String.join((CharSequence)"\n", (List)internet_search_result.get((Object)"urls"))) + "\n";
            }
        }
        SseSendService4AutoData sseSendService4AutoData = (SseSendService4AutoData)SpringContextUtil.getBean(SseSendService4AutoData.class);
        sseSendService4AutoData.asyncSendDQDetailAndFATitle(reportCreateReq.getId(), msg.replaceAll("(?:\n)+$", ""), reportCreateReq.getLocale(), Boolean.valueOf(reportCreateReq.isIfStream()), context);
        return Output.through();
    }
}

